/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.file;

import java.net.URISyntaxException;
import java.net.URL;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.IterableAssert;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.java.nio.base.GeneralPathImpl;
import org.uberfire.java.nio.file.FileStore;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.spi.FileSystemProvider;
import org.uberfire.java.nio.fs.file.SimpleFileSystemProvider;
import org.uberfire.java.nio.fs.file.SimpleUnixFileSystem;

public class SimpleUnixFileSystemTest {
    final FileSystemProvider fsProvider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);

    @Test
    public void simpleTests() {
        SimpleUnixFileSystem fileSystem = new SimpleUnixFileSystem(this.fsProvider, "/");
        Assertions.assertThat((boolean)fileSystem.isOpen()).isTrue();
        Assertions.assertThat((boolean)fileSystem.isReadOnly()).isFalse();
        Assertions.assertThat((String)fileSystem.getSeparator()).isEqualTo((Object)System.getProperty("file.separator"));
        Assertions.assertThat((Object)fileSystem.provider()).isEqualTo((Object)this.fsProvider);
        ((IterableAssert)((IterableAssert)Assertions.assertThat((Iterable)fileSystem.supportedFileAttributeViews()).isNotEmpty()).hasSize(1)).contains((Object[])new String[]{"basic"});
        ((IterableAssert)Assertions.assertThat((Iterable)fileSystem.getPath("/path/to/file.txt", new String[0])).isNotNull()).isEqualTo((Object)GeneralPathImpl.create((FileSystem)fileSystem, (String)"/path/to/file.txt", (boolean)false));
        ((IterableAssert)Assertions.assertThat((Iterable)fileSystem.getPath("/path/to/file.txt", null)).isNotNull()).isEqualTo((Object)GeneralPathImpl.create((FileSystem)fileSystem, (String)"/path/to/file.txt", (boolean)false));
        ((IterableAssert)Assertions.assertThat((Iterable)fileSystem.getPath("/path", new String[]{"to", "file.txt"})).isNotNull()).isEqualTo((Object)GeneralPathImpl.create((FileSystem)fileSystem, (String)"/path/to/file.txt", (boolean)false));
        ((IterableAssert)Assertions.assertThat((Iterable)fileSystem.getPath("/", new String[]{"path", "to", "file.txt"})).isNotNull()).isEqualTo((Object)GeneralPathImpl.create((FileSystem)fileSystem, (String)"/path/to/file.txt", (boolean)false));
        try {
            fileSystem.close();
            Assertions.fail((String)"can't close this fileSystem");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        ((IterableAssert)Assertions.assertThat((Iterable)fileSystem.getFileStores()).isNotNull()).hasSize(1);
        Assertions.assertThat((String)((FileStore)fileSystem.getFileStores().iterator().next()).name()).isEqualTo((Object)"/");
        ((IterableAssert)Assertions.assertThat((Iterable)fileSystem.getRootDirectories()).isNotNull()).hasSize(1);
        Assertions.assertThat((String)((Path)fileSystem.getRootDirectories().iterator().next()).toString()).isEqualTo((Object)"/");
        Assertions.assertThat((boolean)((Path)fileSystem.getRootDirectories().iterator().next()).isAbsolute()).isTrue();
    }

    @Test
    public void simpleRootTests() throws URISyntaxException {
        SimpleFileSystemProvider fs = new SimpleFileSystemProvider();
        SimpleUnixFileSystem fileSystem = new SimpleUnixFileSystem(this.fsProvider, "/");
        Assertions.assertThat((Iterable)fileSystem.getPath("/", new String[0])).isEqualTo((Object)fileSystem.getPath("/path", new String[0]).getParent());
        URL parentUrl = this.getClass().getResource("/");
        Path parentNioPath = fs.getPath(parentUrl.toURI());
        URL childUrl = this.getClass().getResource("/Folder");
        Path childNioPath = fs.getPath(childUrl.toURI());
        Path childParentNioPath = childNioPath.getParent();
        System.out.println(parentNioPath);
        Assertions.assertThat((Iterable)parentNioPath).isEqualTo((Object)childParentNioPath);
    }

    @Test(expected=IllegalArgumentException.class)
    public void invalidCOnstructorPath() {
        new SimpleUnixFileSystem(this.fsProvider, "home");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void getPathMatcherUnsupportedOp() {
        new SimpleUnixFileSystem(this.fsProvider, "/").getPathMatcher("*.*");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void getUserPrincipalLookupServiceUnsupportedOp() {
        new SimpleUnixFileSystem(this.fsProvider, "/").getUserPrincipalLookupService();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void newWatchServiceUnsupportedOp() {
        new SimpleUnixFileSystem(this.fsProvider, "/").newWatchService();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void removeElementFromRootIteratorUnsupportedOp() {
        new SimpleUnixFileSystem(this.fsProvider, "/").getRootDirectories().iterator().remove();
    }

    @Test(expected=NoSuchElementException.class)
    public void invalidElementFromRootIterator() {
        Iterator iterator = new SimpleUnixFileSystem(this.fsProvider, "/").getRootDirectories().iterator();
        try {
            iterator.next();
        }
        catch (Exception e) {
            Assertions.fail((String)"first is valid");
        }
        iterator.next();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void removeElementFromFStoreIteratorUnsupportedOp() {
        new SimpleUnixFileSystem(this.fsProvider, "/").getFileStores().iterator().remove();
    }

    @Test(expected=NoSuchElementException.class)
    public void invalidElementFromFStoreIterator() {
        Iterator iterator = new SimpleUnixFileSystem(this.fsProvider, "/").getFileStores().iterator();
        try {
            iterator.next();
        }
        catch (Exception e) {
            Assertions.fail((String)"first is valid");
        }
        iterator.next();
    }
}

