/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.file;

import java.io.File;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.IterableAssert;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.java.nio.base.GeneralPathImpl;
import org.uberfire.java.nio.file.FileStore;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.spi.FileSystemProvider;
import org.uberfire.java.nio.fs.file.SimpleWindowsFileSystem;

public class SimpleWindowsFileSystemTest {
    final FileSystemProvider fsProvider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
    final File[] roots = new File[]{new File("c:\\"), new File("a:\\")};
    final File[] singleRoot = new File[]{new File("c:\\")};

    @Test
    public void simpleTests() {
        SimpleWindowsFileSystem fileSystem = new SimpleWindowsFileSystem(this.roots, this.fsProvider, "c:\\");
        Assertions.assertThat((boolean)fileSystem.isOpen()).isTrue();
        Assertions.assertThat((boolean)fileSystem.isReadOnly()).isFalse();
        Assertions.assertThat((String)fileSystem.getSeparator()).isEqualTo((Object)"\\");
        Assertions.assertThat((Object)fileSystem.provider()).isEqualTo((Object)this.fsProvider);
        ((IterableAssert)((IterableAssert)Assertions.assertThat((Iterable)fileSystem.supportedFileAttributeViews()).isNotEmpty()).hasSize(1)).contains((Object[])new String[]{"basic"});
        ((IterableAssert)Assertions.assertThat((Iterable)fileSystem.getPath("c:\\path\\to\\file.txt", new String[0])).isNotNull()).isEqualTo((Object)GeneralPathImpl.create((FileSystem)fileSystem, (String)"c:\\path\\to\\file.txt", (boolean)false));
        ((IterableAssert)Assertions.assertThat((Iterable)fileSystem.getPath("/c:/path/to/file.txt", new String[0])).isNotNull()).isEqualTo((Object)GeneralPathImpl.create((FileSystem)fileSystem, (String)"/c:/path/to/file.txt", (boolean)false));
        ((IterableAssert)Assertions.assertThat((Iterable)fileSystem.getPath("c:\\path\\to\\", new String[0])).isNotNull()).isEqualTo((Object)GeneralPathImpl.create((FileSystem)fileSystem, (String)"c:\\path\\to", (boolean)false));
        ((IterableAssert)Assertions.assertThat((Iterable)fileSystem.getPath("/c:/path/to/", new String[0])).isNotNull()).isEqualTo((Object)GeneralPathImpl.create((FileSystem)fileSystem, (String)"/c:/path/to", (boolean)false));
        ((IterableAssert)Assertions.assertThat((Iterable)fileSystem.getPath("c:\\path\\to\\file.txt", null)).isNotNull()).isEqualTo((Object)GeneralPathImpl.create((FileSystem)fileSystem, (String)"c:\\path\\to\\file.txt", (boolean)false));
        ((IterableAssert)Assertions.assertThat((Iterable)fileSystem.getPath("c:\\path", new String[]{"to", "file.txt"})).isNotNull()).isEqualTo((Object)GeneralPathImpl.create((FileSystem)fileSystem, (String)"c:\\path\\to\\file.txt", (boolean)false));
        ((IterableAssert)Assertions.assertThat((Iterable)fileSystem.getPath("c:\\path\\", new String[]{"to", "file.txt"})).isNotNull()).isEqualTo((Object)GeneralPathImpl.create((FileSystem)fileSystem, (String)"c:\\path\\to\\file.txt", (boolean)false));
        ((IterableAssert)Assertions.assertThat((Iterable)fileSystem.getPath("/c:/path", new String[]{"to", "file.txt"})).isNotNull()).isEqualTo((Object)GeneralPathImpl.create((FileSystem)fileSystem, (String)"/c:/path/to/file.txt", (boolean)false));
        ((IterableAssert)Assertions.assertThat((Iterable)fileSystem.getPath("/c:/path/", new String[]{"to", "file.txt"})).isNotNull()).isEqualTo((Object)GeneralPathImpl.create((FileSystem)fileSystem, (String)"/c:/path/to/file.txt", (boolean)false));
        ((IterableAssert)Assertions.assertThat((Iterable)fileSystem.getPath("/", new String[]{"c:", "path"})).isNotNull()).isEqualTo((Object)GeneralPathImpl.create((FileSystem)fileSystem, (String)"/c:/path", (boolean)false));
        try {
            fileSystem.close();
            Assertions.fail((String)"can't close this fileSystem");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        ((IterableAssert)Assertions.assertThat((Iterable)fileSystem.getFileStores()).isNotNull()).hasSize(2);
        Assertions.assertThat((String)((FileStore)fileSystem.getFileStores().iterator().next()).name()).isEqualTo((Object)"c:\\");
        ((IterableAssert)Assertions.assertThat((Iterable)fileSystem.getRootDirectories()).isNotNull()).hasSize(2);
        Assertions.assertThat((String)((Path)fileSystem.getRootDirectories().iterator().next()).toString()).isEqualTo((Object)"c:\\");
        Assertions.assertThat((boolean)((Path)fileSystem.getRootDirectories().iterator().next()).isAbsolute()).isTrue();
    }

    @Test(expected=IllegalArgumentException.class)
    public void invalidCOnstructorPath() {
        new SimpleWindowsFileSystem(this.fsProvider, "home");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void getPathMatcherUnsupportedOp() {
        new SimpleWindowsFileSystem(this.fsProvider, "c:\\").getPathMatcher("*.*");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void getUserPrincipalLookupServiceUnsupportedOp() {
        new SimpleWindowsFileSystem(this.fsProvider, "c:\\").getUserPrincipalLookupService();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void newWatchServiceUnsupportedOp() {
        new SimpleWindowsFileSystem(this.fsProvider, "c:\\").newWatchService();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void removeElementFromRootIteratorUnsupportedOp() {
        new SimpleWindowsFileSystem(this.fsProvider, "c:\\").getRootDirectories().iterator().remove();
    }

    @Test(expected=NoSuchElementException.class)
    public void invalidElementFromRootIterator() {
        Iterator iterator = new SimpleWindowsFileSystem(this.singleRoot, this.fsProvider, "c:\\").getRootDirectories().iterator();
        try {
            iterator.next();
        }
        catch (Exception e) {
            Assertions.fail((String)"first is valid");
        }
        iterator.next();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void removeElementFromFStoreIteratorUnsupportedOp() {
        new SimpleWindowsFileSystem(this.fsProvider, "c:\\").getFileStores().iterator().remove();
    }

    @Test(expected=NoSuchElementException.class)
    public void invalidElementFromFStoreIterator() {
        Iterator iterator = new SimpleWindowsFileSystem(this.singleRoot, this.fsProvider, "c:\\").getFileStores().iterator();
        try {
            iterator.next();
        }
        catch (Exception e) {
            Assertions.fail((String)"first is valid");
        }
        iterator.next();
    }
}

