/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.eclipse.jgit.transport.PacketLineIn;
import org.eclipse.jgit.transport.resolver.ServiceNotAuthorizedException;
import org.eclipse.jgit.transport.resolver.ServiceNotEnabledException;
import org.eclipse.jgit.util.io.SafeBufferedOutputStream;
import org.uberfire.java.nio.fs.jgit.util.Daemon;
import org.uberfire.java.nio.fs.jgit.util.DaemonService;

public class DaemonClient {
    private final Daemon daemon;
    private InetAddress peer;
    private InputStream rawIn;
    private OutputStream rawOut;

    DaemonClient(Daemon d) {
        this.daemon = d;
    }

    void setRemoteAddress(InetAddress ia) {
        this.peer = ia;
    }

    public Daemon getDaemon() {
        return this.daemon;
    }

    public InetAddress getRemoteAddress() {
        return this.peer;
    }

    public InputStream getInputStream() {
        return this.rawIn;
    }

    public OutputStream getOutputStream() {
        return this.rawOut;
    }

    void execute(Socket sock) throws IOException, ServiceNotEnabledException, ServiceNotAuthorizedException {
        DaemonService srv;
        String cmd;
        int nul;
        this.rawIn = new BufferedInputStream(sock.getInputStream());
        this.rawOut = new SafeBufferedOutputStream(sock.getOutputStream());
        if (0 < this.daemon.getTimeout()) {
            sock.setSoTimeout(this.daemon.getTimeout() * 1000);
        }
        if ((nul = (cmd = new PacketLineIn(this.rawIn).readStringRaw()).indexOf(0)) >= 0) {
            cmd = cmd.substring(0, nul);
        }
        if ((srv = this.getDaemon().matchService(cmd)) == null) {
            return;
        }
        sock.setSoTimeout(0);
        srv.execute(this, cmd);
    }
}

