/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.internal.storage.file.WindowCache;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.WindowCacheConfig;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.PostReceiveHook;
import org.eclipse.jgit.transport.PreReceiveHook;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.transport.ReceivePack;
import org.eclipse.jgit.transport.ServiceMayNotContinueException;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.transport.resolver.ReceivePackFactory;
import org.eclipse.jgit.transport.resolver.RepositoryResolver;
import org.eclipse.jgit.transport.resolver.ServiceNotAuthorizedException;
import org.eclipse.jgit.transport.resolver.ServiceNotEnabledException;
import org.eclipse.jgit.util.FileUtils;
import org.uberfire.commons.cluster.ClusterService;
import org.uberfire.commons.data.Pair;
import org.uberfire.commons.message.MessageType;
import org.uberfire.commons.validation.Preconditions;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.base.AbstractPath;
import org.uberfire.java.nio.base.BasicFileAttributesImpl;
import org.uberfire.java.nio.base.ExtendedAttributeView;
import org.uberfire.java.nio.base.FileSystemState;
import org.uberfire.java.nio.base.SeekableByteChannelFileBasedImpl;
import org.uberfire.java.nio.base.WatchContext;
import org.uberfire.java.nio.base.dotfiles.DotFileOption;
import org.uberfire.java.nio.base.dotfiles.DotFileUtils;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.base.version.VersionAttributeView;
import org.uberfire.java.nio.base.version.VersionAttributes;
import org.uberfire.java.nio.channels.AsynchronousFileChannel;
import org.uberfire.java.nio.channels.SeekableByteChannel;
import org.uberfire.java.nio.file.AccessDeniedException;
import org.uberfire.java.nio.file.AccessMode;
import org.uberfire.java.nio.file.AtomicMoveNotSupportedException;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.DirectoryNotEmptyException;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.FileStore;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileSystemAlreadyExistsException;
import org.uberfire.java.nio.file.FileSystemNotFoundException;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.NotDirectoryException;
import org.uberfire.java.nio.file.NotLinkException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Option;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.StandardCopyOption;
import org.uberfire.java.nio.file.StandardDeleteOption;
import org.uberfire.java.nio.file.StandardOpenOption;
import org.uberfire.java.nio.file.StandardWatchEventKind;
import org.uberfire.java.nio.file.WatchEvent;
import org.uberfire.java.nio.file.attribute.AttributeView;
import org.uberfire.java.nio.file.attribute.BasicFileAttributeView;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;
import org.uberfire.java.nio.file.attribute.FileAttribute;
import org.uberfire.java.nio.file.attribute.FileAttributeView;
import org.uberfire.java.nio.file.spi.FileSystemProvider;
import org.uberfire.java.nio.fs.jgit.CommitInfo;
import org.uberfire.java.nio.fs.jgit.JGitBasicAttributeView;
import org.uberfire.java.nio.fs.jgit.JGitFSPath;
import org.uberfire.java.nio.fs.jgit.JGitFileStore;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.JGitPathImpl;
import org.uberfire.java.nio.fs.jgit.JGitVersionAttributeView;
import org.uberfire.java.nio.fs.jgit.NotificationModel;
import org.uberfire.java.nio.fs.jgit.daemon.git.Daemon;
import org.uberfire.java.nio.fs.jgit.daemon.git.DaemonClient;
import org.uberfire.java.nio.fs.jgit.daemon.ssh.BaseGitCommand;
import org.uberfire.java.nio.fs.jgit.daemon.ssh.GitSSHService;
import org.uberfire.java.nio.fs.jgit.util.CommitContent;
import org.uberfire.java.nio.fs.jgit.util.CopyCommitContent;
import org.uberfire.java.nio.fs.jgit.util.DefaultCommitContent;
import org.uberfire.java.nio.fs.jgit.util.JGitUtil;
import org.uberfire.java.nio.fs.jgit.util.MoveCommitContent;
import org.uberfire.java.nio.fs.jgit.util.RevertCommitContent;
import org.uberfire.java.nio.security.SecurityAware;
import org.uberfire.security.auth.AuthenticationManager;
import org.uberfire.security.authz.AuthorizationManager;

public class JGitFileSystemProvider
implements FileSystemProvider,
SecurityAware {
    protected static final String DEFAULT_IO_SERVICE_NAME = "default";
    public static final String GIT_DEFAULT_REMOTE_NAME = "origin";
    public static final String GIT_LIST_ROOT_BRANCH_MODE = "listMode";
    private static final String SCHEME = "git";
    public static final String REPOSITORIES_ROOT_DIR = ".niogit";
    public static final String SSH_FILE_CERT_ROOT_DIR = ".security";
    public static final String DEFAULT_HOST_NAME = "localhost";
    public static final String DEFAULT_HOST_ADDR = "127.0.0.1";
    public static final boolean DAEMON_DEFAULT_ENABLED = true;
    public static final int DAEMON_DEFAULT_PORT = 9418;
    public static final boolean SSH_DEFAULT_ENABLED = true;
    public static final int SSH_DEFAULT_PORT = 8001;
    private static final String GIT_ENV_PROP_DEST_PATH = "out-dir";
    public static File FILE_REPOSITORIES_ROOT;
    public static boolean DAEMON_ENABLED;
    public static int DAEMON_PORT;
    private static String DAEMON_HOST_ADDR;
    private static String DAEMON_HOST_NAME;
    private static boolean SSH_ENABLED;
    private static int SSH_PORT;
    private static String SSH_HOST_ADDR;
    private static String SSH_HOST_NAME;
    private static File SSH_FILE_CERT_DIR;
    public static final String USER_NAME = "username";
    public static final String PASSWORD = "password";
    public static final String INIT = "init";
    public static final int SCHEME_SIZE;
    public static final int DEFAULT_SCHEME_SIZE;
    private FileSystemState state = FileSystemState.NORMAL;
    private CommitInfo batchCommitInfo = null;
    private boolean hadCommitOnBatchState = false;
    private final Map<String, JGitFileSystem> fileSystems = new ConcurrentHashMap<String, JGitFileSystem>();
    private final Set<JGitFileSystem> closedFileSystems = new HashSet<JGitFileSystem>();
    private final Map<Repository, JGitFileSystem> repoIndex = new ConcurrentHashMap<Repository, JGitFileSystem>();
    private final Map<Repository, ClusterService> clusterMap = new ConcurrentHashMap<Repository, ClusterService>();
    private final Map<String, String> fullHostNames = new HashMap<String, String>();
    private boolean isDefault;
    private final Map<JGitFileSystem, Map<String, NotificationModel>> oldHeadsOfPendingDiffs = new HashMap<JGitFileSystem, Map<String, NotificationModel>>();
    private AuthenticationManager authenticationManager = null;
    private AuthorizationManager authorizationManager = null;
    private Daemon daemonService = null;
    private GitSSHService gitSSHService = null;
    private static JGitFileSystemProvider provider;

    private void loadConfig() {
        String bareReposDir = System.getProperty("org.uberfire.nio.git.dir");
        String enabled = System.getProperty("org.uberfire.nio.git.daemon.enabled");
        String host = System.getProperty("org.uberfire.nio.git.daemon.host");
        String hostName = System.getProperty("org.uberfire.nio.git.daemon.hostname");
        String port = System.getProperty("org.uberfire.nio.git.daemon.port");
        String sshEnabled = System.getProperty("org.uberfire.nio.git.ssh.enabled");
        String sshHost = System.getProperty("org.uberfire.nio.git.ssh.host");
        String sshHostName = System.getProperty("org.uberfire.nio.git.ssh.hostname");
        String sshPort = System.getProperty("org.uberfire.nio.git.ssh.port");
        String sshCertDir = System.getProperty("org.uberfire.nio.git.ssh.cert.dir");
        FILE_REPOSITORIES_ROOT = bareReposDir == null || bareReposDir.trim().isEmpty() ? new File(REPOSITORIES_ROOT_DIR) : new File(bareReposDir.trim(), REPOSITORIES_ROOT_DIR);
        if (enabled == null || enabled.trim().isEmpty()) {
            DAEMON_ENABLED = true;
        } else {
            try {
                DAEMON_ENABLED = Boolean.valueOf(enabled);
            }
            catch (Exception ex) {
                DAEMON_ENABLED = true;
            }
        }
        DAEMON_PORT = port == null || port.trim().isEmpty() ? 9418 : Integer.valueOf(port);
        DAEMON_HOST_ADDR = host == null || host.trim().isEmpty() ? DEFAULT_HOST_ADDR : host;
        DAEMON_HOST_NAME = hostName == null || hostName.trim().isEmpty() ? (host != null && !host.trim().isEmpty() ? host : DEFAULT_HOST_NAME) : hostName;
        if (sshEnabled == null || sshEnabled.trim().isEmpty()) {
            SSH_ENABLED = true;
        } else {
            try {
                SSH_ENABLED = Boolean.valueOf(sshEnabled);
            }
            catch (Exception ex) {
                SSH_ENABLED = true;
            }
        }
        SSH_PORT = sshPort == null || sshPort.trim().isEmpty() ? 8001 : Integer.valueOf(sshPort);
        SSH_HOST_ADDR = sshHost == null || sshHost.trim().isEmpty() ? DEFAULT_HOST_ADDR : sshHost;
        SSH_HOST_NAME = sshHostName == null || sshHostName.trim().isEmpty() ? (sshHost != null && !sshHost.trim().isEmpty() ? sshHost : DEFAULT_HOST_NAME) : sshHostName;
        SSH_FILE_CERT_DIR = sshCertDir == null || sshCertDir.trim().isEmpty() ? new File(SSH_FILE_CERT_ROOT_DIR) : new File(sshCertDir.trim(), SSH_FILE_CERT_ROOT_DIR);
    }

    public void onCloseFileSystem(JGitFileSystem fileSystem) {
        this.closedFileSystems.add(fileSystem);
        this.oldHeadsOfPendingDiffs.remove(fileSystem);
        if (this.closedFileSystems.size() == this.fileSystems.size()) {
            if (this.daemonService != null) {
                this.daemonService.stop();
            }
            if (this.gitSSHService != null) {
                this.gitSSHService.stop();
            }
        }
    }

    public void onDisposeFileSystem(JGitFileSystem fileSystem) {
        this.onCloseFileSystem(fileSystem);
        this.closedFileSystems.remove(fileSystem);
        this.fileSystems.remove(fileSystem.id());
        this.repoIndex.remove(fileSystem.gitRepo().getRepository());
        this.clusterMap.remove(fileSystem.gitRepo().getRepository());
    }

    public static JGitFileSystemProvider getInstance() {
        if (provider == null) {
            provider = new JGitFileSystemProvider();
        }
        return provider;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
        if (this.gitSSHService != null) {
            this.gitSSHService.setAuthenticationManager(authenticationManager);
        }
    }

    public void setAuthorizationManager(AuthorizationManager authorizationManager) {
        this.authorizationManager = authorizationManager;
        if (this.gitSSHService != null) {
            this.gitSSHService.setAuthorizationManager(authorizationManager);
        }
    }

    public JGitFileSystemProvider() {
        String[] repos;
        this.loadConfig();
        CredentialsProvider.setDefault((CredentialsProvider)new UsernamePasswordCredentialsProvider("guest", ""));
        if (DAEMON_ENABLED) {
            this.fullHostNames.put(SCHEME, DAEMON_HOST_NAME + ":" + DAEMON_PORT);
        }
        if (SSH_ENABLED) {
            this.fullHostNames.put("ssh", SSH_HOST_NAME + ":" + SSH_PORT);
        }
        if ((repos = FILE_REPOSITORIES_ROOT.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".git");
            }
        })) != null) {
            for (String repo : repos) {
                File repoDir = new File(FILE_REPOSITORIES_ROOT, repo);
                if (!repoDir.isDirectory()) continue;
                String name = repoDir.getName().substring(0, repoDir.getName().indexOf(".git"));
                JGitFileSystem fs = new JGitFileSystem(this, this.fullHostNames, JGitUtil.newRepository(repoDir, true), name, ListBranchCommand.ListMode.ALL, this.buildCredential(null));
                this.fileSystems.put(name, fs);
                this.repoIndex.put(fs.gitRepo().getRepository(), fs);
            }
        }
        if (DAEMON_ENABLED) {
            this.buildAndStartDaemon();
        } else {
            this.daemonService = null;
        }
        if (SSH_ENABLED) {
            this.buildAndStartSSH();
        } else {
            this.gitSSHService = null;
        }
    }

    private void buildAndStartSSH() {
        ReceivePackFactory<BaseGitCommand> receivePackFactory = new ReceivePackFactory<BaseGitCommand>(){

            public ReceivePack create(final BaseGitCommand req, final Repository db) throws ServiceNotEnabledException, ServiceNotAuthorizedException {
                return new ReceivePack(db){
                    {
                        super(x0);
                        final ClusterService clusterService = (ClusterService)JGitFileSystemProvider.this.clusterMap.get(db);
                        final JGitFileSystem fs = (JGitFileSystem)JGitFileSystemProvider.this.repoIndex.get(db);
                        final HashMap oldTreeRefs = new HashMap();
                        this.setPreReceiveHook(new PreReceiveHook(){

                            public void onPreReceive(ReceivePack rp, Collection<ReceiveCommand> commands) {
                                if (clusterService != null) {
                                    clusterService.lock();
                                }
                                for (ReceiveCommand command : commands) {
                                    oldTreeRefs.put(command.getRefName(), JGitUtil.getTreeRefObjectId(db, command.getRefName()));
                                }
                            }
                        });
                        this.setPostReceiveHook(new PostReceiveHook(){

                            public void onPostReceive(ReceivePack rp, Collection<ReceiveCommand> commands) {
                                for (Map.Entry oldTreeRef : oldTreeRefs.entrySet()) {
                                    JGitFileSystemProvider.this.notifyDiffs(fs, (String)oldTreeRef.getKey(), "<ssh>", req.getUser().getName(), (ObjectId)oldTreeRef.getValue(), JGitUtil.getTreeRefObjectId(db, (String)oldTreeRef.getKey()));
                                }
                                if (clusterService != null) {
                                    clusterService.broadcast(JGitFileSystemProvider.DEFAULT_IO_SERVICE_NAME, new MessageType(){

                                        public String toString() {
                                            return "SYNC_FS";
                                        }

                                        public int hashCode() {
                                            return "SYNC_FS".hashCode();
                                        }
                                    }, (Map)new HashMap<String, String>(){
                                        {
                                            this.put("fs_scheme", JGitFileSystemProvider.SCHEME);
                                            this.put("fs_id", fs.id());
                                            this.put("fs_uri", fs.toString());
                                        }
                                    });
                                    clusterService.unlock();
                                }
                            }
                        });
                    }
                };
            }
        };
        this.gitSSHService = new GitSSHService();
        this.gitSSHService.setup(SSH_FILE_CERT_DIR, SSH_HOST_ADDR, SSH_PORT, this.authenticationManager, this.authorizationManager, (ReceivePackFactory)receivePackFactory, new RepositoryResolverImpl<BaseGitCommand>());
        this.gitSSHService.start();
    }

    void buildAndStartDaemon() {
        if (this.daemonService == null || !this.daemonService.isRunning()) {
            this.daemonService = new Daemon(new InetSocketAddress(DAEMON_HOST_ADDR, DAEMON_PORT));
            this.daemonService.setRepositoryResolver(new RepositoryResolverImpl<DaemonClient>());
            try {
                this.daemonService.start();
            }
            catch (java.io.IOException e) {
                throw new IOException((Exception)e);
            }
        }
    }

    void forceStopDaemon() {
        if (this.daemonService != null || this.daemonService.isRunning()) {
            this.daemonService.stop();
        }
    }

    public synchronized void forceAsDefault() {
        this.isDefault = true;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public String getScheme() {
        return SCHEME;
    }

    public FileSystem newFileSystem(Path path, Map<String, ?> env) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        throw new UnsupportedOperationException();
    }

    public FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IllegalArgumentException, IOException, SecurityException, FileSystemAlreadyExistsException {
        Object _clusterService;
        Git git;
        CredentialsProvider credential;
        ListBranchCommand.ListMode listMode;
        Preconditions.checkNotNull((String)"uri", (Object)uri);
        Preconditions.checkCondition((String)"uri scheme not supported", (uri.getScheme().equals(this.getScheme()) || uri.getScheme().equals(DEFAULT_IO_SERVICE_NAME) ? 1 : 0) != 0);
        this.checkURI("uri", uri);
        Preconditions.checkNotNull((String)"env", env);
        String name = this.extractRepoName(uri);
        if (this.fileSystems.containsKey(name)) {
            throw new FileSystemAlreadyExistsException();
        }
        if (env.containsKey(GIT_LIST_ROOT_BRANCH_MODE)) {
            try {
                listMode = ListBranchCommand.ListMode.valueOf((String)((String)env.get(GIT_LIST_ROOT_BRANCH_MODE)));
            }
            catch (Exception ex) {
                listMode = null;
            }
        } else {
            listMode = null;
        }
        boolean bare = true;
        String outPath = (String)env.get(GIT_ENV_PROP_DEST_PATH);
        File repoDest = outPath != null ? new File(outPath, name + ".git") : new File(FILE_REPOSITORIES_ROOT, name + ".git");
        if (env.containsKey(GIT_DEFAULT_REMOTE_NAME)) {
            String originURI = env.get(GIT_DEFAULT_REMOTE_NAME).toString();
            credential = this.buildCredential(env);
            git = JGitUtil.cloneRepository(repoDest, originURI, bare, credential);
        } else {
            credential = this.buildCredential(null);
            git = JGitUtil.newRepository(repoDest, bare);
        }
        JGitFileSystem fs = new JGitFileSystem(this, this.fullHostNames, git, name, listMode, credential);
        this.fileSystems.put(name, fs);
        this.repoIndex.put(fs.gitRepo().getRepository(), fs);
        boolean init = false;
        if (env.containsKey(INIT) && Boolean.valueOf(env.get(INIT).toString()).booleanValue()) {
            init = true;
        }
        if (!env.containsKey(GIT_DEFAULT_REMOTE_NAME) && init) {
            try {
                URI initURI = URI.create(this.getScheme() + "://master@" + name + "/readme.md");
                CommentedOption op = this.setupOp(env);
                OutputStream stream = this.newOutputStream(this.getPath(initURI), new OpenOption[]{op});
                String _init = "Repository Init Content\n=======================\n\nYour project description here.";
                stream.write("Repository Init Content\n=======================\n\nYour project description here.".getBytes());
                stream.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!bare) {
                // empty if block
            }
        }
        if ((_clusterService = env.get("clusterService")) != null && _clusterService instanceof ClusterService) {
            this.clusterMap.put(git.getRepository(), (ClusterService)_clusterService);
        }
        if (DAEMON_ENABLED && this.daemonService != null && !this.daemonService.isRunning()) {
            this.buildAndStartDaemon();
        }
        return fs;
    }

    private CommentedOption setupOp(Map<String, ?> env) {
        return null;
    }

    public FileSystem getFileSystem(URI uri) throws IllegalArgumentException, FileSystemNotFoundException, SecurityException {
        Preconditions.checkNotNull((String)"uri", (Object)uri);
        Preconditions.checkCondition((String)"uri scheme not supported", (uri.getScheme().equals(this.getScheme()) || uri.getScheme().equals(DEFAULT_IO_SERVICE_NAME) ? 1 : 0) != 0);
        this.checkURI("uri", uri);
        JGitFileSystem fileSystem = this.fileSystems.get(this.extractRepoName(uri));
        if (fileSystem == null) {
            throw new FileSystemNotFoundException("No filesystem for uri (" + uri + ") found.");
        }
        if (this.hasSyncFlag(uri)) {
            try {
                String treeRef = "master";
                ObjectId oldHead = JGitUtil.getTreeRefObjectId(fileSystem.gitRepo().getRepository(), "master");
                Map<String, String> params = JGitFileSystemProvider.getQueryParams(uri);
                JGitUtil.syncRepository(fileSystem.gitRepo(), fileSystem.getCredential(), params.get("sync"), this.hasForceFlag(uri));
                ObjectId newHead = JGitUtil.getTreeRefObjectId(fileSystem.gitRepo().getRepository(), "master");
                this.notifyDiffs(fileSystem, "master", "<system>", "<system>", oldHead, newHead);
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
        }
        if (this.hasPushFlag(uri)) {
            try {
                Map<String, String> params = JGitFileSystemProvider.getQueryParams(uri);
                JGitUtil.pushRepository(fileSystem.gitRepo(), fileSystem.getCredential(), params.get("push"), this.hasForceFlag(uri));
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
        }
        return fileSystem;
    }

    public Path getPath(URI uri) throws IllegalArgumentException, FileSystemNotFoundException, SecurityException {
        Preconditions.checkNotNull((String)"uri", (Object)uri);
        Preconditions.checkCondition((String)"uri scheme not supported", (uri.getScheme().equals(this.getScheme()) || uri.getScheme().equals(DEFAULT_IO_SERVICE_NAME) ? 1 : 0) != 0);
        this.checkURI("uri", uri);
        JGitFileSystem fileSystem = this.fileSystems.get(this.extractRepoName(uri));
        if (fileSystem == null) {
            throw new FileSystemNotFoundException();
        }
        return JGitPathImpl.create(fileSystem, this.extractPath(uri), this.extractHost(uri), false);
    }

    public InputStream newInputStream(Path path, OpenOption ... options) throws IllegalArgumentException, UnsupportedOperationException, NoSuchFileException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        JGitPathImpl gPath = this.toPathImpl(path);
        return JGitUtil.resolveInputStream(((JGitFileSystem)gPath.getFileSystem()).gitRepo(), gPath.getRefTree(), gPath.getPath());
    }

    public OutputStream newOutputStream(Path path, final OpenOption ... options) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        final JGitPathImpl gPath = this.toPathImpl(path);
        Pair<JGitUtil.PathType, ObjectId> result = JGitUtil.checkPath(((JGitFileSystem)gPath.getFileSystem()).gitRepo(), gPath.getRefTree(), gPath.getPath());
        if (((JGitUtil.PathType)((Object)result.getK1())).equals((Object)JGitUtil.PathType.DIRECTORY)) {
            throw new IOException();
        }
        try {
            final File file = File.createTempFile("gitz", "woot");
            return new FilterOutputStream(new FileOutputStream(file)){

                @Override
                public void close() throws java.io.IOException {
                    super.close();
                    JGitFileSystemProvider.this.commit(gPath, JGitFileSystemProvider.this.buildCommitInfo(null, Arrays.asList(options)), new DefaultCommitContent((Map<String, File>)new HashMap<String, File>(){
                        {
                            this.put(gPath.getPath(), file);
                        }
                    }));
                }
            };
        }
        catch (java.io.IOException e) {
            throw new IOException((Exception)e);
        }
    }

    private CommitInfo buildCommitInfo(String defaultMessage, Collection<? extends Option> options) {
        CommentedOption op;
        String sessionId = null;
        String name = null;
        String email = null;
        String message = defaultMessage;
        TimeZone timeZone = null;
        Date when = null;
        if (options != null && !options.isEmpty() && (op = this.extractCommentedOption(options)) != null) {
            sessionId = op.getSessionId();
            name = op.getName();
            email = op.getEmail();
            if (op.getMessage() != null && !op.getMessage().trim().isEmpty()) {
                message = op.getMessage();
            }
            timeZone = op.getTimeZone();
            when = op.getWhen();
        }
        return new CommitInfo(sessionId, name, email, message, timeZone, when);
    }

    private CommitInfo buildCommitInfo(String defaultMessage, CommentedOption op) {
        String sessionId = null;
        String name = null;
        String email = null;
        String message = defaultMessage;
        TimeZone timeZone = null;
        Date when = null;
        if (op != null) {
            sessionId = op.getSessionId();
            name = op.getName();
            email = op.getEmail();
            if (op.getMessage() != null && !op.getMessage().trim().isEmpty()) {
                message = op.getMessage();
            }
            timeZone = op.getTimeZone();
            when = op.getWhen();
        }
        return new CommitInfo(sessionId, name, email, message, timeZone, when);
    }

    final CommentedOption extractCommentedOption(Collection<? extends Option> options) {
        for (Option option : options) {
            if (!(option instanceof CommentedOption)) continue;
            return (CommentedOption)option;
        }
        return null;
    }

    public FileChannel newFileChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        throw new UnsupportedOperationException();
    }

    public AsynchronousFileChannel newAsynchronousFileChannel(Path path, Set<? extends OpenOption> options, ExecutorService executor, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        throw new UnsupportedOperationException();
    }

    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        JGitPathImpl gPath = this.toPathImpl(path);
        if (this.exists(path) && !this.shouldCreateOrOpenAByteChannel(options)) {
            throw new FileAlreadyExistsException(path.toString());
        }
        Pair<JGitUtil.PathType, ObjectId> result = JGitUtil.checkPath(((JGitFileSystem)gPath.getFileSystem()).gitRepo(), gPath.getRefTree(), gPath.getPath());
        if (((JGitUtil.PathType)((Object)result.getK1())).equals((Object)JGitUtil.PathType.DIRECTORY)) {
            throw new IOException();
        }
        try {
            if (options != null && options.contains(StandardOpenOption.READ)) {
                SeekableByteChannelFileBasedImpl seekableByteChannelFileBasedImpl = this.openAByteChannel(path);
                return seekableByteChannelFileBasedImpl;
            }
            SeekableByteChannel seekableByteChannel = this.createANewByteChannel(path, options, gPath, attrs);
            return seekableByteChannel;
        }
        catch (java.io.IOException e) {
            throw new IOException((Exception)e);
        }
        finally {
            ((AbstractPath)path).clearCache();
        }
    }

    private SeekableByteChannel createANewByteChannel(final Path path, final Set<? extends OpenOption> options, final JGitPathImpl gPath, final FileAttribute<?>[] attrs) throws java.io.IOException {
        final File file = File.createTempFile("gitz", "woot");
        return new SeekableByteChannelFileBasedImpl(new RandomAccessFile(file, "rw").getChannel()){

            public void close() throws java.io.IOException {
                boolean hasDotContent;
                super.close();
                File tempDot = null;
                if (options != null && options.contains(new DotFileOption())) {
                    JGitFileSystemProvider.this.deleteIfExists(DotFileUtils.dot((Path)path), new DeleteOption[]{JGitFileSystemProvider.this.extractCommentedOption(options)});
                    tempDot = File.createTempFile("meta", "dot");
                    hasDotContent = DotFileUtils.buildDotFile((Path)path, (OutputStream)new FileOutputStream(tempDot), (FileAttribute[])attrs);
                } else {
                    hasDotContent = false;
                }
                final File dotfile = tempDot;
                JGitFileSystemProvider.this.commit(gPath, JGitFileSystemProvider.this.buildCommitInfo(null, options), new DefaultCommitContent((Map<String, File>)new HashMap<String, File>(){
                    {
                        this.put(gPath.getPath(), file);
                        if (hasDotContent) {
                            this.put(JGitFileSystemProvider.this.toPathImpl(DotFileUtils.dot((Path)gPath)).getPath(), dotfile);
                        }
                    }
                }));
            }
        };
    }

    private SeekableByteChannelFileBasedImpl openAByteChannel(Path path) throws FileNotFoundException {
        return new SeekableByteChannelFileBasedImpl(new RandomAccessFile(path.toFile(), "r").getChannel());
    }

    private boolean shouldCreateOrOpenAByteChannel(Set<? extends OpenOption> options) {
        return options != null && (options.contains(StandardOpenOption.TRUNCATE_EXISTING) || options.contains(StandardOpenOption.READ));
    }

    protected boolean exists(Path path) {
        try {
            this.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public DirectoryStream<Path> newDirectoryStream(Path path, DirectoryStream.Filter<Path> pfilter) throws NotDirectoryException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        DirectoryStream.Filter<Path> filter = pfilter == null ? new DirectoryStream.Filter<Path>(){

            public boolean accept(Path entry) throws IOException {
                return true;
            }
        } : pfilter;
        final JGitPathImpl gPath = this.toPathImpl(path);
        Pair<JGitUtil.PathType, ObjectId> result = JGitUtil.checkPath(((JGitFileSystem)gPath.getFileSystem()).gitRepo(), gPath.getRefTree(), gPath.getPath());
        if (!((JGitUtil.PathType)((Object)result.getK1())).equals((Object)JGitUtil.PathType.DIRECTORY)) {
            throw new NotDirectoryException(path.toString());
        }
        final List<JGitUtil.JGitPathInfo> pathContent = JGitUtil.listPathContent(((JGitFileSystem)gPath.getFileSystem()).gitRepo(), gPath.getRefTree(), gPath.getPath());
        return new DirectoryStream<Path>((DirectoryStream.Filter)filter){
            boolean isClosed = false;
            final /* synthetic */ DirectoryStream.Filter val$filter;
            {
                this.val$filter = filter;
            }

            public void close() throws IOException {
                if (this.isClosed) {
                    throw new IOException();
                }
                this.isClosed = true;
            }

            public Iterator<Path> iterator() {
                if (this.isClosed) {
                    throw new IOException();
                }
                return new Iterator<Path>(){
                    private int i = -1;
                    private Path nextEntry = null;
                    public boolean atEof = false;

                    @Override
                    public boolean hasNext() {
                        if (this.nextEntry == null && !this.atEof) {
                            this.nextEntry = this.readNextEntry();
                        }
                        return this.nextEntry != null;
                    }

                    @Override
                    public Path next() {
                        Path result;
                        if (this.nextEntry == null && !this.atEof) {
                            result = this.readNextEntry();
                        } else {
                            result = this.nextEntry;
                            this.nextEntry = null;
                        }
                        if (result == null) {
                            throw new NoSuchElementException();
                        }
                        return result;
                    }

                    private Path readNextEntry() {
                        JGitPathImpl result;
                        block3: {
                            JGitUtil.JGitPathInfo content;
                            JGitPathImpl path;
                            if (this.atEof) {
                                return null;
                            }
                            result = null;
                            do {
                                ++this.i;
                                if (this.i >= pathContent.size()) {
                                    this.atEof = true;
                                    break block3;
                                }
                                content = (JGitUtil.JGitPathInfo)pathContent.get(this.i);
                            } while (!val$filter.accept((Object)(path = JGitPathImpl.create((JGitFileSystem)gPath.getFileSystem(), "/" + content.getPath(), gPath.getHost(), content.getObjectId(), gPath.isRealPath()))));
                            result = path;
                        }
                        return result;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public void createDirectory(Path path, FileAttribute<?> ... attrs) throws UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        JGitPathImpl gPath = this.toPathImpl(path);
        Pair<JGitUtil.PathType, ObjectId> result = JGitUtil.checkPath(((JGitFileSystem)gPath.getFileSystem()).gitRepo(), gPath.getRefTree(), gPath.getPath());
        if (!((JGitUtil.PathType)((Object)result.getK1())).equals((Object)JGitUtil.PathType.NOT_FOUND)) {
            throw new FileAlreadyExistsException(path.toString());
        }
        try {
            OutputStream outputStream = this.newOutputStream(path.resolve(".gitignore"), new OpenOption[0]);
            outputStream.write("# empty\n".getBytes());
            outputStream.close();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) throws UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        throw new UnsupportedOperationException();
    }

    public void createLink(Path link, Path existing) throws UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        throw new UnsupportedOperationException();
    }

    public void delete(Path path, DeleteOption ... options) throws DirectoryNotEmptyException, NoSuchFileException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        if (path instanceof JGitFSPath) {
            this.deleteRepo(path.getFileSystem());
            return;
        }
        JGitPathImpl gPath = this.toPathImpl(path);
        if (this.isBranch(gPath)) {
            this.deleteBranch(gPath);
            return;
        }
        this.deleteAsset(gPath, options);
    }

    private boolean deleteRepo(FileSystem fileSystem) {
        File gitDir = ((JGitFileSystem)fileSystem).gitRepo().getRepository().getDirectory();
        fileSystem.close();
        fileSystem.dispose();
        try {
            if (System.getProperty("os.name").toLowerCase().contains("windows")) {
                WindowCache.reconfigure((WindowCacheConfig)new WindowCacheConfig());
            }
            FileUtils.delete((File)gitDir, (int)3);
            return true;
        }
        catch (java.io.IOException e) {
            throw new IOException((Exception)e);
        }
    }

    public void deleteAsset(JGitPathImpl path, DeleteOption ... options) {
        Pair<JGitUtil.PathType, ObjectId> result = JGitUtil.checkPath(((JGitFileSystem)path.getFileSystem()).gitRepo(), path.getRefTree(), path.getPath());
        if (((JGitUtil.PathType)((Object)result.getK1())).equals((Object)JGitUtil.PathType.DIRECTORY)) {
            if (this.deleteNonEmptyDirectory(options)) {
                this.deleteResource(path, options);
                return;
            }
            List<JGitUtil.JGitPathInfo> content = JGitUtil.listPathContent(((JGitFileSystem)path.getFileSystem()).gitRepo(), path.getRefTree(), path.getPath());
            if (content.size() == 1 && content.get(0).getPath().equals(path.getPath().substring(1) + "/.gitignore")) {
                this.delete(path.resolve(".gitignore"), new DeleteOption[0]);
                this.deleteResource(path, options);
                return;
            }
            throw new DirectoryNotEmptyException(path.toString());
        }
        if (((JGitUtil.PathType)((Object)result.getK1())).equals((Object)JGitUtil.PathType.NOT_FOUND)) {
            throw new NoSuchFileException(path.toString());
        }
        this.deleteResource(path, options);
    }

    void deleteResource(JGitPathImpl path, DeleteOption ... options) {
        this.delete(path, this.buildCommitInfo("delete {" + path.getPath() + "}", Arrays.asList(options)));
    }

    private boolean deleteNonEmptyDirectory(DeleteOption ... options) {
        for (DeleteOption option : options) {
            if (!option.equals(StandardDeleteOption.NON_EMPTY_DIRECTORIES)) continue;
            return true;
        }
        return false;
    }

    public void deleteBranch(JGitPathImpl path) {
        Ref branch = JGitUtil.getBranch(((JGitFileSystem)path.getFileSystem()).gitRepo(), path.getRefTree());
        if (branch == null) {
            throw new NoSuchFileException(path.toString());
        }
        JGitUtil.deleteBranch(((JGitFileSystem)path.getFileSystem()).gitRepo(), branch);
    }

    public boolean deleteIfExists(Path path, DeleteOption ... options) throws DirectoryNotEmptyException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        if (path instanceof JGitFSPath) {
            return this.deleteRepo(path.getFileSystem());
        }
        JGitPathImpl gPath = this.toPathImpl(path);
        if (this.isBranch(gPath)) {
            return this.deleteBranchIfExists(gPath);
        }
        return this.deleteAssetIfExists(gPath, options);
    }

    public boolean deleteBranchIfExists(JGitPathImpl path) {
        Ref branch = JGitUtil.getBranch(((JGitFileSystem)path.getFileSystem()).gitRepo(), path.getRefTree());
        if (branch == null) {
            return false;
        }
        JGitUtil.deleteBranch(((JGitFileSystem)path.getFileSystem()).gitRepo(), branch);
        return true;
    }

    public boolean deleteAssetIfExists(JGitPathImpl path, DeleteOption ... options) {
        Pair<JGitUtil.PathType, ObjectId> result = JGitUtil.checkPath(((JGitFileSystem)path.getFileSystem()).gitRepo(), path.getRefTree(), path.getPath());
        if (((JGitUtil.PathType)((Object)result.getK1())).equals((Object)JGitUtil.PathType.DIRECTORY)) {
            if (this.deleteNonEmptyDirectory(options)) {
                this.deleteResource(path, options);
                return true;
            }
            List<JGitUtil.JGitPathInfo> content = JGitUtil.listPathContent(((JGitFileSystem)path.getFileSystem()).gitRepo(), path.getRefTree(), path.getPath());
            if (content.size() == 1 && content.get(0).getPath().equals(path.getPath().substring(1) + "/.gitignore")) {
                this.delete(path.resolve(".gitignore"), new DeleteOption[0]);
                return true;
            }
            throw new DirectoryNotEmptyException(path.toString());
        }
        if (((JGitUtil.PathType)((Object)result.getK1())).equals((Object)JGitUtil.PathType.NOT_FOUND)) {
            return false;
        }
        this.deleteResource(path, options);
        return true;
    }

    private String deleteCommitMessage(String path, DeleteOption ... options) {
        return "delete {" + path + "}";
    }

    public Path readSymbolicLink(Path link) throws UnsupportedOperationException, NotLinkException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"link", (Object)link);
        throw new UnsupportedOperationException();
    }

    public void copy(Path source, Path target, CopyOption ... options) throws UnsupportedOperationException, FileAlreadyExistsException, DirectoryNotEmptyException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"source", (Object)source);
        Preconditions.checkNotNull((String)"target", (Object)target);
        JGitPathImpl gSource = this.toPathImpl(source);
        JGitPathImpl gTarget = this.toPathImpl(target);
        boolean isSourceBranch = this.isBranch(gSource);
        boolean isTargetBranch = this.isBranch(gTarget);
        if (isSourceBranch && isTargetBranch) {
            this.copyBranch(gSource, gTarget);
            return;
        }
        this.copyAsset(gSource, gTarget, options);
    }

    private void copyBranch(JGitPathImpl source, JGitPathImpl target) {
        Preconditions.checkCondition((String)"source and taget should have same setup", (!this.hasSameFileSystem(source, target) ? 1 : 0) != 0);
        if (this.existsBranch(target)) {
            throw new FileAlreadyExistsException(target.toString());
        }
        if (!this.existsBranch(source)) {
            throw new NoSuchFileException(target.toString());
        }
        this.createBranch(source, target);
    }

    private void copyAsset(JGitPathImpl source, JGitPathImpl target, CopyOption ... options) {
        Pair<JGitUtil.PathType, ObjectId> sourceResult = JGitUtil.checkPath(((JGitFileSystem)source.getFileSystem()).gitRepo(), source.getRefTree(), source.getPath());
        Pair<JGitUtil.PathType, ObjectId> targetResult = JGitUtil.checkPath(((JGitFileSystem)target.getFileSystem()).gitRepo(), target.getRefTree(), target.getPath());
        if (!this.isRoot(target) && targetResult.getK1() != JGitUtil.PathType.NOT_FOUND && !this.contains(options, (CopyOption)StandardCopyOption.REPLACE_EXISTING)) {
            throw new FileAlreadyExistsException(target.toString());
        }
        if (sourceResult.getK1() == JGitUtil.PathType.NOT_FOUND) {
            throw new NoSuchFileException(target.toString());
        }
        if (!source.getRefTree().equals(target.getRefTree())) {
            this.copyAssetContent(source, target, options);
        } else {
            HashMap<JGitPathImpl, JGitPathImpl> sourceDest = new HashMap<JGitPathImpl, JGitPathImpl>();
            if (sourceResult.getK1() == JGitUtil.PathType.DIRECTORY) {
                sourceDest.putAll(this.mapDirectoryContent(source, target, options));
            } else {
                sourceDest.put(source, target);
            }
            this.copyFiles(source, target, sourceDest, options);
        }
    }

    private void copyAssetContent(JGitPathImpl source, JGitPathImpl target, CopyOption ... options) {
        Pair<JGitUtil.PathType, ObjectId> sourceResult = JGitUtil.checkPath(((JGitFileSystem)source.getFileSystem()).gitRepo(), source.getRefTree(), source.getPath());
        Pair<JGitUtil.PathType, ObjectId> targetResult = JGitUtil.checkPath(((JGitFileSystem)target.getFileSystem()).gitRepo(), target.getRefTree(), target.getPath());
        if (!this.isRoot(target) && targetResult.getK1() != JGitUtil.PathType.NOT_FOUND && !this.contains(options, (CopyOption)StandardCopyOption.REPLACE_EXISTING)) {
            throw new FileAlreadyExistsException(target.toString());
        }
        if (sourceResult.getK1() == JGitUtil.PathType.NOT_FOUND) {
            throw new NoSuchFileException(target.toString());
        }
        if (sourceResult.getK1() == JGitUtil.PathType.DIRECTORY) {
            this.copyDirectory(source, target, options);
            return;
        }
        this.copyFile(source, target, options);
    }

    private boolean contains(CopyOption[] options, CopyOption opt) {
        for (CopyOption option : options) {
            if (!option.equals(opt)) continue;
            return true;
        }
        return false;
    }

    private void copyDirectory(JGitPathImpl source, JGitPathImpl target, CopyOption ... options) {
        ArrayList<JGitPathImpl> directories = new ArrayList<JGitPathImpl>();
        for (Path path : this.newDirectoryStream((Path)source, null)) {
            JGitPathImpl gPath = this.toPathImpl(path);
            Pair<JGitUtil.PathType, ObjectId> pathResult = JGitUtil.checkPath(((JGitFileSystem)gPath.getFileSystem()).gitRepo(), gPath.getRefTree(), gPath.getPath());
            if (pathResult.getK1() == JGitUtil.PathType.DIRECTORY) {
                directories.add(gPath);
                continue;
            }
            JGitPathImpl gTarget = this.composePath(target, (JGitPathImpl)gPath.getFileName(), new CopyOption[0]);
            this.copyFile(gPath, gTarget, new CopyOption[0]);
        }
        for (JGitPathImpl directory : directories) {
            this.createDirectory((Path)this.composePath(target, (JGitPathImpl)directory.getFileName(), new CopyOption[0]), new FileAttribute[0]);
        }
    }

    private JGitPathImpl composePath(JGitPathImpl directory, JGitPathImpl fileName, CopyOption ... options) {
        if (directory.getPath().endsWith("/")) {
            return this.toPathImpl(this.getPath(URI.create(directory.toUri().toString() + this.uriEncode(fileName.toString(false)))));
        }
        return this.toPathImpl(this.getPath(URI.create(directory.toUri().toString() + "/" + this.uriEncode(fileName.toString(false)))));
    }

    private String uriEncode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void copyFile(JGitPathImpl source, JGitPathImpl target, final CopyOption ... options) {
        InputStream in = this.newInputStream((Path)source, this.convert(options));
        SeekableByteChannel out = this.newByteChannel((Path)target, (Set<? extends OpenOption>)new HashSet<OpenOption>(){
            {
                this.add(StandardOpenOption.TRUNCATE_EXISTING);
                for (CopyOption _option : options) {
                    if (!(_option instanceof OpenOption)) continue;
                    this.add((OpenOption)_option);
                }
            }
        }, new FileAttribute[0]);
        try {
            int count;
            byte[] buffer = new byte[8192];
            while ((count = in.read(buffer)) > 0) {
                out.write(ByteBuffer.wrap(buffer, 0, count));
            }
            return;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            try {
                out.close();
            }
            catch (java.io.IOException e) {
                throw new IOException((Exception)e);
            }
            finally {
                try {
                    in.close();
                }
                catch (java.io.IOException e) {
                    throw new IOException((Exception)e);
                }
            }
        }
    }

    private OpenOption[] convert(CopyOption ... options) {
        if (options == null || options.length == 0) {
            return new OpenOption[0];
        }
        ArrayList<OpenOption> newOptions = new ArrayList<OpenOption>(options.length);
        for (CopyOption option : options) {
            if (!(option instanceof OpenOption)) continue;
            newOptions.add((OpenOption)option);
        }
        return newOptions.toArray(new OpenOption[newOptions.size()]);
    }

    private void createBranch(JGitPathImpl source, JGitPathImpl target) {
        JGitUtil.createBranch(((JGitFileSystem)source.getFileSystem()).gitRepo(), source.getRefTree(), target.getRefTree());
    }

    private boolean existsBranch(JGitPathImpl path) {
        return JGitUtil.hasBranch(((JGitFileSystem)path.getFileSystem()).gitRepo(), path.getRefTree());
    }

    private boolean isBranch(JGitPathImpl path) {
        return path.getPath().length() == 1 && path.getPath().equals("/");
    }

    private boolean isRoot(JGitPathImpl path) {
        return path.getPath().length() == 1 && path.getPath().equals("/");
    }

    private boolean hasSameFileSystem(JGitPathImpl source, JGitPathImpl target) {
        return ((JGitFileSystem)source.getFileSystem()).equals((Object)target);
    }

    public void move(Path source, Path target, CopyOption ... options) throws DirectoryNotEmptyException, AtomicMoveNotSupportedException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"source", (Object)source);
        Preconditions.checkNotNull((String)"target", (Object)target);
        JGitPathImpl gSource = this.toPathImpl(source);
        JGitPathImpl gTarget = this.toPathImpl(target);
        boolean isSourceBranch = this.isBranch(gSource);
        boolean isTargetBranch = this.isBranch(gTarget);
        if (isSourceBranch && isTargetBranch) {
            this.moveBranch(gSource, gTarget, options);
            return;
        }
        this.moveAsset(gSource, gTarget, options);
    }

    private void moveBranch(JGitPathImpl source, JGitPathImpl target, CopyOption ... options) {
        Preconditions.checkCondition((String)"source and taget should have same setup", (!this.hasSameFileSystem(source, target) ? 1 : 0) != 0);
        if (!this.exists((Path)source)) {
            throw new NoSuchFileException(target.toString());
        }
        boolean targetExists = this.existsBranch(target);
        if (targetExists && !this.contains(options, (CopyOption)StandardCopyOption.REPLACE_EXISTING)) {
            throw new FileAlreadyExistsException(target.toString());
        }
        if (!targetExists) {
            this.createBranch(source, target);
            this.deleteBranch(source);
        } else {
            this.commit(target, this.buildCommitInfo("reverting from {" + source.getPath() + "}", Arrays.asList(options)), new RevertCommitContent(source.getRefTree()));
        }
    }

    private void moveAsset(JGitPathImpl source, JGitPathImpl target, CopyOption ... options) {
        Pair<JGitUtil.PathType, ObjectId> sourceResult = JGitUtil.checkPath(((JGitFileSystem)source.getFileSystem()).gitRepo(), source.getRefTree(), source.getPath());
        Pair<JGitUtil.PathType, ObjectId> targetResult = JGitUtil.checkPath(((JGitFileSystem)target.getFileSystem()).gitRepo(), target.getRefTree(), target.getPath());
        if (!this.isRoot(target) && targetResult.getK1() != JGitUtil.PathType.NOT_FOUND && !this.contains(options, (CopyOption)StandardCopyOption.REPLACE_EXISTING)) {
            throw new FileAlreadyExistsException(target.toString());
        }
        if (sourceResult.getK1() == JGitUtil.PathType.NOT_FOUND) {
            throw new NoSuchFileException(target.toString());
        }
        if (!source.getRefTree().equals(target.getRefTree())) {
            this.copy((Path)source, (Path)target, options);
            this.delete((Path)source, new DeleteOption[0]);
        } else {
            HashMap<JGitPathImpl, JGitPathImpl> fromTo = new HashMap<JGitPathImpl, JGitPathImpl>();
            if (sourceResult.getK1() == JGitUtil.PathType.DIRECTORY) {
                fromTo.putAll(this.mapDirectoryContent(source, target, options));
            } else {
                fromTo.put(source, target);
            }
            this.moveFiles(source, target, fromTo, options);
        }
    }

    private Map<JGitPathImpl, JGitPathImpl> mapDirectoryContent(JGitPathImpl source, JGitPathImpl target, CopyOption ... options) {
        HashMap<JGitPathImpl, JGitPathImpl> fromTo = new HashMap<JGitPathImpl, JGitPathImpl>();
        for (Path path : this.newDirectoryStream((Path)source, null)) {
            JGitPathImpl gPath = this.toPathImpl(path);
            Pair<JGitUtil.PathType, ObjectId> pathResult = JGitUtil.checkPath(((JGitFileSystem)gPath.getFileSystem()).gitRepo(), gPath.getRefTree(), gPath.getPath());
            if (pathResult.getK1() == JGitUtil.PathType.DIRECTORY) {
                fromTo.putAll(this.mapDirectoryContent(gPath, this.composePath(target, (JGitPathImpl)gPath.getFileName(), new CopyOption[0]), new CopyOption[0]));
                continue;
            }
            JGitPathImpl gTarget = this.composePath(target, (JGitPathImpl)gPath.getFileName(), new CopyOption[0]);
            fromTo.put(gPath, gTarget);
        }
        return fromTo;
    }

    private void moveFiles(JGitPathImpl source, JGitPathImpl target, Map<JGitPathImpl, JGitPathImpl> fromTo, CopyOption ... options) {
        HashMap<String, String> result = new HashMap<String, String>(fromTo.size());
        for (Map.Entry<JGitPathImpl, JGitPathImpl> fromToEntry : fromTo.entrySet()) {
            result.put(JGitUtil.fixPath(fromToEntry.getKey().getPath()), JGitUtil.fixPath(fromToEntry.getValue().getPath()));
        }
        this.commit(source, this.buildCommitInfo("moving from {" + source.getPath() + "} to {" + target.getPath() + "}", Arrays.asList(options)), new MoveCommitContent(result));
    }

    private void copyFiles(JGitPathImpl source, JGitPathImpl target, Map<JGitPathImpl, JGitPathImpl> sourceDest, CopyOption ... options) {
        HashMap<String, String> result = new HashMap<String, String>(sourceDest.size());
        for (Map.Entry<JGitPathImpl, JGitPathImpl> sourceDestEntry : sourceDest.entrySet()) {
            result.put(JGitUtil.fixPath(sourceDestEntry.getKey().getPath()), JGitUtil.fixPath(sourceDestEntry.getValue().getPath()));
        }
        this.commit(source, this.buildCommitInfo("copy from {" + source.getPath() + "} to {" + target.getPath() + "}", Arrays.asList(options)), new CopyCommitContent(result));
    }

    public boolean isSameFile(Path pathA, Path pathB) throws IOException, SecurityException {
        Preconditions.checkNotNull((String)"pathA", (Object)pathA);
        Preconditions.checkNotNull((String)"pathB", (Object)pathB);
        JGitPathImpl gPathA = this.toPathImpl(pathA);
        JGitPathImpl gPathB = this.toPathImpl(pathB);
        Pair<JGitUtil.PathType, ObjectId> resultA = JGitUtil.checkPath(((JGitFileSystem)gPathA.getFileSystem()).gitRepo(), gPathA.getRefTree(), gPathA.getPath());
        Pair<JGitUtil.PathType, ObjectId> resultB = JGitUtil.checkPath(((JGitFileSystem)gPathB.getFileSystem()).gitRepo(), gPathB.getRefTree(), gPathB.getPath());
        if (resultA.getK1() == JGitUtil.PathType.FILE && ((ObjectId)resultA.getK2()).equals((AnyObjectId)resultB.getK2())) {
            return true;
        }
        return pathA.equals(pathB);
    }

    public boolean isHidden(Path path) throws IllegalArgumentException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        JGitPathImpl gPath = this.toPathImpl(path);
        if (gPath.getFileName() == null) {
            return false;
        }
        return this.toPathImpl(path.getFileName()).toString(false).startsWith(".");
    }

    public FileStore getFileStore(Path path) throws IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        return new JGitFileStore(((JGitFileSystem)this.toPathImpl(path).getFileSystem()).gitRepo().getRepository());
    }

    public void checkAccess(Path path, AccessMode ... modes) throws UnsupportedOperationException, NoSuchFileException, AccessDeniedException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        JGitPathImpl gPath = this.toPathImpl(path);
        Pair<JGitUtil.PathType, ObjectId> result = JGitUtil.checkPath(((JGitFileSystem)gPath.getFileSystem()).gitRepo(), gPath.getRefTree(), gPath.getPath());
        if (((JGitUtil.PathType)((Object)result.getK1())).equals((Object)JGitUtil.PathType.NOT_FOUND)) {
            throw new NoSuchFileException(path.toString());
        }
    }

    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) throws NoSuchFileException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        Preconditions.checkNotNull((String)"type", type);
        JGitPathImpl gPath = this.toPathImpl(path);
        Pair<JGitUtil.PathType, ObjectId> pathResult = JGitUtil.checkPath(((JGitFileSystem)gPath.getFileSystem()).gitRepo(), gPath.getRefTree(), gPath.getPath());
        if (((JGitUtil.PathType)((Object)pathResult.getK1())).equals((Object)JGitUtil.PathType.NOT_FOUND)) {
            throw new NoSuchFileException(path.toString());
        }
        FileAttributeView resultView = (FileAttributeView)gPath.getAttrView(type);
        if (resultView == null) {
            if (type == BasicFileAttributeView.class || type == JGitBasicAttributeView.class) {
                JGitBasicAttributeView newView = new JGitBasicAttributeView(gPath);
                gPath.addAttrView((AttributeView)newView);
                return (V)((Object)newView);
            }
            if (type == VersionAttributeView.class || type == JGitVersionAttributeView.class) {
                JGitVersionAttributeView newView = new JGitVersionAttributeView(gPath);
                gPath.addAttrView((AttributeView)newView);
                return (V)((Object)newView);
            }
        }
        return (V)resultView;
    }

    private ExtendedAttributeView getFileAttributeView(JGitPathImpl path, String name, LinkOption ... options) {
        ExtendedAttributeView view = (ExtendedAttributeView)path.getAttrView(name);
        if (view == null) {
            if (name.equals("basic")) {
                JGitBasicAttributeView newView = new JGitBasicAttributeView(path);
                path.addAttrView((AttributeView)newView);
                return newView;
            }
            if (name.equals("version")) {
                JGitVersionAttributeView newView = new JGitVersionAttributeView(path);
                path.addAttrView((AttributeView)newView);
                return newView;
            }
        }
        return view;
    }

    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws NoSuchFileException, UnsupportedOperationException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        Preconditions.checkNotNull((String)"type", type);
        JGitPathImpl gPath = this.toPathImpl(path);
        Pair<JGitUtil.PathType, ObjectId> pathResult = JGitUtil.checkPath(((JGitFileSystem)gPath.getFileSystem()).gitRepo(), gPath.getRefTree(), gPath.getPath());
        if (((JGitUtil.PathType)((Object)pathResult.getK1())).equals((Object)JGitUtil.PathType.NOT_FOUND)) {
            throw new NoSuchFileException(path.toString());
        }
        if (type == VersionAttributes.class) {
            JGitVersionAttributeView view = this.getFileAttributeView(path, JGitVersionAttributeView.class, options);
            return (A)view.readAttributes();
        }
        if (type == BasicFileAttributesImpl.class || type == BasicFileAttributes.class) {
            JGitBasicAttributeView view = this.getFileAttributeView(path, JGitBasicAttributeView.class, options);
            return (A)view.readAttributes();
        }
        return null;
    }

    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws UnsupportedOperationException, IllegalArgumentException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        Preconditions.checkNotEmpty((String)"attributes", (String)attributes);
        String[] s = this.split(attributes);
        if (s[0].length() == 0) {
            throw new IllegalArgumentException(attributes);
        }
        ExtendedAttributeView view = this.getFileAttributeView(this.toPathImpl(path), s[0], options);
        if (view == null) {
            throw new UnsupportedOperationException("View '" + s[0] + "' not available");
        }
        return view.readAttributes(s[1].split(","));
    }

    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws UnsupportedOperationException, IllegalArgumentException, ClassCastException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        Preconditions.checkNotEmpty((String)"attributes", (String)attribute);
        if (attribute.equals(FileSystemState.FILE_SYSTEM_STATE_ATTR)) {
            if (value instanceof CommentedOption) {
                this.batchCommitInfo = this.buildCommitInfo("Batch mode", (CommentedOption)value);
                return;
            }
            boolean isOriginalStateBatch = this.state.equals((Object)FileSystemState.BATCH);
            try {
                this.state = FileSystemState.valueOf((String)value.toString());
                FileSystemState.valueOf((String)value.toString());
            }
            catch (Exception ex) {
                this.state = FileSystemState.NORMAL;
            }
            if (isOriginalStateBatch && this.state.equals((Object)FileSystemState.NORMAL)) {
                this.batchCommitInfo = null;
                this.notifyAllDiffs();
            }
            this.hadCommitOnBatchState = false;
            return;
        }
        String[] s = this.split(attribute);
        if (s[0].length() == 0) {
            throw new IllegalArgumentException(attribute);
        }
        ExtendedAttributeView view = this.getFileAttributeView(this.toPathImpl(path), s[0], options);
        if (view == null) {
            throw new UnsupportedOperationException("View '" + s[0] + "' not available");
        }
        view.setAttribute(s[1], value);
    }

    private void checkURI(String paramName, URI uri) throws IllegalArgumentException {
        Preconditions.checkNotNull((String)"uri", (Object)uri);
        if (uri.getAuthority() == null || uri.getAuthority().isEmpty()) {
            throw new IllegalArgumentException("Parameter named '" + paramName + "' is invalid, missing host repository!");
        }
        int atIndex = uri.getPath().indexOf("@");
        if (atIndex != -1 && !uri.getAuthority().contains("@") && uri.getPath().indexOf("/", atIndex) == -1) {
            throw new IllegalArgumentException("Parameter named '" + paramName + "' is invalid, missing host repository!");
        }
    }

    private String extractHost(URI uri) {
        Preconditions.checkNotNull((String)"uri", (Object)uri);
        int atIndex = uri.getPath().indexOf("@");
        if (atIndex != -1 && !uri.getAuthority().contains("@")) {
            return uri.getAuthority() + uri.getPath().substring(0, uri.getPath().indexOf("/", atIndex));
        }
        return uri.getAuthority();
    }

    private String extractRepoName(URI uri) {
        Preconditions.checkNotNull((String)"uri", (Object)uri);
        String host = this.extractHost(uri);
        int index = host.indexOf(64);
        if (index != -1) {
            return host.substring(index + 1);
        }
        return host;
    }

    private boolean hasSyncFlag(URI uri) {
        Preconditions.checkNotNull((String)"uri", (Object)uri);
        if (uri.getQuery() != null) {
            return uri.getQuery().contains("sync");
        }
        return false;
    }

    private boolean hasForceFlag(URI uri) {
        Preconditions.checkNotNull((String)"uri", (Object)uri);
        if (uri.getQuery() != null) {
            return uri.getQuery().contains("force");
        }
        return false;
    }

    private boolean hasPushFlag(URI uri) {
        Preconditions.checkNotNull((String)"uri", (Object)uri);
        if (uri.getQuery() != null) {
            return uri.getQuery().contains("push");
        }
        return false;
    }

    private static Map<String, String> getQueryParams(URI uri) {
        final String[] params = uri.getQuery().split("&");
        return new HashMap<String, String>(params.length){
            {
                super(x0);
                for (String param : params) {
                    String[] kv = param.split("=");
                    String name = kv[0];
                    String value = kv.length == 2 ? kv[1] : "";
                    this.put(name, value);
                }
            }
        };
    }

    private String extractPath(URI uri) {
        String path;
        Preconditions.checkNotNull((String)"uri", (Object)uri);
        String host = this.extractHost(uri);
        try {
            path = URIUtil.decode((String)uri.toString()).substring(this.getSchemeSize(uri) + host.length());
        }
        catch (URIException e) {
            return null;
        }
        if (path.startsWith("/:")) {
            return path.substring(2);
        }
        return path;
    }

    private CredentialsProvider buildCredential(Map<String, ?> env) {
        if (env != null && env.containsKey(USER_NAME)) {
            if (env.containsKey(PASSWORD)) {
                return new UsernamePasswordCredentialsProvider(env.get(USER_NAME).toString(), env.get(PASSWORD).toString());
            }
            return new UsernamePasswordCredentialsProvider(env.get(USER_NAME).toString(), "");
        }
        return CredentialsProvider.getDefault();
    }

    private JGitPathImpl toPathImpl(Path path) {
        if (path instanceof JGitPathImpl) {
            return (JGitPathImpl)path;
        }
        throw new IllegalArgumentException("Path not supported by current provider.");
    }

    private String[] split(String attribute) {
        String[] s = new String[2];
        int pos = attribute.indexOf(58);
        if (pos == -1) {
            s[0] = "basic";
            s[1] = attribute;
        } else {
            s[0] = attribute.substring(0, pos);
            s[1] = pos == attribute.length() ? "" : attribute.substring(pos + 1);
        }
        return s;
    }

    private int getSchemeSize(URI uri) {
        if (uri.getScheme().equals(SCHEME)) {
            return SCHEME_SIZE;
        }
        return DEFAULT_SCHEME_SIZE;
    }

    private void delete(final JGitPathImpl path, CommitInfo commitInfo) {
        this.commit(path, commitInfo, new DefaultCommitContent((Map<String, File>)new HashMap<String, File>(){
            {
                this.put(path.getPath(), null);
            }
        }));
    }

    private void commit(JGitPathImpl path, CommitInfo commitInfo, CommitContent commitContent) {
        Git git = ((JGitFileSystem)path.getFileSystem()).gitRepo();
        String branchName = path.getRefTree();
        boolean batchState = this.state == FileSystemState.BATCH;
        boolean amend = batchState && this.hadCommitOnBatchState;
        ObjectId oldHead = JGitUtil.getTreeRefObjectId(((JGitFileSystem)path.getFileSystem()).gitRepo().getRepository(), branchName);
        boolean hasCommit = batchState && this.batchCommitInfo != null ? JGitUtil.commit(git, branchName, this.batchCommitInfo, amend, commitContent) : JGitUtil.commit(git, branchName, commitInfo, amend, commitContent);
        if (!batchState) {
            ObjectId newHead = JGitUtil.getTreeRefObjectId(((JGitFileSystem)path.getFileSystem()).gitRepo().getRepository(), branchName);
            this.notifyDiffs((JGitFileSystem)path.getFileSystem(), branchName, commitInfo.getSessionId(), commitInfo.getName(), oldHead, newHead);
        } else if (!this.oldHeadsOfPendingDiffs.containsKey(path.getFileSystem()) || !this.oldHeadsOfPendingDiffs.get(path.getFileSystem()).containsKey(branchName)) {
            if (!this.oldHeadsOfPendingDiffs.containsKey(path.getFileSystem())) {
                this.oldHeadsOfPendingDiffs.put((JGitFileSystem)path.getFileSystem(), new HashMap());
            }
            if (this.batchCommitInfo != null) {
                this.oldHeadsOfPendingDiffs.get(path.getFileSystem()).put(branchName, new NotificationModel(oldHead, this.batchCommitInfo.getSessionId(), this.batchCommitInfo.getName()));
            } else {
                this.oldHeadsOfPendingDiffs.get(path.getFileSystem()).put(branchName, new NotificationModel(oldHead, commitInfo.getSessionId(), commitInfo.getName()));
            }
        }
        if (this.state == FileSystemState.BATCH && !this.hadCommitOnBatchState) {
            this.hadCommitOnBatchState = hasCommit;
        }
    }

    private void notifyAllDiffs() {
        for (Map.Entry<JGitFileSystem, Map<String, NotificationModel>> jGitFileSystemMapEntry : this.oldHeadsOfPendingDiffs.entrySet()) {
            for (Map.Entry<String, NotificationModel> branchNameNotificationModelEntry : jGitFileSystemMapEntry.getValue().entrySet()) {
                ObjectId newHead = JGitUtil.getTreeRefObjectId(jGitFileSystemMapEntry.getKey().gitRepo().getRepository(), branchNameNotificationModelEntry.getKey());
                this.notifyDiffs(jGitFileSystemMapEntry.getKey(), branchNameNotificationModelEntry.getKey(), branchNameNotificationModelEntry.getValue().getSessionId(), branchNameNotificationModelEntry.getValue().getUserName(), branchNameNotificationModelEntry.getValue().getOriginalHead(), newHead);
            }
        }
        this.oldHeadsOfPendingDiffs.clear();
    }

    private void notifyDiffs(JGitFileSystem fs, String _tree, String sessionId, String userName, ObjectId oldHead, ObjectId newHead) {
        String tree = _tree.startsWith("refs/") ? _tree.substring(_tree.lastIndexOf("/") + 1) : _tree;
        String host = tree + "@" + fs.getName();
        JGitPathImpl root = JGitPathImpl.createRoot(fs, "/", host, false);
        List<DiffEntry> diff = JGitUtil.getDiff(fs.gitRepo().getRepository(), oldHead, newHead);
        ArrayList events = new ArrayList(diff.size());
        for (final DiffEntry diffEntry : diff) {
            JGitPathImpl newPath;
            JGitPathImpl oldPath = !diffEntry.getOldPath().equals("/dev/null") ? JGitPathImpl.create(fs, "/" + diffEntry.getOldPath(), host, null, false) : null;
            if (!diffEntry.getNewPath().equals("/dev/null")) {
                JGitUtil.JGitPathInfo pathInfo = JGitUtil.resolvePath(fs.gitRepo(), tree, diffEntry.getNewPath());
                newPath = JGitPathImpl.create(fs, "/" + pathInfo.getPath(), host, pathInfo.getObjectId(), false);
            } else {
                newPath = null;
            }
            events.add(new WatchEvent((Path)newPath, (Path)oldPath, sessionId, userName){
                final /* synthetic */ Path val$newPath;
                final /* synthetic */ Path val$oldPath;
                final /* synthetic */ String val$sessionId;
                final /* synthetic */ String val$userName;
                {
                    this.val$newPath = path;
                    this.val$oldPath = path2;
                    this.val$sessionId = string;
                    this.val$userName = string2;
                }

                public WatchEvent.Kind kind() {
                    switch (diffEntry.getChangeType()) {
                        case ADD: 
                        case COPY: {
                            return StandardWatchEventKind.ENTRY_CREATE;
                        }
                        case DELETE: {
                            return StandardWatchEventKind.ENTRY_DELETE;
                        }
                        case MODIFY: {
                            return StandardWatchEventKind.ENTRY_MODIFY;
                        }
                        case RENAME: {
                            return StandardWatchEventKind.ENTRY_RENAME;
                        }
                    }
                    throw new RuntimeException();
                }

                public int count() {
                    return 1;
                }

                public Object context() {
                    return new WatchContext(){

                        public Path getPath() {
                            return val$newPath;
                        }

                        public Path getOldPath() {
                            return val$oldPath;
                        }

                        public String getSessionId() {
                            return val$sessionId;
                        }

                        public String getUser() {
                            return val$userName;
                        }
                    };
                }

                public String toString() {
                    return "WatchEvent{newPath=" + this.val$newPath + ", oldPath=" + this.val$oldPath + ", sessionId='" + this.val$sessionId + '\'' + ", userName='" + this.val$userName + '\'' + ", changeType=" + diffEntry.getChangeType() + '}';
                }
            });
        }
        if (!events.isEmpty()) {
            fs.publishEvents((Path)root, events);
        }
    }

    static {
        SCHEME_SIZE = "git://".length();
        DEFAULT_SCHEME_SIZE = "default://".length();
        provider = null;
    }

    public final class RepositoryResolverImpl<T>
    implements RepositoryResolver<T> {
        public Repository open(T client, String name) throws RepositoryNotFoundException, ServiceNotAuthorizedException, ServiceNotEnabledException, ServiceMayNotContinueException {
            JGitFileSystem fs = (JGitFileSystem)JGitFileSystemProvider.this.fileSystems.get(name);
            if (fs == null) {
                throw new RepositoryNotFoundException(name);
            }
            return fs.gitRepo().getRepository();
        }

        public JGitFileSystem resolveFileSystem(Repository repository) {
            return (JGitFileSystem)JGitFileSystemProvider.this.repoIndex.get(repository);
        }
    }
}

