/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.net.URI;
import org.fest.assertions.api.Assertions;
import org.junit.Test;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProvider;

public class JGitFileSystemProviderAsDefaultTest
extends AbstractTestInfra {
    private static final JGitFileSystemProvider PROVIDER = JGitFileSystemProvider.getInstance();

    @Test
    public void testGetPath() {
        URI newRepo = URI.create("default://default-new-get-repo-name");
        PROVIDER.newFileSystem(newRepo, EMPTY_ENV);
        Path path = PROVIDER.getPath(URI.create("default://master@default-new-get-repo-name/home"));
        Assertions.assertThat((Iterable)path).isNotNull();
        Assertions.assertThat((String)path.getRoot().toString()).isEqualTo((Object)"/");
        Assertions.assertThat((String)path.toString()).isEqualTo((Object)"/home");
        Assertions.assertThat((String)path.toUri().getScheme()).isEqualTo((Object)"default");
        Path pathRelative = PROVIDER.getPath(URI.create("default://master@default-new-get-repo-name/:home"));
        Assertions.assertThat((Iterable)pathRelative).isNotNull();
        Assertions.assertThat((String)pathRelative.toUri().toString()).isEqualTo((Object)"default://master@default-new-get-repo-name/:home");
        Assertions.assertThat((String)pathRelative.getRoot().toString()).isEqualTo((Object)"");
        Assertions.assertThat((String)pathRelative.toString()).isEqualTo((Object)"home");
    }

    @Test
    public void testGetComplexPath() {
        URI newRepo = URI.create("default://default-new-complex-get-repo-name");
        PROVIDER.newFileSystem(newRepo, EMPTY_ENV);
        Path path = PROVIDER.getPath(URI.create("default://origin/master@default-new-complex-get-repo-name/home"));
        Assertions.assertThat((Iterable)path).isNotNull();
        Assertions.assertThat((String)path.getRoot().toString()).isEqualTo((Object)"/");
        Assertions.assertThat((String)path.toString()).isEqualTo((Object)"/home");
        Assertions.assertThat((String)path.toUri().getScheme()).isEqualTo((Object)"default");
        Path pathRelative = PROVIDER.getPath(URI.create("default://origin/master@default-new-complex-get-repo-name/:home"));
        Assertions.assertThat((Iterable)pathRelative).isNotNull();
        Assertions.assertThat((String)pathRelative.getRoot().toString()).isEqualTo((Object)"");
        Assertions.assertThat((String)pathRelative.getRoot().toUri().toString()).isEqualTo((Object)"default://origin/master@default-new-complex-get-repo-name");
        Assertions.assertThat((String)pathRelative.toString()).isEqualTo((Object)"home");
    }

    static {
        PROVIDER.forceAsDefault();
    }
}

