/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.io.FileUtils;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.FS;
import org.uberfire.commons.data.Pair;
import org.uberfire.commons.validation.Preconditions;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.base.FileTimeImpl;
import org.uberfire.java.nio.base.version.VersionAttributes;
import org.uberfire.java.nio.base.version.VersionHistory;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;
import org.uberfire.java.nio.file.attribute.FileTime;
import org.uberfire.java.nio.fs.jgit.CommitInfo;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.util.CommitContent;
import org.uberfire.java.nio.fs.jgit.util.CopyCommitContent;
import org.uberfire.java.nio.fs.jgit.util.CustomDiffCommand;
import org.uberfire.java.nio.fs.jgit.util.DefaultCommitContent;
import org.uberfire.java.nio.fs.jgit.util.MoveCommitContent;
import org.uberfire.java.nio.fs.jgit.util.RevertCommitContent;

public final class JGitUtil {
    private JGitUtil() {
    }

    public static Git newRepository(File repoFolder, boolean bare) throws IOException {
        Preconditions.checkNotNull((String)"repoFolder", (Object)repoFolder);
        try {
            return Git.init().setBare(bare).setDirectory(repoFolder).call();
        }
        catch (GitAPIException e) {
            throw new IOException((Exception)((Object)e));
        }
    }

    public static List<Ref> branchList(Git git) {
        Preconditions.checkNotNull((String)"git", (Object)git);
        return JGitUtil.branchList(git, null);
    }

    public static List<Ref> branchList(Git git, ListBranchCommand.ListMode listMode) {
        Preconditions.checkNotNull((String)"git", (Object)git);
        try {
            return git.branchList().setListMode(listMode).call();
        }
        catch (GitAPIException e) {
            throw new RuntimeException(e);
        }
    }

    public static InputStream resolveInputStream(Git git, String treeRef, String path) {
        Preconditions.checkNotNull((String)"git", (Object)git);
        Preconditions.checkNotEmpty((String)"treeRef", (String)treeRef);
        Preconditions.checkNotEmpty((String)"path", (String)path);
        String gitPath = JGitUtil.fixPath(path);
        RevWalk rw = null;
        TreeWalk tw = null;
        try {
            ObjectId tree = git.getRepository().resolve(treeRef + "^{tree}");
            rw = new RevWalk(git.getRepository());
            tw = new TreeWalk(git.getRepository());
            tw.setFilter(PathFilterGroup.createFromStrings(Collections.singleton(gitPath)));
            tw.reset((AnyObjectId)tree);
            while (tw.next()) {
                if (tw.isSubtree() && !gitPath.equals(tw.getPathString())) {
                    tw.enterSubtree();
                    continue;
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(git.getRepository().open((AnyObjectId)tw.getObjectId(0), 3).getBytes());
                return byteArrayInputStream;
            }
        }
        catch (Throwable t) {
            throw new NoSuchFileException("Can't find '" + gitPath + "' in tree '" + treeRef + "'");
        }
        finally {
            if (rw != null) {
                rw.dispose();
            }
            if (tw != null) {
                tw.release();
            }
        }
        throw new NoSuchFileException("");
    }

    public static String fixPath(String path) {
        if (path.equals("/")) {
            return "";
        }
        boolean startsWith = path.startsWith("/");
        boolean endsWith = path.endsWith("/");
        if (startsWith && endsWith) {
            return path.substring(1, path.length() - 1);
        }
        if (startsWith) {
            return path.substring(1);
        }
        if (endsWith) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static Git cloneRepository(File repoFolder, String fromURI, boolean bare, CredentialsProvider credentialsProvider) {
        if (!repoFolder.getName().endsWith(".git")) {
            throw new RuntimeException("Invalid name");
        }
        try {
            Git git;
            FileRepository repository;
            File gitDir = RepositoryCache.FileKey.resolve((File)repoFolder, (FS)FS.DETECTED);
            if (gitDir != null && gitDir.exists()) {
                repository = new FileRepository(gitDir);
                git = new Git((Repository)repository);
            } else {
                git = ((CloneCommand)Git.cloneRepository().setBare(bare).setCloneAllBranches(true).setURI(fromURI).setDirectory(repoFolder).setCredentialsProvider(credentialsProvider)).call();
                repository = git.getRepository();
            }
            JGitUtil.fetchRepository(git, credentialsProvider, new RefSpec[0]);
            repository.close();
            return git;
        }
        catch (Exception ex) {
            try {
                FileUtils.forceDelete((File)repoFolder);
            }
            catch (java.io.IOException e) {
                throw new RuntimeException(e);
            }
            throw new RuntimeException(ex);
        }
    }

    public static void fetchRepository(Git git, CredentialsProvider credentialsProvider, RefSpec ... refSpecs) throws InvalidRemoteException {
        ArrayList<RefSpec> specs = new ArrayList<RefSpec>();
        if (refSpecs == null || refSpecs.length == 0) {
            specs.add(new RefSpec("+refs/heads/*:refs/remotes/origin/*"));
            specs.add(new RefSpec("+refs/tags/*:refs/tags/*"));
            specs.add(new RefSpec("+refs/notes/*:refs/notes/*"));
        } else {
            specs.addAll(Arrays.asList(refSpecs));
        }
        try {
            ((FetchCommand)git.fetch().setCredentialsProvider(credentialsProvider)).setRefSpecs(specs).call();
        }
        catch (InvalidRemoteException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void syncRepository(Git git, CredentialsProvider credentialsProvider, String origin, boolean force) throws InvalidRemoteException {
        if (origin == null || origin.isEmpty()) {
            JGitUtil.fetchRepository(git, credentialsProvider, new RefSpec[0]);
        } else {
            try {
                StoredConfig config = git.getRepository().getConfig();
                config.setString("remote", "upstream", "url", origin);
                config.save();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            ArrayList<RefSpec> specs = new ArrayList<RefSpec>();
            specs.add(new RefSpec("+refs/heads/*:refs/remotes/upstream/*"));
            specs.add(new RefSpec("+refs/tags/*:refs/tags/*"));
            specs.add(new RefSpec("+refs/notes/*:refs/notes/*"));
            try {
                ((FetchCommand)git.fetch().setCredentialsProvider(credentialsProvider)).setRefSpecs(specs).setRemote(origin).call();
                git.branchCreate().setName("master").setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.SET_UPSTREAM).setStartPoint("upstream/master").setForce(true).call();
            }
            catch (InvalidRemoteException e) {
                throw e;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static void pushRepository(Git git, CredentialsProvider credentialsProvider, String origin, boolean force) throws InvalidRemoteException {
        if (origin != null && !origin.isEmpty()) {
            try {
                StoredConfig config = git.getRepository().getConfig();
                config.setString("remote", "upstream", "url", origin);
                config.save();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            ArrayList<RefSpec> specs = new ArrayList<RefSpec>();
            specs.add(new RefSpec("+refs/heads/*:refs/remotes/upstream/*"));
            specs.add(new RefSpec("+refs/tags/*:refs/tags/*"));
            specs.add(new RefSpec("+refs/notes/*:refs/notes/*"));
            try {
                ((PushCommand)git.push().setCredentialsProvider(credentialsProvider)).setRefSpecs(specs).setRemote(origin).setForce(force).setPushAll().call();
            }
            catch (InvalidRemoteException e) {
                throw e;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static ObjectId getTreeRefObjectId(Repository repo, String treeRef) {
        try {
            return repo.resolve(treeRef + "^{tree}");
        }
        catch (java.io.IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static List<DiffEntry> getDiff(Repository repo, ObjectId oldRef, ObjectId newRef) {
        if (oldRef == null || newRef == null || repo == null) {
            return Collections.emptyList();
        }
        try {
            ObjectReader reader = repo.newObjectReader();
            CanonicalTreeParser oldTreeIter = new CanonicalTreeParser();
            oldTreeIter.reset(reader, (AnyObjectId)oldRef);
            CanonicalTreeParser newTreeIter = new CanonicalTreeParser();
            newTreeIter.reset(reader, (AnyObjectId)newRef);
            return new CustomDiffCommand(repo).setNewTree((AbstractTreeIterator)newTreeIter).setOldTree((AbstractTreeIterator)oldTreeIter).setShowNameAndStatusOnly(true).call();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void commit(Git git, String branchName, String name, String email, String message, TimeZone timeZone, Date when, boolean amend, Map<String, File> content) {
        JGitUtil.commit(git, branchName, new CommitInfo(null, name, email, message, timeZone, when), amend, new DefaultCommitContent(content));
    }

    public static boolean commit(Git git, String branchName, CommitInfo commitInfo, boolean amend, CommitContent content) {
        if (content instanceof RevertCommitContent) {
            return JGitUtil.commit(git, branchName, commitInfo, amend, JGitUtil.resolveObjectId(git, ((RevertCommitContent)content).getRefTree()), content);
        }
        return JGitUtil.commit(git, branchName, commitInfo, amend, null, content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean commit(Git git, String branchName, CommitInfo commitInfo, boolean amend, ObjectId _originId, CommitContent content) {
        boolean hadEffecitiveCommit = true;
        PersonIdent author = JGitUtil.buildPersonIdent(git, commitInfo.getName(), commitInfo.getEmail(), commitInfo.getTimeZone(), commitInfo.getWhen());
        try {
            ObjectInserter odi = git.getRepository().newObjectInserter();
            try {
                void var11_17;
                ObjectId headId = git.getRepository().resolve(branchName + "^{commit}");
                ObjectId originId = _originId == null ? git.getRepository().resolve(branchName + "^{commit}") : _originId;
                if (content instanceof DefaultCommitContent) {
                    DirCache dirCache = JGitUtil.createTemporaryIndex(git, originId, (DefaultCommitContent)content);
                } else if (content instanceof MoveCommitContent) {
                    DirCache dirCache = JGitUtil.createTemporaryIndex(git, originId, (MoveCommitContent)content);
                } else if (content instanceof CopyCommitContent) {
                    DirCache dirCache = JGitUtil.createTemporaryIndex(git, originId, (CopyCommitContent)content);
                } else if (content instanceof RevertCommitContent) {
                    DirCache dirCache = JGitUtil.createTemporaryIndex(git, originId);
                } else {
                    Object var11_16 = null;
                }
                if (var11_17 != null) {
                    ObjectId indexTreeId = var11_17.writeTree(odi);
                    CommitBuilder commit = new CommitBuilder();
                    commit.setAuthor(author);
                    commit.setCommitter(author);
                    commit.setEncoding("UTF-8");
                    commit.setMessage(commitInfo.getMessage());
                    if (headId != null) {
                        if (amend) {
                            RevCommit[] p;
                            LinkedList<ObjectId> parents = new LinkedList<ObjectId>();
                            RevCommit previousCommit = new RevWalk(git.getRepository()).parseCommit((AnyObjectId)headId);
                            for (RevCommit revCommit : p = previousCommit.getParents()) {
                                parents.add(0, revCommit.getId());
                            }
                            commit.setParentIds(parents);
                        } else {
                            commit.setParentId((AnyObjectId)headId);
                        }
                    }
                    commit.setTreeId((AnyObjectId)indexTreeId);
                    ObjectId commitId = odi.insert(commit);
                    odi.flush();
                    RevWalk revWalk = new RevWalk(git.getRepository());
                    try {
                        RevCommit revCommit = revWalk.parseCommit((AnyObjectId)commitId);
                        RefUpdate ru = git.getRepository().updateRef("refs/heads/" + branchName);
                        if (headId == null) {
                            ru.setExpectedOldObjectId((AnyObjectId)ObjectId.zeroId());
                        } else {
                            ru.setExpectedOldObjectId((AnyObjectId)headId);
                        }
                        ru.setNewObjectId((AnyObjectId)commitId);
                        ru.setRefLogMessage("commit: " + revCommit.getShortMessage(), false);
                        RefUpdate.Result rc = ru.forceUpdate();
                        switch (rc) {
                            case NEW: 
                            case FORCED: 
                            case FAST_FORWARD: {
                                return hadEffecitiveCommit;
                            }
                            case REJECTED: 
                            case LOCK_FAILURE: {
                                throw new ConcurrentRefUpdateException(JGitText.get().couldNotLockHEAD, ru.getRef(), rc);
                            }
                            default: {
                                throw new JGitInternalException(MessageFormat.format(JGitText.get().updatingRefFailed, "HEAD", commitId.toString(), rc));
                            }
                        }
                    }
                    finally {
                        revWalk.release();
                    }
                }
                hadEffecitiveCommit = false;
                return hadEffecitiveCommit;
            }
            finally {
                odi.release();
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static PersonIdent buildPersonIdent(Git git, String name, String _email, TimeZone timeZone, Date when) {
        String email;
        TimeZone tz = timeZone == null ? TimeZone.getDefault() : timeZone;
        String string = email = _email == null ? "" : _email;
        if (name != null) {
            if (when != null) {
                return new PersonIdent(name, email, when, tz);
            }
            return new PersonIdent(name, email);
        }
        return new PersonIdent(git.getRepository());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DirCache createTemporaryIndex(Git git, ObjectId headId, DefaultCommitContent commitContent) {
        Map<String, File> content = commitContent.getContent();
        HashMap<String, Pair> paths = new HashMap<String, Pair>(content.size());
        HashSet<String> path2delete = new HashSet<String>();
        DirCache inCoreIndex = DirCache.newInCore();
        ObjectInserter inserter = git.getRepository().newObjectInserter();
        DirCacheEditor editor = inCoreIndex.editor();
        try {
            for (Map.Entry<String, File> entry : content.entrySet()) {
                String gPath = JGitUtil.fixPath(entry.getKey());
                if (entry.getValue() == null) {
                    TreeWalk treeWalk = new TreeWalk(git.getRepository());
                    treeWalk.addTree((AnyObjectId)new RevWalk(git.getRepository()).parseTree((AnyObjectId)headId));
                    treeWalk.setRecursive(true);
                    treeWalk.setFilter((TreeFilter)PathFilter.create((String)gPath));
                    while (treeWalk.next()) {
                        path2delete.add(treeWalk.getPathString());
                    }
                    treeWalk.release();
                    continue;
                }
                try {
                    FileInputStream inputStream = new FileInputStream(entry.getValue());
                    try {
                        ObjectId objectId = inserter.insert(3, entry.getValue().length(), (InputStream)inputStream);
                        paths.put(gPath, Pair.newPair((Object)entry.getValue(), (Object)objectId));
                    }
                    finally {
                        ((InputStream)inputStream).close();
                    }
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            if (headId != null) {
                TreeWalk treeWalk = new TreeWalk(git.getRepository());
                int n = treeWalk.addTree((AnyObjectId)new RevWalk(git.getRepository()).parseTree((AnyObjectId)headId));
                treeWalk.setRecursive(true);
                while (treeWalk.next()) {
                    String walkPath = treeWalk.getPathString();
                    CanonicalTreeParser hTree = (CanonicalTreeParser)treeWalk.getTree(n, CanonicalTreeParser.class);
                    if (paths.containsKey(walkPath) && ((ObjectId)((Pair)paths.get(walkPath)).getK2()).equals((AnyObjectId)hTree.getEntryObjectId())) {
                        paths.remove(walkPath);
                    }
                    if (paths.get(walkPath) != null || path2delete.contains(walkPath)) continue;
                    DirCacheEntry dcEntry = new DirCacheEntry(walkPath);
                    final ObjectId _objectId = hTree.getEntryObjectId();
                    final FileMode _fileMode = hTree.getEntryFileMode();
                    editor.add(new DirCacheEditor.PathEdit(dcEntry){

                        public void apply(DirCacheEntry ent) {
                            ent.setObjectId((AnyObjectId)_objectId);
                            ent.setFileMode(_fileMode);
                        }
                    });
                }
                treeWalk.release();
            }
            for (final Map.Entry<String, File> entry : paths.entrySet()) {
                if (((Pair)entry.getValue()).getK1() == null) continue;
                editor.add(new DirCacheEditor.PathEdit(new DirCacheEntry(entry.getKey())){

                    public void apply(DirCacheEntry ent) {
                        ent.setLength(((File)((Pair)entry.getValue()).getK1()).length());
                        ent.setLastModified(((File)((Pair)entry.getValue()).getK1()).lastModified());
                        ent.setFileMode(FileMode.REGULAR_FILE);
                        ent.setObjectId((AnyObjectId)((Pair)entry.getValue()).getK2());
                    }
                });
            }
            editor.finish();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            inserter.release();
        }
        if (path2delete.isEmpty() && paths.isEmpty()) {
            return null;
        }
        return inCoreIndex;
    }

    private static DirCache createTemporaryIndex(Git git, ObjectId headId, MoveCommitContent commitContent) {
        Map<String, String> content = commitContent.getContent();
        DirCache inCoreIndex = DirCache.newInCore();
        DirCacheEditor editor = inCoreIndex.editor();
        try {
            if (headId != null) {
                TreeWalk treeWalk = new TreeWalk(git.getRepository());
                int hIdx = treeWalk.addTree((AnyObjectId)new RevWalk(git.getRepository()).parseTree((AnyObjectId)headId));
                treeWalk.setRecursive(true);
                while (treeWalk.next()) {
                    FileMode _fileMode;
                    ObjectId _objectId;
                    DirCacheEntry dcEntry;
                    String walkPath = treeWalk.getPathString();
                    CanonicalTreeParser hTree = (CanonicalTreeParser)treeWalk.getTree(hIdx, CanonicalTreeParser.class);
                    String toPath = content.get(walkPath);
                    if (toPath == null) {
                        dcEntry = new DirCacheEntry(walkPath);
                        _objectId = hTree.getEntryObjectId();
                        _fileMode = hTree.getEntryFileMode();
                        editor.add(new DirCacheEditor.PathEdit(dcEntry){

                            public void apply(DirCacheEntry ent) {
                                ent.setObjectId((AnyObjectId)_objectId);
                                ent.setFileMode(_fileMode);
                            }
                        });
                        continue;
                    }
                    dcEntry = new DirCacheEntry(toPath);
                    _objectId = hTree.getEntryObjectId();
                    _fileMode = hTree.getEntryFileMode();
                    editor.add(new DirCacheEditor.PathEdit(dcEntry){

                        public void apply(DirCacheEntry ent) {
                            ent.setFileMode(_fileMode);
                            ent.setObjectId((AnyObjectId)_objectId);
                        }
                    });
                }
                treeWalk.release();
            }
            editor.finish();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return inCoreIndex;
    }

    private static DirCache createTemporaryIndex(Git git, ObjectId headId, CopyCommitContent commitContent) {
        Map<String, String> content = commitContent.getContent();
        DirCache inCoreIndex = DirCache.newInCore();
        DirCacheEditor editor = inCoreIndex.editor();
        try {
            if (headId != null) {
                TreeWalk treeWalk = new TreeWalk(git.getRepository());
                int hIdx = treeWalk.addTree((AnyObjectId)new RevWalk(git.getRepository()).parseTree((AnyObjectId)headId));
                treeWalk.setRecursive(true);
                while (treeWalk.next()) {
                    String walkPath = treeWalk.getPathString();
                    CanonicalTreeParser hTree = (CanonicalTreeParser)treeWalk.getTree(hIdx, CanonicalTreeParser.class);
                    String toPath = content.get(walkPath);
                    DirCacheEntry dcEntry = new DirCacheEntry(walkPath);
                    final ObjectId _objectId = hTree.getEntryObjectId();
                    final FileMode _fileMode = hTree.getEntryFileMode();
                    editor.add(new DirCacheEditor.PathEdit(dcEntry){

                        public void apply(DirCacheEntry ent) {
                            ent.setObjectId((AnyObjectId)_objectId);
                            ent.setFileMode(_fileMode);
                        }
                    });
                    if (toPath == null) continue;
                    DirCacheEntry newdcEntry = new DirCacheEntry(toPath);
                    final ObjectId newObjectId = hTree.getEntryObjectId();
                    final FileMode newFileMode = hTree.getEntryFileMode();
                    editor.add(new DirCacheEditor.PathEdit(newdcEntry){

                        public void apply(DirCacheEntry ent) {
                            ent.setFileMode(newFileMode);
                            ent.setObjectId((AnyObjectId)newObjectId);
                        }
                    });
                }
                treeWalk.release();
            }
            editor.finish();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return inCoreIndex;
    }

    private static DirCache createTemporaryIndex(Git git, ObjectId headId) {
        DirCache inCoreIndex = DirCache.newInCore();
        DirCacheEditor editor = inCoreIndex.editor();
        try {
            if (headId != null) {
                TreeWalk treeWalk = new TreeWalk(git.getRepository());
                int hIdx = treeWalk.addTree((AnyObjectId)new RevWalk(git.getRepository()).parseTree((AnyObjectId)headId));
                treeWalk.setRecursive(true);
                while (treeWalk.next()) {
                    String walkPath = treeWalk.getPathString();
                    CanonicalTreeParser hTree = (CanonicalTreeParser)treeWalk.getTree(hIdx, CanonicalTreeParser.class);
                    DirCacheEntry dcEntry = new DirCacheEntry(walkPath);
                    final ObjectId _objectId = hTree.getEntryObjectId();
                    final FileMode _fileMode = hTree.getEntryFileMode();
                    editor.add(new DirCacheEditor.PathEdit(dcEntry){

                        public void apply(DirCacheEntry ent) {
                            ent.setObjectId((AnyObjectId)_objectId);
                            ent.setFileMode(_fileMode);
                        }
                    });
                }
                treeWalk.release();
            }
            editor.finish();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return inCoreIndex;
    }

    public static ObjectId resolveObjectId(Git git, String name) {
        try {
            Ref refName = JGitUtil.getBranch(git, name);
            if (refName != null) {
                return refName.getObjectId();
            }
            try {
                ObjectId id = ObjectId.fromString((String)name);
                if (git.getRepository().getObjectDatabase().has((AnyObjectId)id)) {
                    return id;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return null;
        }
        catch (java.io.IOException iOException) {
            return null;
        }
    }

    public static Ref getBranch(Git git, String name) {
        try {
            return git.getRepository().getRefDatabase().getRef(name);
        }
        catch (java.io.IOException iOException) {
            return null;
        }
    }

    public static void deleteBranch(Git git, Ref branch) {
        try {
            git.branchDelete().setBranchNames(new String[]{branch.getName()}).setForce(true).call();
        }
        catch (GitAPIException e) {
            throw new IOException((Exception)((Object)e));
        }
    }

    public static VersionAttributes buildVersionAttributes(final JGitFileSystem fs, String branchName, final String path) {
        final JGitPathInfo pathInfo = JGitUtil.resolvePath(fs.gitRepo(), branchName, path);
        if (pathInfo == null) {
            throw new NoSuchFileException(path);
        }
        String gPath = JGitUtil.fixPath(path);
        ObjectId id = JGitUtil.resolveObjectId(fs.gitRepo(), branchName);
        final ArrayList<8> records = new ArrayList<8>();
        if (id != null) {
            try {
                LogCommand logCommand = fs.gitRepo().log().add((AnyObjectId)id);
                if (!gPath.isEmpty()) {
                    logCommand.addPath(gPath);
                }
                for (final RevCommit commit : logCommand.call()) {
                    records.add(new VersionRecord(){

                        public String id() {
                            return commit.name();
                        }

                        public String author() {
                            return commit.getAuthorIdent().getName();
                        }

                        public String email() {
                            return commit.getAuthorIdent().getEmailAddress();
                        }

                        public String comment() {
                            return commit.getFullMessage();
                        }

                        public Date date() {
                            return commit.getAuthorIdent().getWhen();
                        }

                        public String uri() {
                            return fs.getPath(commit.name(), path).toUri().toString();
                        }
                    });
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Collections.sort(records, new Comparator<VersionRecord>(){

            @Override
            public int compare(VersionRecord o1, VersionRecord o2) {
                return o1.date().compareTo(o2.date());
            }
        });
        return new VersionAttributes(){

            public VersionHistory history() {
                return new VersionHistory(){

                    public List<VersionRecord> records() {
                        return records;
                    }
                };
            }

            public FileTime lastModifiedTime() {
                if (records.size() > 0) {
                    return new FileTimeImpl(((VersionRecord)records.get(records.size() - 1)).date().getTime());
                }
                return null;
            }

            public FileTime lastAccessTime() {
                return null;
            }

            public FileTime creationTime() {
                if (records.size() > 0) {
                    return new FileTimeImpl(((VersionRecord)records.get(0)).date().getTime());
                }
                return null;
            }

            public boolean isRegularFile() {
                return pathInfo.getPathType().equals((Object)PathType.FILE);
            }

            public boolean isDirectory() {
                return pathInfo.getPathType().equals((Object)PathType.DIRECTORY);
            }

            public boolean isSymbolicLink() {
                return false;
            }

            public boolean isOther() {
                return false;
            }

            public long size() {
                return pathInfo.getSize();
            }

            public Object fileKey() {
                return pathInfo.getObjectId() == null ? null : pathInfo.getObjectId().toString();
            }
        };
    }

    public static BasicFileAttributes buildBasicAttributes(final JGitFileSystem fs, String branchName, String path) {
        final JGitPathInfo pathInfo = JGitUtil.resolvePath(fs.gitRepo(), branchName, path);
        if (pathInfo == null) {
            throw new NoSuchFileException(path);
        }
        final ObjectId id = JGitUtil.resolveObjectId(fs.gitRepo(), branchName);
        final String gPath = JGitUtil.fixPath(path);
        return new BasicFileAttributes(){
            private long lastModifiedDate = -1L;
            private long creationDate = -1L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public FileTime lastModifiedTime() {
                if (this.lastModifiedDate == -1L) {
                    RevWalk revWalk = null;
                    try {
                        LogCommand logCommand = fs.gitRepo().log().add((AnyObjectId)id).setMaxCount(1);
                        if (!gPath.isEmpty()) {
                            logCommand.addPath(gPath);
                        }
                        revWalk = (RevWalk)logCommand.call();
                        this.lastModifiedDate = ((RevCommit)revWalk.iterator().next()).getCommitterIdent().getWhen().getTime();
                    }
                    catch (Exception ex) {
                        this.lastModifiedDate = 0L;
                    }
                    finally {
                        if (revWalk != null) {
                            revWalk.dispose();
                        }
                    }
                }
                return new FileTimeImpl(this.lastModifiedDate);
            }

            public FileTime lastAccessTime() {
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public FileTime creationTime() {
                if (this.creationDate == -1L) {
                    RevWalk revWalk = null;
                    try {
                        LogCommand logCommand = fs.gitRepo().log().add((AnyObjectId)id).setMaxCount(1);
                        if (!gPath.isEmpty()) {
                            logCommand.addPath(gPath);
                        }
                        revWalk = (RevWalk)logCommand.call();
                        this.creationDate = ((RevCommit)revWalk.iterator().next()).getCommitterIdent().getWhen().getTime();
                    }
                    catch (Exception ex) {
                        this.creationDate = 0L;
                    }
                    finally {
                        if (revWalk != null) {
                            revWalk.dispose();
                        }
                    }
                }
                return new FileTimeImpl(this.creationDate);
            }

            public boolean isRegularFile() {
                return pathInfo.getPathType().equals((Object)PathType.FILE);
            }

            public boolean isDirectory() {
                return pathInfo.getPathType().equals((Object)PathType.DIRECTORY);
            }

            public boolean isSymbolicLink() {
                return false;
            }

            public boolean isOther() {
                return false;
            }

            public long size() {
                return pathInfo.getSize();
            }

            public Object fileKey() {
                return pathInfo.getObjectId() == null ? null : pathInfo.getObjectId().toString();
            }
        };
    }

    public static void createBranch(Git git, String source, String target) {
        try {
            git.branchCreate().setName(target).setStartPoint(source).call();
        }
        catch (GitAPIException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean hasBranch(Git git, String branchName) {
        Preconditions.checkNotNull((String)"git", (Object)git);
        Preconditions.checkNotEmpty((String)"branchName", (String)branchName);
        return JGitUtil.getBranch(git, branchName) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<PathType, ObjectId> checkPath(Git git, String branchName, String path) {
        Preconditions.checkNotNull((String)"git", (Object)git);
        Preconditions.checkNotNull((String)"path", (Object)path);
        Preconditions.checkNotEmpty((String)"branchName", (String)branchName);
        String gitPath = JGitUtil.fixPath(path);
        if (gitPath.isEmpty()) {
            return Pair.newPair((Object)((Object)PathType.DIRECTORY), null);
        }
        TreeWalk tw = null;
        try {
            ObjectId tree = git.getRepository().resolve(branchName + "^{tree}");
            tw = new TreeWalk(git.getRepository());
            tw.setFilter((TreeFilter)PathFilter.create((String)gitPath));
            tw.reset((AnyObjectId)tree);
            while (tw.next()) {
                if (tw.getPathString().equals(gitPath)) {
                    if (tw.getFileMode(0).equals(16384)) {
                        Pair pair = Pair.newPair((Object)((Object)PathType.DIRECTORY), (Object)tw.getObjectId(0));
                        return pair;
                    }
                    if (tw.getFileMode(0).equals(32768) || tw.getFileMode(0).equals(FileMode.EXECUTABLE_FILE) || tw.getFileMode(0).equals(FileMode.REGULAR_FILE)) {
                        Pair pair = Pair.newPair((Object)((Object)PathType.FILE), (Object)tw.getObjectId(0));
                        return pair;
                    }
                }
                if (!tw.isSubtree()) continue;
                tw.enterSubtree();
            }
        }
        catch (Throwable ignored) {
        }
        finally {
            if (tw != null) {
                tw.release();
            }
        }
        return Pair.newPair((Object)((Object)PathType.NOT_FOUND), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JGitPathInfo resolvePath(Git git, String branchName, String path) {
        Preconditions.checkNotNull((String)"git", (Object)git);
        Preconditions.checkNotNull((String)"path", (Object)path);
        Preconditions.checkNotEmpty((String)"branchName", (String)branchName);
        String gitPath = JGitUtil.fixPath(path);
        if (gitPath.isEmpty()) {
            return new JGitPathInfo(null, "/", FileMode.TREE);
        }
        TreeWalk tw = null;
        try {
            ObjectId tree = git.getRepository().resolve(branchName + "^{tree}");
            tw = new TreeWalk(git.getRepository());
            tw.setFilter((TreeFilter)PathFilter.create((String)gitPath));
            tw.reset((AnyObjectId)tree);
            while (tw.next()) {
                if (tw.getPathString().equals(gitPath)) {
                    if (tw.getFileMode(0).equals(FileMode.TREE)) {
                        JGitPathInfo jGitPathInfo = new JGitPathInfo(tw.getObjectId(0), tw.getPathString(), FileMode.TREE);
                        return jGitPathInfo;
                    }
                    if (tw.getFileMode(0).equals(FileMode.REGULAR_FILE) || tw.getFileMode(0).equals(FileMode.EXECUTABLE_FILE)) {
                        long size = tw.getObjectReader().getObjectSize((AnyObjectId)tw.getObjectId(0), 3);
                        JGitPathInfo jGitPathInfo = new JGitPathInfo(tw.getObjectId(0), tw.getPathString(), FileMode.REGULAR_FILE, size);
                        return jGitPathInfo;
                    }
                }
                if (!tw.isSubtree()) continue;
                tw.enterSubtree();
            }
        }
        catch (Throwable ignored) {
        }
        finally {
            if (tw != null) {
                tw.release();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<JGitPathInfo> listPathContent(Git git, String branchName, String path) {
        Preconditions.checkNotNull((String)"git", (Object)git);
        Preconditions.checkNotNull((String)"path", (Object)path);
        Preconditions.checkNotEmpty((String)"branchName", (String)branchName);
        String gitPath = JGitUtil.fixPath(path);
        TreeWalk tw = null;
        ArrayList<JGitPathInfo> result = new ArrayList<JGitPathInfo>();
        try {
            ObjectId tree = git.getRepository().resolve(branchName + "^{tree}");
            tw = new TreeWalk(git.getRepository());
            boolean found = false;
            if (gitPath.isEmpty()) {
                found = true;
            } else {
                tw.setFilter((TreeFilter)PathFilter.create((String)gitPath));
            }
            tw.reset((AnyObjectId)tree);
            while (tw.next()) {
                if (!found && tw.isSubtree()) {
                    tw.enterSubtree();
                }
                if (tw.getPathString().equals(gitPath)) {
                    found = true;
                    continue;
                }
                if (!found) continue;
                result.add(new JGitPathInfo(tw.getObjectId(0), tw.getPathString(), tw.getFileMode(0)));
            }
        }
        catch (Throwable ignored) {
        }
        finally {
            if (tw != null) {
                tw.release();
            }
        }
        return result;
    }

    public static class JGitPathInfo {
        private final ObjectId objectId;
        private final String path;
        private final long size;
        private final PathType pathType;

        public JGitPathInfo(ObjectId objectId, String path, FileMode fileMode) {
            this(objectId, path, fileMode, -1L);
        }

        public JGitPathInfo(ObjectId objectId, String path, FileMode fileMode, long size) {
            this.objectId = objectId;
            this.size = size;
            this.path = path;
            this.pathType = fileMode.equals(16384) ? PathType.DIRECTORY : (fileMode.equals(32768) ? PathType.FILE : null);
        }

        public ObjectId getObjectId() {
            return this.objectId;
        }

        public String getPath() {
            return this.path;
        }

        public PathType getPathType() {
            return this.pathType;
        }

        public long getSize() {
            return this.size;
        }
    }

    public static enum PathType {
        NOT_FOUND,
        DIRECTORY,
        FILE;

    }
}

