/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.api.Git;
import org.fest.assertions.api.Assertions;
import org.junit.Test;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.util.JGitUtil;

public class JGitFileSystemProviderEncodingTest
extends AbstractTestInfra {
    private int gitDaemonPort;

    @Override
    public Map<String, String> getGitPreferences() {
        Map<String, String> gitPrefs = super.getGitPreferences();
        gitPrefs.put("org.uberfire.nio.git.daemon.enabled", "true");
        this.gitDaemonPort = JGitFileSystemProviderEncodingTest.findFreePort();
        gitPrefs.put("org.uberfire.nio.git.daemon.port", String.valueOf(this.gitDaemonPort));
        return gitPrefs;
    }

    @Test
    public void test() throws IOException {
        URI originRepo = URI.create("git://encoding-origin-name");
        JGitFileSystem origin = (JGitFileSystem)this.provider.newFileSystem(originRepo, (Map)new HashMap<String, Object>(){
            {
                this.put("listMode", "ALL");
            }
        });
        JGitUtil.commit((Git)origin.gitRepo(), (String)"master", (String)"user1", (String)"user1@example.com", (String)"commitx", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("file-name.txt", JGitFileSystemProviderEncodingTest.this.tempFile("temp1"));
            }
        });
        JGitUtil.commit((Git)origin.gitRepo(), (String)"master", (String)"user1", (String)"user1@example.com", (String)"commitx", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("file+name.txt", JGitFileSystemProviderEncodingTest.this.tempFile("temp2"));
            }
        });
        JGitUtil.commit((Git)origin.gitRepo(), (String)"master", (String)"user1", (String)"user1@example.com", (String)"commitx", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("file name.txt", JGitFileSystemProviderEncodingTest.this.tempFile("temp3"));
            }
        });
        URI newRepo = URI.create("git://my-encoding-repo-name");
        HashMap<String, Object> env = new HashMap<String, Object>(){
            {
                this.put("origin", "git://localhost:" + JGitFileSystemProviderEncodingTest.this.gitDaemonPort + "/encoding-origin-name");
                this.put("listMode", "ALL");
            }
        };
        FileSystem fs = this.provider.newFileSystem(newRepo, (Map)env);
        Assertions.assertThat((Object)fs).isNotNull();
        fs.getPath("file+name.txt", new String[0]).toUri();
        this.provider.getPath(fs.getPath("file+name.txt", new String[0]).toUri());
        Assertions.assertThat((Iterable)this.provider.getPath(fs.getPath("file+name.txt", new String[0]).toUri())).isEqualTo((Object)fs.getPath("file+name.txt", new String[0]));
        Assertions.assertThat((Iterable)this.provider.getPath(fs.getPath("file name.txt", new String[0]).toUri())).isEqualTo((Object)fs.getPath("file name.txt", new String[0]));
        Assertions.assertThat((Object)fs.getPath("file.txt", new String[0]).toUri());
        Assertions.assertThat((Iterable)this.provider.getPath(fs.getPath("file.txt", new String[0]).toUri())).isEqualTo((Object)fs.getPath("file.txt", new String[0]));
    }
}

