/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.daemon.ssh;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.transport.resolver.ReceivePackFactory;
import org.eclipse.jgit.util.FileUtils;
import org.fest.assertions.api.Assertions;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProvider;
import org.uberfire.java.nio.fs.jgit.daemon.ssh.GitSSHService;

public class GitSSHServiceTest {
    private static final List<File> tempFiles = new ArrayList<File>();

    protected static File createTempDirectory() throws IOException {
        File temp = File.createTempFile("temp", Long.toString(System.nanoTime()));
        if (!temp.delete()) {
            throw new IOException("Could not delete temp file: " + temp.getAbsolutePath());
        }
        if (!temp.mkdir()) {
            throw new IOException("Could not create temp directory: " + temp.getAbsolutePath());
        }
        tempFiles.add(temp);
        return temp;
    }

    @AfterClass
    @BeforeClass
    public static void cleanup() {
        for (File tempFile : tempFiles) {
            try {
                FileUtils.delete((File)tempFile, (int)1);
            }
            catch (IOException iOException) {}
        }
    }

    @Test
    public void testStartStop() throws Exception {
        GitSSHService sshService = new GitSSHService();
        File certDir = GitSSHServiceTest.createTempDirectory();
        sshService.setup(certDir, null, "10000", "RSA", (ReceivePackFactory)Mockito.mock(ReceivePackFactory.class), (JGitFileSystemProvider.RepositoryResolverImpl)Mockito.mock(JGitFileSystemProvider.RepositoryResolverImpl.class));
        sshService.start();
        Assert.assertTrue((boolean)sshService.isRunning());
        sshService.stop();
        Assert.assertFalse((boolean)sshService.isRunning());
    }

    @Test
    public void testStartStopAlgo2() throws Exception {
        GitSSHService sshService = new GitSSHService();
        File certDir = GitSSHServiceTest.createTempDirectory();
        sshService.setup(certDir, null, "10000", "DSA", (ReceivePackFactory)Mockito.mock(ReceivePackFactory.class), (JGitFileSystemProvider.RepositoryResolverImpl)Mockito.mock(JGitFileSystemProvider.RepositoryResolverImpl.class));
        sshService.start();
        Assert.assertTrue((boolean)sshService.isRunning());
        sshService.stop();
        Assert.assertFalse((boolean)sshService.isRunning());
    }

    @Test
    public void testCheckTimeout() throws Exception {
        GitSSHService sshService = new GitSSHService();
        File certDir = GitSSHServiceTest.createTempDirectory();
        sshService.setup(certDir, null, "10000", "RSA", (ReceivePackFactory)Mockito.mock(ReceivePackFactory.class), (JGitFileSystemProvider.RepositoryResolverImpl)Mockito.mock(JGitFileSystemProvider.RepositoryResolverImpl.class));
        sshService.start();
        Assert.assertTrue((boolean)sshService.isRunning());
        Assert.assertTrue((boolean)"10000".equals(sshService.getSshServer().getProperties().get("idle-timeout")));
        sshService.stop();
        Assert.assertFalse((boolean)sshService.isRunning());
    }

    @Test
    public void testCheckAlgo() throws Exception {
        GitSSHService sshService = new GitSSHService();
        File certDir = GitSSHServiceTest.createTempDirectory();
        try {
            sshService.setup(certDir, null, "10000", "xxxx", (ReceivePackFactory)Mockito.mock(ReceivePackFactory.class), (JGitFileSystemProvider.RepositoryResolverImpl)Mockito.mock(JGitFileSystemProvider.RepositoryResolverImpl.class));
            Assert.fail((String)"has to fail");
        }
        catch (Exception ex) {
            Assertions.assertThat((String)ex.getMessage()).contains("'xxxx'");
        }
    }

    @Test
    public void testCheckSetupParameters() throws Exception {
        GitSSHService sshService = new GitSSHService();
        File certDir = GitSSHServiceTest.createTempDirectory();
        try {
            sshService.setup(null, null, "10000", "RSA", (ReceivePackFactory)Mockito.mock(ReceivePackFactory.class), (JGitFileSystemProvider.RepositoryResolverImpl)Mockito.mock(JGitFileSystemProvider.RepositoryResolverImpl.class));
            Assert.fail((String)"has to fail");
        }
        catch (IllegalArgumentException ex) {
            Assertions.assertThat((String)ex.getMessage()).contains("'certDir'");
        }
        try {
            sshService.setup(certDir, null, null, "RSA", (ReceivePackFactory)Mockito.mock(ReceivePackFactory.class), (JGitFileSystemProvider.RepositoryResolverImpl)Mockito.mock(JGitFileSystemProvider.RepositoryResolverImpl.class));
            Assert.fail((String)"has to fail");
        }
        catch (IllegalArgumentException ex) {
            Assertions.assertThat((String)ex.getMessage()).contains("'sshIdleTimeout'");
        }
        try {
            sshService.setup(certDir, null, "", "RSA", (ReceivePackFactory)Mockito.mock(ReceivePackFactory.class), (JGitFileSystemProvider.RepositoryResolverImpl)Mockito.mock(JGitFileSystemProvider.RepositoryResolverImpl.class));
            Assert.fail((String)"has to fail");
        }
        catch (IllegalArgumentException ex) {
            Assertions.assertThat((String)ex.getMessage()).contains("'sshIdleTimeout'");
        }
        try {
            sshService.setup(certDir, null, "1000", null, (ReceivePackFactory)Mockito.mock(ReceivePackFactory.class), (JGitFileSystemProvider.RepositoryResolverImpl)Mockito.mock(JGitFileSystemProvider.RepositoryResolverImpl.class));
            Assert.fail((String)"has to fail");
        }
        catch (IllegalArgumentException ex) {
            Assertions.assertThat((String)ex.getMessage()).contains("'algorithm'");
        }
        try {
            sshService.setup(certDir, null, "1000", "", (ReceivePackFactory)Mockito.mock(ReceivePackFactory.class), (JGitFileSystemProvider.RepositoryResolverImpl)Mockito.mock(JGitFileSystemProvider.RepositoryResolverImpl.class));
            Assert.fail((String)"has to fail");
        }
        catch (IllegalArgumentException ex) {
            Assertions.assertThat((String)ex.getMessage()).contains("'algorithm'");
        }
        try {
            sshService.setup(certDir, null, "100", "RSA", null, (JGitFileSystemProvider.RepositoryResolverImpl)Mockito.mock(JGitFileSystemProvider.RepositoryResolverImpl.class));
            Assert.fail((String)"has to fail");
        }
        catch (IllegalArgumentException ex) {
            Assertions.assertThat((String)ex.getMessage()).contains("'receivePackFactory'");
        }
        try {
            sshService.setup(certDir, null, "100", "RSA", (ReceivePackFactory)Mockito.mock(ReceivePackFactory.class), null);
            Assert.fail((String)"has to fail");
        }
        catch (IllegalArgumentException ex) {
            Assertions.assertThat((String)ex.getMessage()).contains("'repositoryResolver'");
        }
        try {
            sshService.setup(certDir, null, "10000", "RSA", (ReceivePackFactory)Mockito.mock(ReceivePackFactory.class), (JGitFileSystemProvider.RepositoryResolverImpl)Mockito.mock(JGitFileSystemProvider.RepositoryResolverImpl.class));
        }
        catch (IllegalArgumentException ex) {
            Assert.fail((String)"should not fail");
        }
    }
}

