/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.base.FileSystemId;
import org.uberfire.java.nio.base.FileSystemState;
import org.uberfire.java.nio.base.FileSystemStateAware;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.ClosedWatchServiceException;
import org.uberfire.java.nio.file.FileStore;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.InvalidPathException;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.PathMatcher;
import org.uberfire.java.nio.file.PatternSyntaxException;
import org.uberfire.java.nio.file.WatchEvent;
import org.uberfire.java.nio.file.WatchKey;
import org.uberfire.java.nio.file.WatchService;
import org.uberfire.java.nio.file.Watchable;
import org.uberfire.java.nio.file.attribute.UserPrincipalLookupService;
import org.uberfire.java.nio.file.spi.FileSystemProvider;
import org.uberfire.java.nio.fs.jgit.CommitInfo;
import org.uberfire.java.nio.fs.jgit.JGitFSPath;
import org.uberfire.java.nio.fs.jgit.JGitFileStore;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProvider;
import org.uberfire.java.nio.fs.jgit.JGitPathImpl;
import org.uberfire.java.nio.fs.jgit.util.JGitUtil;

public class JGitFileSystem
implements FileSystem,
FileSystemId,
FileSystemStateAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(JGitFileSystem.class);
    private static final Set<String> SUPPORTED_ATTR_VIEWS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("basic", "version")));
    private final JGitFileSystemProvider provider;
    private final Git gitRepo;
    private final ListBranchCommand.ListMode listMode;
    private final String toStringContent;
    private boolean isClosed = false;
    private final FileStore fileStore;
    private final String name;
    private final CredentialsProvider credential;
    private final Map<WatchService, Queue<WatchKey>> events = new ConcurrentHashMap<WatchService, Queue<WatchKey>>();
    private final Collection<WatchService> watchServices = new ArrayList<WatchService>();
    private final AtomicInteger numberOfCommitsSinceLastGC = new AtomicInteger(0);
    private FileSystemState state = FileSystemState.NORMAL;
    private CommitInfo batchCommitInfo = null;
    private Map<Path, Boolean> hadCommitOnBatchState = new ConcurrentHashMap<Path, Boolean>();
    private final Lock lock = new Lock();

    JGitFileSystem(JGitFileSystemProvider provider, Map<String, String> fullHostNames, Git git, String name, CredentialsProvider credential) {
        this(provider, fullHostNames, git, name, null, credential);
    }

    JGitFileSystem(JGitFileSystemProvider provider, Map<String, String> fullHostNames, Git git, String name, ListBranchCommand.ListMode listMode, CredentialsProvider credential) {
        this.provider = (JGitFileSystemProvider)PortablePreconditions.checkNotNull((String)"provider", (Object)provider);
        this.gitRepo = (Git)PortablePreconditions.checkNotNull((String)"git", (Object)git);
        this.name = PortablePreconditions.checkNotEmpty((String)"name", (String)name);
        this.credential = (CredentialsProvider)PortablePreconditions.checkNotNull((String)"credential", (Object)credential);
        this.listMode = listMode;
        this.fileStore = new JGitFileStore(this.gitRepo.getRepository());
        if (fullHostNames != null && !fullHostNames.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            Iterator<Map.Entry<String, String>> iterator = fullHostNames.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                sb.append(entry.getKey()).append("://").append(entry.getValue()).append("/").append(name);
                if (!iterator.hasNext()) continue;
                sb.append("\n");
            }
            this.toStringContent = sb.toString();
        } else {
            this.toStringContent = "git://" + name;
        }
    }

    public String id() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public Git gitRepo() {
        return this.gitRepo;
    }

    public CredentialsProvider getCredential() {
        return this.credential;
    }

    public FileSystemProvider provider() {
        return this.provider;
    }

    public boolean isOpen() {
        return !this.isClosed;
    }

    public boolean isReadOnly() {
        return false;
    }

    public String getSeparator() {
        return "/";
    }

    public Iterable<Path> getRootDirectories() {
        this.checkClosed();
        return new Iterable<Path>(){

            @Override
            public Iterator<Path> iterator() {
                return new Iterator<Path>(){
                    Iterator<Ref> branches = null;

                    @Override
                    public boolean hasNext() {
                        if (this.branches == null) {
                            this.init();
                        }
                        return this.branches.hasNext();
                    }

                    private void init() {
                        this.branches = JGitUtil.branchList(JGitFileSystem.this.gitRepo, JGitFileSystem.this.listMode).iterator();
                    }

                    @Override
                    public Path next() {
                        if (this.branches == null) {
                            this.init();
                        }
                        return JGitPathImpl.createRoot(JGitFileSystem.this, "/", Repository.shortenRefName((String)this.branches.next().getName()) + "@" + JGitFileSystem.this.name, false);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public Iterable<FileStore> getFileStores() {
        this.checkClosed();
        return new Iterable<FileStore>(){

            @Override
            public Iterator<FileStore> iterator() {
                return new Iterator<FileStore>(){
                    private int i = 0;

                    @Override
                    public boolean hasNext() {
                        return this.i < 1;
                    }

                    @Override
                    public FileStore next() {
                        if (this.i < 1) {
                            ++this.i;
                            return JGitFileSystem.this.fileStore;
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public Set<String> supportedFileAttributeViews() {
        this.checkClosed();
        return SUPPORTED_ATTR_VIEWS;
    }

    public Path getPath(String first, String ... more) throws InvalidPathException {
        this.checkClosed();
        if (first == null || first.trim().isEmpty()) {
            return new JGitFSPath(this);
        }
        if (more == null || more.length == 0) {
            return JGitPathImpl.create(this, first, "master@" + this.name, false);
        }
        StringBuilder sb = new StringBuilder();
        for (String segment : more) {
            if (segment.length() <= 0) continue;
            if (sb.length() > 0) {
                sb.append(this.getSeparator());
            }
            sb.append(segment);
        }
        return JGitPathImpl.create(this, sb.toString(), first + "@" + this.name, false);
    }

    public PathMatcher getPathMatcher(String syntaxAndPattern) throws IllegalArgumentException, PatternSyntaxException, UnsupportedOperationException {
        this.checkClosed();
        PortablePreconditions.checkNotEmpty((String)"syntaxAndPattern", (String)syntaxAndPattern);
        throw new UnsupportedOperationException();
    }

    public UserPrincipalLookupService getUserPrincipalLookupService() throws UnsupportedOperationException {
        this.checkClosed();
        throw new UnsupportedOperationException();
    }

    public WatchService newWatchService() throws UnsupportedOperationException, IOException {
        this.checkClosed();
        WatchService ws = new WatchService(){
            private boolean wsClose = false;

            public WatchKey poll() throws ClosedWatchServiceException {
                return (WatchKey)((Queue)JGitFileSystem.this.events.get(this)).poll();
            }

            public WatchKey poll(long timeout, TimeUnit unit) throws ClosedWatchServiceException, org.uberfire.java.nio.file.InterruptedException {
                return (WatchKey)((Queue)JGitFileSystem.this.events.get(this)).poll();
            }

            public synchronized WatchKey take() throws ClosedWatchServiceException, org.uberfire.java.nio.file.InterruptedException {
                while (true) {
                    if (this.wsClose || JGitFileSystem.this.isClosed) {
                        throw new ClosedWatchServiceException();
                    }
                    if (((Queue)JGitFileSystem.this.events.get(this)).size() > 0) {
                        return (WatchKey)((Queue)JGitFileSystem.this.events.get(this)).poll();
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }

            public boolean isClose() {
                return JGitFileSystem.this.isClosed;
            }

            public synchronized void close() throws IOException {
                this.wsClose = true;
                this.notifyAll();
                JGitFileSystem.this.watchServices.remove(this);
            }

            public String toString() {
                return "WatchService{FileSystem=" + JGitFileSystem.this.toString() + '}';
            }
        };
        this.events.put(ws, new ConcurrentLinkedQueue());
        this.watchServices.add(ws);
        return ws;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        this.gitRepo.getRepository().close();
        this.isClosed = true;
        try {
            for (WatchService ws : new ArrayList<WatchService>(this.watchServices)) {
                try {
                    ws.close();
                }
                catch (Exception ex) {
                    LOGGER.error("Can't close watch service [" + this.toString() + "]", (Throwable)ex);
                }
            }
            this.watchServices.clear();
            this.events.clear();
        }
        catch (Exception ex) {
            LOGGER.error("Error during close of WatchServices [" + this.toString() + "]", (Throwable)ex);
        }
        finally {
            this.provider.onCloseFileSystem(this);
        }
    }

    private void checkClosed() throws IllegalStateException {
        if (this.isClosed) {
            throw new IllegalStateException("FileSystem is close.");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JGitFileSystem that = (JGitFileSystem)o;
        if (this.fileStore != null ? !this.fileStore.equals(that.fileStore) : that.fileStore != null) {
            return false;
        }
        if (!this.gitRepo.equals(that.gitRepo)) {
            return false;
        }
        if (this.listMode != that.listMode) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.provider.equals(that.provider);
    }

    public String toString() {
        return this.toStringContent;
    }

    public int hashCode() {
        int result = this.provider.hashCode();
        result = 31 * result + this.gitRepo.hashCode();
        result = 31 * result + (this.listMode != null ? this.listMode.hashCode() : 0);
        result = 31 * result + (this.fileStore != null ? this.fileStore.hashCode() : 0);
        result = 31 * result + this.name.hashCode();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishEvents(final Path watchable, final List<WatchEvent<?>> elist) {
        if (this.events.isEmpty()) {
            return;
        }
        WatchKey wk = new WatchKey(){

            public boolean isValid() {
                return true;
            }

            public List<WatchEvent<?>> pollEvents() {
                return new ArrayList(elist);
            }

            public boolean reset() {
                return JGitFileSystem.this.isOpen();
            }

            public void cancel() {
            }

            public Watchable watchable() {
                return watchable;
            }
        };
        for (Map.Entry<WatchService, Queue<WatchKey>> watchServiceQueueEntry : this.events.entrySet()) {
            WatchService ws;
            watchServiceQueueEntry.getValue().add(wk);
            WatchService watchService = ws = watchServiceQueueEntry.getKey();
            synchronized (watchService) {
                ws.notifyAll();
            }
        }
    }

    public void dispose() {
        if (!this.isClosed) {
            this.close();
        }
        this.provider.onDisposeFileSystem(this);
    }

    public boolean isOnBatch() {
        return this.state.equals((Object)FileSystemState.BATCH);
    }

    public void setState(String state) {
        try {
            this.state = FileSystemState.valueOf((String)state);
        }
        catch (Exception ex) {
            this.state = FileSystemState.NORMAL;
        }
    }

    private CommitInfo buildCommitInfo(String defaultMessage, CommentedOption op) {
        String sessionId = null;
        String name = null;
        String email = null;
        String message = defaultMessage;
        TimeZone timeZone = null;
        Date when = null;
        if (op != null) {
            sessionId = op.getSessionId();
            name = op.getName();
            email = op.getEmail();
            if (op.getMessage() != null && !op.getMessage().trim().isEmpty()) {
                message = op.getMessage();
            }
            timeZone = op.getTimeZone();
            when = op.getWhen();
        }
        return new CommitInfo(sessionId, name, email, message, timeZone, when);
    }

    public void setBatchCommitInfo(String defaultMessage, CommentedOption op) {
        this.batchCommitInfo = this.buildCommitInfo(defaultMessage, op);
    }

    public void setHadCommitOnBatchState(Path path, boolean hadCommitOnBatchState) {
        Path root = ((Path)PortablePreconditions.checkNotNull((String)"path", (Object)path)).getRoot();
        this.hadCommitOnBatchState.put(root.getRoot(), hadCommitOnBatchState);
    }

    public void setHadCommitOnBatchState(boolean value) {
        for (Map.Entry<Path, Boolean> entry : this.hadCommitOnBatchState.entrySet()) {
            entry.setValue(value);
        }
    }

    public boolean isHadCommitOnBatchState(Path path) {
        Path root = ((Path)PortablePreconditions.checkNotNull((String)"path", (Object)path)).getRoot();
        return this.hadCommitOnBatchState.containsKey(root) ? this.hadCommitOnBatchState.get(root) : false;
    }

    public void setBatchCommitInfo(CommitInfo batchCommitInfo) {
        this.batchCommitInfo = batchCommitInfo;
    }

    public CommitInfo getBatchCommitInfo() {
        return this.batchCommitInfo;
    }

    public int incrementAndGetCommitCount() {
        return this.numberOfCommitsSinceLastGC.incrementAndGet();
    }

    public void resetCommitCount() {
        this.numberOfCommitsSinceLastGC.set(0);
    }

    int getNumberOfCommitsSinceLastGC() {
        return this.numberOfCommitsSinceLastGC.get();
    }

    public FileSystemState getState() {
        return this.state;
    }

    public void lock() {
        try {
            this.lock.lock();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void unlock() {
        this.lock.unlock();
    }

    private static class Lock {
        private final AtomicBoolean isLocked = new AtomicBoolean(false);

        private Lock() {
        }

        public synchronized void lock() throws InterruptedException {
            while (!this.isLocked.compareAndSet(false, true)) {
                this.wait();
            }
        }

        public synchronized void unlock() {
            this.isLocked.set(false);
            this.notifyAll();
        }
    }
}

