/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.fest.assertions.api.Assertions;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.java.nio.file.FileSystemAlreadyExistsException;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.util.JGitUtil;
import org.uberfire.java.nio.fs.jgit.util.commands.Fork;
import org.uberfire.java.nio.fs.jgit.util.exceptions.GitException;

public class JGitForkTest
extends AbstractTestInfra {
    public static final String TARGET_GIT = "target/target";
    public static final String SOURCE_GIT = "source/source";
    private static Logger logger = LoggerFactory.getLogger(JGitForkTest.class);

    @Test
    public void testToForkSuccess() throws IOException, GitAPIException {
        File parentFolder = JGitForkTest.createTempDirectory();
        File gitSource = new File(parentFolder, "source/source.git");
        Git origin = JGitUtil.newRepository((File)gitSource, (boolean)true);
        JGitUtil.commit((Git)origin, (String)"user_branch", (String)"name", (String)"name@example.com", (String)"commit!", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("file2.txt", JGitForkTest.this.tempFile("temp2222"));
            }
        });
        JGitUtil.commit((Git)origin, (String)"master", (String)"name", (String)"name@example.com", (String)"commit", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("file.txt", JGitForkTest.this.tempFile("temp"));
            }
        });
        JGitUtil.commit((Git)origin, (String)"master", (String)"name", (String)"name@example.com", (String)"commit", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("file3.txt", JGitForkTest.this.tempFile("temp3"));
            }
        });
        new Fork(parentFolder, SOURCE_GIT, TARGET_GIT, CredentialsProvider.getDefault()).execute();
        File gitCloned = new File(parentFolder, "target/target.git");
        Git cloned = Git.open((File)gitCloned);
        Assertions.assertThat((Object)cloned).isNotNull();
        Assertions.assertThat((List)JGitUtil.branchList((Git)cloned, (ListBranchCommand.ListMode)ListBranchCommand.ListMode.ALL)).hasSize(4);
        Assertions.assertThat((String)((Ref)JGitUtil.branchList((Git)cloned, (ListBranchCommand.ListMode)ListBranchCommand.ListMode.ALL).get(0)).getName()).isEqualTo((Object)"refs/heads/master");
        Assertions.assertThat((String)((Ref)JGitUtil.branchList((Git)cloned, (ListBranchCommand.ListMode)ListBranchCommand.ListMode.ALL).get(1)).getName()).isEqualTo((Object)"refs/heads/user_branch");
        Assertions.assertThat((String)((Ref)JGitUtil.branchList((Git)cloned, (ListBranchCommand.ListMode)ListBranchCommand.ListMode.ALL).get(2)).getName()).isEqualTo((Object)"refs/remotes/origin/master");
        Assertions.assertThat((String)((Ref)JGitUtil.branchList((Git)cloned, (ListBranchCommand.ListMode)ListBranchCommand.ListMode.ALL).get(3)).getName()).isEqualTo((Object)"refs/remotes/origin/user_branch");
        String remotePath = ((URIish)((RemoteConfig)cloned.remoteList().call().get(0)).getURIs().get(0)).getPath();
        Assertions.assertThat((String)remotePath).isEqualTo((Object)gitSource.getPath());
    }

    @Test(expected=GitException.class)
    public void testToForkAlreadyExists() throws IOException, GitAPIException {
        File parentFolder = JGitForkTest.createTempDirectory();
        File gitSource = new File(parentFolder, "source/source.git");
        Git origin = JGitUtil.newRepository((File)gitSource, (boolean)true);
        JGitUtil.commit((Git)origin, (String)"master", (String)"name", (String)"name@example.com", (String)"commit", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("file.txt", JGitForkTest.this.tempFile("temp"));
            }
        });
        File gitTarget = new File(parentFolder, "target/target.git");
        Git originTarget = JGitUtil.newRepository((File)gitTarget, (boolean)true);
        JGitUtil.commit((Git)originTarget, (String)"master", (String)"name", (String)"name@example.com", (String)"commit", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("file.txt", JGitForkTest.this.tempFile("temp"));
            }
        });
        new Fork(parentFolder, SOURCE_GIT, TARGET_GIT, CredentialsProvider.getDefault()).execute();
    }

    @Test
    public void testToForkWrongSource() throws IOException, GitAPIException {
        File parentFolder = JGitForkTest.createTempDirectory();
        try {
            new Fork(parentFolder, SOURCE_GIT, TARGET_GIT, CredentialsProvider.getDefault()).execute();
            Assertions.fail((String)"If got here is because it could for the repository");
        }
        catch (GitException e) {
            Assertions.assertThat((Throwable)e).isNotNull();
            logger.info(e.getMessage(), (Throwable)e);
        }
    }

    @Test
    public void testForkRepository() throws GitAPIException {
        final String SOURCE = "testforkA/source";
        String TARGET = "testforkB/target";
        HashMap<String, Object> env = new HashMap<String, Object>(){
            {
                this.put("init", "true");
            }
        };
        String sourcePath = "git://" + SOURCE;
        URI sourceUri = URI.create(sourcePath);
        this.provider.newFileSystem(sourceUri, (Map)env);
        HashMap<String, Object> forkEnv = new HashMap<String, Object>(){
            {
                this.put("origin", SOURCE);
                this.put("listMode", "ALL");
            }
        };
        String forkPath = "git://" + TARGET;
        URI forkUri = URI.create(forkPath);
        JGitFileSystem fs = (JGitFileSystem)this.provider.newFileSystem(forkUri, (Map)forkEnv);
        Assertions.assertThat((String)((URIish)((RemoteConfig)fs.gitRepo().remoteList().call().get(0)).getURIs().get(0)).toString()).isEqualTo((Object)new File(this.provider.getGitRepoContainerDir(), SOURCE + ".git").getAbsolutePath());
    }

    @Test(expected=FileSystemAlreadyExistsException.class)
    public void testForkRepositoryThatAlreadyExists() throws GitAPIException {
        final String SOURCE = "testforkA/source";
        String TARGET = "testforkB/target";
        HashMap<String, Object> env = new HashMap<String, Object>(){
            {
                this.put("init", "true");
            }
        };
        String sourcePath = "git://" + SOURCE;
        URI sourceUri = URI.create(sourcePath);
        this.provider.newFileSystem(sourceUri, (Map)env);
        HashMap<String, Object> forkEnv = new HashMap<String, Object>(){
            {
                this.put("origin", SOURCE);
                this.put("listMode", "ALL");
            }
        };
        String forkPath = "git://" + TARGET;
        URI forkUri = URI.create(forkPath);
        this.provider.newFileSystem(forkUri, (Map)forkEnv);
        this.provider.newFileSystem(forkUri, (Map)forkEnv);
    }
}

