/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.fest.assertions.api.Assertions;
import org.junit.Test;
import org.uberfire.java.nio.file.FileSystemNotFoundException;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;

public class JGitFileSystemProviderMigrationTest
extends AbstractTestInfra {
    @Test
    public void testCreateANewDirectoryWithMigrationEnv() {
        HashMap<String, Object> envMigrate = new HashMap<String, Object>(){
            {
                this.put("init", Boolean.TRUE);
                this.put("migrate-from", URI.create("git://old"));
            }
        };
        String newPath = "git://test/old";
        URI newUri = URI.create(newPath);
        this.provider.newFileSystem(newUri, (Map)envMigrate);
        this.provider.getFileSystem(newUri);
        Assertions.assertThat((boolean)new File(this.provider.getGitRepoContainerDir(), "test/old.git").exists()).isTrue();
        Assertions.assertThat((Object)this.provider.getFileSystem(newUri)).isNotNull();
    }

    @Test
    public void testMigrateOldDirectories() {
        HashMap<String, Object> env = new HashMap<String, Object>(){
            {
                this.put("init", Boolean.TRUE);
            }
        };
        HashMap<String, Object> envMigrate = new HashMap<String, Object>(){
            {
                this.put("init", Boolean.TRUE);
                this.put("migrate-from", URI.create("git://old"));
            }
        };
        String oldPath = "git://old";
        URI oldUri = URI.create(oldPath);
        JGitFileSystem fs = (JGitFileSystem)this.provider.newFileSystem(oldUri, (Map)env);
        String newPath = "git://test/old";
        URI newUri = URI.create(newPath);
        this.provider.newFileSystem(newUri, (Map)envMigrate);
        try {
            this.provider.getFileSystem(oldUri);
            Assertions.fail((String)"It should not reach here because old filesystem does not exists");
        }
        catch (FileSystemNotFoundException ex) {
            Assertions.assertThat((boolean)new File(this.provider.getGitRepoContainerDir(), "test/old.git").exists()).isTrue();
            Assertions.assertThat((boolean)new File(this.provider.getGitRepoContainerDir(), "old.git").exists()).isFalse();
        }
    }
}

