/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.jboss.byteman.contrib.bmunit.BMScript;
import org.jboss.byteman.contrib.bmunit.BMUnitConfig;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.util.JGitUtil;

@RunWith(value=BMUnitRunner.class)
@BMUnitConfig(loadDirectory="target/test-classes", debug=true)
public class ConcurrentJGitUtilTest
extends AbstractTestInfra {
    @BeforeClass
    public static void setup() {
        JGitUtil.setRetryTimes((int)5);
    }

    @Test
    @BMScript(value="byteman/retry/resolve_path.btm")
    public void testRetryResolvePath() throws IOException {
        File parentFolder = ConcurrentJGitUtilTest.createTempDirectory();
        File gitFolder = new File(parentFolder, "mytest.git");
        Git git = JGitUtil.newRepository((File)gitFolder, (boolean)true);
        JGitUtil.commit((Git)git, (String)"master", (String)"name", (String)"name@example.com", (String)"1st commit", null, (Date)new Date(), (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file1.txt", ConcurrentJGitUtilTest.this.tempFile("temp2222"));
            }
        });
        JGitUtil.commit((Git)git, (String)"master", (String)"name", (String)"name@example.com", (String)"2nd commit", null, (Date)new Date(), (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file2.txt", ConcurrentJGitUtilTest.this.tempFile("temp2222"));
            }
        });
        try {
            Assert.assertNotNull((Object)JGitUtil.resolvePath((Git)git, (String)"master", (String)"path/to/file1.txt"));
            Assert.assertNotNull((Object)JGitUtil.resolvePath((Git)git, (String)"master", (String)"path/to/file1.txt"));
            Assert.assertNotNull((Object)JGitUtil.resolvePath((Git)git, (String)"master", (String)"path/to/file1.txt"));
            Assert.assertNotNull((Object)JGitUtil.resolvePath((Git)git, (String)"master", (String)"path/to/file1.txt"));
        }
        catch (Exception ex) {
            Assert.fail();
        }
        try {
            JGitUtil.resolvePath((Git)git, (String)"master", (String)"path/to/file1.txt");
            Assert.fail((String)"forced to fail!");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    @BMScript(value="byteman/retry/resolve_inputstream.btm")
    public void testRetryResolveInputStream() throws IOException {
        File parentFolder = ConcurrentJGitUtilTest.createTempDirectory();
        File gitFolder = new File(parentFolder, "mytest.git");
        Git git = JGitUtil.newRepository((File)gitFolder, (boolean)true);
        JGitUtil.commit((Git)git, (String)"master", (String)"name", (String)"name@example.com", (String)"1st commit", null, (Date)new Date(), (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file1.txt", ConcurrentJGitUtilTest.this.tempFile("temp2222"));
            }
        });
        JGitUtil.commit((Git)git, (String)"master", (String)"name", (String)"name@example.com", (String)"2nd commit", null, (Date)new Date(), (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file2.txt", ConcurrentJGitUtilTest.this.tempFile("temp2222"));
            }
        });
        try {
            Assert.assertNotNull((Object)JGitUtil.resolveInputStream((Git)git, (String)"master", (String)"path/to/file1.txt"));
            Assert.assertNotNull((Object)JGitUtil.resolveInputStream((Git)git, (String)"master", (String)"path/to/file1.txt"));
            Assert.assertNotNull((Object)JGitUtil.resolveInputStream((Git)git, (String)"master", (String)"path/to/file1.txt"));
            Assert.assertNotNull((Object)JGitUtil.resolveInputStream((Git)git, (String)"master", (String)"path/to/file1.txt"));
        }
        catch (Exception ex) {
            Assert.fail();
        }
        try {
            Assert.assertNotNull((Object)JGitUtil.resolveInputStream((Git)git, (String)"master", (String)"path/to/file1.txt"));
            Assert.fail((String)"forced to fail!");
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
    }

    @Test
    @BMScript(value="byteman/retry/list_path_content.btm")
    public void testRetryListPathContent() throws IOException {
        File parentFolder = ConcurrentJGitUtilTest.createTempDirectory();
        File gitFolder = new File(parentFolder, "mytest.git");
        Git git = JGitUtil.newRepository((File)gitFolder, (boolean)true);
        JGitUtil.commit((Git)git, (String)"master", (String)"name", (String)"name@example.com", (String)"1st commit", null, (Date)new Date(), (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file1.txt", ConcurrentJGitUtilTest.this.tempFile("temp2222"));
            }
        });
        JGitUtil.commit((Git)git, (String)"master", (String)"name", (String)"name@example.com", (String)"2nd commit", null, (Date)new Date(), (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file2.txt", ConcurrentJGitUtilTest.this.tempFile("temp2222"));
            }
        });
        try {
            Assert.assertNotNull((Object)JGitUtil.listPathContent((Git)git, (String)"master", (String)"path/to/"));
            Assert.assertNotNull((Object)JGitUtil.listPathContent((Git)git, (String)"master", (String)"path/to/"));
            Assert.assertNotNull((Object)JGitUtil.listPathContent((Git)git, (String)"master", (String)"path/to/"));
            Assert.assertNotNull((Object)JGitUtil.listPathContent((Git)git, (String)"master", (String)"path/to/"));
        }
        catch (Exception ex) {
            Assert.fail();
        }
        try {
            Assert.assertNotNull((Object)JGitUtil.listPathContent((Git)git, (String)"master", (String)"path/to/"));
            Assert.fail((String)"forced to fail!");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    @BMScript(value="byteman/retry/check_path.btm")
    public void testRetryCheckPath() throws IOException {
        File parentFolder = ConcurrentJGitUtilTest.createTempDirectory();
        File gitFolder = new File(parentFolder, "mytest.git");
        Git git = JGitUtil.newRepository((File)gitFolder, (boolean)true);
        JGitUtil.commit((Git)git, (String)"master", (String)"name", (String)"name@example.com", (String)"1st commit", null, (Date)new Date(), (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file1.txt", ConcurrentJGitUtilTest.this.tempFile("temp2222"));
            }
        });
        JGitUtil.commit((Git)git, (String)"master", (String)"name", (String)"name@example.com", (String)"2nd commit", null, (Date)new Date(), (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file2.txt", ConcurrentJGitUtilTest.this.tempFile("temp2222"));
            }
        });
        try {
            Assert.assertNotNull((Object)JGitUtil.checkPath((Git)git, (String)"master", (String)"path/to/file2.txt"));
            Assert.assertNotNull((Object)JGitUtil.checkPath((Git)git, (String)"master", (String)"path/to/file2.txt"));
            Assert.assertNotNull((Object)JGitUtil.checkPath((Git)git, (String)"master", (String)"path/to/file2.txt"));
            Assert.assertNotNull((Object)JGitUtil.checkPath((Git)git, (String)"master", (String)"path/to/file2.txt"));
        }
        catch (Exception ex) {
            Assert.fail();
        }
        try {
            Assert.assertNotNull((Object)JGitUtil.checkPath((Git)git, (String)"master", (String)"path/to/file2.txt"));
            Assert.fail((String)"forced to fail!");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    @BMScript(value="byteman/retry/get_last_commit.btm")
    public void testRetryGetLastCommit() throws IOException {
        File parentFolder = ConcurrentJGitUtilTest.createTempDirectory();
        File gitFolder = new File(parentFolder, "mytest.git");
        Git git = JGitUtil.newRepository((File)gitFolder, (boolean)true);
        JGitUtil.commit((Git)git, (String)"master", (String)"name", (String)"name@example.com", (String)"1st commit", null, (Date)new Date(), (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file1.txt", ConcurrentJGitUtilTest.this.tempFile("temp2222"));
            }
        });
        JGitUtil.commit((Git)git, (String)"master", (String)"name", (String)"name@example.com", (String)"2nd commit", null, (Date)new Date(), (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file2.txt", ConcurrentJGitUtilTest.this.tempFile("temp2222"));
            }
        });
        try {
            Assert.assertNotNull((Object)JGitUtil.getLastCommit((Git)git, (String)"master"));
            Assert.assertNotNull((Object)JGitUtil.getLastCommit((Git)git, (String)"master"));
            Assert.assertNotNull((Object)JGitUtil.getLastCommit((Git)git, (String)"master"));
            Assert.assertNotNull((Object)JGitUtil.getLastCommit((Git)git, (String)"master"));
        }
        catch (Exception ex) {
            Assert.fail();
        }
        try {
            Assert.assertNotNull((Object)JGitUtil.getLastCommit((Git)git, (String)"master"));
            Assert.fail((String)"forced to fail!");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    @BMScript(value="byteman/retry/get_commits.btm")
    public void testRetryGetCommits() throws IOException {
        File parentFolder = ConcurrentJGitUtilTest.createTempDirectory();
        File gitFolder = new File(parentFolder, "mytest.git");
        Git git = JGitUtil.newRepository((File)gitFolder, (boolean)true);
        JGitUtil.commit((Git)git, (String)"master", (String)"name", (String)"name@example.com", (String)"1st commit", null, (Date)new Date(), (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file1.txt", ConcurrentJGitUtilTest.this.tempFile("temp2222"));
            }
        });
        JGitUtil.commit((Git)git, (String)"master", (String)"name", (String)"name@example.com", (String)"2nd commit", null, (Date)new Date(), (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file2.txt", ConcurrentJGitUtilTest.this.tempFile("temp2222"));
            }
        });
        RevCommit commit = JGitUtil.getLastCommit((Git)git, (String)"master");
        try {
            Assert.assertNotNull((Object)JGitUtil.getCommits((Git)git, (String)"master", null, (ObjectId)commit));
            Assert.assertNotNull((Object)JGitUtil.getCommits((Git)git, (String)"master", null, (ObjectId)commit));
            Assert.assertNotNull((Object)JGitUtil.getCommits((Git)git, (String)"master", null, (ObjectId)commit));
        }
        catch (Exception ex) {
            Assert.fail();
        }
        try {
            Assert.assertNotNull((Object)JGitUtil.getCommits((Git)git, (String)"master", null, (ObjectId)commit));
            Assert.fail((String)"forced to fail!");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

