/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.fest.assertions.api.Assertions;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.util.JGitUtil;
import org.uberfire.java.nio.fs.jgit.util.commands.Merge;
import org.uberfire.java.nio.fs.jgit.util.exceptions.GitException;

public class JGitMergeTest
extends AbstractTestInfra {
    public static final String SOURCE_GIT = "source/source";
    private static Logger logger = LoggerFactory.getLogger(JGitMergeTest.class);

    @Test
    public void testMergeSuccessful() throws IOException, GitAPIException {
        File parentFolder = JGitMergeTest.createTempDirectory();
        File gitSource = new File(parentFolder, "source/source.git");
        Git origin = JGitUtil.newRepository((File)gitSource, (boolean)true);
        JGitUtil.commit((Git)origin, (String)"master", (String)"name", (String)"name@example.com", (String)"master-1", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("file1.txt", JGitMergeTest.this.tempFile("temp1"));
            }
        });
        JGitUtil.createBranch((Git)origin, (String)"master", (String)"develop");
        JGitUtil.commit((Git)origin, (String)"develop", (String)"name", (String)"name@example.com", (String)"develop-1", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("file2.txt", JGitMergeTest.this.tempFile("temp2"));
            }
        });
        JGitUtil.commit((Git)origin, (String)"develop", (String)"name", (String)"name@example.com", (String)"develop-2", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("file3.txt", JGitMergeTest.this.tempFile("temp3"));
            }
        });
        JGitUtil.commit((Git)origin, (String)"develop", (String)"name", (String)"name@example.com", (String)"develop-3", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("file4.txt", JGitMergeTest.this.tempFile("temp4"));
            }
        });
        JGitUtil.commit((Git)origin, (String)"develop", (String)"name", (String)"name@example.com", (String)"develop-4", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("file5.txt", JGitMergeTest.this.tempFile("temp5"));
            }
        });
        new Merge(origin, "develop", "master").execute();
        List result = JGitUtil.getDiff((Repository)origin.getRepository(), (ObjectId)JGitUtil.getTreeRefObjectId((Repository)origin.getRepository(), (String)"master").toObjectId(), (ObjectId)JGitUtil.getTreeRefObjectId((Repository)origin.getRepository(), (String)"develop").toObjectId());
        Assertions.assertThat((int)result.size()).isEqualTo(0);
    }

    @Test
    public void testMergeConflict() throws IOException, GitAPIException {
        File parentFolder = JGitMergeTest.createTempDirectory();
        File gitSource = new File(parentFolder, "source/source.git");
        Git origin = JGitUtil.newRepository((File)gitSource, (boolean)true);
        JGitUtil.commit((Git)origin, (String)"master", (String)"name", (String)"name@example.com", (String)"master-1", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("file1.txt", JGitMergeTest.this.tempFile("temp1"));
            }
        });
        JGitUtil.createBranch((Git)origin, (String)"master", (String)"develop");
        JGitUtil.commit((Git)origin, (String)"develop", (String)"name", (String)"name@example.com", (String)"develop-1", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("file1.txt", JGitMergeTest.this.tempFile("temp1"));
            }
        });
        new Merge(origin, "develop", "master").execute();
        List result = JGitUtil.getDiff((Repository)origin.getRepository(), (ObjectId)JGitUtil.getTreeRefObjectId((Repository)origin.getRepository(), (String)"master").toObjectId(), (ObjectId)JGitUtil.getTreeRefObjectId((Repository)origin.getRepository(), (String)"develop").toObjectId());
        Assertions.assertThat((int)result.size()).isEqualTo(0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParametersNotNull() throws IOException, GitAPIException {
        new Merge(null, "develop", "master").execute();
    }

    @Test(expected=GitException.class)
    public void testTryToMergeNonexistentBranch() throws IOException, GitAPIException {
        File parentFolder = JGitMergeTest.createTempDirectory();
        File gitSource = new File(parentFolder, "source/source.git");
        Git origin = JGitUtil.newRepository((File)gitSource, (boolean)true);
        JGitUtil.commit((Git)origin, (String)"master", (String)"name", (String)"name@example.com", (String)"master-1", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("file1.txt", JGitMergeTest.this.tempFile("temp1"));
            }
        });
        JGitUtil.createBranch((Git)origin, (String)"master", (String)"develop");
        JGitUtil.commit((Git)origin, (String)"develop", (String)"name", (String)"name@example.com", (String)"develop-1", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("file2.txt", JGitMergeTest.this.tempFile("temp2"));
            }
        });
        JGitUtil.commit((Git)origin, (String)"develop", (String)"name", (String)"name@example.com", (String)"develop-2", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("file3.txt", JGitMergeTest.this.tempFile("temp3"));
            }
        });
        JGitUtil.commit((Git)origin, (String)"develop", (String)"name", (String)"name@example.com", (String)"develop-3", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("file4.txt", JGitMergeTest.this.tempFile("temp4"));
            }
        });
        JGitUtil.commit((Git)origin, (String)"develop", (String)"name", (String)"name@example.com", (String)"develop-4", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("file5.txt", JGitMergeTest.this.tempFile("temp5"));
            }
        });
        new Merge(origin, "develop", "nonexistent").execute();
    }

    @Test(expected=GitException.class)
    public void testMergeBinaryInformationButHasConflicts() throws IOException, GitAPIException {
        final byte[] contentA = this.loadImage("images/drools.png");
        final byte[] contentB = this.loadImage("images/jbpm.png");
        final byte[] contentC = this.loadImage("images/opta.png");
        File parentFolder = JGitMergeTest.createTempDirectory();
        File gitSource = new File(parentFolder, "source/source.git");
        Git origin = JGitUtil.newRepository((File)gitSource, (boolean)true);
        JGitUtil.commit((Git)origin, (String)"master", (String)"name", (String)"name@example.com", (String)"master-1", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("file1.jpg", JGitMergeTest.this.tempFile(contentA));
            }
        });
        JGitUtil.createBranch((Git)origin, (String)"master", (String)"develop");
        JGitUtil.commit((Git)origin, (String)"develop", (String)"name", (String)"name@example.com", (String)"develop-1", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("file1.jpg", JGitMergeTest.this.tempFile(contentB));
            }
        });
        JGitUtil.commit((Git)origin, (String)"master", (String)"name", (String)"name@example.com", (String)"master-1", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("file1.jpg", JGitMergeTest.this.tempFile(contentC));
            }
        });
        new Merge(origin, "develop", "master").execute();
        List result = JGitUtil.getDiff((Repository)origin.getRepository(), (ObjectId)JGitUtil.getTreeRefObjectId((Repository)origin.getRepository(), (String)"master").toObjectId(), (ObjectId)JGitUtil.getTreeRefObjectId((Repository)origin.getRepository(), (String)"develop").toObjectId());
        Assertions.assertThat((int)result.size()).isEqualTo(0);
    }

    @Test
    public void testMergeBinaryInformationSuccessful() throws IOException, GitAPIException {
        final byte[] contentA = this.loadImage("images/drools.png");
        final byte[] contentB = this.loadImage("images/jbpm.png");
        File parentFolder = JGitMergeTest.createTempDirectory();
        File gitSource = new File(parentFolder, "source/source.git");
        Git origin = JGitUtil.newRepository((File)gitSource, (boolean)true);
        JGitUtil.commit((Git)origin, (String)"master", (String)"name", (String)"name@example.com", (String)"master-1", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("file1.jpg", JGitMergeTest.this.tempFile(contentA));
            }
        });
        JGitUtil.createBranch((Git)origin, (String)"master", (String)"develop");
        JGitUtil.commit((Git)origin, (String)"develop", (String)"name", (String)"name@example.com", (String)"develop-1", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("file1.jpg", JGitMergeTest.this.tempFile(contentB));
            }
        });
        new Merge(origin, "develop", "master").execute();
        List result = JGitUtil.getDiff((Repository)origin.getRepository(), (ObjectId)JGitUtil.getTreeRefObjectId((Repository)origin.getRepository(), (String)"master").toObjectId(), (ObjectId)JGitUtil.getTreeRefObjectId((Repository)origin.getRepository(), (String)"develop").toObjectId());
        Assertions.assertThat((int)result.size()).isEqualTo(0);
    }
}

