/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.fest.assertions.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.java.nio.base.version.VersionAttributes;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.util.JGitUtil;

public class JGitUtilTest
extends AbstractTestInfra {
    @Test
    public void testNewRepo() throws IOException {
        File parentFolder = JGitUtilTest.createTempDirectory();
        File gitFolder = new File(parentFolder, "mytest.git");
        Git git = JGitUtil.newRepository((File)gitFolder, (boolean)true);
        Assertions.assertThat((Object)git).isNotNull();
        Assertions.assertThat((int)JGitUtil.branchList((Git)git).size()).isEqualTo(0);
        JGitUtil.commit((Git)git, (String)"master", (String)"name", (String)"name@example.com", (String)"commit", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("file.txt", JGitUtilTest.this.tempFile("temp"));
            }
        });
        Assertions.assertThat((int)JGitUtil.branchList((Git)git).size()).isEqualTo(1);
    }

    @Test
    public void testClone() throws IOException {
        File parentFolder = JGitUtilTest.createTempDirectory();
        File gitFolder = new File(parentFolder, "mytest.git");
        Git origin = JGitUtil.newRepository((File)gitFolder, (boolean)true);
        JGitUtil.commit((Git)origin, (String)"user_branch", (String)"name", (String)"name@example.com", (String)"commit!", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("file2.txt", JGitUtilTest.this.tempFile("temp2222"));
            }
        });
        JGitUtil.commit((Git)origin, (String)"master", (String)"name", (String)"name@example.com", (String)"commit", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("file.txt", JGitUtilTest.this.tempFile("temp"));
            }
        });
        JGitUtil.commit((Git)origin, (String)"master", (String)"name", (String)"name@example.com", (String)"commit", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("file3.txt", JGitUtilTest.this.tempFile("temp3"));
            }
        });
        File gitClonedFolder = new File(parentFolder, "myclone.git");
        Git git = JGitUtil.cloneRepository((File)gitClonedFolder, (String)origin.getRepository().getDirectory().toString(), (boolean)true, (CredentialsProvider)CredentialsProvider.getDefault());
        Assertions.assertThat((Object)git).isNotNull();
        Assertions.assertThat((List)JGitUtil.branchList((Git)git, (ListBranchCommand.ListMode)ListBranchCommand.ListMode.ALL)).hasSize(4);
        Assertions.assertThat((String)((Ref)JGitUtil.branchList((Git)git, (ListBranchCommand.ListMode)ListBranchCommand.ListMode.ALL).get(0)).getName()).isEqualTo((Object)"refs/heads/master");
        Assertions.assertThat((String)((Ref)JGitUtil.branchList((Git)git, (ListBranchCommand.ListMode)ListBranchCommand.ListMode.ALL).get(1)).getName()).isEqualTo((Object)"refs/heads/user_branch");
        Assertions.assertThat((String)((Ref)JGitUtil.branchList((Git)git, (ListBranchCommand.ListMode)ListBranchCommand.ListMode.ALL).get(2)).getName()).isEqualTo((Object)"refs/remotes/origin/master");
        Assertions.assertThat((String)((Ref)JGitUtil.branchList((Git)git, (ListBranchCommand.ListMode)ListBranchCommand.ListMode.ALL).get(3)).getName()).isEqualTo((Object)"refs/remotes/origin/user_branch");
    }

    @Test
    public void testPathResolve() throws IOException {
        File parentFolder = JGitUtilTest.createTempDirectory();
        File gitFolder = new File(parentFolder, "mytest.git");
        Git origin = JGitUtil.newRepository((File)gitFolder, (boolean)true);
        JGitUtil.commit((Git)origin, (String)"user_branch", (String)"name", (String)"name@example.com", (String)"commit!", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file2.txt", JGitUtilTest.this.tempFile("temp2222"));
            }
        });
        JGitUtil.commit((Git)origin, (String)"user_branch", (String)"name", (String)"name@example.com", (String)"commit!", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file3.txt", JGitUtilTest.this.tempFile("temp2222"));
            }
        });
        File gitClonedFolder = new File(parentFolder, "myclone.git");
        Git git = JGitUtil.cloneRepository((File)gitClonedFolder, (String)origin.getRepository().getDirectory().toString(), (boolean)true, (CredentialsProvider)CredentialsProvider.getDefault());
        Assertions.assertThat((Object)JGitUtil.checkPath((Git)git, (String)"user_branch", (String)"pathx/").getK1()).isEqualTo((Object)JGitUtil.PathType.NOT_FOUND);
        Assertions.assertThat((Object)JGitUtil.checkPath((Git)git, (String)"user_branch", (String)"path/to/file2.txt").getK1()).isEqualTo((Object)JGitUtil.PathType.FILE);
        Assertions.assertThat((Object)JGitUtil.checkPath((Git)git, (String)"user_branch", (String)"path/to").getK1()).isEqualTo((Object)JGitUtil.PathType.DIRECTORY);
    }

    @Test
    public void testAmend() throws IOException {
        File parentFolder = JGitUtilTest.createTempDirectory();
        System.out.println("COOL!:" + parentFolder.toString());
        File gitFolder = new File(parentFolder, "myxxxtest.git");
        Git origin = JGitUtil.newRepository((File)gitFolder, (boolean)true);
        JGitUtil.commit((Git)origin, (String)"master", (String)"name", (String)"name@example.com", (String)"commit!", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file2.txt", JGitUtilTest.this.tempFile("tempwdf sdf asdf asd2222"));
            }
        });
        JGitUtil.commit((Git)origin, (String)"master", (String)"name", (String)"name@example.com", (String)"commit!", null, null, (boolean)true, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file3.txt", JGitUtilTest.this.tempFile("temp2x d dasdf asdf 222"));
            }
        });
        File gitClonedFolder = new File(parentFolder, "myclone.git");
        Git git = JGitUtil.cloneRepository((File)gitClonedFolder, (String)origin.getRepository().getDirectory().toString(), (boolean)true, (CredentialsProvider)CredentialsProvider.getDefault());
        Assertions.assertThat((Object)JGitUtil.checkPath((Git)git, (String)"master", (String)"pathx/").getK1()).isEqualTo((Object)JGitUtil.PathType.NOT_FOUND);
        Assertions.assertThat((Object)JGitUtil.checkPath((Git)git, (String)"master", (String)"path/to/file2.txt").getK1()).isEqualTo((Object)JGitUtil.PathType.FILE);
        Assertions.assertThat((Object)JGitUtil.checkPath((Git)git, (String)"master", (String)"path/to").getK1()).isEqualTo((Object)JGitUtil.PathType.DIRECTORY);
    }

    @Test
    public void testBuildVersionAttributes() throws Exception {
        File parentFolder = JGitUtilTest.createTempDirectory();
        File gitFolder = new File(parentFolder, "mytest.git");
        Git git = JGitUtil.newRepository((File)gitFolder, (boolean)true);
        JGitUtil.commit((Git)git, (String)"master", (String)"name", (String)"name@example.com", (String)"commit 1", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file2.txt", JGitUtilTest.this.tempFile("who"));
            }
        });
        JGitUtil.commit((Git)git, (String)"master", (String)"name", (String)"name@example.com", (String)"commit 2", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file2.txt", JGitUtilTest.this.tempFile("you"));
            }
        });
        JGitUtil.commit((Git)git, (String)"master", (String)"name", (String)"name@example.com", (String)"commit 3", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file2.txt", JGitUtilTest.this.tempFile("gonna"));
            }
        });
        JGitUtil.commit((Git)git, (String)"master", (String)"name", (String)"name@example.com", (String)"commit 4", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file2.txt", JGitUtilTest.this.tempFile("call?"));
            }
        });
        JGitFileSystem jGitFileSystem = (JGitFileSystem)Mockito.mock(JGitFileSystem.class);
        Mockito.when((Object)jGitFileSystem.gitRepo()).thenReturn((Object)git);
        VersionAttributes versionAttributes = JGitUtil.buildVersionAttributes((JGitFileSystem)jGitFileSystem, (String)"master", (String)"path/to/file2.txt");
        List records = versionAttributes.history().records();
        Assert.assertEquals((Object)"commit 1", (Object)((VersionRecord)records.get(0)).comment());
        Assert.assertEquals((Object)"commit 2", (Object)((VersionRecord)records.get(1)).comment());
        Assert.assertEquals((Object)"commit 3", (Object)((VersionRecord)records.get(2)).comment());
        Assert.assertEquals((Object)"commit 4", (Object)((VersionRecord)records.get(3)).comment());
    }

    @Test
    public void testDiffForFileCreatedInEmptyRepositoryOrBranch() throws Exception {
        File parentFolder = JGitUtilTest.createTempDirectory();
        File gitFolder = new File(parentFolder, "mytest.git");
        Git git = JGitUtil.newRepository((File)gitFolder, (boolean)true);
        ObjectId oldHead = JGitUtil.getTreeRefObjectId((Repository)git.getRepository(), (String)"master");
        JGitUtil.commit((Git)git, (String)"master", (String)"name", (String)"name@example.com", (String)"commit 1", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file.txt", JGitUtilTest.this.tempFile("who"));
            }
        });
        ObjectId newHead = JGitUtil.getTreeRefObjectId((Repository)git.getRepository(), (String)"master");
        List diff = JGitUtil.getDiff((Repository)git.getRepository(), (ObjectId)oldHead, (ObjectId)newHead);
        Assert.assertNotNull((Object)diff);
        Assert.assertFalse((boolean)diff.isEmpty());
        Assert.assertEquals((Object)DiffEntry.ChangeType.ADD, (Object)((DiffEntry)diff.get(0)).getChangeType());
        Assert.assertEquals((Object)"path/to/file.txt", (Object)((DiffEntry)diff.get(0)).getNewPath());
    }
}

