/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FS_POSIX;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.ProcessResult;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProvider;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.commands.Commit;
import org.uberfire.java.nio.fs.jgit.util.model.CommitContent;
import org.uberfire.java.nio.fs.jgit.util.model.CommitInfo;
import org.uberfire.java.nio.fs.jgit.util.model.DefaultCommitContent;

public abstract class AbstractTestInfra {
    private static final Logger logger = LoggerFactory.getLogger(AbstractTestInfra.class);
    protected static final Map<String, Object> EMPTY_ENV = Collections.emptyMap();
    protected static final List<File> tempFiles = new ArrayList<File>();
    protected JGitFileSystemProvider provider;

    @Before
    public void createGitFsProvider() {
        this.provider = new JGitFileSystemProvider(this.getGitPreferences());
    }

    public Map<String, String> getGitPreferences() {
        HashMap<String, String> gitPrefs = new HashMap<String, String>();
        gitPrefs.put("org.uberfire.nio.git.daemon.enabled", "false");
        gitPrefs.put("org.uberfire.nio.git.ssh.enabled", "false");
        return gitPrefs;
    }

    @After
    public void destroyGitFsProvider() throws IOException {
        if (this.provider == null) {
            return;
        }
        this.provider.shutdown();
        if (this.provider.getGitRepoContainerDir() != null && this.provider.getGitRepoContainerDir().exists()) {
            FileUtils.delete((File)this.provider.getGitRepoContainerDir(), (int)1);
        }
    }

    @AfterClass
    @BeforeClass
    public static void cleanup() {
        for (File tempFile : tempFiles) {
            try {
                FileUtils.delete((File)tempFile, (int)1);
            }
            catch (IOException iOException) {}
        }
    }

    protected Git setupGit() throws IOException, GitAPIException {
        return this.setupGit(AbstractTestInfra.createTempDirectory());
    }

    protected Git setupGit(File tempDir) throws IOException, GitAPIException {
        Git git = Git.createRepository((File)tempDir);
        new Commit(git, "master", new CommitInfo(null, "name", "name@example.com", "cool1", null, null), false, null, (CommitContent)new DefaultCommitContent((Map)new HashMap<String, File>(){
            {
                this.put("file1.txt", AbstractTestInfra.tempFile("content"));
                this.put("file2.txt", AbstractTestInfra.tempFile("content2"));
            }
        })).execute();
        return git;
    }

    protected static File createTempDirectory() throws IOException {
        File temp = File.createTempFile("temp", Long.toString(System.nanoTime()));
        if (!temp.delete()) {
            throw new IOException("Could not delete temp file: " + temp.getAbsolutePath());
        }
        if (!temp.mkdir()) {
            throw new IOException("Could not create temp directory: " + temp.getAbsolutePath());
        }
        tempFiles.add(temp);
        return temp;
    }

    public static File tempFile(String content) throws IOException {
        File file = File.createTempFile("bar", "foo");
        FileOutputStream out = new FileOutputStream(file);
        if (content != null && !content.isEmpty()) {
            ((OutputStream)out).write(content.getBytes());
            out.flush();
        }
        ((OutputStream)out).close();
        return file;
    }

    public File tempFile(byte[] content) throws IOException {
        File file = File.createTempFile("bar", "foo");
        FileOutputStream out = new FileOutputStream(file);
        if (content != null && content.length > 0) {
            out.write(content);
            out.flush();
        }
        out.close();
        return file;
    }

    public PersonIdent getAuthor() {
        return new PersonIdent("user", "user@example.com");
    }

    public static int findFreePort() {
        int port = 0;
        try {
            ServerSocket server = new ServerSocket(0);
            port = server.getLocalPort();
            server.close();
        }
        catch (IOException e) {
            Assert.fail((String)"Can't find free port!");
        }
        logger.debug("Found free port " + port);
        return port;
    }

    protected byte[] loadImage(String path) throws IOException {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(path);
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)stream, (Writer)writer);
        return writer.toString().getBytes();
    }

    static void commit(Git origin, String branchName, String message, TestFile ... testFiles) throws IOException {
        Map<String, File> data = Arrays.stream(testFiles).collect(Collectors.toMap(f -> f.path, f -> AbstractTestInfra.tmpFile(f.content)));
        new Commit(origin, branchName, "name", "name@example.com", message, null, null, false, data).execute();
    }

    public static File tmpFile(String content) {
        try {
            return AbstractTestInfra.tempFile(content);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static TestFile content(String path, String content) {
        return new TestFile(path, content);
    }

    void writeMockHook(File hooksDirectory, String hookName) throws FileNotFoundException, UnsupportedEncodingException {
        PrintWriter writer = new PrintWriter(new File(hooksDirectory, hookName), "UTF-8");
        writer.println("# something");
        writer.close();
    }

    void testHook(String gitRepoName, final String testedHookName, boolean wasExecuted) throws IOException {
        URI newRepo = URI.create("git://" + gitRepoName);
        final AtomicBoolean hookExecuted = new AtomicBoolean(false);
        FileSystem fs = this.provider.newFileSystem(newRepo, EMPTY_ENV);
        this.provider.setDetectedFS((FS)new FS_POSIX(){

            public ProcessResult runHookIfPresent(Repository repox, String hookName, String[] args) throws JGitInternalException {
                if (hookName.equals(testedHookName)) {
                    hookExecuted.set(true);
                }
                return null;
            }
        });
        Assertions.assertThat((Object)fs).isNotNull();
        Path path = this.provider.getPath(URI.create("git://user_branch@" + gitRepoName + "/some/path/myfile.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        Assertions.assertThat((Object)outStream).isNotNull();
        outStream.write("my cool content".getBytes());
        outStream.close();
        InputStream inStream = this.provider.newInputStream(path, new OpenOption[0]);
        String content = new Scanner(inStream).useDelimiter("\\A").next();
        inStream.close();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)content).isNotNull()).isEqualTo((Object)"my cool content");
        if (wasExecuted) {
            Assertions.assertThat((boolean)hookExecuted.get()).isTrue();
        } else {
            Assertions.assertThat((boolean)hookExecuted.get()).isFalse();
        }
    }

    static class TestFile {
        final String path;
        final String content;

        TestFile(String path, String content) {
            this.path = path;
            this.content = content;
        }
    }
}

