/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.manager;

import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemImpl;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemLock;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProvider;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProviderConfiguration;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProxy;
import org.uberfire.java.nio.fs.jgit.manager.JGitFileSystemsCache;
import org.uberfire.java.nio.fs.jgit.util.Git;

@RunWith(value=MockitoJUnitRunner.class)
public class JGitFileSystemsCacheTest
extends AbstractTestInfra {
    JGitFileSystemsCache cache;
    private JGitFileSystemProviderConfiguration config;

    @Before
    public void setup() {
        this.config = (JGitFileSystemProviderConfiguration)Mockito.mock(JGitFileSystemProviderConfiguration.class);
    }

    @Test
    public void addAndGetTest() {
        Mockito.when((Object)this.config.getJgitFileSystemsInstancesCache()).thenReturn((Object)2);
        this.cache = new JGitFileSystemsCache(this.config);
        Assert.assertTrue((boolean)this.cache.fileSystemsSuppliers.isEmpty());
        Assert.assertTrue((boolean)this.cache.memoizedSuppliers.isEmpty());
        Assert.assertEquals(null, (Object)this.cache.get("fs1"));
        JGitFileSystem fs1 = (JGitFileSystem)Mockito.mock(JGitFileSystem.class);
        Supplier<JGitFileSystem> fs1Supplier = () -> fs1;
        this.cache.addSupplier("fs1", fs1Supplier);
        Assert.assertFalse((boolean)this.cache.fileSystemsSuppliers.isEmpty());
        Assert.assertFalse((boolean)this.cache.memoizedSuppliers.isEmpty());
        JGitFileSystemProxy fs1Proxy = (JGitFileSystemProxy)this.cache.get("fs1");
        Assert.assertEquals((Object)fs1, (Object)fs1Proxy.getRealJGitFileSystem());
        Assert.assertTrue((boolean)this.cache.containsKey("fs1"));
        this.cache.clear();
        Assert.assertTrue((boolean)this.cache.fileSystemsSuppliers.isEmpty());
        Assert.assertTrue((boolean)this.cache.memoizedSuppliers.isEmpty());
    }

    @Test
    public void addMoreFSThanCacheSupports() {
        Mockito.when((Object)this.config.getJgitFileSystemsInstancesCache()).thenReturn((Object)2);
        this.cache = new JGitFileSystemsCache(this.config);
        JGitFileSystem fs1 = (JGitFileSystem)Mockito.mock(JGitFileSystem.class);
        Supplier<JGitFileSystem> fs1Supplier = this.getSupplierSpy(fs1);
        this.cache.addSupplier("fs1", fs1Supplier);
        Assert.assertEquals((long)1L, (long)this.cache.fileSystemsSuppliers.size());
        Assert.assertEquals((long)1L, (long)this.cache.memoizedSuppliers.size());
        ((JGitFileSystemProxy)this.cache.get("fs1")).getRealJGitFileSystem();
        JGitFileSystem fs2 = (JGitFileSystem)Mockito.mock(JGitFileSystem.class);
        Supplier<JGitFileSystem> fs2Supplier = this.getSupplierSpy(fs2);
        this.cache.addSupplier("fs2", fs2Supplier);
        ((JGitFileSystemProxy)this.cache.get("fs2")).getRealJGitFileSystem();
        Assert.assertEquals((long)2L, (long)this.cache.fileSystemsSuppliers.size());
        Assert.assertEquals((long)2L, (long)this.cache.memoizedSuppliers.size());
        JGitFileSystem fs3 = (JGitFileSystem)Mockito.mock(JGitFileSystem.class);
        Supplier<JGitFileSystem> fs3Supplier = this.getSupplierSpy(fs3);
        this.cache.addSupplier("fs3", fs3Supplier);
        ((JGitFileSystemProxy)this.cache.get("fs3")).getRealJGitFileSystem();
        Assert.assertEquals((long)3L, (long)this.cache.fileSystemsSuppliers.size());
        Assert.assertEquals((long)2L, (long)this.cache.memoizedSuppliers.size());
        ((JGitFileSystemProxy)this.cache.get("fs2")).getRealJGitFileSystem();
        ((Supplier)Mockito.verify(fs2Supplier, (VerificationMode)Mockito.times((int)1))).get();
        ((JGitFileSystemProxy)this.cache.get("fs3")).getRealJGitFileSystem();
        ((Supplier)Mockito.verify(fs3Supplier, (VerificationMode)Mockito.times((int)1))).get();
        ((JGitFileSystemProxy)this.cache.get("fs1")).getRealJGitFileSystem();
        ((Supplier)Mockito.verify(fs1Supplier, (VerificationMode)Mockito.times((int)2))).get();
    }

    @Test
    public void cacheIsOrderedByTheAccessOrder() {
        JGitFileSystemProviderConfiguration config = this.setupConfigMock();
        this.setupCacheToTestOrder(config, "fs1", "fs2", "fs3");
        Assert.assertFalse((boolean)this.cache.memoizedSuppliers.containsKey("fs1"));
        this.setupCacheToTestOrder(config, "fs1", "fs2", "fs3");
        this.cache.get("fs1");
        Assert.assertFalse((boolean)this.cache.memoizedSuppliers.containsKey("fs2"));
        this.setupCacheToTestOrder(config, "fs1", "fs2", "fs3");
        this.cache.get("fs1");
        this.cache.get("fs2");
        Assert.assertFalse((boolean)this.cache.memoizedSuppliers.containsKey("fs3"));
        this.cache.get("fs1");
        this.cache.get("fs2");
        this.cache.get("fs3");
        this.setupCacheToTestOrder(config, "fs1", "fs2", "fs3");
        Assert.assertFalse((boolean)this.cache.memoizedSuppliers.containsKey("fs1"));
    }

    @Test
    public void removeEldestEntryTest() {
        JGitFileSystemProviderConfiguration config = this.setupConfigMock();
        this.setupCacheToTestOrder(config, "fs1", "fs2", "fs3");
        Assert.assertFalse((boolean)this.cache.memoizedSuppliers.containsKey("fs1"));
        this.cache = new JGitFileSystemsCache(config);
        JGitFileSystem fs1 = (JGitFileSystem)Mockito.mock(JGitFileSystem.class);
        Mockito.when((Object)fs1.hasBeenInUse()).thenReturn((Object)true);
        Supplier<JGitFileSystem> fsSupplier1 = this.getSupplierSpy(fs1);
        this.cache.addSupplier("fs1", fsSupplier1);
        JGitFileSystem fs2 = (JGitFileSystem)Mockito.mock(JGitFileSystem.class);
        Supplier<JGitFileSystem> fsSupplier2 = this.getSupplierSpy(fs2);
        Mockito.when((Object)fs2.hasBeenInUse()).thenReturn((Object)false);
        this.cache.addSupplier("fs2", fsSupplier2);
        JGitFileSystem fs3 = (JGitFileSystem)Mockito.mock(JGitFileSystem.class);
        Supplier<JGitFileSystem> fsSupplier = this.getSupplierSpy(fs3);
        Mockito.when((Object)fs3.hasBeenInUse()).thenReturn((Object)false);
        this.cache.addSupplier("fs3", fsSupplier);
        Assert.assertTrue((boolean)this.cache.memoizedSuppliers.containsKey("fs1"));
        Assert.assertTrue((boolean)this.cache.memoizedSuppliers.containsKey("fs3"));
        Assert.assertFalse((boolean)this.cache.memoizedSuppliers.containsKey("fs2"));
    }

    @Test
    public void removeEldestEntryTestAllOpen() {
        JGitFileSystemProviderConfiguration config = this.setupConfigMock();
        this.cache = new JGitFileSystemsCache(config);
        JGitFileSystem fs1 = (JGitFileSystem)Mockito.mock(JGitFileSystem.class);
        Mockito.when((Object)fs1.hasBeenInUse()).thenReturn((Object)true);
        Supplier<JGitFileSystem> fsSupplier1 = this.getSupplierSpy(fs1);
        this.cache.addSupplier("fs1", fsSupplier1);
        JGitFileSystem fs2 = (JGitFileSystem)Mockito.mock(JGitFileSystem.class);
        Supplier<JGitFileSystem> fs2Supplier = this.getSupplierSpy(fs2);
        Mockito.when((Object)fs2.hasBeenInUse()).thenReturn((Object)true);
        this.cache.addSupplier("fs2", fs2Supplier);
        JGitFileSystem fs3 = (JGitFileSystem)Mockito.mock(JGitFileSystem.class);
        Supplier<JGitFileSystem> fs3Supplier = this.getSupplierSpy(fs3);
        Mockito.when((Object)fs3.hasBeenInUse()).thenReturn((Object)true);
        this.cache.addSupplier("fs3", fs3Supplier);
        JGitFileSystem fs4 = (JGitFileSystem)Mockito.mock(JGitFileSystem.class);
        Supplier<JGitFileSystem> fs4Supplier = this.getSupplierSpy(fs4);
        Mockito.when((Object)fs4.hasBeenInUse()).thenReturn((Object)true);
        this.cache.addSupplier("fs4", fs3Supplier);
        Assert.assertTrue((boolean)this.cache.memoizedSuppliers.containsKey("fs1"));
        Assert.assertTrue((boolean)this.cache.memoizedSuppliers.containsKey("fs3"));
        Assert.assertTrue((boolean)this.cache.memoizedSuppliers.containsKey("fs2"));
        Assert.assertTrue((boolean)this.cache.memoizedSuppliers.containsKey("fs4"));
        Mockito.when((Object)fs1.hasBeenInUse()).thenReturn((Object)false);
        Mockito.when((Object)fs2.hasBeenInUse()).thenReturn((Object)false);
        Mockito.when((Object)fs4.hasBeenInUse()).thenReturn((Object)false);
        JGitFileSystem fs5 = (JGitFileSystem)Mockito.mock(JGitFileSystem.class);
        Supplier<JGitFileSystem> fs5Supplier = this.getSupplierSpy(fs5);
        Mockito.when((Object)fs5.hasBeenInUse()).thenReturn((Object)true);
        this.cache.addSupplier("fs5", fs5Supplier);
        Assert.assertTrue((boolean)this.cache.memoizedSuppliers.containsKey("fs3"));
        Assert.assertTrue((boolean)this.cache.memoizedSuppliers.containsKey("fs5"));
        Assert.assertFalse((boolean)this.cache.memoizedSuppliers.containsKey("fs1"));
        Assert.assertFalse((boolean)this.cache.memoizedSuppliers.containsKey("fs2"));
    }

    @Test
    public void fsInUseAreAlwaysOnTheCache() throws IOException, GitAPIException {
        JGitFileSystemProviderConfiguration config = new JGitFileSystemProviderConfiguration(){

            public int getJgitFileSystemsInstancesCache() {
                return 2;
            }
        };
        this.cache = new JGitFileSystemsCache(config);
        JGitFileSystemProvider fsProvider = (JGitFileSystemProvider)Mockito.mock(JGitFileSystemProvider.class);
        Git git = this.setupGit();
        JGitFileSystemImpl fs1 = new JGitFileSystemImpl(fsProvider, null, git, new JGitFileSystemLock(git, TimeUnit.MILLISECONDS, config.getJgitCacheEvictThresholdDuration()), "fs1", CredentialsProvider.getDefault(), null, null);
        Supplier<JGitFileSystem> fs1Supplier = this.getSupplierSpy((JGitFileSystem)fs1);
        this.cache.addSupplier("fs1", fs1Supplier);
        fs1.lock();
        fs1.lock();
        fs1.unlock();
        Assert.assertTrue((boolean)this.cache.memoizedSuppliers.containsKey("fs1"));
        JGitFileSystem fs2 = (JGitFileSystem)Mockito.mock(JGitFileSystem.class);
        Supplier<JGitFileSystem> fs2Supplier = this.getSupplierSpy(fs2);
        Mockito.when((Object)fs2.hasBeenInUse()).thenReturn((Object)true);
        this.cache.addSupplier("fs2", fs2Supplier);
        JGitFileSystem fs3 = (JGitFileSystem)Mockito.mock(JGitFileSystem.class);
        Supplier<JGitFileSystem> fs3Supplier = this.getSupplierSpy(fs3);
        Mockito.when((Object)fs3.hasBeenInUse()).thenReturn((Object)true);
        this.cache.addSupplier("fs5", fs3Supplier);
        Assert.assertTrue((boolean)this.cache.memoizedSuppliers.containsKey("fs1"));
    }

    private void setupCacheToTestOrder(JGitFileSystemProviderConfiguration config, String ... fsNames) {
        this.cache = new JGitFileSystemsCache(config);
        Arrays.stream(fsNames).forEach(fsName -> {
            JGitFileSystem fs = (JGitFileSystem)Mockito.mock(JGitFileSystem.class);
            Supplier<JGitFileSystem> fsSupplier = this.getSupplierSpy(fs);
            this.cache.addSupplier(fsName, fsSupplier);
        });
    }

    private Supplier<JGitFileSystem> getSupplierSpy(final JGitFileSystem fs1) {
        return (Supplier)Mockito.spy((Object)new Supplier<JGitFileSystem>(){

            @Override
            public JGitFileSystem get() {
                return fs1;
            }
        });
    }

    private JGitFileSystemProviderConfiguration setupConfigMock() {
        return new JGitFileSystemProviderConfiguration(){

            public int getJgitFileSystemsInstancesCache() {
                return 2;
            }

            public int getJgitRemoveEldestEntryIterations() {
                return 10;
            }

            public int getJgitCacheOverflowCleanupSize() {
                return 10;
            }
        };
    }
}

