/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.daemon.ssh;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.sshd.common.cipher.BuiltinCiphers;
import org.apache.sshd.common.mac.BuiltinMacs;
import org.assertj.core.api.Assertions;
import org.eclipse.jgit.transport.resolver.ReceivePackFactory;
import org.eclipse.jgit.util.FileUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.commons.concurrent.ExecutorServiceProducer;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProvider;
import org.uberfire.java.nio.fs.jgit.daemon.ssh.GitSSHService;

public class GitSSHServiceTest {
    private static final List<File> tempFiles = new ArrayList<File>();
    private final ExecutorService executorService = new ExecutorServiceProducer().produceUnmanagedExecutorService();

    protected static File createTempDirectory() throws IOException {
        File temp = File.createTempFile("temp", Long.toString(System.nanoTime()));
        if (!temp.delete()) {
            throw new IOException("Could not delete temp file: " + temp.getAbsolutePath());
        }
        if (!temp.mkdir()) {
            throw new IOException("Could not create temp directory: " + temp.getAbsolutePath());
        }
        tempFiles.add(temp);
        return temp;
    }

    @AfterClass
    @BeforeClass
    public static void cleanup() {
        for (File tempFile : tempFiles) {
            try {
                FileUtils.delete((File)tempFile, (int)1);
            }
            catch (IOException iOException) {}
        }
    }

    @Test
    public void testStartStop() throws Exception {
        GitSSHService sshService = new GitSSHService();
        File certDir = GitSSHServiceTest.createTempDirectory();
        sshService.setup(certDir, null, "10000", "RSA", (ReceivePackFactory)Mockito.mock(ReceivePackFactory.class), (JGitFileSystemProvider.RepositoryResolverImpl)Mockito.mock(JGitFileSystemProvider.RepositoryResolverImpl.class), this.executorService);
        sshService.start();
        Assert.assertTrue((boolean)sshService.isRunning());
        sshService.stop();
        Assert.assertFalse((boolean)sshService.isRunning());
    }

    @Test
    public void testStartStopAlgo2() throws Exception {
        GitSSHService sshService = new GitSSHService();
        File certDir = GitSSHServiceTest.createTempDirectory();
        sshService.setup(certDir, null, "10000", "DSA", (ReceivePackFactory)Mockito.mock(ReceivePackFactory.class), (JGitFileSystemProvider.RepositoryResolverImpl)Mockito.mock(JGitFileSystemProvider.RepositoryResolverImpl.class), this.executorService);
        sshService.start();
        Assert.assertTrue((boolean)sshService.isRunning());
        sshService.stop();
        Assert.assertFalse((boolean)sshService.isRunning());
    }

    @Test
    public void testCheckTimeout() throws Exception {
        GitSSHService sshService = new GitSSHService();
        File certDir = GitSSHServiceTest.createTempDirectory();
        String idleTimeout = "10000";
        sshService.setup(certDir, null, idleTimeout, "RSA", (ReceivePackFactory)Mockito.mock(ReceivePackFactory.class), (JGitFileSystemProvider.RepositoryResolverImpl)Mockito.mock(JGitFileSystemProvider.RepositoryResolverImpl.class), this.executorService);
        sshService.start();
        Assert.assertTrue((boolean)sshService.isRunning());
        Assertions.assertThat(sshService.getSshServer().getProperties().get("idle-timeout")).isEqualTo((Object)idleTimeout);
        sshService.stop();
        Assert.assertFalse((boolean)sshService.isRunning());
    }

    @Test
    public void testCheckAlgo() throws Exception {
        GitSSHService sshService = new GitSSHService();
        File certDir = GitSSHServiceTest.createTempDirectory();
        try {
            sshService.setup(certDir, null, "10000", "xxxx", (ReceivePackFactory)Mockito.mock(ReceivePackFactory.class), (JGitFileSystemProvider.RepositoryResolverImpl)Mockito.mock(JGitFileSystemProvider.RepositoryResolverImpl.class), this.executorService);
            Assert.fail((String)"has to fail");
        }
        catch (Exception ex) {
            Assertions.assertThat((String)ex.getMessage()).contains(new CharSequence[]{"'xxxx'"});
        }
    }

    @Test
    public void testCheckSetupParameters() throws Exception {
        GitSSHService sshService = new GitSSHService();
        File certDir = GitSSHServiceTest.createTempDirectory();
        try {
            sshService.setup(null, null, "10000", "RSA", (ReceivePackFactory)Mockito.mock(ReceivePackFactory.class), (JGitFileSystemProvider.RepositoryResolverImpl)Mockito.mock(JGitFileSystemProvider.RepositoryResolverImpl.class), this.executorService);
            Assert.fail((String)"has to fail");
        }
        catch (IllegalArgumentException ex) {
            Assertions.assertThat((String)ex.getMessage()).contains(new CharSequence[]{"'certDir'"});
        }
        try {
            sshService.setup(certDir, null, null, "RSA", (ReceivePackFactory)Mockito.mock(ReceivePackFactory.class), (JGitFileSystemProvider.RepositoryResolverImpl)Mockito.mock(JGitFileSystemProvider.RepositoryResolverImpl.class), this.executorService);
            Assert.fail((String)"has to fail");
        }
        catch (IllegalArgumentException ex) {
            Assertions.assertThat((String)ex.getMessage()).contains(new CharSequence[]{"'sshIdleTimeout'"});
        }
        try {
            sshService.setup(certDir, null, "", "RSA", (ReceivePackFactory)Mockito.mock(ReceivePackFactory.class), (JGitFileSystemProvider.RepositoryResolverImpl)Mockito.mock(JGitFileSystemProvider.RepositoryResolverImpl.class), this.executorService);
            Assert.fail((String)"has to fail");
        }
        catch (IllegalArgumentException ex) {
            Assertions.assertThat((String)ex.getMessage()).contains(new CharSequence[]{"'sshIdleTimeout'"});
        }
        try {
            sshService.setup(certDir, null, "1000", null, (ReceivePackFactory)Mockito.mock(ReceivePackFactory.class), (JGitFileSystemProvider.RepositoryResolverImpl)Mockito.mock(JGitFileSystemProvider.RepositoryResolverImpl.class), this.executorService);
            Assert.fail((String)"has to fail");
        }
        catch (IllegalArgumentException ex) {
            Assertions.assertThat((String)ex.getMessage()).contains(new CharSequence[]{"'algorithm'"});
        }
        try {
            sshService.setup(certDir, null, "1000", "", (ReceivePackFactory)Mockito.mock(ReceivePackFactory.class), (JGitFileSystemProvider.RepositoryResolverImpl)Mockito.mock(JGitFileSystemProvider.RepositoryResolverImpl.class), this.executorService);
            Assert.fail((String)"has to fail");
        }
        catch (IllegalArgumentException ex) {
            Assertions.assertThat((String)ex.getMessage()).contains(new CharSequence[]{"'algorithm'"});
        }
        try {
            sshService.setup(certDir, null, "100", "RSA", null, (JGitFileSystemProvider.RepositoryResolverImpl)Mockito.mock(JGitFileSystemProvider.RepositoryResolverImpl.class), this.executorService);
            Assert.fail((String)"has to fail");
        }
        catch (IllegalArgumentException ex) {
            Assertions.assertThat((String)ex.getMessage()).contains(new CharSequence[]{"'receivePackFactory'"});
        }
        try {
            sshService.setup(certDir, null, "100", "RSA", (ReceivePackFactory)Mockito.mock(ReceivePackFactory.class), null, this.executorService);
            Assert.fail((String)"has to fail");
        }
        catch (IllegalArgumentException ex) {
            Assertions.assertThat((String)ex.getMessage()).contains(new CharSequence[]{"'repositoryResolver'"});
        }
        try {
            sshService.setup(certDir, null, "10000", "RSA", (ReceivePackFactory)Mockito.mock(ReceivePackFactory.class), (JGitFileSystemProvider.RepositoryResolverImpl)Mockito.mock(JGitFileSystemProvider.RepositoryResolverImpl.class), this.executorService);
        }
        catch (IllegalArgumentException ex) {
            Assert.fail((String)"should not fail");
        }
    }

    @Test
    public void testCheckCiphersAndMacs() throws Exception {
        GitSSHService sshService = new GitSSHService();
        File certDir = GitSSHServiceTest.createTempDirectory();
        String idleTimeout = "10000";
        String ciphers = "aes128-cbc,aes128-ctr,aes192-cbc,aes192-ctr,aes256-cbc,aes256-ctr,arcfour128,arcfour256,blowfish-cbc,3des-cbc";
        String macs = "hmac-md5, hmac-md5-96, hmac-sha1, hmac-sha1-96, hmac-sha2-256, hmac-sha2-512";
        sshService.setup(certDir, null, idleTimeout, "RSA", (ReceivePackFactory)Mockito.mock(ReceivePackFactory.class), (JGitFileSystemProvider.RepositoryResolverImpl)Mockito.mock(JGitFileSystemProvider.RepositoryResolverImpl.class), this.executorService, ciphers, macs);
        sshService.start();
        Assert.assertTrue((boolean)sshService.isRunning());
        List ciphersReaded = sshService.getSshServer().getCipherFactoriesNames();
        List macsReaded = sshService.getSshServer().getMacFactoriesNames();
        Assertions.assertThat((List)ciphersReaded).hasSize(7);
        this.checkCiphersName(ciphersReaded);
        Assertions.assertThat((List)macsReaded).hasSize(6);
        this.checkMacsName(macsReaded);
        Assertions.assertThat(sshService.getSshServer().getProperties().get("idle-timeout")).isEqualTo((Object)idleTimeout);
        sshService.stop();
        Assert.assertFalse((boolean)sshService.isRunning());
    }

    @Test
    public void testCheckEmptyCiphers() throws Exception {
        GitSSHService sshService = new GitSSHService();
        File certDir = GitSSHServiceTest.createTempDirectory();
        String idleTimeout = "10000";
        String macs = "hmac-md5, hmac-md5-96, hmac-sha1, hmac-sha1-96, hmac-sha2-256, hmac-sha2-512";
        sshService.setup(certDir, null, idleTimeout, "RSA", (ReceivePackFactory)Mockito.mock(ReceivePackFactory.class), (JGitFileSystemProvider.RepositoryResolverImpl)Mockito.mock(JGitFileSystemProvider.RepositoryResolverImpl.class), this.executorService, "", macs);
        sshService.start();
        Assert.assertTrue((boolean)sshService.isRunning());
        List ciphersReaded = sshService.getSshServer().getCipherFactoriesNames();
        List macsReaded = sshService.getSshServer().getMacFactoriesNames();
        Assertions.assertThat((List)ciphersReaded).hasSize(7);
        this.checkCiphersName(ciphersReaded);
        Assertions.assertThat((List)macsReaded).hasSize(6);
        this.checkMacsName(macsReaded);
        Assertions.assertThat(sshService.getSshServer().getProperties().get("idle-timeout")).isEqualTo((Object)idleTimeout);
        sshService.stop();
        Assert.assertFalse((boolean)sshService.isRunning());
    }

    @Test
    public void testCheckEmptyMacs() throws Exception {
        GitSSHService sshService = new GitSSHService();
        File certDir = GitSSHServiceTest.createTempDirectory();
        String idleTimeout = "10000";
        String ciphers = "aes128-cbc,aes128-ctr,aes192-cbc,aes192-ctr,aes256-cbc,aes256-ctr,arcfour128,arcfour256,blowfish-cbc,3des-cbc";
        sshService.setup(certDir, null, idleTimeout, "RSA", (ReceivePackFactory)Mockito.mock(ReceivePackFactory.class), (JGitFileSystemProvider.RepositoryResolverImpl)Mockito.mock(JGitFileSystemProvider.RepositoryResolverImpl.class), this.executorService, ciphers, "");
        sshService.start();
        Assert.assertTrue((boolean)sshService.isRunning());
        List ciphersReaded = sshService.getSshServer().getCipherFactoriesNames();
        List macsReaded = sshService.getSshServer().getMacFactoriesNames();
        Assertions.assertThat((List)ciphersReaded).hasSize(7);
        this.checkCiphersName(ciphersReaded);
        Assertions.assertThat((List)macsReaded).hasSize(6);
        this.checkMacsName(macsReaded);
        Assertions.assertThat(sshService.getSshServer().getProperties().get("idle-timeout")).isEqualTo((Object)idleTimeout);
        sshService.stop();
        Assert.assertFalse((boolean)sshService.isRunning());
    }

    @Test
    public void testCheckEmptyCiphersAndMacs() throws Exception {
        GitSSHService sshService = new GitSSHService();
        File certDir = GitSSHServiceTest.createTempDirectory();
        String idleTimeout = "10000";
        sshService.setup(certDir, null, idleTimeout, "RSA", (ReceivePackFactory)Mockito.mock(ReceivePackFactory.class), (JGitFileSystemProvider.RepositoryResolverImpl)Mockito.mock(JGitFileSystemProvider.RepositoryResolverImpl.class), this.executorService, "", "");
        sshService.start();
        Assert.assertTrue((boolean)sshService.isRunning());
        List ciphersReaded = sshService.getSshServer().getCipherFactoriesNames();
        List macsReaded = sshService.getSshServer().getMacFactoriesNames();
        Assertions.assertThat((List)ciphersReaded).hasSize(7);
        this.checkCiphersName(ciphersReaded);
        Assertions.assertThat((List)macsReaded).hasSize(6);
        this.checkMacsName(macsReaded);
        Assertions.assertThat(sshService.getSshServer().getProperties().get("idle-timeout")).isEqualTo((Object)idleTimeout);
        sshService.stop();
        Assert.assertFalse((boolean)sshService.isRunning());
    }

    @Test
    public void testCheckNullCiphersAndMacs() throws Exception {
        GitSSHService sshService = new GitSSHService();
        File certDir = GitSSHServiceTest.createTempDirectory();
        String idleTimeout = "10000";
        sshService.setup(certDir, null, idleTimeout, "RSA", (ReceivePackFactory)Mockito.mock(ReceivePackFactory.class), (JGitFileSystemProvider.RepositoryResolverImpl)Mockito.mock(JGitFileSystemProvider.RepositoryResolverImpl.class), this.executorService, null, null);
        sshService.start();
        Assert.assertTrue((boolean)sshService.isRunning());
        List ciphersReaded = sshService.getSshServer().getCipherFactoriesNames();
        List macsReaded = sshService.getSshServer().getMacFactoriesNames();
        Assertions.assertThat((List)ciphersReaded).hasSize(7);
        this.checkCiphersName(ciphersReaded);
        Assertions.assertThat((List)macsReaded).hasSize(6);
        this.checkMacsName(macsReaded);
        Assertions.assertThat(sshService.getSshServer().getProperties().get("idle-timeout")).isEqualTo((Object)idleTimeout);
        sshService.stop();
        Assert.assertFalse((boolean)sshService.isRunning());
    }

    @Test
    public void testWithWrongCiphersAndMacs() throws Exception {
        GitSSHService sshService = new GitSSHService();
        File certDir = GitSSHServiceTest.createTempDirectory();
        String idleTimeout = "10000";
        String ciphers = "aes126-cbc,aes124-ctr,aes192-cbc,aes192-ctr,aes255-cbc,aes256-ctr,arcfour128,arcfour256,blowfish-cbc,3des-cbc";
        sshService.setup(certDir, null, idleTimeout, "RSA", (ReceivePackFactory)Mockito.mock(ReceivePackFactory.class), (JGitFileSystemProvider.RepositoryResolverImpl)Mockito.mock(JGitFileSystemProvider.RepositoryResolverImpl.class), this.executorService, ciphers, "");
        sshService.start();
        Assert.assertTrue((boolean)sshService.isRunning());
        List ciphersReaded = sshService.getSshServer().getCipherFactoriesNames();
        List macsReaded = sshService.getSshServer().getMacFactoriesNames();
        Assertions.assertThat((List)ciphersReaded).hasSize(5);
        this.checkCiphersName(ciphersReaded);
        Assertions.assertThat((List)macsReaded).hasSize(6);
        this.checkMacsName(macsReaded);
        Assertions.assertThat(sshService.getSshServer().getProperties().get("idle-timeout")).isEqualTo((Object)idleTimeout);
        sshService.stop();
        Assert.assertFalse((boolean)sshService.isRunning());
    }

    private void checkCiphersName(List<String> ciphersReaded) {
        for (String cipher : ciphersReaded) {
            Assertions.assertThat((Comparable)BuiltinCiphers.fromFactoryName((String)cipher)).isNotNull();
        }
    }

    private void checkMacsName(List<String> macsReaded) {
        for (String mac : macsReaded) {
            Assertions.assertThat((Comparable)BuiltinMacs.fromFactoryName((String)mac)).isNotNull();
        }
    }
}

