/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.extensions;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.java.nio.file.extensions.FileSystemHookExecutionContext;
import org.uberfire.java.nio.file.extensions.FileSystemHooks;
import org.uberfire.java.nio.fs.jgit.util.extensions.JGitFSHooks;

@RunWith(value=MockitoJUnitRunner.class)
public class JGitFSHooksTest {
    private static final String FS_NAME = "dora";
    private static final Integer EXIT_CODE = 0;
    @Captor
    private ArgumentCaptor<FileSystemHookExecutionContext> contextArgumentCaptor;

    @Test
    public void executeFSHooksTest() {
        FileSystemHookExecutionContext ctx = new FileSystemHookExecutionContext(FS_NAME);
        this.testExecuteFSHooks(ctx, FileSystemHooks.ExternalUpdate);
        ctx.addParam("POST_COMMIT_EXIT_CODE", (Object)EXIT_CODE);
        this.testExecuteFSHooks(ctx, FileSystemHooks.PostCommit);
    }

    private void testExecuteFSHooks(FileSystemHookExecutionContext ctx, FileSystemHooks hookType) {
        AtomicBoolean executedWithLambda = new AtomicBoolean(false);
        FileSystemHooks.FileSystemHook hook = (FileSystemHooks.FileSystemHook)Mockito.spy((Object)new FileSystemHooks.FileSystemHook(){

            public void execute(FileSystemHookExecutionContext context) {
                Assert.assertEquals((Object)JGitFSHooksTest.FS_NAME, (Object)context.getFsName());
            }
        });
        FileSystemHooks.FileSystemHook lambdaHook = context -> {
            Assert.assertEquals((Object)FS_NAME, (Object)context.getFsName());
            executedWithLambda.set(true);
        };
        JGitFSHooks.executeFSHooks((Object)hook, (FileSystemHooks)hookType, (FileSystemHookExecutionContext)ctx);
        JGitFSHooks.executeFSHooks((Object)lambdaHook, (FileSystemHooks)hookType, (FileSystemHookExecutionContext)ctx);
        this.verifyFSHook(hook, hookType);
        Assert.assertTrue((boolean)executedWithLambda.get());
    }

    @Test
    public void executeFSHooksArrayTest() {
        FileSystemHookExecutionContext ctx = new FileSystemHookExecutionContext(FS_NAME);
        this.testExecuteFSHooksArray(ctx, FileSystemHooks.ExternalUpdate);
        ctx.addParam("POST_COMMIT_EXIT_CODE", (Object)EXIT_CODE);
        this.testExecuteFSHooksArray(ctx, FileSystemHooks.PostCommit);
    }

    private void testExecuteFSHooksArray(FileSystemHookExecutionContext ctx, FileSystemHooks hookType) {
        AtomicBoolean executedWithLambda = new AtomicBoolean(false);
        FileSystemHooks.FileSystemHook hook = (FileSystemHooks.FileSystemHook)Mockito.spy((Object)new FileSystemHooks.FileSystemHook(){

            public void execute(FileSystemHookExecutionContext context) {
                Assert.assertEquals((Object)JGitFSHooksTest.FS_NAME, (Object)context.getFsName());
            }
        });
        FileSystemHooks.FileSystemHook lambdaHook = context -> {
            Assert.assertEquals((Object)FS_NAME, (Object)context.getFsName());
            executedWithLambda.set(true);
        };
        JGitFSHooks.executeFSHooks(Arrays.asList(hook, lambdaHook), (FileSystemHooks)hookType, (FileSystemHookExecutionContext)ctx);
        this.verifyFSHook(hook, hookType);
        Assert.assertTrue((boolean)executedWithLambda.get());
    }

    private void verifyFSHook(FileSystemHooks.FileSystemHook hook, FileSystemHooks hookType) {
        ((FileSystemHooks.FileSystemHook)Mockito.verify((Object)hook)).execute((FileSystemHookExecutionContext)this.contextArgumentCaptor.capture());
        FileSystemHookExecutionContext ctx = (FileSystemHookExecutionContext)this.contextArgumentCaptor.getValue();
        ((AbstractObjectAssert)Assertions.assertThat((Object)ctx).isNotNull()).hasFieldOrPropertyWithValue("fsName", (Object)FS_NAME);
        if (hookType.equals((Object)FileSystemHooks.PostCommit)) {
            ((AbstractObjectAssert)Assertions.assertThat((Object)ctx.getParamValue("POST_COMMIT_EXIT_CODE")).isNotNull()).isEqualTo((Object)EXIT_CODE);
        }
    }
}

