/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.net.URI;
import java.util.Collections;
import java.util.Set;
import org.fest.assertions.api.Assertions;
import org.junit.Test;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttribute;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.JGitPathImpl;

public class JGitFileSystemImplProviderUnsupportedOpTest
extends AbstractTestInfra {
    @Test
    public void testNewFileSystemUnsupportedOp() {
        URI newRepo = URI.create("git://someunsup-repo-name");
        FileSystem fs = this.provider.newFileSystem(newRepo, EMPTY_ENV);
        JGitPathImpl path = JGitPathImpl.create((JGitFileSystem)((JGitFileSystem)fs), (String)"", (String)"repo2-name", (boolean)false);
        try {
            this.provider.newFileSystem((Path)path, EMPTY_ENV);
            Assertions.failBecauseExceptionWasNotThrown(UnsupportedOperationException.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testNewFileChannelUnsupportedOp() {
        URI newRepo = URI.create("git://newfcrepo-name");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("git://newfcrepo-name/file.txt"));
        Set options = Collections.emptySet();
        try {
            this.provider.newFileChannel(path, options, new FileAttribute[0]);
            Assertions.failBecauseExceptionWasNotThrown(UnsupportedOperationException.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testNewAsynchronousFileChannelUnsupportedOp() {
        URI newRepo = URI.create("git://newasyncrepo-name");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("git://newasyncrepo-name/file.txt"));
        Set options = Collections.emptySet();
        try {
            this.provider.newAsynchronousFileChannel(path, options, null, new FileAttribute[0]);
            Assertions.failBecauseExceptionWasNotThrown(UnsupportedOperationException.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testCreateSymbolicLinkUnsupportedOp() {
        URI newRepo = URI.create("git://symbolic-repo-name");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path link = this.provider.getPath(URI.create("git://symbolic-repo-name/link.lnk"));
        Path path = this.provider.getPath(URI.create("git://symbolic-repo-name/file.txt"));
        try {
            this.provider.createSymbolicLink(link, path, new FileAttribute[0]);
            Assertions.failBecauseExceptionWasNotThrown(UnsupportedOperationException.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testCreateLinkUnsupportedOp() {
        URI newRepo = URI.create("git://link-repo-name");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path link = this.provider.getPath(URI.create("git://link-repo-name/link.lnk"));
        Path path = this.provider.getPath(URI.create("git://link-repo-name/file.txt"));
        try {
            this.provider.createLink(link, path);
            Assertions.failBecauseExceptionWasNotThrown(UnsupportedOperationException.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testReadSymbolicLinkUnsupportedOp() {
        URI newRepo = URI.create("git://read-link-repo-name");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path link = this.provider.getPath(URI.create("git://read-link-repo-name/link.lnk"));
        try {
            this.provider.readSymbolicLink(link);
            Assertions.failBecauseExceptionWasNotThrown(UnsupportedOperationException.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

