/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.fest.assertions.api.Assertions;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.java.nio.file.FileSystemAlreadyExistsException;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.GitImpl;
import org.uberfire.java.nio.fs.jgit.util.commands.Commit;
import org.uberfire.java.nio.fs.jgit.util.commands.CreateRepository;
import org.uberfire.java.nio.fs.jgit.util.commands.Fork;
import org.uberfire.java.nio.fs.jgit.util.commands.ListRefs;
import org.uberfire.java.nio.fs.jgit.util.exceptions.GitException;

public class JGitForkTest
extends AbstractTestInfra {
    public static final String TARGET_GIT = "target/target";
    public static final String SOURCE_GIT = "source/source";
    private static Logger logger = LoggerFactory.getLogger(JGitForkTest.class);

    @Test
    public void testToForkSuccess() throws IOException, GitAPIException {
        File parentFolder = JGitForkTest.createTempDirectory();
        File gitSource = new File(parentFolder, "source/source.git");
        Git origin = (Git)new CreateRepository(gitSource).execute().get();
        new Commit(origin, "user_branch", "name", "name@example.com", "commit!", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file2.txt", JGitForkTest.this.tempFile("temp2222"));
            }
        }).execute();
        new Commit(origin, "master", "name", "name@example.com", "commit", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file.txt", JGitForkTest.this.tempFile("temp"));
            }
        }).execute();
        new Commit(origin, "master", "name", "name@example.com", "commit", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file3.txt", JGitForkTest.this.tempFile("temp3"));
            }
        }).execute();
        new Fork(parentFolder, SOURCE_GIT, TARGET_GIT, CredentialsProvider.getDefault(), null).execute();
        File gitCloned = new File(parentFolder, "target/target.git");
        Git cloned = Git.createRepository((File)gitCloned);
        Assertions.assertThat((Object)cloned).isNotNull();
        Assertions.assertThat((List)new ListRefs(cloned.getRepository()).execute()).hasSize(2);
        Assertions.assertThat((String)((Ref)new ListRefs(cloned.getRepository()).execute().get(0)).getName()).isEqualTo((Object)"refs/heads/master");
        Assertions.assertThat((String)((Ref)new ListRefs(cloned.getRepository()).execute().get(1)).getName()).isEqualTo((Object)"refs/heads/user_branch");
        String remotePath = ((URIish)((RemoteConfig)((GitImpl)cloned)._remoteList().call().get(0)).getURIs().get(0)).getPath();
        Assertions.assertThat((String)remotePath).isEqualTo((Object)(gitSource.getPath() + "/"));
    }

    @Test(expected=GitException.class)
    public void testToForkAlreadyExists() throws IOException, GitAPIException {
        File parentFolder = JGitForkTest.createTempDirectory();
        File gitSource = new File(parentFolder, "source/source.git");
        Git origin = (Git)new CreateRepository(gitSource).execute().get();
        new Commit(origin, "master", "name", "name@example.com", "commit", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file.txt", JGitForkTest.this.tempFile("temp"));
            }
        }).execute();
        File gitTarget = new File(parentFolder, "target/target.git");
        Git originTarget = (Git)new CreateRepository(gitTarget).execute().get();
        new Commit(originTarget, "master", "name", "name@example.com", "commit", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file.txt", JGitForkTest.this.tempFile("temp"));
            }
        }).execute();
        new Fork(parentFolder, SOURCE_GIT, TARGET_GIT, CredentialsProvider.getDefault(), null).execute();
    }

    @Test
    public void testToForkWrongSource() throws IOException, GitAPIException {
        File parentFolder = JGitForkTest.createTempDirectory();
        try {
            new Fork(parentFolder, SOURCE_GIT, TARGET_GIT, CredentialsProvider.getDefault(), null).execute();
            Assertions.fail((String)"If got here is because it could for the repository");
        }
        catch (InvalidRemoteException e) {
            Assertions.assertThat((Throwable)e).isNotNull();
            logger.info(e.getMessage(), (Throwable)e);
        }
    }

    @Test
    public void testForkRepository() throws GitAPIException {
        final String SOURCE = "testforkA/source";
        String TARGET = "testforkB/target";
        HashMap<String, Object> env = new HashMap<String, Object>(){
            {
                this.put("init", "true");
            }
        };
        String sourcePath = "git://" + SOURCE;
        URI sourceUri = URI.create(sourcePath);
        this.provider.newFileSystem(sourceUri, (Map)env);
        HashMap<String, Object> forkEnv = new HashMap<String, Object>(){
            {
                this.put("origin", SOURCE);
            }
        };
        String forkPath = "git://" + TARGET;
        URI forkUri = URI.create(forkPath);
        JGitFileSystem fs = (JGitFileSystem)this.provider.newFileSystem(forkUri, (Map)forkEnv);
        Assertions.assertThat((String)((URIish)((RemoteConfig)((GitImpl)fs.getGit())._remoteList().call().get(0)).getURIs().get(0)).toString()).isEqualTo((Object)new File(this.provider.getGitRepoContainerDir(), SOURCE + ".git").toPath().toUri().toString());
    }

    @Test(expected=FileSystemAlreadyExistsException.class)
    public void testForkRepositoryThatAlreadyExists() throws GitAPIException {
        final String SOURCE = "testforkA/source";
        String TARGET = "testforkB/target";
        HashMap<String, Object> env = new HashMap<String, Object>(){
            {
                this.put("init", "true");
            }
        };
        String sourcePath = "git://" + SOURCE;
        URI sourceUri = URI.create(sourcePath);
        this.provider.newFileSystem(sourceUri, (Map)env);
        HashMap<String, Object> forkEnv = new HashMap<String, Object>(){
            {
                this.put("origin", SOURCE);
            }
        };
        String forkPath = "git://" + TARGET;
        URI forkUri = URI.create(forkPath);
        this.provider.newFileSystem(forkUri, (Map)forkEnv);
        this.provider.newFileSystem(forkUri, (Map)forkEnv);
    }
}

