/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.java.nio.base.version.VersionAttributes;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.JGitPathImpl;
import org.uberfire.java.nio.fs.jgit.JGitVersionAttributeView;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.commands.Clone;
import org.uberfire.java.nio.fs.jgit.util.commands.Commit;
import org.uberfire.java.nio.fs.jgit.util.commands.CreateRepository;
import org.uberfire.java.nio.fs.jgit.util.commands.GetTreeFromRef;
import org.uberfire.java.nio.fs.jgit.util.commands.ListDiffs;
import org.uberfire.java.nio.fs.jgit.util.commands.ListRefs;
import org.uberfire.java.nio.fs.jgit.util.model.PathType;

public class JGitUtilTest
extends AbstractTestInfra {
    @Test
    public void testNewRepo() throws IOException {
        File parentFolder = JGitUtilTest.createTempDirectory();
        File gitFolder = new File(parentFolder, "mytest.git");
        Git git = (Git)new CreateRepository(gitFolder).execute().get();
        Assertions.assertThat((Object)git).isNotNull();
        Assertions.assertThat((int)new ListRefs(git.getRepository()).execute().size()).isEqualTo(0);
        new Commit(git, "master", "name", "name@example.com", "commit", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file.txt", AbstractTestInfra.tempFile("temp"));
            }
        }).execute();
        Assertions.assertThat((int)new ListRefs(git.getRepository()).execute().size()).isEqualTo(1);
    }

    @Test
    public void testClone() throws IOException, InvalidRemoteException {
        File parentFolder = JGitUtilTest.createTempDirectory();
        File gitFolder = new File(parentFolder, "mytest.git");
        Git origin = (Git)new CreateRepository(gitFolder).execute().get();
        new Commit(origin, "user_branch", "name", "name@example.com", "commit!", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file2.txt", AbstractTestInfra.tempFile("temp2222"));
            }
        }).execute();
        new Commit(origin, "master", "name", "name@example.com", "commit", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file.txt", AbstractTestInfra.tempFile("temp"));
            }
        }).execute();
        new Commit(origin, "master", "name", "name@example.com", "commit", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file3.txt", AbstractTestInfra.tempFile("temp3"));
            }
        }).execute();
        File gitClonedFolder = new File(parentFolder, "myclone.git");
        Git git = (Git)new Clone(gitClonedFolder, origin.getRepository().getDirectory().toString(), false, null, CredentialsProvider.getDefault(), null, null).execute().get();
        Assertions.assertThat((Object)git).isNotNull();
        Assertions.assertThat((List)new ListRefs(git.getRepository()).execute()).hasSize(2);
        Assertions.assertThat((String)((Ref)new ListRefs(git.getRepository()).execute().get(0)).getName()).isEqualTo((Object)"refs/heads/master");
        Assertions.assertThat((String)((Ref)new ListRefs(git.getRepository()).execute().get(1)).getName()).isEqualTo((Object)"refs/heads/user_branch");
    }

    @Test
    public void testPathResolve() throws IOException, InvalidRemoteException {
        File parentFolder = JGitUtilTest.createTempDirectory();
        File gitFolder = new File(parentFolder, "mytest.git");
        Git origin = (Git)new CreateRepository(gitFolder).execute().get();
        new Commit(origin, "user_branch", "name", "name@example.com", "commit!", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file2.txt", AbstractTestInfra.tempFile("temp2222"));
            }
        }).execute();
        new Commit(origin, "user_branch", "name", "name@example.com", "commit!", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file3.txt", AbstractTestInfra.tempFile("temp2222"));
            }
        }).execute();
        File gitClonedFolder = new File(parentFolder, "myclone.git");
        Git git = (Git)new Clone(gitClonedFolder, origin.getRepository().getDirectory().toString(), false, null, CredentialsProvider.getDefault(), null, null).execute().get();
        Assertions.assertThat((Comparable)git.getPathInfo("user_branch", "pathx/").getPathType()).isEqualTo((Object)PathType.NOT_FOUND);
        Assertions.assertThat((Comparable)git.getPathInfo("user_branch", "path/to/file2.txt").getPathType()).isEqualTo((Object)PathType.FILE);
        Assertions.assertThat((Comparable)git.getPathInfo("user_branch", "path/to").getPathType()).isEqualTo((Object)PathType.DIRECTORY);
    }

    @Test
    public void testAmend() throws IOException, InvalidRemoteException {
        File parentFolder = JGitUtilTest.createTempDirectory();
        System.out.println("COOL!:" + parentFolder.toString());
        File gitFolder = new File(parentFolder, "myxxxtest.git");
        Git origin = (Git)new CreateRepository(gitFolder).execute().get();
        new Commit(origin, "master", "name", "name@example.com", "commit!", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file2.txt", AbstractTestInfra.tempFile("tempwdf sdf asdf asd2222"));
            }
        }).execute();
        new Commit(origin, "master", "name", "name@example.com", "commit!", null, null, true, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file3.txt", AbstractTestInfra.tempFile("temp2x d dasdf asdf 222"));
            }
        }).execute();
        File gitClonedFolder = new File(parentFolder, "myclone.git");
        Git git = (Git)new Clone(gitClonedFolder, origin.getRepository().getDirectory().toString(), false, null, CredentialsProvider.getDefault(), null, null).execute().get();
        Assertions.assertThat((Comparable)git.getPathInfo("master", "pathx/").getPathType()).isEqualTo((Object)PathType.NOT_FOUND);
        Assertions.assertThat((Comparable)git.getPathInfo("master", "path/to/file2.txt").getPathType()).isEqualTo((Object)PathType.FILE);
        Assertions.assertThat((Comparable)git.getPathInfo("master", "path/to").getPathType()).isEqualTo((Object)PathType.DIRECTORY);
    }

    @Test
    public void testBuildVersionAttributes() throws Exception {
        File parentFolder = JGitUtilTest.createTempDirectory();
        File gitFolder = new File(parentFolder, "mytest.git");
        Git git = (Git)new CreateRepository(gitFolder).execute().get();
        new Commit(git, "master", "name", "name@example.com", "commit 1", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file2.txt", AbstractTestInfra.tempFile("who"));
            }
        }).execute();
        new Commit(git, "master", "name", "name@example.com", "commit 2", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file2.txt", AbstractTestInfra.tempFile("you"));
            }
        }).execute();
        new Commit(git, "master", "name", "name@example.com", "commit 3", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file2.txt", AbstractTestInfra.tempFile("gonna"));
            }
        }).execute();
        new Commit(git, "master", "name", "name@example.com", "commit 4", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file2.txt", AbstractTestInfra.tempFile("call?"));
            }
        }).execute();
        JGitFileSystem jGitFileSystem = (JGitFileSystem)Mockito.mock(JGitFileSystem.class);
        Mockito.when((Object)jGitFileSystem.getGit()).thenReturn((Object)git);
        JGitPathImpl path = (JGitPathImpl)Mockito.mock(JGitPathImpl.class);
        Mockito.when((Object)path.getFileSystem()).thenReturn((Object)jGitFileSystem);
        Mockito.when((Object)path.getRefTree()).thenReturn((Object)"master");
        Mockito.when((Object)path.getPath()).thenReturn((Object)"path/to/file2.txt");
        VersionAttributes versionAttributes = new JGitVersionAttributeView(path).readAttributes();
        List records = versionAttributes.history().records();
        Assert.assertEquals((Object)"commit 1", (Object)((VersionRecord)records.get(0)).comment());
        Assert.assertEquals((Object)"commit 2", (Object)((VersionRecord)records.get(1)).comment());
        Assert.assertEquals((Object)"commit 3", (Object)((VersionRecord)records.get(2)).comment());
        Assert.assertEquals((Object)"commit 4", (Object)((VersionRecord)records.get(3)).comment());
    }

    @Test
    public void testDiffForFileCreatedInEmptyRepositoryOrBranch() throws Exception {
        File parentFolder = JGitUtilTest.createTempDirectory();
        File gitFolder = new File(parentFolder, "mytest.git");
        Git git = (Git)new CreateRepository(gitFolder).execute().get();
        ObjectId oldHead = new GetTreeFromRef(git, "master").execute();
        new Commit(git, "master", "name", "name@example.com", "commit 1", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file.txt", AbstractTestInfra.tempFile("who"));
            }
        }).execute();
        ObjectId newHead = new GetTreeFromRef(git, "master").execute();
        List diff = new ListDiffs(git, oldHead, newHead).execute();
        Assert.assertNotNull((Object)diff);
        Assert.assertFalse((boolean)diff.isEmpty());
        Assert.assertEquals((Object)DiffEntry.ChangeType.ADD, (Object)((DiffEntry)diff.get(0)).getChangeType());
        Assert.assertEquals((Object)"path/to/file.txt", (Object)((DiffEntry)diff.get(0)).getNewPath());
    }
}

