/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.daemon.http;

import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProvider;
import org.uberfire.java.nio.fs.jgit.daemon.http.HTTPSupport;

public class HTTPSupportDisableTest
extends AbstractTestInfra {
    @Override
    public Map<String, String> getGitPreferences() {
        Map<String, String> gitPrefs = super.getGitPreferences();
        gitPrefs.put("org.uberfire.nio.git.http.enabled", "false");
        return gitPrefs;
    }

    @Test
    public void testRoot() {
        Assertions.assertThat((String)((String)this.provider.getFullHostNames().get("http"))).isNull();
    }

    @Test
    public void test() {
        HTTPSupport httpSupport = new HTTPSupport(){

            protected JGitFileSystemProvider resolveProvider() {
                return HTTPSupportDisableTest.this.provider;
            }
        };
        ServletContextEvent sce = (ServletContextEvent)Mockito.mock(ServletContextEvent.class);
        ServletContext sc = (ServletContext)Mockito.mock(ServletContext.class);
        Mockito.when((Object)sce.getServletContext()).thenReturn((Object)sc);
        httpSupport.contextInitialized(sce);
        Assert.assertFalse((boolean)this.provider.getFullHostNames().containsKey("http"));
        ((ServletContext)Mockito.verify((Object)sc, (VerificationMode)Mockito.times((int)0))).addServlet(Matchers.anyString(), (Servlet)Matchers.any(Servlet.class));
    }
}

