/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.fest.assertions.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProxy;

@RunWith(value=Parameterized.class)
public class NewProviderDefineDirTest
extends AbstractTestInfra {
    private String dirPathName;
    private File tempDir;

    public NewProviderDefineDirTest(String dirPathName) {
        this.dirPathName = dirPathName;
    }

    @Parameterized.Parameters(name="{index}: dir name: {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({".niogit"}, {".tempgit"});
    }

    @Override
    public Map<String, String> getGitPreferences() {
        try {
            this.tempDir = NewProviderDefineDirTest.createTempDirectory();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        Map<String, String> gitPrefs = super.getGitPreferences();
        gitPrefs.put("org.uberfire.nio.git.dir", this.tempDir.toString());
        if (!".niogit".equals(this.dirPathName)) {
            gitPrefs.put("org.uberfire.nio.git.dirname", this.dirPathName);
        }
        return gitPrefs;
    }

    @Test
    public void testUsingProvidedPath() throws IOException {
        URI newRepo = URI.create("git://repo-name");
        JGitFileSystemProxy fileSystem = (JGitFileSystemProxy)this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Object[] names = this.tempDir.list();
        Assertions.assertThat((Object[])names).isEmpty();
        Object[] repos = new File(this.tempDir, this.dirPathName).list();
        Assertions.assertThat((Object[])repos).isNull();
        fileSystem.getRealJGitFileSystem();
        names = this.tempDir.list();
        Assertions.assertThat((Object[])names).isNotEmpty().contains(new Object[]{this.dirPathName});
        repos = new File(this.tempDir, this.dirPathName).list();
        Assertions.assertThat((Object[])repos).isNotEmpty().contains(new Object[]{"repo-name.git"});
    }
}

