/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.config.ConfigProperties;

public class JGitFileSystemProviderConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(JGitFileSystemProviderConfiguration.class);
    public static final String GIT_ENV_KEY_DEFAULT_REMOTE_NAME = "origin";
    public static final String GIT_DAEMON_ENABLED = "org.uberfire.nio.git.daemon.enabled";
    public static final String GIT_SSH_ENABLED = "org.uberfire.nio.git.ssh.enabled";
    public static final String GIT_NIO_DIR = "org.uberfire.nio.git.dir";
    public static final String GIT_NIO_DIR_NAME = "org.uberfire.nio.git.dirname";
    public static final String ENABLE_GIT_KETCH = "org.uberfire.nio.git.ketch";
    public static final String HOOK_DIR = "org.uberfire.nio.git.hooks";
    public static final String GIT_DAEMON_HOST = "org.uberfire.nio.git.daemon.host";
    public static final String GIT_DAEMON_HOSTNAME = "org.uberfire.nio.git.daemon.hostname";
    public static final String GIT_DAEMON_PORT = "org.uberfire.nio.git.daemon.port";
    public static final String GIT_SSH_HOST = "org.uberfire.nio.git.ssh.host";
    public static final String GIT_SSH_HOSTNAME = "org.uberfire.nio.git.ssh.hostname";
    public static final String GIT_SSH_PORT = "org.uberfire.nio.git.ssh.port";
    public static final String GIT_SSH_CERT_DIR = "org.uberfire.nio.git.ssh.cert.dir";
    public static final String GIT_SSH_IDLE_TIMEOUT = "org.uberfire.nio.git.ssh.idle.timeout";
    public static final String GIT_SSH_ALGORITHM = "org.uberfire.nio.git.ssh.algorithm";
    public static final String GIT_SSH_PASSPHRASE = "org.uberfire.nio.git.ssh.passphrase";
    public static final String GIT_GC_LIMIT = "org.uberfire.nio.git.gc.limit";
    public static final String HTTP_PROXY_USER = "http.proxyUser";
    public static final String HTTP_PROXY_PASSWORD = "http.proxyPassword";
    public static final String HTTPS_PROXY_USER = "https.proxyUser";
    public static final String HTTPS_PROXY_PASSWORD = "https.proxyPassword";
    public static final String USER_DIR = "user.dir";
    public static final String JGIT_CACHE_INSTANCES = "org.uberfire.nio.jgit.cache.instances";
    public static final String GIT_ENV_KEY_DEST_PATH = "out-dir";
    public static final String GIT_ENV_KEY_USER_NAME = "username";
    public static final String GIT_ENV_KEY_PASSWORD = "password";
    public static final String GIT_ENV_KEY_INIT = "init";
    public static final String GIT_ENV_KEY_MIRROR = "mirror";
    public static final String SCHEME = "git";
    public static final int SCHEME_SIZE = "git://".length();
    public static final int DEFAULT_SCHEME_SIZE = "default://".length();
    public static final String REPOSITORIES_CONTAINER_DIR = ".niogit";
    public static final String SSH_FILE_CERT_CONTAINER_DIR = ".security";
    public static final String DEFAULT_HOST_NAME = "localhost";
    public static final String DEFAULT_HOST_ADDR = "127.0.0.1";
    public static final String DEFAULT_DAEMON_DEFAULT_ENABLED = "true";
    public static final String DEFAULT_DAEMON_DEFAULT_PORT = "9418";
    public static final String DEFAULT_SSH_ENABLED = "true";
    public static final String DEFAULT_SSH_PORT = "8001";
    public static final String DEFAULT_SSH_IDLE_TIMEOUT = "10000";
    public static final String DEFAULT_SSH_ALGORITHM = "DSA";
    public static final String DEFAULT_SSH_CERT_PASSPHRASE = "";
    public static final String DEFAULT_COMMIT_LIMIT_TO_GC = "20";
    public static final String DEFAULT_JGIT_FILE_SYSTEM_INSTANCES_CACHE = "20";
    public static final String DEFAULT_GIT_ENV_KEY_MIGRATE_FROM = "migrate-from";
    public static final String DEFAULT_ENABLE_GIT_KETCH = "false";
    private int commitLimit;
    private boolean daemonEnabled;
    private int daemonPort;
    private String daemonHostAddr;
    private String daemonHostName;
    private boolean sshEnabled;
    private int sshPort;
    private String sshHostAddr;
    private String sshHostName;
    private File sshFileCertDir;
    private String sshAlgorithm;
    private String sshPassphrase;
    private String sshIdleTimeout;
    private File gitReposParentDir;
    private File hookDir;
    boolean enableKetch = false;
    private String httpProxyUser;
    private String httpProxyPassword;
    private String httpsProxyUser;
    private String httpsProxyPassword;
    private int jgitFileSystemsInstancesCache;

    public void load(ConfigProperties systemConfig) {
        LOG.debug("Configuring from properties:");
        String currentDirectory = System.getProperty(USER_DIR);
        ConfigProperties.ConfigProperty enableKetchProp = systemConfig.get(ENABLE_GIT_KETCH, DEFAULT_ENABLE_GIT_KETCH);
        ConfigProperties.ConfigProperty hookDirProp = systemConfig.get(HOOK_DIR, null);
        ConfigProperties.ConfigProperty bareReposDirProp = systemConfig.get(GIT_NIO_DIR, currentDirectory);
        ConfigProperties.ConfigProperty reposDirNameProp = systemConfig.get(GIT_NIO_DIR_NAME, REPOSITORIES_CONTAINER_DIR);
        ConfigProperties.ConfigProperty enabledProp = systemConfig.get(GIT_DAEMON_ENABLED, "true");
        ConfigProperties.ConfigProperty hostProp = systemConfig.get(GIT_DAEMON_HOST, DEFAULT_HOST_ADDR);
        ConfigProperties.ConfigProperty hostNameProp = systemConfig.get(GIT_DAEMON_HOSTNAME, hostProp.isDefault() ? DEFAULT_HOST_NAME : hostProp.getValue());
        ConfigProperties.ConfigProperty portProp = systemConfig.get(GIT_DAEMON_PORT, DEFAULT_DAEMON_DEFAULT_PORT);
        ConfigProperties.ConfigProperty sshEnabledProp = systemConfig.get(GIT_SSH_ENABLED, "true");
        ConfigProperties.ConfigProperty sshHostProp = systemConfig.get(GIT_SSH_HOST, DEFAULT_HOST_ADDR);
        ConfigProperties.ConfigProperty sshHostNameProp = systemConfig.get(GIT_SSH_HOSTNAME, sshHostProp.isDefault() ? DEFAULT_HOST_NAME : sshHostProp.getValue());
        ConfigProperties.ConfigProperty sshPortProp = systemConfig.get(GIT_SSH_PORT, DEFAULT_SSH_PORT);
        ConfigProperties.ConfigProperty sshCertDirProp = systemConfig.get(GIT_SSH_CERT_DIR, currentDirectory);
        ConfigProperties.ConfigProperty sshIdleTimeoutProp = systemConfig.get(GIT_SSH_IDLE_TIMEOUT, DEFAULT_SSH_IDLE_TIMEOUT);
        ConfigProperties.ConfigProperty sshAlgorithmProp = systemConfig.get(GIT_SSH_ALGORITHM, DEFAULT_SSH_ALGORITHM);
        ConfigProperties.ConfigProperty sshPassphraseProp = systemConfig.get(GIT_SSH_PASSPHRASE, DEFAULT_SSH_CERT_PASSPHRASE);
        ConfigProperties.ConfigProperty commitLimitProp = systemConfig.get(GIT_GC_LIMIT, "20");
        ConfigProperties.ConfigProperty httpProxyUserProp = systemConfig.get(HTTP_PROXY_USER, null);
        ConfigProperties.ConfigProperty httpProxyPasswordProp = systemConfig.get(HTTP_PROXY_PASSWORD, null);
        ConfigProperties.ConfigProperty httpsProxyUserProp = systemConfig.get(HTTPS_PROXY_USER, null);
        ConfigProperties.ConfigProperty httpsProxyPasswordProp = systemConfig.get(HTTPS_PROXY_PASSWORD, null);
        ConfigProperties.ConfigProperty jgitFileSystemsInstancesCacheProp = systemConfig.get(JGIT_CACHE_INSTANCES, "20");
        this.httpProxyUser = httpProxyUserProp.getValue();
        this.httpProxyPassword = httpProxyPasswordProp.getValue();
        this.httpsProxyUser = httpsProxyUserProp.getValue();
        this.httpsProxyPassword = httpsProxyPasswordProp.getValue();
        if (LOG.isDebugEnabled()) {
            LOG.debug(systemConfig.getConfigurationSummary("Summary of JGit configuration:"));
        }
        if (enableKetchProp != null && enableKetchProp.getValue() != null) {
            this.enableKetch = enableKetchProp.getBooleanValue();
        }
        if (hookDirProp != null && hookDirProp.getValue() != null) {
            this.hookDir = new File(hookDirProp.getValue());
            if (!this.hookDir.exists()) {
                this.hookDir = null;
            }
        }
        this.gitReposParentDir = new File(bareReposDirProp.getValue(), reposDirNameProp.getValue());
        this.commitLimit = commitLimitProp.getIntValue();
        this.jgitFileSystemsInstancesCache = jgitFileSystemsInstancesCacheProp.getIntValue();
        if (this.jgitFileSystemsInstancesCache < 1) {
            this.jgitFileSystemsInstancesCache = Integer.valueOf("20");
        }
        this.daemonEnabled = enabledProp.getBooleanValue();
        if (this.daemonEnabled) {
            this.daemonPort = portProp.getIntValue();
            this.daemonHostAddr = hostProp.getValue();
            this.daemonHostName = hostNameProp.getValue();
        }
        this.sshEnabled = sshEnabledProp.getBooleanValue();
        if (this.sshEnabled) {
            this.sshPort = sshPortProp.getIntValue();
            this.sshHostAddr = sshHostProp.getValue();
            this.sshHostName = sshHostNameProp.getValue();
            this.sshFileCertDir = new File(sshCertDirProp.getValue(), SSH_FILE_CERT_CONTAINER_DIR);
            this.sshAlgorithm = sshAlgorithmProp.getValue();
            this.sshIdleTimeout = sshIdleTimeoutProp.getValue();
            try {
                Integer.valueOf(this.sshIdleTimeout);
            }
            catch (NumberFormatException exception) {
                LOG.error("SSH Idle Timeout value is not a valid integer - Parameter is ignored, now using default value.");
                this.sshIdleTimeout = DEFAULT_SSH_IDLE_TIMEOUT;
            }
        }
        this.sshPassphrase = sshPassphraseProp.getValue();
    }

    public boolean httpProxyIsDefined() {
        return this.httpProxyUser != null && this.httpProxyPassword != null || this.httpsProxyUser != null && this.httpsProxyPassword != null;
    }

    public int getCommitLimit() {
        return this.commitLimit;
    }

    public boolean isDaemonEnabled() {
        return this.daemonEnabled;
    }

    public int getDaemonPort() {
        return this.daemonPort;
    }

    public String getDaemonHostAddr() {
        return this.daemonHostAddr;
    }

    public String getDaemonHostName() {
        return this.daemonHostName;
    }

    public boolean isSshEnabled() {
        return this.sshEnabled;
    }

    public int getSshPort() {
        return this.sshPort;
    }

    public String getSshHostAddr() {
        return this.sshHostAddr;
    }

    public String getSshHostName() {
        return this.sshHostName;
    }

    public File getSshFileCertDir() {
        return this.sshFileCertDir;
    }

    public String getSshAlgorithm() {
        return this.sshAlgorithm;
    }

    public String getSshPassphrase() {
        return this.sshPassphrase;
    }

    public String getSshIdleTimeout() {
        return this.sshIdleTimeout;
    }

    public File getGitReposParentDir() {
        return this.gitReposParentDir;
    }

    public File getHookDir() {
        return this.hookDir;
    }

    public boolean isEnableKetch() {
        return this.enableKetch;
    }

    public String getHttpProxyUser() {
        return this.httpProxyUser;
    }

    public String getHttpProxyPassword() {
        return this.httpProxyPassword;
    }

    public String getHttpsProxyUser() {
        return this.httpsProxyUser;
    }

    public String getHttpsProxyPassword() {
        return this.httpsProxyPassword;
    }

    public int getJgitFileSystemsInstancesCache() {
        return this.jgitFileSystemsInstancesCache;
    }
}

