/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.commands;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.uberfire.java.nio.fs.jgit.util.GitImpl;

public class ListCommits {
    private final GitImpl git;
    private final ObjectId startRange;
    private final ObjectId endRange;
    private final Ref ref;
    private final String path;

    public ListCommits(GitImpl git, Ref ref, String path) {
        this.git = git;
        this.ref = ref;
        this.path = path;
        this.startRange = null;
        this.endRange = null;
    }

    public ListCommits(GitImpl git, ObjectId startRange, ObjectId endRange) {
        this.git = git;
        this.startRange = startRange;
        this.endRange = endRange;
        this.ref = null;
        this.path = null;
    }

    public List<RevCommit> execute() throws IOException, GitAPIException {
        ArrayList<RevCommit> list = new ArrayList<RevCommit>();
        try (RevWalk rw = this.buildWalk();){
            if (this.ref == null) {
                rw.markStart(rw.parseCommit((AnyObjectId)this.endRange));
                if (this.startRange != null) {
                    rw.markUninteresting(rw.parseCommit((AnyObjectId)this.startRange));
                }
            }
            for (RevCommit rev : rw) {
                list.add(rev);
            }
            ArrayList<RevCommit> arrayList = list;
            return arrayList;
        }
    }

    private RevWalk buildWalk() throws GitAPIException, IncorrectObjectTypeException, MissingObjectException {
        if (this.ref != null) {
            LogCommand logCommand = this.git._log().add((AnyObjectId)this.ref.getObjectId());
            if (this.path != null && !this.path.isEmpty()) {
                logCommand.addPath(this.path);
            }
            return (RevWalk)logCommand.call();
        }
        return new RevWalk(this.git.getRepository());
    }
}

