/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.ws;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.cluster.ClusterJMSService;
import org.uberfire.commons.cluster.ClusterService;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.WatchEvent;
import org.uberfire.java.nio.file.WatchService;
import org.uberfire.java.nio.fs.jgit.ws.JGitFileSystemWatchServices;
import org.uberfire.java.nio.fs.jgit.ws.cluster.JGitEventsBroadcast;

public class JGitFileSystemsEventsManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(JGitFileSystemsEventsManager.class);
    private final Map<String, JGitFileSystemWatchServices> fsWatchServices = new ConcurrentHashMap<String, JGitFileSystemWatchServices>();
    private final ClusterService clusterService = this.createClusterJMSService();
    JGitEventsBroadcast jGitEventsBroadcast;

    public JGitFileSystemsEventsManager() {
        if (this.clusterService.isAppFormerClustered()) {
            this.setupJGitEventsBroadcast();
        }
    }

    ClusterService createClusterJMSService() {
        return new ClusterJMSService();
    }

    void setupJGitEventsBroadcast() {
        this.jGitEventsBroadcast = new JGitEventsBroadcast(this.clusterService, w -> this.publishEvents(w.getFsName(), w.getWatchable(), w.getEvents(), false));
    }

    public WatchService newWatchService(String fsName) throws UnsupportedOperationException, IOException {
        this.fsWatchServices.putIfAbsent(fsName, this.createFSWatchServicesManager());
        if (this.jGitEventsBroadcast != null) {
            this.jGitEventsBroadcast.createWatchServiceJMS(fsName);
        }
        return this.fsWatchServices.get(fsName).newWatchService(fsName);
    }

    JGitFileSystemWatchServices createFSWatchServicesManager() {
        return new JGitFileSystemWatchServices();
    }

    public void publishEvents(String fsName, Path watchable, List<WatchEvent<?>> elist) {
        this.publishEvents(fsName, watchable, elist, true);
    }

    public void publishEvents(String fsName, Path watchable, List<WatchEvent<?>> elist, boolean broadcastEvents) {
        JGitFileSystemWatchServices watchService = this.fsWatchServices.get(fsName);
        if (watchService == null) {
            return;
        }
        watchService.publishEvents(watchable, elist);
        if (this.shouldIBroadcast(broadcastEvents)) {
            this.jGitEventsBroadcast.broadcast(fsName, watchable, elist);
        }
    }

    private boolean shouldIBroadcast(boolean broadcastEvents) {
        return broadcastEvents && this.jGitEventsBroadcast != null;
    }

    public void close(String name) {
        JGitFileSystemWatchServices watchService = this.fsWatchServices.get(name);
        if (watchService != null) {
            try {
                watchService.close();
            }
            catch (Exception ex) {
                LOGGER.error("Can't close watch service [" + this.toString() + "]", (Throwable)ex);
            }
        }
        if (this.jGitEventsBroadcast != null) {
            this.jGitEventsBroadcast.close();
        }
    }

    JGitEventsBroadcast getjGitEventsBroadcast() {
        return this.jGitEventsBroadcast;
    }

    Map<String, JGitFileSystemWatchServices> getFsWatchServices() {
        return this.fsWatchServices;
    }
}

