/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.manager;

import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProviderConfiguration;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProxy;
import org.uberfire.java.nio.fs.jgit.manager.JGitFileSystemsCache;

@RunWith(value=MockitoJUnitRunner.class)
public class JGitFileSystemsCacheTest {
    JGitFileSystemsCache cache;
    private JGitFileSystemProviderConfiguration config;

    @Before
    public void setup() {
        this.config = (JGitFileSystemProviderConfiguration)Mockito.mock(JGitFileSystemProviderConfiguration.class);
    }

    @Test
    public void addAndGetTest() {
        Mockito.when((Object)this.config.getJgitFileSystemsInstancesCache()).thenReturn((Object)2);
        this.cache = new JGitFileSystemsCache(this.config);
        Assert.assertTrue((boolean)this.cache.fileSystemsSuppliers.isEmpty());
        Assert.assertTrue((boolean)this.cache.memoizedSuppliers.isEmpty());
        Assert.assertEquals(null, (Object)this.cache.get("fs1"));
        JGitFileSystem fs1 = (JGitFileSystem)Mockito.mock(JGitFileSystem.class);
        Supplier<JGitFileSystem> fs1Supplier = () -> fs1;
        this.cache.addSupplier("fs1", fs1Supplier);
        Assert.assertFalse((boolean)this.cache.fileSystemsSuppliers.isEmpty());
        Assert.assertFalse((boolean)this.cache.memoizedSuppliers.isEmpty());
        JGitFileSystemProxy fs1Proxy = (JGitFileSystemProxy)this.cache.get("fs1");
        Assert.assertEquals((Object)fs1, (Object)fs1Proxy.getRealJGitFileSystem());
        Assert.assertTrue((boolean)this.cache.containsKey("fs1"));
        this.cache.clear();
        Assert.assertTrue((boolean)this.cache.fileSystemsSuppliers.isEmpty());
        Assert.assertTrue((boolean)this.cache.memoizedSuppliers.isEmpty());
    }

    @Test
    public void addMoreFSThanCacheSupports() {
        Mockito.when((Object)this.config.getJgitFileSystemsInstancesCache()).thenReturn((Object)2);
        this.cache = new JGitFileSystemsCache(this.config);
        JGitFileSystem fs1 = (JGitFileSystem)Mockito.mock(JGitFileSystem.class);
        Supplier<JGitFileSystem> fs1Supplier = this.getSupplierSpy(fs1);
        this.cache.addSupplier("fs1", fs1Supplier);
        Assert.assertEquals((long)1L, (long)this.cache.fileSystemsSuppliers.size());
        Assert.assertEquals((long)1L, (long)this.cache.memoizedSuppliers.size());
        ((JGitFileSystemProxy)this.cache.get("fs1")).getRealJGitFileSystem();
        JGitFileSystem fs2 = (JGitFileSystem)Mockito.mock(JGitFileSystem.class);
        Supplier<JGitFileSystem> fs2Supplier = this.getSupplierSpy(fs2);
        this.cache.addSupplier("fs2", fs2Supplier);
        ((JGitFileSystemProxy)this.cache.get("fs2")).getRealJGitFileSystem();
        Assert.assertEquals((long)2L, (long)this.cache.fileSystemsSuppliers.size());
        Assert.assertEquals((long)2L, (long)this.cache.memoizedSuppliers.size());
        JGitFileSystem fs3 = (JGitFileSystem)Mockito.mock(JGitFileSystem.class);
        Supplier<JGitFileSystem> fs3Supplier = this.getSupplierSpy(fs3);
        this.cache.addSupplier("fs3", fs3Supplier);
        ((JGitFileSystemProxy)this.cache.get("fs3")).getRealJGitFileSystem();
        Assert.assertEquals((long)3L, (long)this.cache.fileSystemsSuppliers.size());
        Assert.assertEquals((long)2L, (long)this.cache.memoizedSuppliers.size());
        ((JGitFileSystemProxy)this.cache.get("fs2")).getRealJGitFileSystem();
        ((Supplier)Mockito.verify(fs2Supplier, (VerificationMode)Mockito.times((int)1))).get();
        ((JGitFileSystemProxy)this.cache.get("fs3")).getRealJGitFileSystem();
        ((Supplier)Mockito.verify(fs3Supplier, (VerificationMode)Mockito.times((int)1))).get();
        ((JGitFileSystemProxy)this.cache.get("fs1")).getRealJGitFileSystem();
        ((Supplier)Mockito.verify(fs1Supplier, (VerificationMode)Mockito.times((int)2))).get();
    }

    private Supplier<JGitFileSystem> getSupplierSpy(final JGitFileSystem fs1) {
        return (Supplier)Mockito.spy((Object)new Supplier<JGitFileSystem>(){

            @Override
            public JGitFileSystem get() {
                return fs1;
            }
        });
    }
}

