/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.manager;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProvider;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProviderConfiguration;
import org.uberfire.java.nio.fs.jgit.manager.JGitFileSystemsManager;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.ws.JGitFileSystemsEventsManager;

@RunWith(value=MockitoJUnitRunner.class)
public class JGitFileSystemsManagerTest {
    private JGitFileSystemProviderConfiguration config;
    private JGitFileSystemsManager manager;

    @Before
    public void setup() {
        this.config = (JGitFileSystemProviderConfiguration)Mockito.mock(JGitFileSystemProviderConfiguration.class);
    }

    @Test
    public void newFSTest() {
        JGitFileSystem fs = (JGitFileSystem)Mockito.mock(JGitFileSystem.class);
        Mockito.when((Object)fs.getName()).thenReturn((Object)"fs");
        JGitFileSystem fs1 = (JGitFileSystem)Mockito.mock(JGitFileSystem.class);
        Mockito.when((Object)fs1.getName()).thenReturn((Object)"fs1");
        this.manager = new JGitFileSystemsManager((JGitFileSystemProvider)Mockito.mock(JGitFileSystemProvider.class), this.config);
        this.manager.newFileSystem(() -> new HashMap(), () -> (Git)Mockito.mock(Git.class), () -> fs.getName(), () -> (CredentialsProvider)Mockito.mock(CredentialsProvider.class), () -> (JGitFileSystemsEventsManager)Mockito.mock(JGitFileSystemsEventsManager.class));
        this.manager.newFileSystem(() -> new HashMap(), () -> (Git)Mockito.mock(Git.class), () -> fs1.getName(), () -> (CredentialsProvider)Mockito.mock(CredentialsProvider.class), () -> (JGitFileSystemsEventsManager)Mockito.mock(JGitFileSystemsEventsManager.class));
        Assert.assertTrue((boolean)this.manager.containsKey("fs"));
        this.manager.addClosedFileSystems(fs);
        Assert.assertTrue((!this.manager.allTheFSAreClosed() ? 1 : 0) != 0);
        this.manager.clear();
        Assert.assertTrue((boolean)this.manager.allTheFSAreClosed());
    }

    @Test
    public void parseFSTest() {
        this.manager = new JGitFileSystemsManager((JGitFileSystemProvider)Mockito.mock(JGitFileSystemProvider.class), this.config);
        this.checkParse("a", Arrays.asList("a"));
        this.checkParse("/a", Arrays.asList("a"));
        this.checkParse("/a/", Arrays.asList("a"));
        this.checkParse("a/b/", Arrays.asList("a", "a/b"));
        this.checkParse("/a/b/", Arrays.asList("a", "a/b"));
        this.checkParse("a/b/c", Arrays.asList("a", "a/b", "a/b/c"));
        this.checkParse("a/b/c/d", Arrays.asList("a", "a/b", "a/b/c", "a/b/c/d"));
    }

    @Test
    public void removeFSTest() {
        JGitFileSystem fs = (JGitFileSystem)Mockito.mock(JGitFileSystem.class);
        Mockito.when((Object)fs.getName()).thenReturn((Object)"fs");
        JGitFileSystem fs1 = (JGitFileSystem)Mockito.mock(JGitFileSystem.class);
        Mockito.when((Object)fs1.getName()).thenReturn((Object)"fs1");
        this.manager = new JGitFileSystemsManager((JGitFileSystemProvider)Mockito.mock(JGitFileSystemProvider.class), this.config);
        this.manager.newFileSystem(() -> new HashMap(), () -> (Git)Mockito.mock(Git.class), () -> fs.getName(), () -> (CredentialsProvider)Mockito.mock(CredentialsProvider.class), () -> (JGitFileSystemsEventsManager)Mockito.mock(JGitFileSystemsEventsManager.class));
        this.manager.newFileSystem(() -> new HashMap(), () -> (Git)Mockito.mock(Git.class), () -> fs1.getName(), () -> (CredentialsProvider)Mockito.mock(CredentialsProvider.class), () -> (JGitFileSystemsEventsManager)Mockito.mock(JGitFileSystemsEventsManager.class));
        Assert.assertTrue((boolean)this.manager.containsKey("fs1"));
        Assert.assertTrue((boolean)this.manager.containsRoot("fs1"));
        this.manager.addClosedFileSystems(fs1);
        Assert.assertTrue((boolean)this.manager.getClosedFileSystems().contains("fs1"));
        this.manager.remove("fs1");
        Assert.assertFalse((boolean)this.manager.containsKey("fs1"));
        Assert.assertFalse((boolean)this.manager.containsRoot("fs1"));
        Assert.assertFalse((boolean)this.manager.containsRoot("fs1"));
    }

    private void checkParse(String fsKey, List<String> expected) {
        List actual = this.manager.parseFSRoots(fsKey);
        Assert.assertEquals((long)actual.size(), (long)expected.size());
        for (String root : expected) {
            if (actual.contains(root)) continue;
            throw new RuntimeException();
        }
        this.manager.clear();
    }
}

