/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.jgit.diff.DiffEntry;
import org.junit.Before;
import org.junit.Test;
import org.uberfire.java.nio.base.FileDiff;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.GitImpl;
import org.uberfire.java.nio.fs.jgit.util.commands.Commit;
import org.uberfire.java.nio.fs.jgit.util.commands.CreateBranch;
import org.uberfire.java.nio.fs.jgit.util.commands.CreateRepository;

public class JGitDiffBranchesTest
extends AbstractTestInfra {
    private Git git;
    private static final String MASTER_BRANCH = "master";
    private static final String DEVELOP_BRANCH = "develop";
    private static final String NON_EXISTENT_FILE = "/dev/null";
    private static final List<String> TXT_FILES = Stream.of("file0", "file1", "file2", "file3", "file4").collect(Collectors.toList());
    private static final String[] COMMON_TXT_LINES = new String[]{"Line1", "Line2", "Line3", "Line4"};

    @Before
    public void setup() throws IOException {
        File parentFolder = JGitDiffBranchesTest.createTempDirectory();
        File gitSource = new File(parentFolder, "source/source.git");
        this.git = (Git)new CreateRepository(gitSource).execute().get();
        JGitDiffBranchesTest.commit(this.git, MASTER_BRANCH, "Adding files into master", JGitDiffBranchesTest.content(TXT_FILES.get(0), JGitDiffBranchesTest.multiline(TXT_FILES.get(0), COMMON_TXT_LINES)), JGitDiffBranchesTest.content(TXT_FILES.get(1), JGitDiffBranchesTest.multiline(TXT_FILES.get(1), COMMON_TXT_LINES)), JGitDiffBranchesTest.content(TXT_FILES.get(2), JGitDiffBranchesTest.multiline(TXT_FILES.get(2), COMMON_TXT_LINES)));
        new CreateBranch((GitImpl)this.git, MASTER_BRANCH, DEVELOP_BRANCH).execute();
    }

    @Test
    public void testDiffWithAddedFiles() throws IOException {
        JGitDiffBranchesTest.commit(this.git, DEVELOP_BRANCH, "Adding files", JGitDiffBranchesTest.content(TXT_FILES.get(3), JGitDiffBranchesTest.multiline(TXT_FILES.get(3), COMMON_TXT_LINES)), JGitDiffBranchesTest.content(TXT_FILES.get(4), JGitDiffBranchesTest.multiline(TXT_FILES.get(4), COMMON_TXT_LINES)));
        List fileDiffs = this.git.diffRefs(MASTER_BRANCH, DEVELOP_BRANCH);
        Assertions.assertThat((List)fileDiffs).isNotEmpty();
        Assertions.assertThat((List)fileDiffs).hasSize(2);
        fileDiffs.forEach(diff -> {
            AbstractCharSequenceAssert cfr_ignored_0 = (AbstractCharSequenceAssert)Assertions.assertThat((String)diff.getChangeType()).isEqualTo((Object)DiffEntry.ChangeType.ADD.toString());
        });
        Assertions.assertThat((String)((FileDiff)fileDiffs.get(0)).getNameA()).isEqualTo((Object)NON_EXISTENT_FILE);
        Assertions.assertThat((String)((FileDiff)fileDiffs.get(0)).getNameB()).isEqualTo((Object)TXT_FILES.get(3));
        Assertions.assertThat((int)((FileDiff)fileDiffs.get(0)).getStartA()).isEqualTo(0);
        Assertions.assertThat((int)((FileDiff)fileDiffs.get(0)).getEndA()).isEqualTo(0);
        Assertions.assertThat((int)((FileDiff)fileDiffs.get(0)).getStartB()).isEqualTo(0);
        Assertions.assertThat((int)((FileDiff)fileDiffs.get(0)).getEndB()).isEqualTo(4);
    }

    @Test
    public void testDiffWithRemovedFile() {
        new Commit(this.git, DEVELOP_BRANCH, "name", "name@example.com", "Removing file", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put(TXT_FILES.get(0), null);
            }
        }).execute();
        List fileDiffs = this.git.diffRefs(MASTER_BRANCH, DEVELOP_BRANCH);
        Assertions.assertThat((List)fileDiffs).isNotEmpty();
        Assertions.assertThat((List)fileDiffs).hasSize(1);
        Assertions.assertThat((String)((FileDiff)fileDiffs.get(0)).getChangeType()).isEqualTo((Object)DiffEntry.ChangeType.DELETE.toString());
        Assertions.assertThat((String)((FileDiff)fileDiffs.get(0)).getNameA()).isEqualTo((Object)TXT_FILES.get(0));
        Assertions.assertThat((String)((FileDiff)fileDiffs.get(0)).getNameB()).isEqualTo((Object)NON_EXISTENT_FILE);
        Assertions.assertThat((int)((FileDiff)fileDiffs.get(0)).getStartA()).isEqualTo(0);
        Assertions.assertThat((int)((FileDiff)fileDiffs.get(0)).getEndA()).isEqualTo(4);
        Assertions.assertThat((int)((FileDiff)fileDiffs.get(0)).getStartB()).isEqualTo(0);
        Assertions.assertThat((int)((FileDiff)fileDiffs.get(0)).getEndB()).isEqualTo(0);
    }

    @Test
    public void testDiffWithUpdatedFiles() throws IOException {
        JGitDiffBranchesTest.commit(this.git, DEVELOP_BRANCH, "Updating files", JGitDiffBranchesTest.content(TXT_FILES.get(1), JGitDiffBranchesTest.multiline(TXT_FILES.get(1), "Line1", "Line2Changed", "Line3", "Line4")), JGitDiffBranchesTest.content(TXT_FILES.get(2), JGitDiffBranchesTest.multiline(TXT_FILES.get(2), "Line1", "Line2Changed", "Line3", "Line4")));
        List fileDiffs = this.git.diffRefs(MASTER_BRANCH, DEVELOP_BRANCH);
        Assertions.assertThat((List)fileDiffs).isNotEmpty();
        Assertions.assertThat((List)fileDiffs).hasSize(2);
        fileDiffs.forEach(diff -> {
            AbstractCharSequenceAssert cfr_ignored_0 = (AbstractCharSequenceAssert)Assertions.assertThat((String)diff.getChangeType()).isEqualTo((Object)DiffEntry.ChangeType.MODIFY.toString());
        });
        Assertions.assertThat((String)((FileDiff)fileDiffs.get(0)).getNameA()).isEqualTo((Object)TXT_FILES.get(1));
        Assertions.assertThat((String)((FileDiff)fileDiffs.get(1)).getNameB()).isEqualTo((Object)TXT_FILES.get(2));
    }

    @Test
    public void testDiffWithUpdateFirstLine() throws IOException {
        JGitDiffBranchesTest.commit(this.git, DEVELOP_BRANCH, "Updating file", JGitDiffBranchesTest.content(TXT_FILES.get(1), JGitDiffBranchesTest.multiline(TXT_FILES.get(1), "Line1Changed", "Line2", "Line3", "Line4")));
        List fileDiffs = this.git.diffRefs(MASTER_BRANCH, DEVELOP_BRANCH);
        Assertions.assertThat((List)fileDiffs).isNotEmpty();
        Assertions.assertThat((List)fileDiffs).hasSize(1);
        Assertions.assertThat((String)((FileDiff)fileDiffs.get(0)).getChangeType()).isEqualTo((Object)DiffEntry.ChangeType.MODIFY.toString());
        Assertions.assertThat((String)((FileDiff)fileDiffs.get(0)).getNameA()).isEqualTo((Object)TXT_FILES.get(1));
        Assertions.assertThat((String)((FileDiff)fileDiffs.get(0)).getNameB()).isEqualTo((Object)TXT_FILES.get(1));
        Assertions.assertThat((int)((FileDiff)fileDiffs.get(0)).getStartA()).isEqualTo(0);
        Assertions.assertThat((int)((FileDiff)fileDiffs.get(0)).getEndA()).isEqualTo(1);
        Assertions.assertThat((int)((FileDiff)fileDiffs.get(0)).getStartB()).isEqualTo(0);
        Assertions.assertThat((int)((FileDiff)fileDiffs.get(0)).getEndB()).isEqualTo(1);
    }

    @Test
    public void testDiffWithUpdateLastLine() throws IOException {
        JGitDiffBranchesTest.commit(this.git, DEVELOP_BRANCH, "Updating file", JGitDiffBranchesTest.content(TXT_FILES.get(1), JGitDiffBranchesTest.multiline(TXT_FILES.get(1), "Line1", "Line2", "Line3", "Line4Changed")));
        List fileDiffs = this.git.diffRefs(MASTER_BRANCH, DEVELOP_BRANCH);
        Assertions.assertThat((List)fileDiffs).isNotEmpty();
        Assertions.assertThat((List)fileDiffs).hasSize(1);
        Assertions.assertThat((String)((FileDiff)fileDiffs.get(0)).getChangeType()).isEqualTo((Object)DiffEntry.ChangeType.MODIFY.toString());
        Assertions.assertThat((String)((FileDiff)fileDiffs.get(0)).getNameA()).isEqualTo((Object)TXT_FILES.get(1));
        Assertions.assertThat((String)((FileDiff)fileDiffs.get(0)).getNameB()).isEqualTo((Object)TXT_FILES.get(1));
        Assertions.assertThat((int)((FileDiff)fileDiffs.get(0)).getStartA()).isEqualTo(3);
        Assertions.assertThat((int)((FileDiff)fileDiffs.get(0)).getEndA()).isEqualTo(4);
        Assertions.assertThat((int)((FileDiff)fileDiffs.get(0)).getStartB()).isEqualTo(3);
        Assertions.assertThat((int)((FileDiff)fileDiffs.get(0)).getEndB()).isEqualTo(4);
    }

    @Test
    public void testDiffWithUpdateTwoConsecutiveLines() throws IOException {
        JGitDiffBranchesTest.commit(this.git, DEVELOP_BRANCH, "Updating file", JGitDiffBranchesTest.content(TXT_FILES.get(1), JGitDiffBranchesTest.multiline(TXT_FILES.get(1), "Line1", "Line2Changed", "Line3Changed", "Line4")));
        List fileDiffs = this.git.diffRefs(MASTER_BRANCH, DEVELOP_BRANCH);
        Assertions.assertThat((List)fileDiffs).isNotEmpty();
        Assertions.assertThat((List)fileDiffs).hasSize(1);
        Assertions.assertThat((String)((FileDiff)fileDiffs.get(0)).getChangeType()).isEqualTo((Object)DiffEntry.ChangeType.MODIFY.toString());
        Assertions.assertThat((String)((FileDiff)fileDiffs.get(0)).getNameA()).isEqualTo((Object)TXT_FILES.get(1));
        Assertions.assertThat((String)((FileDiff)fileDiffs.get(0)).getNameB()).isEqualTo((Object)TXT_FILES.get(1));
        Assertions.assertThat((int)((FileDiff)fileDiffs.get(0)).getStartA()).isEqualTo(1);
        Assertions.assertThat((int)((FileDiff)fileDiffs.get(0)).getEndA()).isEqualTo(3);
        Assertions.assertThat((int)((FileDiff)fileDiffs.get(0)).getStartB()).isEqualTo(1);
        Assertions.assertThat((int)((FileDiff)fileDiffs.get(0)).getEndB()).isEqualTo(3);
    }

    @Test
    public void testDiffWithUpdateFirstAndLastLines() throws IOException {
        JGitDiffBranchesTest.commit(this.git, DEVELOP_BRANCH, "Updating file", JGitDiffBranchesTest.content(TXT_FILES.get(1), JGitDiffBranchesTest.multiline(TXT_FILES.get(1), "Line1Changed", "Line2", "Line3", "Line4Changed")));
        List fileDiffs = this.git.diffRefs(MASTER_BRANCH, DEVELOP_BRANCH);
        Assertions.assertThat((List)fileDiffs).isNotEmpty();
        Assertions.assertThat((List)fileDiffs).hasSize(2);
        fileDiffs.forEach(diff -> {
            Assertions.assertThat((String)diff.getChangeType()).isEqualTo((Object)DiffEntry.ChangeType.MODIFY.toString());
            Assertions.assertThat((String)diff.getNameA()).isEqualTo((Object)TXT_FILES.get(1));
            Assertions.assertThat((String)diff.getNameB()).isEqualTo((Object)TXT_FILES.get(1));
        });
        Assertions.assertThat((int)((FileDiff)fileDiffs.get(0)).getStartA()).isEqualTo(0);
        Assertions.assertThat((int)((FileDiff)fileDiffs.get(0)).getEndA()).isEqualTo(1);
        Assertions.assertThat((int)((FileDiff)fileDiffs.get(0)).getStartB()).isEqualTo(0);
        Assertions.assertThat((int)((FileDiff)fileDiffs.get(0)).getEndB()).isEqualTo(1);
        Assertions.assertThat((int)((FileDiff)fileDiffs.get(1)).getStartA()).isEqualTo(3);
        Assertions.assertThat((int)((FileDiff)fileDiffs.get(1)).getEndA()).isEqualTo(4);
        Assertions.assertThat((int)((FileDiff)fileDiffs.get(1)).getStartB()).isEqualTo(3);
        Assertions.assertThat((int)((FileDiff)fileDiffs.get(1)).getEndB()).isEqualTo(4);
    }

    @Test
    public void testDiffWithAddedRemovedUpdatedFiles() throws IOException {
        new Commit(this.git, DEVELOP_BRANCH, "name", "name@example.com", "Removing file0", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put(TXT_FILES.get(0), null);
            }
        }).execute();
        JGitDiffBranchesTest.commit(this.git, DEVELOP_BRANCH, "Updating file1", JGitDiffBranchesTest.content(TXT_FILES.get(1), JGitDiffBranchesTest.multiline(TXT_FILES.get(1), "Line1", "Line2Changed", "Line3", "Line4")));
        JGitDiffBranchesTest.commit(this.git, DEVELOP_BRANCH, "Adding file3", JGitDiffBranchesTest.content(TXT_FILES.get(3), JGitDiffBranchesTest.multiline(TXT_FILES.get(3), COMMON_TXT_LINES)));
        List fileDiffs = this.git.diffRefs(MASTER_BRANCH, DEVELOP_BRANCH);
        Assertions.assertThat((List)fileDiffs).isNotEmpty();
        Assertions.assertThat((List)fileDiffs).hasSize(3);
        Assertions.assertThat((String)((FileDiff)fileDiffs.get(0)).getChangeType()).isEqualTo((Object)DiffEntry.ChangeType.DELETE.toString());
        Assertions.assertThat((String)((FileDiff)fileDiffs.get(0)).getNameA()).isEqualTo((Object)TXT_FILES.get(0));
        Assertions.assertThat((String)((FileDiff)fileDiffs.get(0)).getNameB()).isEqualTo((Object)NON_EXISTENT_FILE);
        Assertions.assertThat((String)((FileDiff)fileDiffs.get(1)).getChangeType()).isEqualTo((Object)DiffEntry.ChangeType.MODIFY.toString());
        Assertions.assertThat((String)((FileDiff)fileDiffs.get(1)).getNameA()).isEqualTo((Object)TXT_FILES.get(1));
        Assertions.assertThat((String)((FileDiff)fileDiffs.get(1)).getNameB()).isEqualTo((Object)TXT_FILES.get(1));
        Assertions.assertThat((String)((FileDiff)fileDiffs.get(2)).getChangeType()).isEqualTo((Object)DiffEntry.ChangeType.ADD.toString());
        Assertions.assertThat((String)((FileDiff)fileDiffs.get(2)).getNameA()).isEqualTo((Object)NON_EXISTENT_FILE);
        Assertions.assertThat((String)((FileDiff)fileDiffs.get(2)).getNameB()).isEqualTo((Object)TXT_FILES.get(3));
    }

    @Test
    public void testDiffWithNonExistentBranch() {
        List fileDiffs = this.git.diffRefs(MASTER_BRANCH, "nonExistentBranch");
        Assertions.assertThat((List)fileDiffs).isEmpty();
    }
}

