/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemImpl;

public class JGitFileSystemImplProviderHookTest
extends AbstractTestInfra {
    @Override
    public Map<String, String> getGitPreferences() {
        Map<String, String> gitPrefs = super.getGitPreferences();
        try {
            File hooksDir = JGitFileSystemImplProviderHookTest.createTempDirectory();
            gitPrefs.put("org.uberfire.nio.git.hooks", hooksDir.getAbsolutePath());
            this.writeMockHook(hooksDir, "post-commit");
            this.writeMockHook(hooksDir, "pre-commit");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return gitPrefs;
    }

    @Test
    public void testInstalledHook() {
        URI newRepo = URI.create("git://hook-repo-name");
        FileSystem fs = this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Assertions.assertThat((Object)fs).isNotNull();
        if (fs instanceof JGitFileSystemImpl) {
            Object[] hooks = new File(((JGitFileSystemImpl)fs).getGit().getRepository().getDirectory(), "hooks").listFiles();
            Assertions.assertThat((Object[])hooks).isNotEmpty().isNotNull();
            Assertions.assertThat((int)hooks.length).isEqualTo(2);
            boolean foundPreCommitHook = false;
            boolean foundPostCommitHook = false;
            for (Object hook : hooks) {
                if (((File)hook).getName().equals("pre-commit")) {
                    foundPreCommitHook = ((File)hook).canExecute();
                    continue;
                }
                if (!((File)hook).getName().equals("post-commit")) continue;
                foundPostCommitHook = ((File)hook).canExecute();
            }
            Assertions.assertThat((boolean)foundPreCommitHook).isTrue();
            Assertions.assertThat((boolean)foundPostCommitHook).isTrue();
        }
    }

    @Test
    public void testExecutedPostCommitHook() throws IOException {
        this.testHook("hook-repo-name-executed", "post-commit", true);
    }

    @Test
    public void testNotSupportedPreCommitHook() throws IOException {
        this.testHook("hook-repo-name-executed-pre-commit", "pre-commit", false);
    }
}

