/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.extensions.FileSystemHookExecutionContext;
import org.uberfire.java.nio.file.extensions.FileSystemHooks;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;

@RunWith(value=MockitoJUnitRunner.class)
public class JGitFileSystemImplProviderPostCommitHookTest
extends AbstractTestInfra {
    private static final Integer SUCCESS = 0;
    private static final Integer WARNING = 10;
    private static final Integer ERROR = 50;
    private static final String SCRIPT = "exit ";
    private static final String HOOKS_FOLDER = "hooks";
    private static final String GIT = "git://";
    private static final String REPO_NAME = "repo";
    private static final String NEW_FILE_PATH = "/folder/file.txt";
    @Mock
    private FileSystemHooks.FileSystemHook postCommitHook;
    @Captor
    private ArgumentCaptor<FileSystemHookExecutionContext> contextCaptor;
    private JGitFileSystem fs;

    @Before
    public void init() {
        URI newRepo = URI.create("git://repo");
        HashMap<String, FileSystemHooks.FileSystemHook> env = new HashMap<String, FileSystemHooks.FileSystemHook>();
        env.put(FileSystemHooks.PostCommit.name(), this.postCommitHook);
        this.fs = (JGitFileSystem)this.provider.newFileSystem(newRepo, env);
        Assertions.assertThat((Object)this.fs).isNotNull();
    }

    @Test
    public void testPostCommitWithoutHook() throws IOException {
        this.commitFile();
        ((FileSystemHooks.FileSystemHook)Mockito.verify((Object)this.postCommitHook, (VerificationMode)Mockito.never())).execute((FileSystemHookExecutionContext)Matchers.any());
    }

    @Test
    public void testPostCommitHookSuccess() throws IOException {
        this.testPostCommit(SUCCESS);
    }

    @Test
    public void testPostCommitHookWarning() throws IOException {
        this.testPostCommit(WARNING);
    }

    @Test
    public void testPostCommitHookError() throws IOException {
        this.testPostCommit(ERROR);
    }

    private void testPostCommit(Integer exitCode) throws IOException {
        this.prepareHook(exitCode);
        this.commitFile();
        ((FileSystemHooks.FileSystemHook)Mockito.verify((Object)this.postCommitHook)).execute((FileSystemHookExecutionContext)this.contextCaptor.capture());
        FileSystemHookExecutionContext context = (FileSystemHookExecutionContext)this.contextCaptor.getValue();
        ((ObjectAssert)Assertions.assertThat((Object)context).isNotNull()).hasFieldOrPropertyWithValue("fsName", (Object)REPO_NAME);
        ((ObjectAssert)Assertions.assertThat((Object)context.getParamValue("POST_COMMIT_EXIT_CODE")).isNotNull()).isEqualTo((Object)exitCode);
    }

    private void prepareHook(Integer code) throws IOException {
        File destHookFile = this.fs.getGit().getRepository().getDirectory().toPath().resolve(HOOKS_FOLDER).resolve("post-commit").toFile();
        FileUtils.write((File)destHookFile, (CharSequence)(SCRIPT + code), (Charset)Charset.defaultCharset());
        if (SystemUtils.IS_OS_WINDOWS) {
            destHookFile.setReadable(true);
            destHookFile.setWritable(true);
            destHookFile.setExecutable(true);
        } else {
            HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
            perms.add(PosixFilePermission.OWNER_READ);
            perms.add(PosixFilePermission.OWNER_WRITE);
            perms.add(PosixFilePermission.GROUP_EXECUTE);
            perms.add(PosixFilePermission.OTHERS_EXECUTE);
            perms.add(PosixFilePermission.OWNER_EXECUTE);
            Files.setPosixFilePermissions(destHookFile.toPath(), perms);
        }
    }

    private void commitFile() throws IOException {
        Path path = this.provider.getPath(URI.create("git://repo/folder/file.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        Assertions.assertThat((Object)outStream).isNotNull();
        outStream.write("my content".getBytes());
        outStream.close();
    }
}

