/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.jboss.byteman.contrib.bmunit.BMScript;
import org.jboss.byteman.contrib.bmunit.BMUnitConfig;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.java.nio.base.options.SquashOption;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemImpl;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProvider;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProxy;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.GitImpl;
import org.uberfire.java.nio.fs.jgit.util.commands.GetRef;

@RunWith(value=BMUnitRunner.class)
@BMUnitConfig(loadDirectory="target/test-classes", debug=true)
public class JGitFileSystemImplProviderBytemanTest
extends AbstractTestInfra {
    private static Logger logger = LoggerFactory.getLogger(JGitFileSystemImplProviderBytemanTest.class);

    @Override
    @Before
    public void createGitFsProvider() {
        this.provider = new JGitFileSystemProvider();
    }

    @Ignore(value="This test produces a strange behaviour that locks the other test. Is ignored until a solution is found.")
    @Test
    @BMScript(value="byteman/squash_lock.btm")
    public void testConcurrentLocking() throws IOException, GitAPIException {
        URI newRepo = URI.create("git://byteman-lock-squash-repo");
        JGitFileSystemImpl fs = (JGitFileSystemImpl)this.provider.newFileSystem(newRepo, EMPTY_ENV);
        CyclicBarrier threadsFinishedBarrier = new CyclicBarrier(3);
        Thread t = new Thread(() -> {
            Path master = this.provider.getPath(URI.create("git://master@byteman-lock-squash-repo"));
            RevCommit commit = this.commitThreeTimesAndGetReference((JGitFileSystem)fs, "byteman-lock-squash-repo", "master", "t1");
            Thread t1 = new Thread(() -> {
                logger.info("<<<<<<<<<<<<< " + commit.getName() + " --- " + commit.getFullMessage());
                JGitFileSystemImplProviderBytemanTest.printLog(fs.getGit());
                VersionRecord record = this.makeVersionRecord("aparedes", "aparedes@redhat.com", "squashing a!", new Date(), commit.getName());
                SquashOption squashOption = new SquashOption(record);
                logger.info("COMMITTER-1: Squashing");
                this.provider.setAttribute(master, "SQUASH_ATTR", (Object)squashOption, new LinkOption[0]);
                JGitFileSystemImplProviderBytemanTest.printLog(fs.getGit());
                JGitFileSystemImplProviderBytemanTest.waitFor(threadsFinishedBarrier);
            });
            Thread t2 = new Thread(() -> {
                logger.info("<<<<<<<<<<<<< " + commit.getName() + " --- " + commit.getFullMessage());
                JGitFileSystemImplProviderBytemanTest.printLog(fs.getGit());
                VersionRecord record = this.makeVersionRecord("aparedes", "aparedes@redhat.com", "squashing a!", new Date(), commit.getName());
                SquashOption squashOption = new SquashOption(record);
                logger.info("COMMITTER-2: Squashing");
                this.provider.setAttribute(master, "SQUASH_ATTR", (Object)squashOption, new LinkOption[0]);
                JGitFileSystemImplProviderBytemanTest.printLog(fs.getGit());
                JGitFileSystemImplProviderBytemanTest.waitFor(threadsFinishedBarrier);
            });
            t1.setName("LOCK-COMMITTER-1");
            t2.setName("LOCK-COMMITTER-2");
            t2.start();
            t1.start();
            JGitFileSystemImplProviderBytemanTest.waitFor(threadsFinishedBarrier);
        });
        try {
            t.start();
            t.join(10000L);
            t.interrupt();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((long)3L, (long)this.getCommitsFromBranch((GitImpl)fs.getGit(), "master").size());
    }

    @Test
    @BMScript(value="byteman/squash.btm")
    public void testConcurrentSquashWithThreeCommit() throws IOException, GitAPIException {
        URI newRepo = URI.create("git://three-squash-repo");
        JGitFileSystem fs = (JGitFileSystem)this.provider.newFileSystem(newRepo, EMPTY_ENV);
        CyclicBarrier threadsFinishedBarrier = new CyclicBarrier(3);
        Path master = this.provider.getPath(URI.create("git://three-squash-repo"));
        RevCommit commit = this.commitThreeTimesAndGetReference(fs, "three-squash-repo", "master", "t1");
        Thread t1 = new Thread(() -> {
            logger.info("<<<<<<<<<<<<< COMMIT TO SQUASH " + commit.getName() + " --- " + commit.getFullMessage());
            JGitFileSystemImplProviderBytemanTest.printLog(fs.getGit());
            VersionRecord record = this.makeVersionRecord("aparedes", "aparedes@redhat.com", "squashing a!", new Date(), commit.getName());
            SquashOption squashOption = new SquashOption(record);
            logger.info("COMMITTER-1: Squashing");
            this.provider.setAttribute(master, "SQUASH_ATTR", (Object)squashOption, new LinkOption[0]);
            JGitFileSystemImplProviderBytemanTest.printLog(fs.getGit());
            JGitFileSystemImplProviderBytemanTest.waitFor(threadsFinishedBarrier);
        });
        Thread t2 = new Thread(() -> {
            logger.info("<<<<<<<<<<<<< COMMIT TO SQUASH " + commit.getName() + " --- " + commit.getFullMessage());
            JGitFileSystemImplProviderBytemanTest.printLog(fs.getGit());
            VersionRecord record = this.makeVersionRecord("aparedes", "aparedes@redhat.com", "squashing b!", new Date(), commit.getName());
            SquashOption squashOption = new SquashOption(record);
            logger.info("COMMITTER-2: Squashing");
            this.provider.setAttribute(master, "SQUASH_ATTR", (Object)squashOption, new LinkOption[0]);
            JGitFileSystemImplProviderBytemanTest.printLog(fs.getGit());
            JGitFileSystemImplProviderBytemanTest.waitFor(threadsFinishedBarrier);
        });
        t1.setName("COMMITTER-1");
        t2.setName("COMMITTER-2");
        t2.start();
        t1.start();
        JGitFileSystemImplProviderBytemanTest.waitFor(threadsFinishedBarrier);
        Assert.assertEquals((long)2L, (long)this.getCommitsFromBranch((GitImpl)fs.getGit(), "master").size());
    }

    @Test
    @BMScript(value="byteman/squash.btm")
    public void testConcurrentSquashWithSixCommit() throws IOException, GitAPIException {
        URI newRepo = URI.create("git://byteman-six-squash-repo");
        JGitFileSystem fs = (JGitFileSystem)this.provider.newFileSystem(newRepo, EMPTY_ENV);
        CyclicBarrier threadsFinishedBarrier = new CyclicBarrier(3);
        Path master = this.provider.getPath(URI.create("git://master@byteman-six-squash-repo"));
        RevCommit commit = this.commitSixTimesAndGetReference(fs, "byteman-six-squash-repo", "master", "t1");
        Thread t1 = new Thread(() -> {
            logger.info("<<<<<<<<<<<<< COMMIT TO SQUASH " + commit.getName() + " --- " + commit.getFullMessage());
            JGitFileSystemImplProviderBytemanTest.printLog(fs.getGit());
            VersionRecord record = this.makeVersionRecord("aparedes", "aparedes@redhat.com", "squashing a!", new Date(), commit.getName());
            SquashOption squashOption = new SquashOption(record);
            logger.info("COMMITTER-1: Squashing");
            this.provider.setAttribute(master, "SQUASH_ATTR", (Object)squashOption, new LinkOption[0]);
            JGitFileSystemImplProviderBytemanTest.printLog(fs.getGit());
            JGitFileSystemImplProviderBytemanTest.waitFor(threadsFinishedBarrier);
        });
        Thread t2 = new Thread(() -> {
            logger.info("<<<<<<<<<<<<< COMMIT TO SQUASH " + commit.getName() + " --- " + commit.getFullMessage());
            JGitFileSystemImplProviderBytemanTest.printLog(fs.getGit());
            VersionRecord record = this.makeVersionRecord("aparedes", "aparedes@redhat.com", "squashing b!", new Date(), commit.getName());
            SquashOption squashOption = new SquashOption(record);
            logger.info("COMMITTER-2: Squashing");
            this.provider.setAttribute(master, "SQUASH_ATTR", (Object)squashOption, new LinkOption[0]);
            JGitFileSystemImplProviderBytemanTest.printLog(fs.getGit());
            JGitFileSystemImplProviderBytemanTest.waitFor(threadsFinishedBarrier);
        });
        t1.setName("COMMITTER-1");
        t2.setName("COMMITTER-2");
        t2.start();
        t1.start();
        JGitFileSystemImplProviderBytemanTest.waitFor(threadsFinishedBarrier);
        Assert.assertEquals((long)2L, (long)this.getCommitsFromBranch((GitImpl)fs.getGit(), "master").size());
    }

    @Test
    @BMScript(value="byteman/squash_exception.btm")
    public void testForceExceptionWhenTryingToSquash() throws IOException, GitAPIException {
        URI newRepo = URI.create("git://byteman-exception-squash-repo");
        JGitFileSystem fs = (JGitFileSystem)this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path master = this.provider.getPath(URI.create("git://master@byteman-exception-squash-repo"));
        RevCommit commit = this.commitThreeTimesAndGetReference(fs, "byteman-exception-squash-repo", "master", "t1");
        logger.info("<<<<<<<<<<<<< COMMIT TO SQUASH " + commit.getName() + " --- " + commit.getFullMessage());
        JGitFileSystemImplProviderBytemanTest.printLog(fs.getGit());
        VersionRecord record = this.makeVersionRecord("aparedes", "aparedes@redhat.com", "squashing a!", new Date(), commit.getName());
        SquashOption squashOption = new SquashOption(record);
        logger.info("COMMITTER-1: Squashing");
        try {
            this.provider.setAttribute(master, "SQUASH_ATTR", (Object)squashOption, new LinkOption[0]);
        }
        catch (Exception e) {
            fs.lock();
            fs.unlock();
        }
        Assert.assertEquals((long)3L, (long)this.getCommitsFromBranch((GitImpl)fs.getGit(), "master").size());
    }

    @Test
    @BMScript(value="byteman/commit_exception.btm")
    public void testFileSystemLockOnException() throws IOException, GitAPIException {
        URI newRepo = URI.create("git://byteman-exception-commit-repo");
        JGitFileSystemProxy fsProxy = (JGitFileSystemProxy)this.provider.newFileSystem(newRepo, EMPTY_ENV);
        JGitFileSystem fs = fsProxy.getRealJGitFileSystem();
        Path path = this.provider.getPath(URI.create("git://master@byteman-exception-commit-repo/myfile.txt"));
        try {
            this.writeFile(fs, path, "master");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Object lock = null;
        try {
            Field field = JGitFileSystemImpl.class.getDeclaredField("lock");
            field.setAccessible(true);
            lock = field.get(fs);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Object isLocked = null;
        try {
            Method method = lock.getClass().getMethod("hasBeenInUse", new Class[0]);
            isLocked = method.invoke(lock, new Object[0]);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertTrue((boolean)((Boolean)isLocked));
    }

    private VersionRecord makeVersionRecord(final String author, final String email, final String comment, final Date date, final String commit) {
        return new VersionRecord(){

            public String id() {
                return commit;
            }

            public String author() {
                return author;
            }

            public String email() {
                return email;
            }

            public String comment() {
                return comment;
            }

            public Date date() {
                return date;
            }

            public String uri() {
                return null;
            }
        };
    }

    private static void printLog(Git git) {
        try {
            for (RevCommit revCommit : ((GitImpl)git)._log().call()) {
                logger.info("[LOG]: " + revCommit.getName() + " --- " + revCommit.getFullMessage());
            }
        }
        catch (GitAPIException e) {
            e.printStackTrace();
        }
    }

    protected static void waitFor(CyclicBarrier barrier) {
        String threadName = Thread.currentThread().getName();
        try {
            logger.info(threadName + " request for await");
            barrier.await();
            logger.info(threadName + " await finished");
        }
        catch (InterruptedException e) {
            Assert.fail((String)("Thread '" + threadName + "' was interrupted while waiting for the other threads!"));
        }
        catch (BrokenBarrierException e) {
            Assert.fail((String)("Thread '" + threadName + "' barrier was broken while waiting for the other threads!"));
        }
    }

    private RevCommit commitThreeTimesAndGetReference(JGitFileSystem fs, String repo, String branch, String thread) {
        try {
            Path path = this.provider.getPath(URI.create("git://" + branch + "@" + repo + "/" + thread + "-myfile1.txt"));
            Path path2 = this.provider.getPath(URI.create("git://" + branch + "@" + repo + "/" + thread + "-myfile2.txt"));
            Path path3 = this.provider.getPath(URI.create("git://" + branch + "@" + repo + "/" + thread + "-myfile3.txt"));
            RevCommit commit = this.writeFile(fs, path, branch);
            this.writeFile(fs, path2, branch);
            this.writeFile(fs, path3, branch);
            return commit;
        }
        catch (IOException | GitAPIException e) {
            throw new RuntimeException(e);
        }
    }

    private RevCommit commitSixTimesAndGetReference(JGitFileSystem fs, String repo, String branch, String thread) {
        try {
            Path path = this.provider.getPath(URI.create("git://" + branch + "@" + repo + "/" + thread + "-myfile1.txt"));
            Path path2 = this.provider.getPath(URI.create("git://" + branch + "@" + repo + "/" + thread + "-myfile2.txt"));
            Path path3 = this.provider.getPath(URI.create("git://" + branch + "@" + repo + "/" + thread + "-myfile3.txt"));
            Path path4 = this.provider.getPath(URI.create("git://" + branch + "@" + repo + "/" + thread + "-myfile4.txt"));
            Path path5 = this.provider.getPath(URI.create("git://" + branch + "@" + repo + "/" + thread + "-myfile5.txt"));
            Path path6 = this.provider.getPath(URI.create("git://" + branch + "@" + repo + "/" + thread + "-myfile6.txt"));
            RevCommit commit = this.writeFile(fs, path, branch);
            this.writeFile(fs, path2, branch);
            this.writeFile(fs, path3, branch);
            this.writeFile(fs, path4, branch);
            this.writeFile(fs, path5, branch);
            this.writeFile(fs, path6, branch);
            return commit;
        }
        catch (IOException | GitAPIException e) {
            throw new RuntimeException(e);
        }
    }

    private RevCommit writeFile(JGitFileSystem fs, Path path, String branch) throws IOException, GitAPIException {
        OutputStream stream = this.provider.newOutputStream(path, new OpenOption[0]);
        logger.info("Writing file: " + path.getFileName().toString());
        stream.write("my cool content".getBytes());
        stream.close();
        return this.getCommitsFromBranch((GitImpl)fs.getGit(), branch).get(0);
    }

    private List<RevCommit> getCommitsFromBranch(GitImpl origin, String branch) throws GitAPIException, MissingObjectException, IncorrectObjectTypeException {
        ArrayList<RevCommit> commits = new ArrayList<RevCommit>();
        ObjectId id = new GetRef(origin.getRepository(), branch).execute().getObjectId();
        for (RevCommit commit : origin._log().add((AnyObjectId)id).call()) {
            commits.add(commit);
        }
        return commits;
    }
}

