/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.daemon.http;

import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletRegistration;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProvider;
import org.uberfire.java.nio.fs.jgit.daemon.http.HTTPSupport;

public class HTTPSOnlySupportTest
extends AbstractTestInfra {
    @Override
    public Map<String, String> getGitPreferences() {
        Map<String, String> gitPrefs = super.getGitPreferences();
        gitPrefs.put("org.uberfire.nio.git.http.enabled", "false");
        gitPrefs.put("org.uberfire.nio.git.https.enabled", "true");
        return gitPrefs;
    }

    @Test
    public void testRoot() {
        this.base("/");
        Assertions.assertThat((String)((String)this.provider.getFullHostNames().get("http"))).isNull();
        Assertions.assertThat((String)((String)this.provider.getFullHostNames().get("https"))).isNotNull();
    }

    public void base(String contextPath) {
        HTTPSupport httpSupport = new HTTPSupport(){

            protected JGitFileSystemProvider resolveProvider() {
                return HTTPSOnlySupportTest.this.provider;
            }
        };
        ServletContextEvent sce = (ServletContextEvent)Mockito.mock(ServletContextEvent.class);
        ServletContext sc = (ServletContext)Mockito.mock(ServletContext.class);
        ServletRegistration.Dynamic dyn = (ServletRegistration.Dynamic)Mockito.mock(ServletRegistration.Dynamic.class);
        ArgumentCaptor servletArgumentCaptor = ArgumentCaptor.forClass(Servlet.class);
        Mockito.when((Object)sc.addServlet(Matchers.anyString(), (Servlet)servletArgumentCaptor.capture())).thenReturn((Object)dyn);
        Mockito.when((Object)sce.getServletContext()).thenReturn((Object)sc);
        Mockito.when((Object)sc.getContextPath()).thenReturn((Object)contextPath);
        httpSupport.contextInitialized(sce);
        ((ServletContext)Mockito.verify((Object)sc, (VerificationMode)Mockito.times((int)1))).addServlet(Matchers.anyString(), (Servlet)Matchers.any(Servlet.class));
        ((ServletRegistration.Dynamic)Mockito.verify((Object)dyn, (VerificationMode)Mockito.times((int)1))).addMapping(new String[]{"/git/*"});
        ((ServletRegistration.Dynamic)Mockito.verify((Object)dyn, (VerificationMode)Mockito.times((int)1))).setLoadOnStartup(1);
        ((ServletRegistration.Dynamic)Mockito.verify((Object)dyn, (VerificationMode)Mockito.times((int)1))).setAsyncSupported(false);
    }
}

