/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import java.util.Scanner;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ListAssert;
import org.junit.Test;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.base.options.CherryPickCopyOption;
import org.uberfire.java.nio.base.version.VersionAttributes;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.DirectoryNotEmptyException;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;

public class JGitFileSystemImplProviderCpMvTest
extends AbstractTestInfra {
    @Test
    public void testCopyBranches() throws java.io.IOException {
        URI newRepo = URI.create("git://copybranch-test-repo");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("git://master@copybranch-test-repo/myfile1.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        outStream.write("my cool content".getBytes());
        outStream.close();
        Path path2 = this.provider.getPath(URI.create("git://user_branch@copybranch-test-repo/other/path/myfile2.txt"));
        OutputStream outStream2 = this.provider.newOutputStream(path2, new OpenOption[0]);
        outStream2.write("my cool content".getBytes());
        outStream2.close();
        Path path3 = this.provider.getPath(URI.create("git://user_branch@copybranch-test-repo/myfile3.txt"));
        OutputStream outStream3 = this.provider.newOutputStream(path3, new OpenOption[0]);
        outStream3.write("my cool content".getBytes());
        outStream3.close();
        Path source = this.provider.getPath(URI.create("git://user_branch@copybranch-test-repo"));
        Path target = this.provider.getPath(URI.create("git://other_branch@copybranch-test-repo"));
        this.provider.copy(source, target, new CopyOption[0]);
        DirectoryStream stream = this.provider.newDirectoryStream(this.provider.getPath(URI.create("git://other_branch@copybranch-test-repo/")), null);
        ((IterableAssert)Assertions.assertThat((Iterable)stream).isNotNull()).hasSize(2);
        Assertions.assertThatThrownBy(() -> this.provider.copy(source, target, new CopyOption[0])).isInstanceOf(FileAlreadyExistsException.class);
        Path notExists = this.provider.getPath(URI.create("git://xxx_user_branch@copybranch-test-repo"));
        Path notExists2 = this.provider.getPath(URI.create("git://xxx_other_branch@copybranch-test-repo"));
        Assertions.assertThatThrownBy(() -> this.provider.copy(notExists, notExists2, new CopyOption[0])).isInstanceOf(NoSuchFileException.class);
    }

    @Test
    public void testCopyFiles() throws java.io.IOException {
        URI newRepo = URI.create("git://copyasset-test-repo");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("git://master@copyasset-test-repo/myfile1.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        outStream.write("my cool content".getBytes());
        outStream.close();
        Path path2 = this.provider.getPath(URI.create("git://user_branch@copyasset-test-repo/other/path/myfile2.txt"));
        OutputStream outStream2 = this.provider.newOutputStream(path2, new OpenOption[0]);
        outStream2.write("my cool content".getBytes());
        outStream2.close();
        Path path3 = this.provider.getPath(URI.create("git://user_branch@copyasset-test-repo/myfile3.txt"));
        OutputStream outStream3 = this.provider.newOutputStream(path3, new OpenOption[0]);
        outStream3.write("my cool content".getBytes());
        outStream3.close();
        Path target = this.provider.getPath(URI.create("git://user_branch@copyasset-test-repo/myfile1.txt"));
        this.provider.copy(path, target, new CopyOption[0]);
        DirectoryStream stream = this.provider.newDirectoryStream(this.provider.getPath(URI.create("git://user_branch@copyasset-test-repo/")), null);
        for (Path path1 : stream) {
            System.out.println("content: " + path1.toUri());
        }
        ((IterableAssert)Assertions.assertThat((Iterable)stream).isNotNull()).hasSize(3);
    }

    @Test
    public void testCopyDir() throws java.io.IOException {
        URI newRepo = URI.create("git://copydir-test-repo");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("git://master@copydir-test-repo/myfile1.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        outStream.write("my cool content".getBytes());
        outStream.close();
        Path path2 = this.provider.getPath(URI.create("git://user_branch@copydir-test-repo/path/myfile2.txt"));
        OutputStream outStream2 = this.provider.newOutputStream(path2, new OpenOption[0]);
        outStream2.write("my cool content".getBytes());
        outStream2.close();
        Path path3 = this.provider.getPath(URI.create("git://user_branch@copydir-test-repo/path/myfile3.txt"));
        OutputStream outStream3 = this.provider.newOutputStream(path3, new OpenOption[0]);
        outStream3.write("my cool content".getBytes());
        outStream3.close();
        Path source = this.provider.getPath(URI.create("git://user_branch@copydir-test-repo/path"));
        Path target = this.provider.getPath(URI.create("git://master@copydir-test-repo/"));
        this.provider.copy(source, target, new CopyOption[0]);
        DirectoryStream stream = this.provider.newDirectoryStream(target, null);
        Assertions.assertThat((Iterable)stream).hasSize(3);
        source = this.provider.getPath(URI.create("git://user_branch@copydir-test-repo/path"));
        target = this.provider.getPath(URI.create("git://master@copydir-test-repo/some/place/here/"));
        this.provider.copy(source, target, new CopyOption[0]);
        stream = this.provider.newDirectoryStream(target, null);
        Assertions.assertThat((Iterable)stream).hasSize(2);
        source = this.provider.getPath(URI.create("git://user_branch@copydir-test-repo/path"));
        target = this.provider.getPath(URI.create("git://master@copydir-test-repo/soXme/place/here"));
        this.provider.copy(source, target, new CopyOption[0]);
        stream = this.provider.newDirectoryStream(target, null);
        Assertions.assertThat((Iterable)stream).hasSize(2);
        source = this.provider.getPath(URI.create("git://user_branch@copydir-test-repo/"));
        target = this.provider.getPath(URI.create("git://master@copydir-test-repo/other_here/"));
        this.provider.copy(source, target, new CopyOption[0]);
        stream = this.provider.newDirectoryStream(target, null);
        Assertions.assertThat((Iterable)stream).hasSize(1);
        source = this.provider.getPath(URI.create("git://user_branch@copydir-test-repo/not_exists"));
        target = this.provider.getPath(URI.create("git://master@copydir-test-repo/xxxxxxxxother_here/"));
        Assertions.assertThatThrownBy(() -> this.provider.copy(source, target, new CopyOption[0])).isInstanceOf(NoSuchFileException.class);
        source = this.provider.getPath(URI.create("git://user_branch@copydir-test-repo/"));
        target = this.provider.getPath(URI.create("git://master@copydir-test-repo/other_here/"));
        Assertions.assertThatThrownBy(() -> this.provider.copy(source, target, new CopyOption[0])).isInstanceOf(FileAlreadyExistsException.class);
    }

    @Test
    public void testCopyFilesAcrossRepositories() throws java.io.IOException {
        URI newRepo1 = URI.create("git://copyasset-test-repo1");
        this.provider.newFileSystem(newRepo1, EMPTY_ENV);
        URI newRepo2 = URI.create("git://copyasset-test-repo2");
        this.provider.newFileSystem(newRepo2, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("git://master@copyasset-test-repo1/myfile1.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        outStream.write("my cool content".getBytes());
        outStream.close();
        Path target = this.provider.getPath(URI.create("git://master@copyasset-test-repo2/myfile1.txt"));
        this.provider.copy(path, target, new CopyOption[0]);
        DirectoryStream stream = this.provider.newDirectoryStream(this.provider.getPath(URI.create("git://master@copyasset-test-repo2/")), null);
        for (Path path1 : stream) {
            System.out.println("content: " + path1.toUri());
        }
        ((IterableAssert)Assertions.assertThat((Iterable)stream).isNotNull()).hasSize(1);
    }

    @Test
    public void testCopyDirAcrossRepositories() throws java.io.IOException {
        URI newRepo1 = URI.create("git://copydir-test-repo1");
        this.provider.newFileSystem(newRepo1, EMPTY_ENV);
        URI newRepo2 = URI.create("git://copydir-test-repo2");
        this.provider.newFileSystem(newRepo2, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("git://master@copydir-test-repo1/myfile1.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        outStream.write("my cool content".getBytes());
        outStream.close();
        Path path2 = this.provider.getPath(URI.create("git://master@copydir-test-repo2/path/myfile2.txt"));
        OutputStream outStream2 = this.provider.newOutputStream(path2, new OpenOption[0]);
        outStream2.write("my cool content".getBytes());
        outStream2.close();
        Path path3 = this.provider.getPath(URI.create("git://master@copydir-test-repo2/path/myfile3.txt"));
        OutputStream outStream3 = this.provider.newOutputStream(path3, new OpenOption[0]);
        outStream3.write("my cool content".getBytes());
        outStream3.close();
        Path source = this.provider.getPath(URI.create("git://master@copydir-test-repo2/path"));
        Path target = this.provider.getPath(URI.create("git://master@copydir-test-repo1/"));
        this.provider.copy(source, target, new CopyOption[0]);
        DirectoryStream stream = this.provider.newDirectoryStream(target, null);
        ((IterableAssert)Assertions.assertThat((Iterable)stream).isNotNull()).hasSize(3);
        source = this.provider.getPath(URI.create("git://master@copydir-test-repo2/path"));
        target = this.provider.getPath(URI.create("git://master@copydir-test-repo1/some/place/here/"));
        this.provider.copy(source, target, new CopyOption[0]);
        stream = this.provider.newDirectoryStream(target, null);
        ((IterableAssert)Assertions.assertThat((Iterable)stream).isNotNull()).hasSize(2);
        source = this.provider.getPath(URI.create("git://master@copydir-test-repo2/path"));
        target = this.provider.getPath(URI.create("git://master@copydir-test-repo1/soXme/place/here"));
        this.provider.copy(source, target, new CopyOption[0]);
        stream = this.provider.newDirectoryStream(target, null);
        ((IterableAssert)Assertions.assertThat((Iterable)stream).isNotNull()).hasSize(2);
        source = this.provider.getPath(URI.create("git://master@copydir-test-repo1/not_exists"));
        target = this.provider.getPath(URI.create("git://master@copydir-test-repo2/xxxxxxxxother_here/"));
        Assertions.assertThatThrownBy(() -> this.provider.copy(source, target, new CopyOption[0])).isInstanceOf(NoSuchFileException.class);
        source = this.provider.getPath(URI.create("git://master@copydir-test-repo2/path"));
        target = this.provider.getPath(URI.create("git://master@copydir-test-repo1/some/place/here/"));
        Assertions.assertThatThrownBy(() -> this.provider.copy(source, target, new CopyOption[0])).isInstanceOf(FileAlreadyExistsException.class);
    }

    @Test
    public void testMoveBranches() throws java.io.IOException {
        URI newRepo = URI.create("git://movebranch-test-repo");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("git://master@movebranch-test-repo/myfile1.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        outStream.write("my cool content".getBytes());
        outStream.close();
        Path path2 = this.provider.getPath(URI.create("git://user_branch@movebranch-test-repo/other/path/myfile2.txt"));
        OutputStream outStream2 = this.provider.newOutputStream(path2, new OpenOption[0]);
        outStream2.write("my cool content".getBytes());
        outStream2.close();
        Path path3 = this.provider.getPath(URI.create("git://user_branch@movebranch-test-repo/myfile3.txt"));
        OutputStream outStream3 = this.provider.newOutputStream(path3, new OpenOption[0]);
        outStream3.write("my cool content".getBytes());
        outStream3.close();
        Path source = this.provider.getPath(URI.create("git://user_branch@movebranch-test-repo/"));
        Path target = this.provider.getPath(URI.create("git://master@movebranch-test-repo/"));
        Assertions.assertThatThrownBy(() -> this.provider.move(source, target, new CopyOption[0])).isInstanceOf(FileAlreadyExistsException.class);
        Path source2 = this.provider.getPath(URI.create("git://user_branch@movebranch-test-repo/"));
        Path target2 = this.provider.getPath(URI.create("git://xxxxddddkh@movebranch-test-repo/"));
        try {
            this.provider.move(source2, target2, new CopyOption[0]);
        }
        catch (Exception e) {
            Assertions.fail((String)"should not throw");
        }
    }

    @Test
    public void testMoveFiles() throws java.io.IOException {
        URI newRepo = URI.create("git://moveasset-test-repo");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("git://master@moveasset-test-repo/myfile1.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        outStream.write("my cool content".getBytes());
        outStream.close();
        Path path2 = this.provider.getPath(URI.create("git://user_branch@moveasset-test-repo/other/path/myfile2.txt"));
        OutputStream outStream2 = this.provider.newOutputStream(path2, new OpenOption[0]);
        outStream2.write("my cool content".getBytes());
        outStream2.close();
        Path path3 = this.provider.getPath(URI.create("git://user_branch@moveasset-test-repo/myfile3.txt"));
        OutputStream outStream3 = this.provider.newOutputStream(path3, new OpenOption[0]);
        outStream3.write("my cool content".getBytes());
        outStream3.close();
        Path target = this.provider.getPath(URI.create("git://user_branch@moveasset-test-repo/myfile1.txt"));
        try {
            this.provider.move(path, target, new CopyOption[0]);
        }
        catch (Exception e) {
            Assertions.fail((String)"should move file", (Throwable)e);
        }
    }

    @Test
    public void testMoveDir() throws java.io.IOException {
        URI newRepo = URI.create("git://movedir-test-repo");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("git://master@movedir-test-repo/myfile1.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        outStream.write("my cool content".getBytes());
        outStream.close();
        Path path2 = this.provider.getPath(URI.create("git://user_branch@movedir-test-repo/path/myfile2.txt"));
        OutputStream outStream2 = this.provider.newOutputStream(path2, new OpenOption[0]);
        outStream2.write("my cool content".getBytes());
        outStream2.close();
        Path path3 = this.provider.getPath(URI.create("git://user_branch@movedir-test-repo/path/myfile3.txt"));
        OutputStream outStream3 = this.provider.newOutputStream(path3, new OpenOption[0]);
        outStream3.write("my cool content".getBytes());
        outStream3.close();
        Path source = this.provider.getPath(URI.create("git://user_branch@movedir-test-repo/path"));
        Path target = this.provider.getPath(URI.create("git://master@movedir-test-repo/"));
        try {
            this.provider.move(source, target, new CopyOption[0]);
        }
        catch (IOException e) {
            Assertions.assertThat((Throwable)e).isInstanceOf(DirectoryNotEmptyException.class);
        }
    }

    @Test
    public void testCherryPick() throws java.io.IOException {
        URI newRepo = URI.create("git://cherrypick-test-repo");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("git://master@cherrypick-test-repo/myfile1.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        outStream.write("my cool content".getBytes());
        outStream.close();
        Path path2 = this.provider.getPath(URI.create("git://user_branch@cherrypick-test-repo/other/path/myfile2.txt"));
        OutputStream outStream2 = this.provider.newOutputStream(path2, new OpenOption[0]);
        outStream2.write("my cool content".getBytes());
        outStream2.close();
        Path path3 = this.provider.getPath(URI.create("git://user_branch@cherrypick-test-repo/myfile3.txt"));
        OutputStream outStream3 = this.provider.newOutputStream(path3, new OpenOption[0]);
        outStream3.write("my cool content".getBytes());
        outStream3.close();
        String cherryPickContent = "my 2nd cool content";
        Path path4 = this.provider.getPath(URI.create("git://master@cherrypick-test-repo/myfile1.txt"));
        OutputStream outStream4 = this.provider.newOutputStream(path4, new OpenOption[0]);
        outStream4.write(cherryPickContent.getBytes());
        outStream4.close();
        VersionAttributes versionAttributes = (VersionAttributes)this.provider.readAttributes(path4, VersionAttributes.class, new LinkOption[0]);
        ((ListAssert)Assertions.assertThat((List)versionAttributes.history().records()).isNotNull()).hasSize(2);
        String commit2CherryPick = ((VersionRecord)versionAttributes.history().records().get(versionAttributes.history().records().size() - 1)).id();
        OutputStream outStream22 = this.provider.newOutputStream(path4, new OpenOption[0]);
        outStream22.write("my 3rd cool content".getBytes());
        outStream22.close();
        Path source = this.provider.getPath(URI.create("git://user_branch@cherrypick-test-repo"));
        Path target = this.provider.getPath(URI.create("git://other_branch@cherrypick-test-repo"));
        this.provider.copy(source, target, new CopyOption[0]);
        String cherryPickContent2 = "my 4tn cool content";
        Path path5 = this.provider.getPath(URI.create("git://master@cherrypick-test-repo/myfile1.txt"));
        OutputStream outStream5 = this.provider.newOutputStream(path5, new OpenOption[0]);
        outStream5.write(cherryPickContent2.getBytes());
        outStream5.close();
        VersionAttributes versionAttributes2 = (VersionAttributes)this.provider.readAttributes(path5, VersionAttributes.class, new LinkOption[0]);
        String commit2CherryPick2 = ((VersionRecord)versionAttributes2.history().records().get(versionAttributes2.history().records().size() - 1)).id();
        Path target2 = this.provider.getPath(URI.create("git://other_branch2@cherrypick-test-repo"));
        this.provider.copy(source, target2, new CopyOption[0]);
        this.provider.copy(source, target, new CopyOption[]{new CherryPickCopyOption(new String[]{commit2CherryPick})});
        String result = JGitFileSystemImplProviderCpMvTest.convertStreamToString(this.provider.newInputStream(this.provider.getPath(URI.create("git://other_branch@cherrypick-test-repo/myfile1.txt")), new OpenOption[0]));
        Assertions.assertThat((String)result).isEqualTo(cherryPickContent);
        this.provider.copy(source, target2, new CopyOption[]{new CherryPickCopyOption(new String[]{commit2CherryPick, commit2CherryPick2})});
        result = JGitFileSystemImplProviderCpMvTest.convertStreamToString(this.provider.newInputStream(this.provider.getPath(URI.create("git://other_branch2@cherrypick-test-repo/myfile1.txt")), new OpenOption[0]));
        Assertions.assertThat((String)result).isEqualTo(cherryPickContent2);
    }

    private static String convertStreamToString(InputStream is) {
        Scanner s = new Scanner(is).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }
}

