/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.net.Authenticator;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProvider;

public class JGitFileSystemImplProviderHttpProxyTest {
    @Test
    public void testHttpProxy() throws MalformedURLException, UnknownHostException {
        String userName = "user";
        String passw = "passwd";
        JGitFileSystemProvider provider = new JGitFileSystemProvider((Map)new HashMap<String, String>(){
            {
                this.put("http.proxyUser", "user");
                this.put("http.proxyPassword", "passwd");
                this.put("org.uberfire.nio.git.daemon.enabled", "false");
                this.put("org.uberfire.nio.git.ssh.enabled", "false");
            }
        });
        PasswordAuthentication passwdAuth = Authenticator.requestPasswordAuthentication("localhost", InetAddress.getLocalHost(), 8080, "http", "xxx", "http", new URL("http://localhost"), Authenticator.RequestorType.PROXY);
        Assert.assertEquals((Object)"user", (Object)passwdAuth.getUserName());
        Assert.assertEquals((Object)"passwd", (Object)new String(passwdAuth.getPassword()));
        provider.dispose();
    }

    @Test
    public void testHttpsProxy() throws MalformedURLException, UnknownHostException {
        String userName = "user";
        String passw = "passwd";
        JGitFileSystemProvider provider = new JGitFileSystemProvider((Map)new HashMap<String, String>(){
            {
                this.put("https.proxyUser", "user");
                this.put("https.proxyPassword", "passwd");
                this.put("org.uberfire.nio.git.daemon.enabled", "false");
                this.put("org.uberfire.nio.git.ssh.enabled", "false");
            }
        });
        PasswordAuthentication passwdAuth = Authenticator.requestPasswordAuthentication("localhost", InetAddress.getLocalHost(), 8080, "https", "xxx", "https", new URL("https://localhost"), Authenticator.RequestorType.PROXY);
        Assert.assertEquals((Object)"user", (Object)passwdAuth.getUserName());
        Assert.assertEquals((Object)"passwd", (Object)new String(passwdAuth.getPassword()));
        provider.dispose();
    }

    @Test
    public void testNoProxyInfo() throws MalformedURLException, UnknownHostException {
        JGitFileSystemProvider provider = new JGitFileSystemProvider((Map)new HashMap<String, String>(){
            {
                this.put("org.uberfire.nio.git.daemon.enabled", "false");
                this.put("org.uberfire.nio.git.ssh.enabled", "false");
            }
        });
        PasswordAuthentication passwdAuth = Authenticator.requestPasswordAuthentication("localhost", InetAddress.getLocalHost(), 8080, "https", "xxx", "https", new URL("https://localhost"), Authenticator.RequestorType.PROXY);
        Assert.assertNull((Object)passwdAuth);
        passwdAuth = Authenticator.requestPasswordAuthentication("localhost", InetAddress.getLocalHost(), 8080, "http", "xxx", "http", new URL("http://localhost"), Authenticator.RequestorType.PROXY);
        Assert.assertNull((Object)passwdAuth);
        provider.dispose();
    }
}

