/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProxy;

public class JGitFileSystemProviderConcurrentOperationsTest
extends AbstractTestInfra {
    private Logger logger = LoggerFactory.getLogger(JGitFileSystemProviderConcurrentOperationsTest.class);

    @Ignore
    @Test
    public void testConcurrentGitCreation() {
        int threadCount = 2;
        CountDownLatch finished = new CountDownLatch(threadCount);
        ArrayList<Thread> threads = new ArrayList<Thread>();
        int i = 0;
        while (i < threadCount) {
            int name = i++;
            Runnable r = () -> {
                this.provider.createNewGitRepo(EMPTY_ENV, "git://parent/concurrent-test" + name);
                finished.countDown();
                this.logger.info("Countdown" + Thread.currentThread().getName());
            };
            Thread t = new Thread(r);
            threads.add(t);
            t.start();
        }
        this.wait(threads);
        Assert.assertEquals((long)0L, (long)finished.getCount());
    }

    @Test
    public void testConcurrentGitDeletion() {
        String gitRepo = "git://parent/delete-test-repo";
        URI newRepo = URI.create(gitRepo);
        JGitFileSystemProxy fs = (JGitFileSystemProxy)this.provider.newFileSystem(newRepo, EMPTY_ENV);
        int threadCount = 2;
        CountDownLatch finished = new CountDownLatch(threadCount);
        ArrayList<Thread> threads = new ArrayList<Thread>();
        int i = 0;
        while (i < threadCount) {
            int name = i++;
            Runnable r = () -> {
                this.provider.deleteFS((FileSystem)fs.getRealJGitFileSystem());
                finished.countDown();
                this.logger.info("Countdown" + Thread.currentThread().getName());
            };
            Thread t = new Thread(r);
            threads.add(t);
            t.start();
        }
        this.wait(threads);
        Assert.assertEquals((long)0L, (long)finished.getCount());
    }

    private void wait(List<Thread> threads) {
        threads.forEach(thread -> {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                this.logger.error("Error waiting for threads", (Throwable)e);
            }
        });
    }
}

