/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jgit.lib.Ref;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.commons.data.Pair;
import org.uberfire.java.nio.fs.jgit.util.GitImpl;
import org.uberfire.java.nio.fs.jgit.util.commands.SyncRemote;

public class SyncRemoteTest {
    private SyncRemote syncRemote;

    @Before
    public void setup() {
        this.syncRemote = new SyncRemote((GitImpl)Mockito.mock(GitImpl.class), new Pair((Object)"upstream", (Object)"b"));
    }

    @Test
    public void fillBranchesTest() {
        List<Ref> branches = Arrays.asList(this.createBranch("refs/heads/local/branch1"), this.createBranch("refs/heads/localBranch2"), this.createBranch("refs/remotes/upstream/remote/branch1"), this.createBranch("refs/remotes/upstream/remoteBranch2"));
        ArrayList remoteBranches = new ArrayList();
        ArrayList localBranches = new ArrayList();
        this.syncRemote.fillBranches(branches, remoteBranches, localBranches);
        Assert.assertEquals((long)2L, (long)remoteBranches.size());
        Assert.assertEquals((Object)"remote/branch1", remoteBranches.get(0));
        Assert.assertEquals((Object)"remoteBranch2", remoteBranches.get(1));
        Assert.assertEquals((long)2L, (long)localBranches.size());
        Assert.assertEquals((Object)"local/branch1", localBranches.get(0));
        Assert.assertEquals((Object)"localBranch2", localBranches.get(1));
    }

    private Ref createBranch(String branchName) {
        Ref branch = (Ref)Mockito.mock(Ref.class);
        ((Ref)Mockito.doReturn((Object)branchName).when((Object)branch)).getName();
        return branch;
    }
}

