/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.daemon.filters;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.lib.Ref;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.java.nio.fs.jgit.daemon.filters.HiddenBranchRefFilter;

@RunWith(value=MockitoJUnitRunner.class)
public class HiddenBranchRefFilterTest {
    private HiddenBranchRefFilter filter;
    @Mock
    private Ref ref;
    private Map<String, Ref> refs;

    @Before
    public void setUp() {
        this.refs = new HashMap<String, Ref>();
        this.refs.put("master", this.ref);
        this.refs.put("develop", this.ref);
        this.refs.put("PR--from/develop-master", this.ref);
        this.refs.put("PR-1--master", this.ref);
        this.refs.put("PR-master", this.ref);
        this.refs.put("PR-1-from/develop-master", this.ref);
        this.filter = new HiddenBranchRefFilter();
    }

    @Test
    public void testHiddenBranchsFiltering() {
        Map filteredRefs = this.filter.filter(this.refs);
        Set set = filteredRefs.entrySet();
        Assert.assertEquals((long)5L, (long)set.size());
        Assert.assertFalse((boolean)set.stream().anyMatch(entry -> ((String)entry.getKey()).equals("PR-1-from/develop-master")));
    }
}

