/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.junit.Assert;
import org.junit.Test;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.commands.Clone;
import org.uberfire.java.nio.fs.jgit.util.commands.Commit;
import org.uberfire.java.nio.fs.jgit.util.commands.CreateRepository;
import org.uberfire.java.nio.fs.jgit.util.commands.ListRefs;

public class JGitCloneTest
extends AbstractTestInfra {
    private static final String TARGET_GIT = "target/target";
    private static final String SOURCE_GIT = "source/source";

    @Test
    public void testToCloneSuccess() throws IOException, GitAPIException {
        File parentFolder = JGitCloneTest.createTempDirectory();
        File gitSource = new File(parentFolder, "source/source.git");
        File gitTarget = new File(parentFolder, "target/target.git");
        Git origin = this.setupGitRepo(gitSource, null);
        Git cloned = (Git)new Clone(gitTarget, gitSource.getAbsolutePath(), false, null, CredentialsProvider.getDefault(), null, null, true).execute().get();
        Assertions.assertThat((Object)cloned).isNotNull();
        Assertions.assertThat((List)new ListRefs(cloned.getRepository()).execute()).hasSize(2);
        Assert.assertEquals((long)new ListRefs(cloned.getRepository()).execute().size(), (long)new ListRefs(origin.getRepository()).execute().size());
        Assertions.assertThat((String)((Ref)new ListRefs(cloned.getRepository()).execute().get(0)).getName()).isEqualTo("refs/heads/main");
        Assertions.assertThat((String)((Ref)new ListRefs(cloned.getRepository()).execute().get(1)).getName()).isEqualTo("refs/heads/user_branch");
    }

    @Test
    public void cloneShouldOnlyWorksWithEmptyRepos() throws IOException {
        File parentFolder = JGitCloneTest.createTempDirectory();
        File gitSource = new File(parentFolder, "source/source.git");
        File gitTarget = new File(parentFolder, "target/target.git");
        Git origin = this.setupGitRepo(gitSource, null);
        Git cloned = (Git)new Clone(gitTarget, gitSource.getAbsolutePath(), false, null, CredentialsProvider.getDefault(), null, null, true).execute().get();
        Assertions.assertThat((Object)cloned).isNotNull();
        Assertions.assertThat((List)new ListRefs(cloned.getRepository()).execute()).hasSize(2);
        Assert.assertEquals((long)new ListRefs(cloned.getRepository()).execute().size(), (long)new ListRefs(origin.getRepository()).execute().size());
        Assertions.assertThatThrownBy(() -> {
            Git cfr_ignored_0 = (Git)new Clone(gitTarget, gitSource.getAbsolutePath(), false, null, CredentialsProvider.getDefault(), null, null, true).execute().get();
        }).isInstanceOf(Clone.CloneException.class);
    }

    @Test
    public void testCloneWithHookDir() throws IOException, GitAPIException {
        File hooksDir = JGitCloneTest.createTempDirectory();
        this.writeMockHook(hooksDir, "post-commit");
        this.writeMockHook(hooksDir, "pre-commit");
        File parentFolder = JGitCloneTest.createTempDirectory();
        File gitSource = new File(parentFolder, "source/source.git");
        File gitTarget = new File(parentFolder, "target/target.git");
        Git origin = this.setupGitRepo(gitSource, hooksDir);
        Git cloned = (Git)new Clone(gitTarget, gitSource.getAbsolutePath(), false, null, CredentialsProvider.getDefault(), null, hooksDir, true).execute().get();
        Assertions.assertThat((Object)cloned).isNotNull();
        Assertions.assertThat((List)new ListRefs(cloned.getRepository()).execute()).hasSize(2);
        Assert.assertEquals((long)new ListRefs(cloned.getRepository()).execute().size(), (long)new ListRefs(origin.getRepository()).execute().size());
        Assertions.assertThat((String)((Ref)new ListRefs(cloned.getRepository()).execute().get(0)).getName()).isEqualTo("refs/heads/main");
        Assertions.assertThat((String)((Ref)new ListRefs(cloned.getRepository()).execute().get(1)).getName()).isEqualTo("refs/heads/user_branch");
        boolean foundPreCommitHook = false;
        boolean foundPostCommitHook = false;
        Object[] hooks = new File(cloned.getRepository().getDirectory(), "hooks").listFiles();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])hooks).isNotEmpty()).isNotNull();
        Assertions.assertThat((int)hooks.length).isEqualTo(2);
        for (Object hook : hooks) {
            if (((File)hook).getName().equals("pre-commit")) {
                foundPreCommitHook = ((File)hook).canExecute();
                continue;
            }
            if (!((File)hook).getName().equals("post-commit")) continue;
            foundPostCommitHook = ((File)hook).canExecute();
        }
        Assertions.assertThat((boolean)foundPreCommitHook).isTrue();
        Assertions.assertThat((boolean)foundPostCommitHook).isTrue();
    }

    private Git setupGitRepo(File gitSource, File hooksDir) throws IOException {
        Git origin = (Git)new CreateRepository(gitSource, hooksDir, true).execute().get();
        new Commit(origin, "user_branch", "name", "name@example.com", "commit!", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file2.txt", AbstractTestInfra.tempFile("temp2222"));
            }
        }).execute();
        new Commit(origin, "main", "name", "name@example.com", "commit", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file.txt", AbstractTestInfra.tempFile("temp"));
            }
        }).execute();
        return origin;
    }

    @Test
    public void cloneNotMirrorRepoConfigTest() throws IOException {
        File parentFolder = JGitCloneTest.createTempDirectory();
        File gitSource = new File(parentFolder, "source/source.git");
        File gitTarget = new File(parentFolder, "target/target.git");
        Git origin = this.setupGitRepo(gitSource, null);
        boolean isMirror = false;
        boolean sslVerify = true;
        Git clonedNotMirror = (Git)new Clone(gitTarget, gitSource.getAbsolutePath(), isMirror, null, CredentialsProvider.getDefault(), null, null, sslVerify).execute().get();
        Assertions.assertThat((Object)clonedNotMirror).isNotNull();
        StoredConfig config = clonedNotMirror.getRepository().getConfig();
        Assert.assertNotEquals((Object)"+refs/heads/*:refs/remotes/origin/*", (Object)config.getString("remote", "origin", "fetch"));
        Assert.assertNull((Object)config.getString("remote", "origin", "mirror"));
        Assert.assertEquals((Object)gitSource.getAbsolutePath(), (Object)config.getString("remote", "origin", "url"));
        boolean missingDefaultValue = true;
        Assert.assertEquals((Object)missingDefaultValue, (Object)config.getBoolean("http", null, "sslVerify", missingDefaultValue));
    }

    @Test
    public void cloneMirrorRepoNoSSLVerifyConfigTest() throws IOException {
        File parentFolder = JGitCloneTest.createTempDirectory();
        File gitSource = new File(parentFolder, "source/source.git");
        File gitTarget = new File(parentFolder, "target/target.git");
        Git origin = this.setupGitRepo(gitSource, null);
        Assert.assertTrue((boolean)this.provider.config.isSslVerify());
        boolean isMirror = true;
        boolean sslVerify = false;
        Git clonedMirror = (Git)new Clone(gitTarget, gitSource.getAbsolutePath(), isMirror, null, CredentialsProvider.getDefault(), null, null, sslVerify).execute().get();
        Assertions.assertThat((Object)clonedMirror).isNotNull();
        StoredConfig config = clonedMirror.getRepository().getConfig();
        Assert.assertEquals((Object)"+refs/heads/*:refs/remotes/origin/*", (Object)config.getString("remote", "origin", "fetch"));
        Assert.assertNull((Object)config.getString("remote", "origin", "mirror"));
        Assert.assertEquals((Object)gitSource.getAbsolutePath(), (Object)config.getString("remote", "origin", "url"));
        Assert.assertEquals((Object)sslVerify, (Object)config.getBoolean("http", null, "sslVerify", !sslVerify));
    }

    @Test
    public void testCloneMultipleBranches() throws Exception {
        File parentFolder = JGitCloneTest.createTempDirectory();
        File gitSource = new File(parentFolder, "source/source.git");
        File gitTarget = new File(parentFolder, "target/target.git");
        Git origin = this.setupGitRepo(gitSource, null);
        JGitCloneTest.commit(origin, "main", "first", JGitCloneTest.content("dir1/file.txt", "foo"), JGitCloneTest.content("dir2/file2.txt", "bar"), JGitCloneTest.content("file3.txt", "moogah"));
        this.branch(origin, "main", "dev");
        JGitCloneTest.commit(origin, "dev", "second", JGitCloneTest.content("dir1/file.txt", "foo1"), JGitCloneTest.content("file3.txt", "bar1"));
        this.branch(origin, "main", "ignored");
        JGitCloneTest.commit(origin, "ignored", "third", JGitCloneTest.content("dir1/file.txt", "foo2"));
        Git cloned = (Git)new Clone(gitTarget, gitSource.getAbsolutePath(), false, Arrays.asList("main", "dev"), CredentialsProvider.getDefault(), null, null, false).execute().get();
        Assertions.assertThat((Object)cloned).isNotNull();
        Set clonedRefs = this.listRefs(cloned).stream().map(ref -> ref.getName()).collect(Collectors.toSet());
        Assertions.assertThat(clonedRefs).hasSize(2);
        Assertions.assertThat(clonedRefs).containsExactly((Object[])new String[]{"refs/heads/main", "refs/heads/dev"});
    }
}

