/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.util.commands.Clone;
import org.uberfire.java.nio.fs.jgit.util.commands.ListRefs;

public class JGitMirrorTest
extends AbstractTestInfra {
    public static final String TARGET_GIT = "test/target.git";
    public static final String ORIGIN = "https://github.com/uberfire/uberfire-website";
    private static Logger logger = LoggerFactory.getLogger(JGitMirrorTest.class);

    @Test
    public void testToHTTPMirrorSuccess() throws IOException, GitAPIException {
        File parentFolder = JGitMirrorTest.createTempDirectory();
        File directory = new File(parentFolder, TARGET_GIT);
        new Clone(directory, ORIGIN, true, null, CredentialsProvider.getDefault(), null, null).execute();
        Git cloned = Git.open((File)directory);
        Assertions.assertThat((Object)cloned).isNotNull();
        Assertions.assertThat((Map)cloned.getRepository().getAllRefs()).is((Condition)new Condition<Map<String, Ref>>(){

            public boolean matches(Map<String, Ref> refs) {
                boolean hasDefaultBranchRef = refs.get("refs/heads/master") != null;
                boolean hasNewWebsiteRef = refs.get("refs/heads/new-website") != null;
                boolean hasRemoteOriginDefaultBranch = refs.get("refs/remotes/origin/master") != null;
                boolean hasRemoteOriginNewWebSite = refs.get("refs/remotes/origin/master") != null;
                return hasDefaultBranchRef && hasNewWebsiteRef && hasRemoteOriginDefaultBranch & hasRemoteOriginNewWebSite;
            }
        });
        URIish remoteUri = (URIish)((RemoteConfig)cloned.remoteList().call().get(0)).getURIs().get(0);
        String remoteUrl = remoteUri.getScheme() + "://" + remoteUri.getHost() + remoteUri.getPath();
        Assertions.assertThat((String)remoteUrl).isEqualTo(ORIGIN);
    }

    @Test
    public void testToHTTPUnmirrorSuccess() throws IOException, GitAPIException {
        File parentFolder = JGitMirrorTest.createTempDirectory();
        File directory = new File(parentFolder, TARGET_GIT);
        new Clone(directory, ORIGIN, false, null, CredentialsProvider.getDefault(), null, null).execute();
        Git cloned = Git.open((File)directory);
        Assertions.assertThat((Object)cloned).isNotNull();
        Assertions.assertThat((Map)cloned.getRepository().getAllRefs()).is((Condition)new Condition<Map<String, Ref>>(){

            public boolean matches(Map<String, Ref> refs) {
                boolean hasDefaultBranchRef = refs.get("refs/heads/master") != null;
                boolean hasNewWebsiteRef = refs.get("refs/heads/new-website") != null;
                boolean hasRemoteOriginDefaultBranch = refs.get("refs/remotes/origin/master") != null;
                boolean hasRemoteOriginNewWebSite = refs.get("refs/remotes/origin/master") != null;
                return hasDefaultBranchRef && hasNewWebsiteRef && hasRemoteOriginDefaultBranch & hasRemoteOriginNewWebSite;
            }
        });
        boolean isMirror = cloned.getRepository().getConfig().getBoolean("remote", "origin", "mirror", false);
        Assert.assertFalse((boolean)isMirror);
        Assertions.assertThat((String)((Ref)new ListRefs(cloned.getRepository()).execute().get(0)).getName()).isEqualTo("refs/heads/master");
        URIish remoteUri = (URIish)((RemoteConfig)cloned.remoteList().call().get(0)).getURIs().get(0);
        String remoteUrl = remoteUri.getScheme() + "://" + remoteUri.getHost() + remoteUri.getPath();
        Assertions.assertThat((String)remoteUrl).isEqualTo(ORIGIN);
    }

    @Test
    public void testEmptyCredentials() throws IOException, GitAPIException {
        File parentFolder = JGitMirrorTest.createTempDirectory();
        File directory = new File(parentFolder, TARGET_GIT);
        new Clone(directory, ORIGIN, false, null, null, null, null).execute();
        Git cloned = Git.open((File)directory);
        Assertions.assertThat((Object)cloned).isNotNull();
        Assertions.assertThat((List)new ListRefs(cloned.getRepository()).execute()).is((Condition)new Condition<List<? extends Ref>>(){

            public boolean matches(List<? extends Ref> refs) {
                return refs.size() > 0;
            }
        });
        Assertions.assertThat((String)((Ref)new ListRefs(cloned.getRepository()).execute().get(0)).getName()).isEqualTo("refs/heads/master");
        URIish remoteUri = (URIish)((RemoteConfig)cloned.remoteList().call().get(0)).getURIs().get(0);
        String remoteUrl = remoteUri.getScheme() + "://" + remoteUri.getHost() + remoteUri.getPath();
        Assertions.assertThat((String)remoteUrl).isEqualTo(ORIGIN);
    }

    @Test
    public void testBadUrl() throws IOException, GitAPIException {
        File parentFolder = JGitMirrorTest.createTempDirectory();
        File directory = new File(parentFolder, TARGET_GIT);
        try {
            new Clone(directory, "https://github.com/uberfire/uberfire-websitesssss", false, null, CredentialsProvider.getDefault(), null, null).execute();
            Assertions.fail((String)"If got here the test is wrong because the ORIGIN does no exist");
        }
        catch (Clone.CloneException ex) {
            Assertions.assertThat((Throwable)ex).isNotNull();
            logger.info(ex.getMessage(), (Throwable)ex);
        }
    }
}

