/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.revwalk.RevCommit;
import org.junit.Before;
import org.junit.Test;
import org.uberfire.java.nio.base.TextualDiff;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.GitImpl;
import org.uberfire.java.nio.fs.jgit.util.commands.Commit;
import org.uberfire.java.nio.fs.jgit.util.commands.CreateBranch;
import org.uberfire.java.nio.fs.jgit.util.commands.CreateRepository;
import org.uberfire.java.nio.fs.jgit.util.exceptions.GitException;

public class JGitTextualDiffBranchesTest
extends AbstractTestInfra {
    private Git git;
    private static final String MAIN_BRANCH = "main";
    private static final String DEVELOP_BRANCH = "develop";
    private static final List<String> TXT_FILES = Stream.of("file0", "file1", "file2", "file3", "file4").collect(Collectors.toList());
    private static final String[] COMMON_TXT_LINES = new String[]{"Line1", "Line2", "Line3", "Line4"};

    @Before
    public void setup() throws IOException {
        File parentFolder = JGitTextualDiffBranchesTest.createTempDirectory();
        File gitSource = new File(parentFolder, "source/source.git");
        this.git = (Git)new CreateRepository(gitSource).execute().get();
        JGitTextualDiffBranchesTest.commit(this.git, MAIN_BRANCH, "Adding files into main", JGitTextualDiffBranchesTest.content(TXT_FILES.get(0), JGitTextualDiffBranchesTest.multiline(TXT_FILES.get(0), COMMON_TXT_LINES)), JGitTextualDiffBranchesTest.content(TXT_FILES.get(1), JGitTextualDiffBranchesTest.multiline(TXT_FILES.get(1), COMMON_TXT_LINES)), JGitTextualDiffBranchesTest.content(TXT_FILES.get(2), JGitTextualDiffBranchesTest.multiline(TXT_FILES.get(2), COMMON_TXT_LINES)));
        new CreateBranch((GitImpl)this.git, MAIN_BRANCH, DEVELOP_BRANCH).execute();
    }

    @Test
    public void testDiffWithAddedFiles() throws IOException {
        JGitTextualDiffBranchesTest.commit(this.git, DEVELOP_BRANCH, "Adding files", JGitTextualDiffBranchesTest.content(TXT_FILES.get(3), JGitTextualDiffBranchesTest.multiline(TXT_FILES.get(3), COMMON_TXT_LINES)), JGitTextualDiffBranchesTest.content(TXT_FILES.get(4), JGitTextualDiffBranchesTest.multiline(TXT_FILES.get(4), COMMON_TXT_LINES)));
        List diffs = this.git.textualDiffRefs(MAIN_BRANCH, DEVELOP_BRANCH);
        Assertions.assertThat((List)diffs).isNotEmpty();
        Assertions.assertThat((List)diffs).hasSize(2);
        diffs.forEach(diff -> {
            Assertions.assertThat((String)diff.getChangeType()).isEqualTo(DiffEntry.ChangeType.ADD.toString());
            Assertions.assertThat((String)diff.getDiffText()).isNotEmpty();
        });
        Assertions.assertThat((String)((TextualDiff)diffs.get(0)).getOldFilePath()).isEqualTo("/dev/null");
        Assertions.assertThat((String)((TextualDiff)diffs.get(0)).getNewFilePath()).isEqualTo(TXT_FILES.get(3));
        Assertions.assertThat((int)((TextualDiff)diffs.get(0)).getLinesAdded()).isEqualTo(4);
        Assertions.assertThat((int)((TextualDiff)diffs.get(0)).getLinesDeleted()).isEqualTo(0);
    }

    @Test
    public void testDiffWithAddedFilesSameBranch() throws IOException {
        RevCommit startCommit = this.git.getLastCommit(MAIN_BRANCH);
        JGitTextualDiffBranchesTest.commit(this.git, MAIN_BRANCH, "Adding files", JGitTextualDiffBranchesTest.content(TXT_FILES.get(3), JGitTextualDiffBranchesTest.multiline(TXT_FILES.get(3), COMMON_TXT_LINES)), JGitTextualDiffBranchesTest.content(TXT_FILES.get(4), JGitTextualDiffBranchesTest.multiline(TXT_FILES.get(4), COMMON_TXT_LINES)));
        RevCommit endCommit = this.git.getLastCommit(MAIN_BRANCH);
        List diffs = this.git.textualDiffRefs(MAIN_BRANCH, MAIN_BRANCH, startCommit.getName(), endCommit.getName());
        Assertions.assertThat((List)diffs).isNotEmpty();
        Assertions.assertThat((List)diffs).hasSize(2);
    }

    @Test
    public void testDiffWithAddedFileAndTargetUpdatedLater() throws IOException {
        JGitTextualDiffBranchesTest.commit(this.git, DEVELOP_BRANCH, "Adding file", JGitTextualDiffBranchesTest.content(TXT_FILES.get(3), JGitTextualDiffBranchesTest.multiline(TXT_FILES.get(3), COMMON_TXT_LINES)));
        JGitTextualDiffBranchesTest.commit(this.git, MAIN_BRANCH, "Adding file", JGitTextualDiffBranchesTest.content(TXT_FILES.get(4), JGitTextualDiffBranchesTest.multiline(TXT_FILES.get(4), COMMON_TXT_LINES)));
        List diffs = this.git.textualDiffRefs(MAIN_BRANCH, DEVELOP_BRANCH);
        Assertions.assertThat((List)diffs).isNotEmpty();
        Assertions.assertThat((List)diffs).hasSize(1);
        Assertions.assertThat((String)((TextualDiff)diffs.get(0)).getChangeType()).isEqualTo(DiffEntry.ChangeType.ADD.toString());
        Assertions.assertThat((String)((TextualDiff)diffs.get(0)).getDiffText()).isNotEmpty();
        Assertions.assertThat((String)((TextualDiff)diffs.get(0)).getOldFilePath()).isEqualTo("/dev/null");
        Assertions.assertThat((String)((TextualDiff)diffs.get(0)).getNewFilePath()).isEqualTo(TXT_FILES.get(3));
        Assertions.assertThat((int)((TextualDiff)diffs.get(0)).getLinesAdded()).isEqualTo(4);
        Assertions.assertThat((int)((TextualDiff)diffs.get(0)).getLinesDeleted()).isEqualTo(0);
    }

    @Test
    public void testDiffWithRemovedFile() {
        new Commit(this.git, DEVELOP_BRANCH, "name", "name@example.com", "Removing file", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put(TXT_FILES.get(0), null);
            }
        }).execute();
        List diffs = this.git.textualDiffRefs(MAIN_BRANCH, DEVELOP_BRANCH);
        Assertions.assertThat((List)diffs).isNotEmpty();
        Assertions.assertThat((List)diffs).hasSize(1);
        Assertions.assertThat((String)((TextualDiff)diffs.get(0)).getChangeType()).isEqualTo(DiffEntry.ChangeType.DELETE.toString());
        Assertions.assertThat((String)((TextualDiff)diffs.get(0)).getOldFilePath()).isEqualTo(TXT_FILES.get(0));
        Assertions.assertThat((String)((TextualDiff)diffs.get(0)).getNewFilePath()).isEqualTo("/dev/null");
        Assertions.assertThat((int)((TextualDiff)diffs.get(0)).getLinesAdded()).isEqualTo(0);
        Assertions.assertThat((int)((TextualDiff)diffs.get(0)).getLinesDeleted()).isEqualTo(4);
        Assertions.assertThat((String)((TextualDiff)diffs.get(0)).getDiffText()).isNotEmpty();
    }

    @Test
    public void testDiffWithUpdatedFiles() throws IOException {
        JGitTextualDiffBranchesTest.commit(this.git, DEVELOP_BRANCH, "Updating files", JGitTextualDiffBranchesTest.content(TXT_FILES.get(1), JGitTextualDiffBranchesTest.multiline(TXT_FILES.get(1), "Line1", "Line2Changed", "Line3", "Line4")), JGitTextualDiffBranchesTest.content(TXT_FILES.get(2), JGitTextualDiffBranchesTest.multiline(TXT_FILES.get(2), "Line1", "Line2Changed", "Line3", "Line4")));
        List diffs = this.git.textualDiffRefs(MAIN_BRANCH, DEVELOP_BRANCH);
        Assertions.assertThat((List)diffs).isNotEmpty();
        Assertions.assertThat((List)diffs).hasSize(2);
        diffs.forEach(diff -> {
            Assertions.assertThat((String)diff.getChangeType()).isEqualTo(DiffEntry.ChangeType.MODIFY.toString());
            Assertions.assertThat((String)diff.getOldFilePath()).isEqualTo(diff.getNewFilePath());
            Assertions.assertThat((int)diff.getLinesAdded()).isEqualTo(1);
            Assertions.assertThat((int)diff.getLinesDeleted()).isEqualTo(1);
            Assertions.assertThat((String)diff.getDiffText()).isNotEmpty();
        });
        Assertions.assertThat((String)((TextualDiff)diffs.get(0)).getOldFilePath()).isEqualTo(TXT_FILES.get(1));
        Assertions.assertThat((String)((TextualDiff)diffs.get(1)).getOldFilePath()).isEqualTo(TXT_FILES.get(2));
    }

    @Test
    public void testDiffWithUpdateFirstAndLastLines() throws IOException {
        JGitTextualDiffBranchesTest.commit(this.git, DEVELOP_BRANCH, "Updating file", JGitTextualDiffBranchesTest.content(TXT_FILES.get(1), JGitTextualDiffBranchesTest.multiline(TXT_FILES.get(1), "Line1Changed", "Line2", "Line3", "Line4Changed")));
        List fileDiffs = this.git.textualDiffRefs(MAIN_BRANCH, DEVELOP_BRANCH);
        Assertions.assertThat((List)fileDiffs).isNotEmpty();
        Assertions.assertThat((List)fileDiffs).hasSize(1);
    }

    @Test
    public void testDiffWithEvenBranches() {
        List diffs = this.git.textualDiffRefs(MAIN_BRANCH, DEVELOP_BRANCH);
        Assertions.assertThat((List)diffs).isEmpty();
    }

    @Test(expected=GitException.class)
    public void testDiffWithNonExistentBranch() {
        List diffs = this.git.textualDiffRefs(MAIN_BRANCH, "nonExistentBranch");
        Assertions.assertThat((List)diffs).isEmpty();
    }
}

