/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.daemon.common;

import java.io.IOException;
import java.net.ServerSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortUtil {
    private static final String ERROR_MESSAGE = "Error trying to find a free port.";
    private static final Logger LOG = LoggerFactory.getLogger(PortUtil.class);

    public static int validateOrGetNew(int preferredPort) {
        if (preferredPort == 0 || PortUtil.isPortInUse(preferredPort)) {
            int n;
            if (preferredPort != 0) {
                LOG.warn("Port {} already in use, system will automatically look for a new one.", (Object)preferredPort);
            }
            ServerSocket ss = new ServerSocket(0);
            try {
                n = ss.getLocalPort();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ss.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.error(ERROR_MESSAGE, (Throwable)e);
                    throw new RuntimeException(ERROR_MESSAGE);
                }
            }
            ss.close();
            return n;
        }
        return preferredPort;
    }

    private static boolean isPortInUse(int port) {
        boolean bl;
        ServerSocket ss = new ServerSocket(port);
        try {
            bl = false;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ss.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                return true;
            }
        }
        ss.close();
        return bl;
    }
}

