/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.uberfire.java.nio.base.options.MergeCopyOption;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.commands.GetTreeFromRef;
import org.uberfire.java.nio.fs.jgit.util.commands.ListDiffs;
import org.uberfire.java.nio.fs.jgit.util.exceptions.GitException;

public class JGitFileSystemImplProviderMergeTest
extends AbstractTestInfra {
    @Test
    public void testMergeSuccessful() throws IOException {
        URI newRepo = URI.create("git://merge-test-repo");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("git://main@merge-test-repo/myfile1.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        outStream.write("my cool content".getBytes());
        outStream.close();
        Path main = this.provider.getPath(URI.create("git://main@merge-test-repo"));
        Path userBranch = this.provider.getPath(URI.create("git://user_branch@merge-test-repo"));
        this.provider.copy(main, userBranch, new CopyOption[0]);
        Path path2 = this.provider.getPath(URI.create("git://user_branch@merge-test-repo/other/path/myfile2.txt"));
        OutputStream outStream2 = this.provider.newOutputStream(path2, new OpenOption[0]);
        outStream2.write("my cool content".getBytes());
        outStream2.close();
        Path path3 = this.provider.getPath(URI.create("git://user_branch@merge-test-repo/myfile3.txt"));
        OutputStream outStream3 = this.provider.newOutputStream(path3, new OpenOption[0]);
        outStream3.write("my cool content".getBytes());
        outStream3.close();
        this.provider.copy(userBranch, main, new CopyOption[]{new MergeCopyOption()});
        Git gitRepo = ((JGitFileSystem)main.getFileSystem()).getGit();
        List result = new ListDiffs(gitRepo, new GetTreeFromRef(gitRepo, "main").execute(), new GetTreeFromRef(gitRepo, "user_branch").execute()).execute();
        Assertions.assertThat((int)result.size()).isEqualTo(0);
    }

    @Test(expected=GitException.class)
    public void testMergeConflicts() throws IOException {
        URI newRepo = URI.create("git://merge-test-repo");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("git://main@merge-test-repo/myfile1.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        outStream.write("my cool content".getBytes());
        outStream.close();
        Path main = this.provider.getPath(URI.create("git://main@merge-test-repo"));
        Path userBranch = this.provider.getPath(URI.create("git://user_branch@merge-test-repo"));
        this.provider.copy(main, userBranch, new CopyOption[0]);
        Path path2 = this.provider.getPath(URI.create("git://user_branch@merge-test-repo/other/path/myfile2.txt"));
        OutputStream outStream2 = this.provider.newOutputStream(path2, new OpenOption[0]);
        outStream2.write("my cool content".getBytes());
        outStream2.close();
        Path path3 = this.provider.getPath(URI.create("git://user_branch@merge-test-repo/myfile1.txt"));
        OutputStream outStream3 = this.provider.newOutputStream(path3, new OpenOption[0]);
        outStream3.write("my cool content changed".getBytes());
        outStream3.close();
        Path path32 = this.provider.getPath(URI.create("git://user_branch@merge-test-repo/myfile3.txt"));
        OutputStream outStream32 = this.provider.newOutputStream(path32, new OpenOption[0]);
        outStream32.write("my cool content".getBytes());
        outStream32.close();
        path3 = this.provider.getPath(URI.create("git://main@merge-test-repo/myfile1.txt"));
        outStream3 = this.provider.newOutputStream(path3, new OpenOption[0]);
        outStream3.write("my very cool content".getBytes());
        outStream3.close();
        this.provider.copy(userBranch, main, new CopyOption[]{new MergeCopyOption()});
    }

    @Test
    public void testMergeBinarySuccessful() throws IOException {
        URI newRepo = URI.create("git://merge-test-repo");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("git://main@merge-test-repo/myfile1.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        outStream.write(this.loadImage("images/drools.png"));
        outStream.close();
        Path main = this.provider.getPath(URI.create("git://main@merge-test-repo"));
        Path userBranch = this.provider.getPath(URI.create("git://user_branch@merge-test-repo"));
        this.provider.copy(main, userBranch, new CopyOption[0]);
        Path path2 = this.provider.getPath(URI.create("git://user_branch@merge-test-repo/other/path/myfile2.txt"));
        OutputStream outStream2 = this.provider.newOutputStream(path2, new OpenOption[0]);
        outStream2.write(this.loadImage("images/jbpm.png"));
        outStream2.close();
        Path path3 = this.provider.getPath(URI.create("git://user_branch@merge-test-repo/myfile3.txt"));
        OutputStream outStream3 = this.provider.newOutputStream(path3, new OpenOption[0]);
        outStream3.write(this.loadImage("images/opta.png"));
        outStream3.close();
        this.provider.copy(userBranch, main, new CopyOption[]{new MergeCopyOption()});
        Git gitRepo = ((JGitFileSystem)main.getFileSystem()).getGit();
        List result = new ListDiffs(gitRepo, new GetTreeFromRef(gitRepo, "main").execute(), new GetTreeFromRef(gitRepo, "user_branch").execute()).execute();
        Assertions.assertThat((int)result.size()).isEqualTo(0);
    }

    @Test(expected=GitException.class)
    public void testBinaryMergeConflicts() throws IOException {
        URI newRepo = URI.create("git://merge-test-repo");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("git://main@merge-test-repo/myfile1.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        outStream.write(this.loadImage("images/drools.png"));
        outStream.close();
        Path main = this.provider.getPath(URI.create("git://main@merge-test-repo"));
        Path userBranch = this.provider.getPath(URI.create("git://user_branch@merge-test-repo"));
        this.provider.copy(main, userBranch, new CopyOption[0]);
        Path path2 = this.provider.getPath(URI.create("git://user_branch@merge-test-repo/other/path/myfile2.txt"));
        OutputStream outStream2 = this.provider.newOutputStream(path2, new OpenOption[0]);
        outStream2.write(this.loadImage("images/jbpm.png"));
        outStream2.close();
        Path path3 = this.provider.getPath(URI.create("git://user_branch@merge-test-repo/myfile1.txt"));
        outStream2 = this.provider.newOutputStream(path3, new OpenOption[0]);
        outStream2.write(this.loadImage("images/jbpm.png"));
        outStream2.close();
        Path path32 = this.provider.getPath(URI.create("git://user_branch@merge-test-repo/myfile3.txt"));
        outStream2 = this.provider.newOutputStream(path32, new OpenOption[0]);
        outStream2.write(this.loadImage("images/opta.png"));
        outStream2.close();
        path3 = this.provider.getPath(URI.create("git://main@merge-test-repo/myfile1.txt"));
        outStream2 = this.provider.newOutputStream(path3, new OpenOption[0]);
        outStream2.write(this.loadImage(""));
        outStream2.close();
        this.provider.copy(userBranch, main, new CopyOption[]{new MergeCopyOption()});
    }

    @Test(expected=GitException.class)
    public void testTryToMergeNonexistentBranch() throws IOException {
        URI newRepo = URI.create("git://merge-test-repo");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("git://main@merge-test-repo/myfile1.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        outStream.write("my cool content".getBytes());
        outStream.close();
        Path main = this.provider.getPath(URI.create("git://main@merge-test-repo"));
        Path develop = this.provider.getPath(URI.create("git://develop@merge-test-repo"));
        this.provider.copy(develop, main, new CopyOption[]{new MergeCopyOption()});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMissingParemeter() throws IOException {
        URI newRepo = URI.create("git://merge-test-repo");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("git://main@merge-test-repo/myfile1.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        outStream.write("my cool content".getBytes());
        outStream.close();
        Path main = this.provider.getPath(URI.create("git://main@merge-test-repo"));
        Path develop = this.provider.getPath(URI.create("git://develop@merge-test-repo"));
        this.provider.copy(develop, null, new CopyOption[]{new MergeCopyOption()});
    }
}

