/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.api.IterableAssert;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.soup.commons.util.Maps;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.java.nio.file.FileStore;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemImpl;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemLock;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProvider;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.GitImpl;

public class JGitFileSystemImplTest
extends AbstractTestInfra {
    @Test
    public void testOnlyLocalRoot() throws IOException, GitAPIException {
        JGitFileSystemProvider fsProvider = (JGitFileSystemProvider)Mockito.mock(JGitFileSystemProvider.class);
        Git git = this.setupGit();
        JGitFileSystemImpl fileSystem = new JGitFileSystemImpl(fsProvider, null, git, this.createFSLock(git), "my-repo", CredentialsProvider.getDefault(), null, null);
        Assertions.assertThat((boolean)fileSystem.isReadOnly()).isFalse();
        Assertions.assertThat((String)fileSystem.getSeparator()).isEqualTo("/");
        Assertions.assertThat((String)fileSystem.getName()).isEqualTo("my-repo");
        Assertions.assertThat((Iterable)fileSystem.getRootDirectories()).hasSize(1);
        Path root = (Path)fileSystem.getRootDirectories().iterator().next();
        Assertions.assertThat((String)root.toString()).isEqualTo("/");
        Assertions.assertThat((String)root.getRoot().toString()).isEqualTo("/");
    }

    @Test
    public void testRemoteRoot() throws IOException, GitAPIException {
        JGitFileSystemProvider fsProvider = (JGitFileSystemProvider)Mockito.mock(JGitFileSystemProvider.class);
        File tempDir = JGitFileSystemImplTest.createTempDirectory();
        GitImpl git = new GitImpl(GitImpl._cloneRepository().setNoCheckout(false).setBare(true).setCloneAllBranches(true).setURI(this.setupGit().getRepository().getDirectory().toString()).setDirectory(tempDir).call());
        JGitFileSystemImpl fileSystem = new JGitFileSystemImpl(fsProvider, null, (Git)git, this.createFSLock((Git)git), "my-repo", CredentialsProvider.getDefault(), null, null);
        Assertions.assertThat((boolean)fileSystem.isReadOnly()).isFalse();
        Assertions.assertThat((String)fileSystem.getSeparator()).isEqualTo("/");
        Assertions.assertThat((String)fileSystem.getName()).isEqualTo("my-repo");
        Assertions.assertThat((Iterable)fileSystem.getRootDirectories()).hasSize(1);
        Path root = (Path)fileSystem.getRootDirectories().iterator().next();
        Assertions.assertThat((String)root.toString()).isEqualTo("/");
        Assertions.assertThat((String)root.getRoot().toString()).isEqualTo("/");
    }

    private JGitFileSystemLock createFSLock(Git git) {
        return new JGitFileSystemLock(git, TimeUnit.MILLISECONDS, 30000L);
    }

    @Test
    public void testProvider() throws IOException, GitAPIException {
        JGitFileSystemProvider fsProvider = (JGitFileSystemProvider)Mockito.mock(JGitFileSystemProvider.class);
        Git git = this.setupGit();
        JGitFileSystemImpl fileSystem = new JGitFileSystemImpl(fsProvider, null, git, this.createFSLock(git), "my-repo", CredentialsProvider.getDefault(), null, null);
        Assertions.assertThat((String)fileSystem.getName()).isEqualTo("my-repo");
        Assertions.assertThat((boolean)fileSystem.isReadOnly()).isFalse();
        Assertions.assertThat((String)fileSystem.getSeparator()).isEqualTo("/");
        Assertions.assertThat((Object)fileSystem.provider()).isEqualTo((Object)fsProvider);
    }

    @Test(expected=IllegalStateException.class)
    public void testClose() throws IOException, GitAPIException {
        JGitFileSystemProvider fsProvider = (JGitFileSystemProvider)Mockito.mock(JGitFileSystemProvider.class);
        Git git = this.setupGit();
        JGitFileSystemImpl fileSystem = new JGitFileSystemImpl(fsProvider, null, git, this.createFSLock(git), "my-repo", CredentialsProvider.getDefault(), null, null);
        Assertions.assertThat((boolean)fileSystem.isReadOnly()).isFalse();
        Assertions.assertThat((String)fileSystem.getSeparator()).isEqualTo("/");
        Assertions.assertThat((String)fileSystem.getName()).isEqualTo("my-repo");
        Assertions.assertThat((boolean)fileSystem.isOpen()).isTrue();
        Assertions.assertThat((Iterable)fileSystem.getFileStores()).isNotNull();
        fileSystem.close();
        Assertions.assertThat((boolean)fileSystem.isOpen()).isFalse();
        Assertions.assertThat((Iterable)fileSystem.getFileStores()).isNotNull();
    }

    @Test
    public void testSupportedFileAttributeViews() throws IOException, GitAPIException {
        JGitFileSystemProvider fsProvider = (JGitFileSystemProvider)Mockito.mock(JGitFileSystemProvider.class);
        Git git = this.setupGit();
        JGitFileSystemImpl fileSystem = new JGitFileSystemImpl(fsProvider, null, git, this.createFSLock(git), "my-repo", CredentialsProvider.getDefault(), null, null);
        Assertions.assertThat((boolean)fileSystem.isReadOnly()).isFalse();
        Assertions.assertThat((String)fileSystem.getSeparator()).isEqualTo("/");
        Assertions.assertThat((String)fileSystem.getName()).isEqualTo("my-repo");
        ((IterableAssert)((IterableAssert)Assertions.assertThat((Iterable)fileSystem.supportedFileAttributeViews()).isNotEmpty()).hasSize(2)).contains((Object[])new String[]{"basic", "version"});
    }

    @Test
    public void testPathNonBranchRooted() throws IOException, GitAPIException {
        JGitFileSystemProvider fsProvider = (JGitFileSystemProvider)Mockito.mock(JGitFileSystemProvider.class);
        Mockito.when((Object)fsProvider.isDefault()).thenReturn((Object)false);
        Mockito.when((Object)fsProvider.getScheme()).thenReturn((Object)"git");
        Git git = this.setupGit();
        JGitFileSystemImpl fileSystem = new JGitFileSystemImpl(fsProvider, null, git, this.createFSLock(git), "my-repo", CredentialsProvider.getDefault(), null, null);
        Path path = fileSystem.getPath("/path/to/some/place.txt", new String[0]);
        AssertionsForClassTypes.assertThat((Object)path).isNotNull();
        Assertions.assertThat((boolean)path.isAbsolute()).isTrue();
        Assertions.assertThat((String)path.toString()).isEqualTo("/path/to/some/place.txt");
        Assertions.assertThat((String)path.toUri().toString()).isEqualTo("git://master@my-repo/path/to/some/place.txt");
        Assertions.assertThat((int)path.getNameCount()).isEqualTo(4);
        ((AbstractStringAssert)Assertions.assertThat((String)path.getName(0).toString()).isNotNull()).isEqualTo("path");
        ((AbstractStringAssert)Assertions.assertThat((String)path.getRoot().toString()).isNotNull()).isEqualTo("/");
    }

    @Test
    public void testPathNonBranchNonRooted() throws IOException, GitAPIException {
        JGitFileSystemProvider fsProvider = (JGitFileSystemProvider)Mockito.mock(JGitFileSystemProvider.class);
        Mockito.when((Object)fsProvider.isDefault()).thenReturn((Object)false);
        Mockito.when((Object)fsProvider.getScheme()).thenReturn((Object)"git");
        Git git = this.setupGit();
        JGitFileSystemImpl fileSystem = new JGitFileSystemImpl(fsProvider, null, git, this.createFSLock(git), "my-repo", CredentialsProvider.getDefault(), null, null);
        Path path = fileSystem.getPath("path/to/some/place.txt", new String[0]);
        AssertionsForClassTypes.assertThat((Object)path).isNotNull();
        Assertions.assertThat((boolean)path.isAbsolute()).isFalse();
        Assertions.assertThat((String)path.toString()).isEqualTo("path/to/some/place.txt");
        Assertions.assertThat((String)path.toUri().toString()).isEqualTo("git://master@my-repo/:path/to/some/place.txt");
        Assertions.assertThat((int)path.getNameCount()).isEqualTo(4);
        ((AbstractStringAssert)Assertions.assertThat((String)path.getName(0).toString()).isNotNull()).isEqualTo("path");
        ((AbstractStringAssert)Assertions.assertThat((String)path.getRoot().toString()).isNotNull()).isEqualTo("");
    }

    @Test
    public void testPathBranchRooted() throws IOException, GitAPIException {
        JGitFileSystemProvider fsProvider = (JGitFileSystemProvider)Mockito.mock(JGitFileSystemProvider.class);
        Mockito.when((Object)fsProvider.isDefault()).thenReturn((Object)false);
        Mockito.when((Object)fsProvider.getScheme()).thenReturn((Object)"git");
        Git git = this.setupGit();
        JGitFileSystemImpl fileSystem = new JGitFileSystemImpl(fsProvider, null, git, this.createFSLock(git), "my-repo", CredentialsProvider.getDefault(), null, null);
        Path path = fileSystem.getPath("test-branch", new String[]{"/path/to/some/place.txt"});
        AssertionsForClassTypes.assertThat((Object)path).isNotNull();
        Assertions.assertThat((boolean)path.isAbsolute()).isTrue();
        Assertions.assertThat((String)path.toString()).isEqualTo("/path/to/some/place.txt");
        Assertions.assertThat((String)path.toUri().toString()).isEqualTo("git://test-branch@my-repo/path/to/some/place.txt");
        Assertions.assertThat((int)path.getNameCount()).isEqualTo(4);
        ((AbstractStringAssert)Assertions.assertThat((String)path.getName(0).toString()).isNotNull()).isEqualTo("path");
        ((AbstractStringAssert)Assertions.assertThat((String)path.getRoot().toString()).isNotNull()).isEqualTo("/");
    }

    @Test
    public void testPathBranchNonRooted() throws IOException, GitAPIException {
        JGitFileSystemProvider fsProvider = (JGitFileSystemProvider)Mockito.mock(JGitFileSystemProvider.class);
        Mockito.when((Object)fsProvider.isDefault()).thenReturn((Object)false);
        Mockito.when((Object)fsProvider.getScheme()).thenReturn((Object)"git");
        Git git = this.setupGit();
        JGitFileSystemImpl fileSystem = new JGitFileSystemImpl(fsProvider, null, git, this.createFSLock(git), "my-repo", CredentialsProvider.getDefault(), null, null);
        Path path = fileSystem.getPath("test-branch", new String[]{"path/to/some/place.txt"});
        AssertionsForClassTypes.assertThat((Object)path).isNotNull();
        Assertions.assertThat((boolean)path.isAbsolute()).isFalse();
        Assertions.assertThat((String)path.toString()).isEqualTo("path/to/some/place.txt");
        Assertions.assertThat((String)path.toUri().toString()).isEqualTo("git://test-branch@my-repo/:path/to/some/place.txt");
        Assertions.assertThat((int)path.getNameCount()).isEqualTo(4);
        ((AbstractStringAssert)Assertions.assertThat((String)path.getName(0).toString()).isNotNull()).isEqualTo("path");
        ((AbstractStringAssert)Assertions.assertThat((String)path.getRoot().toString()).isNotNull()).isEqualTo("");
    }

    @Test
    public void testPathBranchRooted2() throws IOException, GitAPIException {
        JGitFileSystemProvider fsProvider = (JGitFileSystemProvider)Mockito.mock(JGitFileSystemProvider.class);
        Mockito.when((Object)fsProvider.isDefault()).thenReturn((Object)false);
        Mockito.when((Object)fsProvider.getScheme()).thenReturn((Object)"git");
        Git git = this.setupGit();
        JGitFileSystemImpl fileSystem = new JGitFileSystemImpl(fsProvider, null, git, this.createFSLock(git), "my-repo", CredentialsProvider.getDefault(), null, null);
        Path path = fileSystem.getPath("test-branch", new String[]{"/path/to", "some/place.txt"});
        AssertionsForClassTypes.assertThat((Object)path).isNotNull();
        Assertions.assertThat((boolean)path.isAbsolute()).isTrue();
        Assertions.assertThat((String)path.toString()).isEqualTo("/path/to/some/place.txt");
        Assertions.assertThat((String)path.toUri().toString()).isEqualTo("git://test-branch@my-repo/path/to/some/place.txt");
        Assertions.assertThat((int)path.getNameCount()).isEqualTo(4);
        ((AbstractStringAssert)Assertions.assertThat((String)path.getName(0).toString()).isNotNull()).isEqualTo("path");
        ((AbstractStringAssert)Assertions.assertThat((String)path.getRoot().toString()).isNotNull()).isEqualTo("/");
    }

    @Test
    public void testPathBranchNonRooted2() throws IOException, GitAPIException {
        JGitFileSystemProvider fsProvider = (JGitFileSystemProvider)Mockito.mock(JGitFileSystemProvider.class);
        Mockito.when((Object)fsProvider.isDefault()).thenReturn((Object)false);
        Mockito.when((Object)fsProvider.getScheme()).thenReturn((Object)"git");
        Git git = this.setupGit();
        JGitFileSystemImpl fileSystem = new JGitFileSystemImpl(fsProvider, null, git, this.createFSLock(git), "my-repo", CredentialsProvider.getDefault(), null, null);
        Path path = fileSystem.getPath("test-branch", new String[]{"path/to", "some/place.txt"});
        AssertionsForClassTypes.assertThat((Object)path).isNotNull();
        Assertions.assertThat((boolean)path.isAbsolute()).isFalse();
        Assertions.assertThat((String)path.toString()).isEqualTo("path/to/some/place.txt");
        Assertions.assertThat((String)path.toUri().toString()).isEqualTo("git://test-branch@my-repo/:path/to/some/place.txt");
        Assertions.assertThat((int)path.getNameCount()).isEqualTo(4);
        ((AbstractStringAssert)Assertions.assertThat((String)path.getName(0).toString()).isNotNull()).isEqualTo("path");
        ((AbstractStringAssert)Assertions.assertThat((String)path.getRoot().toString()).isNotNull()).isEqualTo("");
    }

    @Test
    public void testFileStore() throws IOException, GitAPIException {
        JGitFileSystemProvider fsProvider = (JGitFileSystemProvider)Mockito.mock(JGitFileSystemProvider.class);
        File tempDir = JGitFileSystemImplTest.createTempDirectory();
        Git git = this.setupGit(tempDir);
        JGitFileSystemImpl fileSystem = new JGitFileSystemImpl(fsProvider, null, git, this.createFSLock(git), "my-repo", CredentialsProvider.getDefault(), null, null);
        Assertions.assertThat((Iterable)fileSystem.getFileStores()).hasSize(1);
        FileStore fileStore = (FileStore)fileSystem.getFileStores().iterator().next();
        Assertions.assertThat((Object)fileStore).isNotNull();
        Assertions.assertThat((long)fileStore.getTotalSpace()).isEqualTo(tempDir.getTotalSpace());
        Assertions.assertThat((long)fileStore.getUsableSpace()).isEqualTo(tempDir.getUsableSpace());
    }

    @Test
    public void testPathEqualsWithDifferentRepos() throws IOException, GitAPIException {
        JGitFileSystemProvider fsProvider = (JGitFileSystemProvider)Mockito.mock(JGitFileSystemProvider.class);
        Git git1 = this.setupGit();
        JGitFileSystemImpl fileSystem1 = new JGitFileSystemImpl(fsProvider, null, git1, this.createFSLock(git1), "my-repo1", CredentialsProvider.getDefault(), null, null);
        Git git2 = this.setupGit();
        JGitFileSystemImpl fileSystem2 = new JGitFileSystemImpl(fsProvider, null, git2, this.createFSLock(git2), "my-repo2", CredentialsProvider.getDefault(), null, null);
        Path path1 = fileSystem1.getPath("master", new String[]{"/path/to/some.txt"});
        Path path2 = fileSystem2.getPath("main", new String[]{"/path/to/some.txt"});
        AssertionsForClassTypes.assertThat((Object)path1).isNotEqualTo((Object)path2);
        AssertionsForClassTypes.assertThat((Object)path1).isEqualTo((Object)fileSystem1.getPath("/path/to/some.txt", new String[0]));
    }

    @Test(expected=UnsupportedOperationException.class)
    @Ignore
    public void testNewWatchService() throws IOException, GitAPIException {
        JGitFileSystemProvider fsProvider = (JGitFileSystemProvider)Mockito.mock(JGitFileSystemProvider.class);
        Git git = this.setupGit();
        JGitFileSystemImpl fileSystem = new JGitFileSystemImpl(fsProvider, null, git, this.createFSLock(git), "my-repo", CredentialsProvider.getDefault(), null, null);
        fileSystem.newWatchService();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testGetUserPrincipalLookupService() throws IOException, GitAPIException {
        JGitFileSystemProvider fsProvider = (JGitFileSystemProvider)Mockito.mock(JGitFileSystemProvider.class);
        Git git = this.setupGit();
        JGitFileSystemImpl fileSystem = new JGitFileSystemImpl(fsProvider, null, git, this.createFSLock(git), "my-repo", CredentialsProvider.getDefault(), null, null);
        fileSystem.getUserPrincipalLookupService();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testGetPathMatcher() throws IOException, GitAPIException {
        JGitFileSystemProvider fsProvider = (JGitFileSystemProvider)Mockito.mock(JGitFileSystemProvider.class);
        Git git = this.setupGit();
        JGitFileSystemImpl fileSystem = new JGitFileSystemImpl(fsProvider, null, git, this.createFSLock(git), "my-repo", CredentialsProvider.getDefault(), null, null);
        fileSystem.getPathMatcher("*");
    }

    @Test
    public void lockShouldSupportMultipleInnerLocksForTheSameThreadTest() throws IOException, GitAPIException {
        JGitFileSystemProvider fsProvider = (JGitFileSystemProvider)Mockito.mock(JGitFileSystemProvider.class);
        Git git = this.setupGit();
        JGitFileSystemImpl fileSystem = new JGitFileSystemImpl(fsProvider, null, git, this.createFSLock(git), "my-repo", CredentialsProvider.getDefault(), null, null);
        fileSystem.lock();
        fileSystem.lock();
        fileSystem.lock();
        fileSystem.unlock();
        fileSystem.unlock();
        fileSystem.unlock();
    }

    @Test
    public void lockTest() throws IOException, GitAPIException {
        Git git = this.setupGit();
        JGitFileSystemLock lock = this.createFSLock(git);
        JGitFileSystemLock lockSpy = (JGitFileSystemLock)Mockito.spy((Object)lock);
        lockSpy.lock();
        lockSpy.lock();
        lockSpy.lock();
        ((JGitFileSystemLock)Mockito.verify((Object)lockSpy, (VerificationMode)Mockito.times((int)1))).physicalLockOnFS();
        lockSpy.unlock();
        lockSpy.unlock();
        lockSpy.unlock();
        ((JGitFileSystemLock)Mockito.verify((Object)lockSpy, (VerificationMode)Mockito.times((int)1))).physicalUnLockOnFS();
    }

    @Test
    public void testSetPublicURI() throws IOException, GitAPIException {
        JGitFileSystemProvider fsProvider = (JGitFileSystemProvider)Mockito.mock(JGitFileSystemProvider.class);
        Git git = this.setupGit();
        JGitFileSystemImpl fileSystem = new JGitFileSystemImpl(fsProvider, new Maps.Builder().put((Object)"ssh", (Object)"localhost:8080/git").build(), git, this.createFSLock(git), "my-repo", CredentialsProvider.getDefault(), null, null);
        Assert.assertTrue((boolean)JGitFileSystemImplTest.checkProtocolPresent(fileSystem.toString(), "ssh"));
        Assert.assertFalse((boolean)JGitFileSystemImplTest.checkProtocolPresent(fileSystem.toString(), "http"));
        fileSystem.setPublicURI(new Maps.Builder().put((Object)"http", (Object)"localhost:8080/git").put((Object)"ssh", (Object)"localhost:8080/git").build());
        Assert.assertTrue((boolean)JGitFileSystemImplTest.checkProtocolPresent(fileSystem.toString(), "ssh"));
        Assert.assertTrue((boolean)JGitFileSystemImplTest.checkProtocolPresent(fileSystem.toString(), "http"));
    }

    static {
        CredentialsProvider.setDefault((CredentialsProvider)new UsernamePasswordCredentialsProvider("guest", ""));
    }
}

