/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.lib.Repository;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemLock;
import org.uberfire.java.nio.fs.jgit.util.Git;

@RunWith(value=MockitoJUnitRunner.class)
public class JGitFileSystemLockTest {
    @Test
    public void thresholdMaxTest() {
        long lastAccessThreshold = Long.MAX_VALUE;
        JGitFileSystemLock lock = this.createLock(lastAccessThreshold);
        lock.registerAccess();
        Assert.assertTrue((boolean)lock.hasBeenInUse());
    }

    @Test
    public void thresholdMinTest() {
        long lastAccessThreshold = Long.MIN_VALUE;
        JGitFileSystemLock lock = this.createLock(lastAccessThreshold);
        lock.registerAccess();
        lock.lock.lock();
        Assert.assertTrue((boolean)lock.hasBeenInUse());
        lock.lock.unlock();
        Assert.assertFalse((boolean)lock.hasBeenInUse());
    }

    private JGitFileSystemLock createLock(long lastAccessThreshold) {
        Git gitMock = (Git)Mockito.mock(Git.class);
        Repository repo = (Repository)Mockito.mock(Repository.class);
        File directory = (File)Mockito.mock(File.class);
        Mockito.when((Object)directory.toURI()).thenReturn((Object)URI.create(""));
        Mockito.when((Object)repo.getDirectory()).thenReturn((Object)directory);
        Mockito.when((Object)gitMock.getRepository()).thenReturn((Object)repo);
        return new JGitFileSystemLock(gitMock, TimeUnit.MILLISECONDS, lastAccessThreshold){

            Path createLockInfra(URI uri) {
                return (Path)Mockito.mock(Path.class);
            }
        };
    }
}

