/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.config.ConfigProperties;

public class JGitFileSystemProviderConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(JGitFileSystemProviderConfiguration.class);
    public static final String GIT_ENV_KEY_DEFAULT_REMOTE_NAME = "origin";
    public static final String GIT_ENV_KEY_BRANCH_LIST = "branches";
    public static final String GIT_ENV_KEY_SUBDIRECTORY = "subdirectory";
    public static final String GIT_DAEMON_ENABLED = "org.uberfire.nio.git.daemon.enabled";
    public static final String GIT_SSH_ENABLED = "org.uberfire.nio.git.ssh.enabled";
    public static final String GIT_HTTP_ENABLED = "org.uberfire.nio.git.http.enabled";
    public static final String GIT_HTTPS_ENABLED = "org.uberfire.nio.git.https.enabled";
    public static final String GIT_NIO_DIR = "org.uberfire.nio.git.dir";
    public static final String GIT_NIO_DIR_NAME = "org.uberfire.nio.git.dirname";
    public static final String ENABLE_GIT_KETCH = "org.uberfire.nio.git.ketch";
    public static final String HOOK_DIR = "org.uberfire.nio.git.hooks";
    public static final String GIT_HTTP_HOST = "org.uberfire.nio.git.http.host";
    public static final String GIT_HTTP_HOSTNAME = "org.uberfire.nio.git.http.hostname";
    public static final String GIT_HTTP_PORT = "org.uberfire.nio.git.http.port";
    public static final String GIT_HTTPS_HOST = "org.uberfire.nio.git.https.host";
    public static final String GIT_HTTPS_HOSTNAME = "org.uberfire.nio.git.https.hostname";
    public static final String GIT_HTTPS_PORT = "org.uberfire.nio.git.https.port";
    public static final String GIT_DAEMON_HOST = "org.uberfire.nio.git.daemon.host";
    public static final String GIT_DAEMON_HOSTNAME = "org.uberfire.nio.git.daemon.hostname";
    public static final String GIT_DAEMON_PORT = "org.uberfire.nio.git.daemon.port";
    public static final String GIT_SSH_HOST = "org.uberfire.nio.git.ssh.host";
    public static final String GIT_SSH_HOSTNAME = "org.uberfire.nio.git.ssh.hostname";
    public static final String GIT_SSH_PORT = "org.uberfire.nio.git.ssh.port";
    public static final String GIT_SSH_CERT_DIR = "org.uberfire.nio.git.ssh.cert.dir";
    public static final String GIT_SSH_IDLE_TIMEOUT = "org.uberfire.nio.git.ssh.idle.timeout";
    public static final String GIT_SSH_ALGORITHM = "org.uberfire.nio.git.ssh.algorithm";
    public static final String GIT_SSH_PASSPHRASE = "org.uberfire.nio.git.ssh.passphrase";
    public static final String GIT_GC_LIMIT = "org.uberfire.nio.git.gc.limit";
    public static final String GIT_HTTP_SSL_VERIFY = "org.uberfire.nio.git.http.sslVerify";
    public static final String PROXY_TYPE = "org.uberfire.nio.git.proxy.type";
    public static final String SSH_OVER_HTTP = "org.uberfire.nio.git.proxy.ssh.over.http";
    public static final String HTTP_PROXY_HOST = "http.proxyHost";
    public static final String HTTP_PROXY_PORT = "http.proxyPort";
    public static final String HTTP_PROXY_USER = "http.proxyUser";
    public static final String HTTP_PROXY_PASSWORD = "http.proxyPassword";
    public static final String SSH_OVER_HTTPS = "org.uberfire.nio.git.proxy.ssh.over.https";
    public static final String HTTPS_PROXY_HOST = "https.proxyHost";
    public static final String HTTPS_PROXY_PORT = "https.proxyPort";
    public static final String HTTPS_PROXY_USER = "https.proxyUser";
    public static final String HTTPS_PROXY_PASSWORD = "https.proxyPassword";
    public static final String USER_DIR = "user.dir";
    public static final String JGIT_CACHE_INSTANCES = "org.uberfire.nio.jgit.cache.instances";
    public static final String JGIT_CACHE_OVERFLOW_CLEANUP_SIZE = "org.uberfire.nio.jgit.cache.overflow.cleanup.size";
    public static final String JGIT_REMOVE_ELDEST_ENTRY_ITERATIONS = "org.uberfire.nio.jgit.remove.eldest.iterations";
    public static final String JGIT_CACHE_EVICT_THRESHOLD_DURATION = "org.uberfire.nio.jgit.cache.evict.threshold.duration";
    public static final String JGIT_CACHE_EVICT_THRESHOLD_TIME_UNIT = "org.uberfire.nio.jgit.cache.evict.threshold.time.unit";
    public static final String GIT_ENV_KEY_DEST_PATH = "out-dir";
    public static final String GIT_ENV_KEY_USER_NAME = "username";
    public static final String GIT_ENV_KEY_PASSWORD = "password";
    public static final String GIT_ENV_KEY_INIT = "init";
    public static final String GIT_ENV_KEY_MIRROR = "mirror";
    public static final String SCHEME = "git";
    public static final String GIT_SSH_CIPHERS = "org.uberfire.nio.git.ssh.ciphers";
    public static final String GIT_SSH_MACS = "org.uberfire.nio.git.ssh.macs";
    public static final int SCHEME_SIZE = "git://".length();
    public static final int DEFAULT_SCHEME_SIZE = "default://".length();
    public static final String DEFAULT_HOST_NAME = "localhost";
    public static final String REPOSITORIES_CONTAINER_DIR = ".niogit";
    public static final String SSH_FILE_CERT_CONTAINER_DIR = ".security";
    public static final String DEFAULT_SSH_OVER_HTTP = "false";
    public static final String DEFAULT_PROXY_TYPE = "http";
    public static final String DEFAULT_SSH_OVER_HTTPS = "false";
    public static final String DEFAULT_HOST_ADDR = "127.0.0.1";
    public static final String DEFAULT_DAEMON_DEFAULT_ENABLED = "false";
    public static final String DEFAULT_DAEMON_DEFAULT_PORT = "9418";
    public static final String DEFAULT_SSH_ENABLED = "true";
    public static final String DEFAULT_HTTP_ENABLED = "true";
    public static final String DEFAULT_HTTPS_ENABLED = "false";
    public static final String DEFAULT_HTTP_PORT = "8080";
    public static final String DEFAULT_HTTPS_PORT = "8443";
    public static final String DEFAULT_SSH_PORT = "8001";
    public static final String DEFAULT_SSH_IDLE_TIMEOUT = "10000";
    public static final String DEFAULT_SSH_ALGORITHM = "RSA";
    public static final String DEFAULT_SSH_CERT_PASSPHRASE = "";
    public static final String DEFAULT_COMMIT_LIMIT_TO_GC = "20";
    public static final Boolean DEFAULT_GIT_HTTP_SSL_VERIFY = Boolean.TRUE;
    public static final String DEFAULT_ENABLE_GIT_KETCH = "false";
    public static final String DEFAULT_JGIT_FILE_SYSTEM_INSTANCES_CACHE = "10000";
    public static final String DEFAULT_JGIT_REMOVE_ELDEST_ENTRY_ITERATIONS = "10";
    public static final String DEFAULT_JGIT_CACHE_OVERFLOW_CLEANUP_SIZE = "10";
    public static final String DEFAULT_JGIT_CACHE_EVICT_THRESHOLD_DURATION = "5";
    public static final TimeUnit DEFAULT_JGIT_CACHE_EVICT_THRESHOLD_TIME_UNIT = TimeUnit.MINUTES;
    private int commitLimit;
    private boolean sslVerify;
    private boolean daemonEnabled;
    private int daemonPort;
    private String daemonHostAddr;
    private String daemonHostName;
    private boolean sshEnabled;
    private int sshPort;
    private String sshHostAddr;
    private String sshHostName;
    private File sshFileCertDir;
    private String sshAlgorithm;
    private String sshPassphrase;
    private String sshIdleTimeout;
    private String gitSshCiphers;
    private String gitSshMACs;
    private boolean httpEnabled;
    private int httpPort;
    private String httpHostAddr;
    private String httpHostName;
    private boolean httpsEnabled;
    private int httpsPort;
    private String httpsHostAddr;
    private String httpsHostName;
    private File gitReposParentDir;
    private File hookDir;
    boolean enableKetch = false;
    private String proxyType;
    private boolean sshOverHttpProxy;
    private String httpProxyHost;
    private int httpProxyPort;
    private String httpProxyUser;
    private String httpProxyPassword;
    private boolean sshOverHttpsProxy;
    private String httpsProxyHost;
    private int httpsProxyPort;
    private String httpsProxyUser;
    private String httpsProxyPassword;
    private int jgitFileSystemsInstancesCache;
    private int jgitCacheOverflowCleanupSize;
    private int jgitRemoveEldestEntryIterations;
    private long jgitCacheEvictThresholdDuration;
    private TimeUnit jgitCacheEvictThresholdTimeUnit;

    public void load(ConfigProperties systemConfig) {
        LOG.debug("Configuring from properties:");
        String currentDirectory = System.getProperty(USER_DIR);
        ConfigProperties.ConfigProperty enableKetchProp = systemConfig.get(ENABLE_GIT_KETCH, "false");
        ConfigProperties.ConfigProperty hookDirProp = systemConfig.get(HOOK_DIR, null);
        ConfigProperties.ConfigProperty bareReposDirProp = systemConfig.get(GIT_NIO_DIR, currentDirectory);
        ConfigProperties.ConfigProperty reposDirNameProp = systemConfig.get(GIT_NIO_DIR_NAME, REPOSITORIES_CONTAINER_DIR);
        ConfigProperties.ConfigProperty enabledProp = systemConfig.get(GIT_DAEMON_ENABLED, "false");
        ConfigProperties.ConfigProperty hostProp = systemConfig.get(GIT_DAEMON_HOST, DEFAULT_HOST_ADDR);
        ConfigProperties.ConfigProperty hostNameProp = systemConfig.get(GIT_DAEMON_HOSTNAME, hostProp.isDefault() ? DEFAULT_HOST_NAME : hostProp.getValue());
        ConfigProperties.ConfigProperty portProp = systemConfig.get(GIT_DAEMON_PORT, DEFAULT_DAEMON_DEFAULT_PORT);
        ConfigProperties.ConfigProperty httpEnabledProp = systemConfig.get(GIT_HTTP_ENABLED, "true");
        ConfigProperties.ConfigProperty httpHostProp = systemConfig.get(GIT_HTTP_HOST, DEFAULT_HOST_ADDR);
        ConfigProperties.ConfigProperty httpHostNameProp = systemConfig.get(GIT_HTTP_HOSTNAME, httpHostProp.isDefault() ? DEFAULT_HOST_NAME : httpHostProp.getValue());
        ConfigProperties.ConfigProperty httpPortProp = systemConfig.get(GIT_HTTP_PORT, DEFAULT_HTTP_PORT);
        ConfigProperties.ConfigProperty httpsEnabledProp = systemConfig.get(GIT_HTTPS_ENABLED, "false");
        ConfigProperties.ConfigProperty httpsHostProp = systemConfig.get(GIT_HTTPS_HOST, DEFAULT_HOST_ADDR);
        ConfigProperties.ConfigProperty httpsHostNameProp = systemConfig.get(GIT_HTTPS_HOSTNAME, httpHostProp.isDefault() ? DEFAULT_HOST_NAME : httpHostProp.getValue());
        ConfigProperties.ConfigProperty httpsPortProp = systemConfig.get(GIT_HTTPS_PORT, DEFAULT_HTTPS_PORT);
        ConfigProperties.ConfigProperty sshEnabledProp = systemConfig.get(GIT_SSH_ENABLED, "true");
        ConfigProperties.ConfigProperty sshHostProp = systemConfig.get(GIT_SSH_HOST, DEFAULT_HOST_ADDR);
        ConfigProperties.ConfigProperty sshHostNameProp = systemConfig.get(GIT_SSH_HOSTNAME, sshHostProp.isDefault() ? DEFAULT_HOST_NAME : sshHostProp.getValue());
        ConfigProperties.ConfigProperty sshPortProp = systemConfig.get(GIT_SSH_PORT, DEFAULT_SSH_PORT);
        ConfigProperties.ConfigProperty sshCertDirProp = systemConfig.get(GIT_SSH_CERT_DIR, currentDirectory);
        ConfigProperties.ConfigProperty sshIdleTimeoutProp = systemConfig.get(GIT_SSH_IDLE_TIMEOUT, "10000");
        ConfigProperties.ConfigProperty sshAlgorithmProp = systemConfig.get(GIT_SSH_ALGORITHM, DEFAULT_SSH_ALGORITHM);
        ConfigProperties.ConfigProperty sshPassphraseProp = systemConfig.get(GIT_SSH_PASSPHRASE, DEFAULT_SSH_CERT_PASSPHRASE);
        ConfigProperties.ConfigProperty commitLimitProp = systemConfig.get(GIT_GC_LIMIT, DEFAULT_COMMIT_LIMIT_TO_GC);
        ConfigProperties.ConfigProperty sslVerifyProp = systemConfig.get(GIT_HTTP_SSL_VERIFY, DEFAULT_GIT_HTTP_SSL_VERIFY.toString());
        ConfigProperties.ConfigProperty sshOverHttpProxyProp = systemConfig.get(SSH_OVER_HTTP, "false");
        ConfigProperties.ConfigProperty proxyTypeProp = systemConfig.get(PROXY_TYPE, DEFAULT_PROXY_TYPE);
        ConfigProperties.ConfigProperty httpProxyHostProp = systemConfig.get(HTTP_PROXY_HOST, null);
        ConfigProperties.ConfigProperty httpProxyPortProp = systemConfig.get(HTTP_PROXY_PORT, null);
        ConfigProperties.ConfigProperty httpProxyUserProp = systemConfig.get(HTTP_PROXY_USER, null);
        ConfigProperties.ConfigProperty httpProxyPasswordProp = systemConfig.get(HTTP_PROXY_PASSWORD, null);
        ConfigProperties.ConfigProperty sshOverHttpsProxyProp = systemConfig.get(SSH_OVER_HTTPS, "false");
        ConfigProperties.ConfigProperty httpsProxyHostProp = systemConfig.get(HTTPS_PROXY_HOST, null);
        ConfigProperties.ConfigProperty httpsProxyPortProp = systemConfig.get(HTTPS_PROXY_PORT, null);
        ConfigProperties.ConfigProperty httpsProxyUserProp = systemConfig.get(HTTPS_PROXY_USER, null);
        ConfigProperties.ConfigProperty httpsProxyPasswordProp = systemConfig.get(HTTPS_PROXY_PASSWORD, null);
        ConfigProperties.ConfigProperty jgitFileSystemsInstancesCacheProp = systemConfig.get(JGIT_CACHE_INSTANCES, "10000");
        ConfigProperties.ConfigProperty jgitFileSystemsCacheOverflowSizePropCacheProp = systemConfig.get(JGIT_CACHE_OVERFLOW_CLEANUP_SIZE, "10");
        ConfigProperties.ConfigProperty jgitRemoveEldestEntryIterationsProp = systemConfig.get(JGIT_REMOVE_ELDEST_ENTRY_ITERATIONS, "10");
        ConfigProperties.ConfigProperty jgitCacheEvictThresoldDurationProp = systemConfig.get(JGIT_CACHE_EVICT_THRESHOLD_DURATION, DEFAULT_JGIT_CACHE_EVICT_THRESHOLD_DURATION);
        ConfigProperties.ConfigProperty jgitCacheEvictThresoldTimeUnitProp = systemConfig.get(JGIT_CACHE_EVICT_THRESHOLD_TIME_UNIT, DEFAULT_JGIT_CACHE_EVICT_THRESHOLD_TIME_UNIT.name());
        ConfigProperties.ConfigProperty jgitSshCiphers = systemConfig.get(GIT_SSH_CIPHERS, null);
        ConfigProperties.ConfigProperty jgitSshMacs = systemConfig.get(GIT_SSH_MACS, null);
        this.gitSshCiphers = jgitSshCiphers.getValue();
        this.gitSshMACs = jgitSshMacs.getValue();
        this.sshOverHttpProxy = sshOverHttpProxyProp.getBooleanValue();
        this.proxyType = proxyTypeProp.getValue();
        if (this.sshOverHttpProxy) {
            this.httpProxyHost = httpProxyHostProp.getValue();
            this.httpProxyPort = httpProxyPortProp.getIntValue();
        }
        this.httpProxyUser = httpProxyUserProp.getValue();
        this.httpProxyPassword = httpProxyPasswordProp.getValue();
        this.sshOverHttpsProxy = sshOverHttpsProxyProp.getBooleanValue();
        if (this.sshOverHttpsProxy) {
            this.httpsProxyHost = httpsProxyHostProp.getValue();
            this.httpsProxyPort = httpsProxyPortProp.getIntValue();
        }
        this.httpsProxyUser = httpsProxyUserProp.getValue();
        this.httpsProxyPassword = httpsProxyPasswordProp.getValue();
        if (LOG.isDebugEnabled()) {
            LOG.debug(systemConfig.getConfigurationSummary("Summary of JGit configuration:"));
        }
        if (enableKetchProp != null && enableKetchProp.getValue() != null) {
            this.enableKetch = enableKetchProp.getBooleanValue();
        }
        if (hookDirProp != null && hookDirProp.getValue() != null) {
            this.hookDir = new File(hookDirProp.getValue());
            if (!this.hookDir.exists()) {
                this.hookDir = null;
            }
        }
        this.gitReposParentDir = new File(bareReposDirProp.getValue(), reposDirNameProp.getValue());
        this.commitLimit = commitLimitProp.getIntValue();
        this.sslVerify = sslVerifyProp.getBooleanValue();
        this.jgitFileSystemsInstancesCache = jgitFileSystemsInstancesCacheProp.getIntValue();
        if (this.jgitFileSystemsInstancesCache < 1) {
            this.jgitFileSystemsInstancesCache = Integer.valueOf("10000");
        }
        this.jgitCacheOverflowCleanupSize = jgitFileSystemsCacheOverflowSizePropCacheProp.getIntValue();
        if (this.jgitCacheOverflowCleanupSize < 1) {
            this.jgitCacheOverflowCleanupSize = Integer.valueOf("10");
        }
        this.jgitRemoveEldestEntryIterations = jgitRemoveEldestEntryIterationsProp.getIntValue();
        if (this.jgitRemoveEldestEntryIterations < 1) {
            this.jgitRemoveEldestEntryIterations = Integer.valueOf("10");
        }
        this.jgitCacheEvictThresholdDuration = Long.valueOf(jgitCacheEvictThresoldDurationProp.getValue());
        if (this.jgitCacheEvictThresholdDuration < 1L) {
            this.jgitCacheEvictThresholdDuration = Integer.valueOf(DEFAULT_JGIT_CACHE_EVICT_THRESHOLD_DURATION).intValue();
        }
        try {
            this.jgitCacheEvictThresholdTimeUnit = TimeUnit.valueOf(jgitCacheEvictThresoldTimeUnitProp.getValue());
        }
        catch (IllegalArgumentException e) {
            String validValues = Stream.of(TimeUnit.values()).map(Enum::toString).collect(Collectors.joining(","));
            LOG.warn("Failed to parse TimeUnit from {}={}. Valid values are {}. Using default instead: {}", new Object[]{JGIT_CACHE_EVICT_THRESHOLD_TIME_UNIT, this.jgitCacheEvictThresholdTimeUnit, validValues, DEFAULT_JGIT_CACHE_EVICT_THRESHOLD_TIME_UNIT});
            this.jgitCacheEvictThresholdTimeUnit = DEFAULT_JGIT_CACHE_EVICT_THRESHOLD_TIME_UNIT;
        }
        this.daemonEnabled = enabledProp.getBooleanValue();
        if (this.daemonEnabled) {
            this.daemonPort = portProp.getIntValue();
            this.daemonHostAddr = hostProp.getValue();
            this.daemonHostName = hostNameProp.getValue();
        }
        this.sshEnabled = sshEnabledProp.getBooleanValue();
        if (this.sshEnabled) {
            this.sshPort = sshPortProp.getIntValue();
            this.sshHostAddr = sshHostProp.getValue();
            this.sshHostName = sshHostNameProp.getValue();
            this.sshFileCertDir = new File(sshCertDirProp.getValue(), SSH_FILE_CERT_CONTAINER_DIR);
            this.sshAlgorithm = sshAlgorithmProp.getValue();
            this.sshIdleTimeout = sshIdleTimeoutProp.getValue();
            try {
                Integer.valueOf(this.sshIdleTimeout);
            }
            catch (NumberFormatException exception) {
                LOG.error("SSH Idle Timeout value is not a valid integer - Parameter is ignored, now using default value.");
                this.sshIdleTimeout = "10000";
            }
        }
        this.sshPassphrase = sshPassphraseProp.getValue();
        this.httpEnabled = httpEnabledProp.getBooleanValue();
        if (this.httpEnabled) {
            this.httpPort = httpPortProp.getIntValue();
            this.httpHostAddr = httpHostProp.getValue();
            this.httpHostName = httpHostNameProp.getValue();
        }
        this.httpsEnabled = httpsEnabledProp.getBooleanValue();
        if (this.httpsEnabled) {
            this.httpsPort = httpsPortProp.getIntValue();
            this.httpsHostAddr = httpsHostProp.getValue();
            this.httpsHostName = httpsHostNameProp.getValue();
        }
    }

    public boolean httpProxyIsDefined() {
        return this.httpProxyUser != null && this.httpProxyPassword != null || this.httpsProxyUser != null && this.httpsProxyPassword != null;
    }

    public int getCommitLimit() {
        return this.commitLimit;
    }

    public boolean isSslVerify() {
        return this.sslVerify;
    }

    public boolean isDaemonEnabled() {
        return this.daemonEnabled;
    }

    public int getDaemonPort() {
        return this.daemonPort;
    }

    public String getDaemonHostAddr() {
        return this.daemonHostAddr;
    }

    public String getDaemonHostName() {
        return this.daemonHostName;
    }

    public boolean isSshEnabled() {
        return this.sshEnabled;
    }

    public int getSshPort() {
        return this.sshPort;
    }

    public String getSshHostAddr() {
        return this.sshHostAddr;
    }

    public String getSshHostName() {
        return this.sshHostName;
    }

    public File getSshFileCertDir() {
        return this.sshFileCertDir;
    }

    public String getSshAlgorithm() {
        return this.sshAlgorithm;
    }

    public String getSshPassphrase() {
        return this.sshPassphrase;
    }

    public String getSshIdleTimeout() {
        return this.sshIdleTimeout;
    }

    public File getGitReposParentDir() {
        return this.gitReposParentDir;
    }

    public File getHookDir() {
        return this.hookDir;
    }

    public boolean isEnableKetch() {
        return this.enableKetch;
    }

    public String getProxyType() {
        return this.proxyType;
    }

    public boolean isSshOverHttpProxy() {
        return this.sshOverHttpProxy;
    }

    public String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    public int getHttpProxyPort() {
        return this.httpProxyPort;
    }

    public String getHttpProxyUser() {
        return this.httpProxyUser;
    }

    public String getHttpProxyPassword() {
        return this.httpProxyPassword;
    }

    public boolean isSshOverHttpsProxy() {
        return this.sshOverHttpsProxy;
    }

    public String getHttpsProxyHost() {
        return this.httpsProxyHost;
    }

    public int getHttpsProxyPort() {
        return this.httpsProxyPort;
    }

    public String getHttpsProxyUser() {
        return this.httpsProxyUser;
    }

    public String getHttpsProxyPassword() {
        return this.httpsProxyPassword;
    }

    public boolean isHttpEnabled() {
        return this.httpEnabled;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public String getHttpHostAddr() {
        return this.httpHostAddr;
    }

    public String getHttpHostName() {
        return this.httpHostName;
    }

    public boolean isHttpsEnabled() {
        return this.httpsEnabled;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    public String getHttpsHostAddr() {
        return this.httpsHostAddr;
    }

    public String getHttpsHostName() {
        return this.httpsHostName;
    }

    public int getJgitFileSystemsInstancesCache() {
        return this.jgitFileSystemsInstancesCache;
    }

    public int getJgitCacheOverflowCleanupSize() {
        return this.jgitCacheOverflowCleanupSize;
    }

    public int getJgitRemoveEldestEntryIterations() {
        return this.jgitRemoveEldestEntryIterations;
    }

    public TimeUnit getDefaultJgitCacheEvictThresholdTimeUnit() {
        return this.jgitCacheEvictThresholdTimeUnit;
    }

    public long getJgitCacheEvictThresholdDuration() {
        return this.jgitCacheEvictThresholdDuration;
    }

    public String getGitSshCiphers() {
        return this.gitSshCiphers;
    }

    public String getGitSshMACs() {
        return this.gitSshMACs;
    }
}

