/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.sshd.core.CoreModuleProperties;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.api.identity.UserImpl;
import org.jboss.errai.security.shared.service.AuthenticationService;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.extensions.FileSystemHookExecutionContext;
import org.uberfire.java.nio.file.extensions.FileSystemHooks;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.UsernamePasswordCredentialsProvider;
import org.uberfire.java.nio.fs.jgit.util.commands.Commit;

public class JGitFileSystemImplProviderSSHTest
extends AbstractTestInfra {
    private int gitSSHPort;
    private int gitPort;

    @Override
    public Map<String, String> getGitPreferences() {
        Map<String, String> gitPrefs = super.getGitPreferences();
        gitPrefs.put("org.uberfire.nio.git.daemon.enabled", "true");
        this.gitPort = JGitFileSystemImplProviderSSHTest.findFreePort();
        gitPrefs.put("org.uberfire.nio.git.daemon.port", String.valueOf(this.gitPort));
        gitPrefs.put("org.uberfire.nio.git.ssh.enabled", "true");
        this.gitSSHPort = JGitFileSystemImplProviderSSHTest.findFreePort();
        gitPrefs.put("org.uberfire.nio.git.ssh.port", String.valueOf(this.gitSSHPort));
        gitPrefs.put("org.uberfire.nio.git.ssh.idle.timeout", "10001");
        return gitPrefs;
    }

    @Test
    public void testSSHPostReceiveHook() throws IOException {
        final FileSystemHooks.FileSystemHook hook = (FileSystemHooks.FileSystemHook)Mockito.spy((Object)new FileSystemHooks.FileSystemHook(){

            public void execute(FileSystemHookExecutionContext context) {
                Assert.assertEquals((Object)"repo", (Object)context.getFsName());
            }
        });
        Assume.assumeFalse((String)"UF-511", (boolean)System.getProperty("java.vendor").equals("IBM Corporation"));
        this.provider.setJAASAuthenticator(new AuthenticationService(){
            private User user;

            public User login(String s, String s1) {
                this.user = new UserImpl(s);
                return this.user;
            }

            public boolean isLoggedIn() {
                return this.user != null;
            }

            public void logout() {
                this.user = null;
            }

            public User getUser() {
                return this.user;
            }
        });
        this.provider.setAuthorizer((fs, fileSystemUser) -> true);
        CredentialsProvider.setDefault((CredentialsProvider)new UsernamePasswordCredentialsProvider("admin", ""));
        Assert.assertEquals((Object)"10001", this.provider.getGitSSHService().getProperties().get(CoreModuleProperties.IDLE_TIMEOUT.getName()));
        URI originRepo = URI.create("git://repo");
        JGitFileSystem origin = (JGitFileSystem)this.provider.newFileSystem(originRepo, (Map)new HashMap<String, Object>(){
            {
                this.put(FileSystemHooks.ExternalUpdate.name(), hook);
            }
        });
        new Commit(origin.getGit(), "main", "user1", "user1@example.com", "commitx", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file-name.txt", AbstractTestInfra.tempFile("temp1"));
            }
        }).execute();
        JGitFileSystem clone = (JGitFileSystem)this.provider.newFileSystem(URI.create("git://repo-clone"), (Map)new HashMap<String, Object>(){
            {
                this.put("init", "true");
                this.put("origin", "ssh://admin@localhost:" + JGitFileSystemImplProviderSSHTest.this.gitSSHPort + "/repo");
            }
        });
        Assert.assertNotNull((Object)clone);
        this.provider.getFileSystem(URI.create("git://repo-clone?push=ssh://admin@localhost:" + this.gitSSHPort + "/repo"));
        ArgumentCaptor captor = ArgumentCaptor.forClass(FileSystemHookExecutionContext.class);
        ((FileSystemHooks.FileSystemHook)Mockito.verify((Object)hook)).execute((FileSystemHookExecutionContext)captor.capture());
        ((ObjectAssert)Assertions.assertThat((Object)((FileSystemHookExecutionContext)captor.getValue())).isNotNull()).hasFieldOrPropertyWithValue("fsName", (Object)"repo");
    }

    @Test
    public void testGitProtocolReadOnly() throws IOException {
        URI originRepo = URI.create("git://repo");
        JGitFileSystem origin = (JGitFileSystem)this.provider.newFileSystem(originRepo, (Map)new HashMap<String, Object>(){
            {
                this.put("init", "true");
            }
        });
        new Commit(origin.getGit(), "main", "user1", "user1@example.com", "commitx", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file-name.txt", AbstractTestInfra.tempFile("temp1"));
            }
        }).execute();
        JGitFileSystem clone = (JGitFileSystem)this.provider.newFileSystem(URI.create("git://repo-clone"), (Map)new HashMap<String, Object>(){
            {
                this.put("init", "true");
                this.put("origin", "git://localhost:" + JGitFileSystemImplProviderSSHTest.this.gitPort + "/repo");
            }
        });
        Files.write((Path)clone.getPath("/home/file.txt", new String[0]), (byte[])"test".getBytes(), (OpenOption[])new OpenOption[0]);
        try {
            this.provider.getFileSystem(URI.create("git://repo-clone?push=git://localhost:" + this.gitPort + "/repo"));
            Assert.fail((String)"should fail");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.provider.getFileSystem(URI.create("git://repo-clone?ssh=git://localhost:" + this.gitSSHPort + "/repo"));
        }
        catch (Throwable ex) {
            Assert.fail((String)"should not fail");
        }
        Assert.assertNotNull((Object)clone);
    }
}

