/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.cloud;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.openshift.client.OpenShiftClient;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.fs.cloud.CloudClientFactory;

public class CloudClientFactoryTest {
    @Test(expected=IllegalStateException.class)
    public void testSetupConfig() {
        new CloudClientFactory(){}.setupConfig();
    }

    @Test
    public void testExecuteCloudFunction() {
        System.setProperty("kubernetes.master", "https://127.0.0.1:8443");
        System.setProperty("kubernetes.auth.token", "dummy");
        Assertions.assertThat((Optional)new CloudClientFactory(){}.executeCloudFunction(client -> OpenShiftClient.class, OpenShiftClient.class)).containsSame(OpenShiftClient.class);
        Assertions.assertThat((Optional)new CloudClientFactory(){}.executeCloudFunction(client -> KubernetesClient.class, KubernetesClient.class)).containsSame(KubernetesClient.class);
        Assertions.assertThat((Optional)new CloudClientFactory(){}.executeCloudFunction(client -> null, KubernetesClient.class)).isEmpty();
        Assertions.assertThat((Optional)new CloudClientFactory(){}.executeCloudFunction(client -> "", KubernetesClient.class)).isNotEmpty();
        Assertions.assertThatThrownBy(() -> new CloudClientFactory(){}.executeCloudFunction(client -> {
            throw new UnsupportedOperationException();
        }, KubernetesClient.class)).isInstanceOf(UnsupportedOperationException.class);
        Assertions.assertThatThrownBy(() -> new CloudClientFactory(){}.executeCloudFunction(client -> {
            throw new IllegalStateException();
        }, KubernetesClient.class)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> new CloudClientFactory(){}.executeCloudFunction(client -> {
            throw new IndexOutOfBoundsException();
        }, KubernetesClient.class)).isInstanceOf(IOException.class);
        System.clearProperty("kubernetes.master");
        System.clearProperty("kubernetes.auth.token");
    }
}

