/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.k8s;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.fs.k8s.SeekableInMemoryByteChannel;

public class SeekableInMemoryByteChannelTestCase {
    private static final Logger log = Logger.getLogger(SeekableInMemoryByteChannelTestCase.class.getName());
    private static final String CONTENTS_SMALLER_BUFFER = "Small";
    private static final String CONTENTS_BIGGER_BUFFER = "Large............";
    private static final String UTF8 = "UTF-8";
    private SeekableInMemoryByteChannel channel;
    private ByteBuffer smallerBuffer;
    private ByteBuffer biggerBuffer;

    @Before
    public void init() throws UnsupportedEncodingException {
        this.channel = new SeekableInMemoryByteChannel();
        this.smallerBuffer = ByteBuffer.wrap(CONTENTS_SMALLER_BUFFER.getBytes(UTF8));
        this.biggerBuffer = ByteBuffer.wrap(CONTENTS_BIGGER_BUFFER.getBytes(UTF8));
    }

    @After
    public void closeChannel() throws IOException {
        if (this.channel.isOpen()) {
            this.channel.close();
        }
    }

    @Test(expected=IOException.class)
    public void readAfterCloseThrowsException() throws IOException {
        this.channel.close();
        this.channel.read(ByteBuffer.wrap(new byte[0]));
    }

    @Test(expected=IOException.class)
    public void writeAfterCloseThrowsException() throws IOException {
        this.channel.close();
        this.channel.write(ByteBuffer.wrap(new byte[0]));
    }

    @Test
    public void isOpenTrue() throws IOException {
        Assert.assertTrue((String)"Channel should report open before it's closed", (boolean)this.channel.isOpen());
    }

    @Test
    public void isOpenFalseAfterClose() throws IOException {
        this.channel.close();
        Assert.assertFalse((String)"Channel should report not open after close", (boolean)this.channel.isOpen());
    }

    @Test
    public void positionInit0() throws IOException {
        Assert.assertEquals((String)"Channel should init to position 0", (long)0L, (long)this.channel.position());
    }

    @Test
    public void sizeInit0() throws IOException {
        Assert.assertEquals((String)"Channel should init to size 0", (long)0L, (long)this.channel.size());
    }

    @Test(expected=IllegalArgumentException.class)
    public void readRequiresBuffer() throws IOException {
        this.channel.read(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void writeRequiresBuffer() throws IOException {
        this.channel.write(null);
    }

    @Test
    public void read() throws IOException, java.io.IOException {
        this.channel.write(this.smallerBuffer);
        int newPosition = 2;
        byte[] contents = new byte[2];
        int numBytesRead = this.channel.position(2L).read(ByteBuffer.wrap(contents));
        String expected = "al";
        String contentsRead = new String(contents, UTF8);
        Assert.assertEquals((String)"Read should report correct number of bytes read", (long)contents.length, (long)numBytesRead);
        Assert.assertEquals((String)"Channel should respect explicit position during reads", (Object)"al", (Object)contentsRead);
    }

    @Test
    public void getContent() throws IOException, java.io.IOException {
        this.channel.write(this.smallerBuffer);
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.channel.getContent()));
        String contents = reader.readLine();
        Assert.assertEquals((String)"Contents read were not as expected", (Object)CONTENTS_SMALLER_BUFFER, (Object)contents);
    }

    @Test
    public void readDestinationBiggerThanChannel() throws IOException, java.io.IOException {
        this.channel.write(this.smallerBuffer);
        ByteBuffer destination = this.biggerBuffer;
        Assert.assertTrue((String)"Test setup incorrect, should be trying to read into a buffer greater than our size", ((long)destination.remaining() > this.channel.size() ? 1 : 0) != 0);
        int numBytesRead = this.channel.position(0L).read(destination);
        Assert.assertEquals((String)"Read to a buffer greater than our size should read only up to our size", (long)this.channel.size(), (long)numBytesRead);
    }

    @Test
    public void nothingToRead() throws IOException, java.io.IOException {
        this.channel.write(this.smallerBuffer);
        int numBytesRead = this.channel.position(this.channel.size() + 3L).read(ByteBuffer.wrap(new byte[1]));
        Assert.assertEquals((String)"Read on position > size should return -1", (long)-1L, (long)numBytesRead);
    }

    @Test
    public void write() throws IOException, java.io.IOException {
        this.channel.write(this.smallerBuffer);
        int newPosition = 2;
        int numBytesWritten = this.channel.position(2L).write(ByteBuffer.wrap("DR".getBytes(UTF8)));
        byte[] contents = new byte[2];
        this.channel.position(2L).read(ByteBuffer.wrap(contents));
        String expected = "DR";
        String read = new String(contents, UTF8);
        Assert.assertEquals((String)"Write should report correct number of bytes written", (long)2L, (long)numBytesWritten);
        Assert.assertEquals((String)"Channel should respect explicit position during writes", (Object)"DR", (Object)read);
    }

    @Test
    public void writeWithPositionPastSize() throws IOException, java.io.IOException {
        this.channel.write(this.smallerBuffer);
        this.smallerBuffer.clear();
        int gap = 5;
        this.channel.position(this.channel.size() + 5L).write(this.smallerBuffer);
        this.smallerBuffer.clear();
        Assert.assertEquals((String)"Channel size should be equal to the size of the writes we put in, plus the gap when we set the position tpo be greater than the size", (long)(this.smallerBuffer.remaining() * 2 + 5), (long)this.channel.size());
    }

    @Test
    public void positionSetPastSize() throws IOException {
        int newPosition = 30;
        this.channel.position(30L);
        Assert.assertEquals((String)"Channel should be able to be set past size", (long)30L, (long)this.channel.position());
    }

    @Test(expected=IllegalArgumentException.class)
    public void negativePositionProhibited() throws IOException {
        this.channel.position(-1L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void exceedMaxIntegerPositionProhibited() throws IOException {
        long newPosition = 0x80000000L;
        Assert.assertTrue((String)"Didn't set up new position to be out of int bounds", (boolean)true);
        this.channel.position(0x80000000L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void negativeTruncateProhibited() throws IOException {
        this.channel.truncate(-1L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void exceedMaxIntegerTruncateProhibited() throws IOException {
        long truncateValue = 0x80000000L;
        Assert.assertTrue((String)"Didn't set up new truncate to be out of int bounds", (boolean)true);
        this.channel.truncate(0x80000000L);
    }

    @Test
    public void size() throws IOException {
        this.channel.write(this.smallerBuffer);
        Assert.assertEquals((String)"Channel should report correct size", (long)this.smallerBuffer.clear().remaining(), (long)this.channel.size());
    }

    @Test
    public void truncate() throws IOException {
        this.channel.write(this.smallerBuffer);
        int newSize = (int)this.channel.size() - 3;
        this.channel.truncate((long)newSize);
        Assert.assertEquals((String)"Channel should report correct size after truncate", (long)newSize, (long)this.channel.size());
        Assert.assertEquals((String)"Channel should report adjusted position after truncate", (long)newSize, (long)this.channel.position());
    }

    @Test
    public void truncateLargerThanSizeRepositions() throws IOException {
        this.channel.write(this.smallerBuffer);
        int oldSize = (int)this.channel.size();
        int newSize = oldSize + 3;
        this.channel.truncate((long)newSize);
        Assert.assertEquals((String)"Channel should report unchanged size after truncate to bigger value", (long)oldSize, (long)this.channel.size());
        Assert.assertEquals((String)"Channel should report unchanged position after truncate to bigger value", (long)oldSize, (long)this.channel.position());
    }

    @Test(expected=IOException.class)
    public void exceedMaxCapacityProhibited() throws IOException {
        this.channel = new SeekableInMemoryByteChannel(5);
        this.channel.write(this.biggerBuffer);
    }

    @Test
    public void emptyContentAfterClose() {
        this.channel.write(this.smallerBuffer);
        Assert.assertTrue((this.channel.toString().length() > 0 ? 1 : 0) != 0);
        this.channel.close();
        Assert.assertTrue((this.channel.toString().length() == 0 ? 1 : 0) != 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void readFromNullDestination() {
        this.channel.read(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void writeToNullSource() {
        this.channel.write(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void invalidPosition() {
        this.channel.position(-1L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void invalidTruncate() {
        this.channel.truncate(-1L);
    }

    @Test(expected=IOException.class)
    public void writeAfterClose() {
        this.channel.close();
        this.channel.write(ByteBuffer.wrap(new byte[0]));
    }
}

