/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.k8s;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.server.mock.KubernetesServer;
import java.net.URI;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.spi.FileSystemProvider;
import org.uberfire.java.nio.fs.cloud.CloudClientFactory;
import org.uberfire.java.nio.fs.k8s.K8SFileChannel;
import org.uberfire.java.nio.fs.k8s.K8SFileSystem;
import org.uberfire.java.nio.fs.k8s.K8SFileSystemProvider;

public class K8SFileChannelTest {
    @ClassRule
    public static KubernetesServer SERVER = new KubernetesServer(false, true);
    protected static String TEST_NAMESPACE = "test";
    protected static ThreadLocal<KubernetesClient> CLIENT_FACTORY = ThreadLocal.withInitial(() -> SERVER.getClient());
    protected static final FileSystemProvider fsProvider = new K8SFileSystemProvider(){

        public KubernetesClient createKubernetesClient() {
            return CLIENT_FACTORY.get();
        }
    };

    @BeforeClass
    public static void setup() {
    }

    @AfterClass
    public static void tearDown() {
        ((NonNamespaceOperation)CLIENT_FACTORY.get().configMaps().inNamespace(TEST_NAMESPACE)).delete();
        CLIENT_FACTORY.get().close();
    }

    @Test(expected=IOException.class)
    public void testOpenChannelWithInitializationErrors() {
        K8SFileSystem kfs = (K8SFileSystem)fsProvider.getFileSystem(URI.create("k8s:///"));
        Path invalid = kfs.getPath("/#weirdFileName$@#^&*", new String[0]);
        new K8SFileChannel(invalid, (CloudClientFactory)fsProvider);
    }

    @Test
    public void testOpenAndCloseChannel() {
        K8SFileSystem kfs = (K8SFileSystem)fsProvider.getFileSystem(URI.create("k8s:///"));
        Path valid = kfs.getPath("/test", new String[0]);
        K8SFileChannel k8sfc = new K8SFileChannel(valid, (CloudClientFactory)fsProvider);
        Assert.assertTrue((boolean)k8sfc.isOpen());
        k8sfc.close();
        Assert.assertFalse((boolean)k8sfc.isOpen());
    }

    @Test
    public void testChannelMustBeClosedRegardlessError() {
        K8SFileSystemProvider fsProvider = new K8SFileSystemProvider(){

            public KubernetesClient createKubernetesClient() {
                return CLIENT_FACTORY.get();
            }
        };
        K8SFileSystem kfs = (K8SFileSystem)fsProvider.getFileSystem(URI.create("k8s:///"));
        Path valid = kfs.getPath("/test", new String[0]);
        K8SFileChannel k8sfc = new K8SFileChannel(valid, (CloudClientFactory)fsProvider);
        Assert.assertTrue((boolean)k8sfc.isOpen());
        k8sfc.ccf = null;
        try {
            k8sfc.close();
            Assert.fail((String)"Channel close should throw an exception.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertFalse((boolean)k8sfc.isOpen());
    }
}

